/*
 * CommandComboViewer.java
 *
 * Created on March 20, 2002, 4:13 PM
 */

package fr.esrf.tangoatk.widget.command;
import javax.swing.*;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.command.VoidVoidCommand;
import fr.esrf.tangoatk.core.command.InvalidCommand;
/**
 *
 * @author  root
 */
public class CommandComboViewer extends javax.swing.JPanel {

    JFrame                argFrame = null;
    AnyCommandViewer      acv = null;    


    private fr.esrf.tangoatk.core.CommandList commandList;
    private javax.swing.JComboBox commands;
    
    
    
    /** Creates new form CommandComboViewer */
    public CommandComboViewer() {
        initComponents();
    }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        commands = new javax.swing.JComboBox();
        
        setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints1;
        
        commands.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                commandsActionPerformed(evt);
            }
        });
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        add(commands, gridBagConstraints1);
        
    }//GEN-END:initComponents

    private void commandsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_commandsActionPerformed
        // Add your handling code here:
	JComboBox cb = (JComboBox)evt.getSource();
        ICommand command = (ICommand)cb.getSelectedItem();

	if (command instanceof InvalidCommand) {
	    javax.swing.JOptionPane.showMessageDialog(this, command.getName() + " is not supported. It probably takes an array as input.", "Error", 1);
	    return;
	}
	
	if (command instanceof VoidVoidCommand) {
	    command.execute();
	    return;
	}


	if( acv==null ) {
	  acv      =new AnyCommandViewer();
	  argFrame =new JFrame();
	  argFrame.getContentPane().add(acv);
	}

	acv.initialize(command);
	acv.setDeviceButtonVisible(deviceButtonVisible);
	acv.setDescriptionVisible(descriptionVisible);
	acv.setInfoButtonVisible(infoButtonVisible);

	acv.setBorder(null);
	acv.setInputVisible(true);	     
	if (!command.takesInput()) {
	    command.execute();
	} 
	

	argFrame.setTitle(command.getName());
	argFrame.pack();
	argFrame.show();
	

    }//GEN-LAST:event_commandsActionPerformed

    boolean borderVisble;
    
    /**
     * Get the value of borderVisble.
     * @return value of borderVisble.
     */
    public boolean isBorderVisible() {
	return borderVisble;
    }
    
    /**
     * Set the value of borderVisble.
     * @param v  Value to assign to borderVisble.
     */
    public void setBorderVisible(boolean  v) {
	this.borderVisble = v;
    }
    

    boolean infoButtonVisible;
    
    /**
     * Get the value of infoButtonVisible.
     * @return value of infoButtonVisible.
     */
    public boolean isInfoButtonVisible() {
	return infoButtonVisible;
    }
    
    /**
     * Set the value of infoButtonVisible.
     * @param v  Value to assign to infoButtonVisible.
     */
    public void setInfoButtonVisible(boolean  v) {
	this.infoButtonVisible = v;
    }
    
    boolean cancelButtonVisible;
    
    /**
     * Get the value of cancelButtonVisible.
     * @return value of cancelButtonVisible.
     */
    public boolean isCancelButtonVisible() {
	return cancelButtonVisible;
    }
    
    /**
     * Set the value of cancelButtonVisble.
     * @param v  Value to assign to cancelButtonVisble.
     */
    public void setCancelButtonVisible(boolean  v) {
	this.cancelButtonVisible = v;
    }
    
    boolean deviceButtonVisible;
    
    /**
     * Get the value of deviceButtonVisible.
     * @return value of deviceButtonVisible.
     */
    public boolean isDeviceButtonVisible() {
	return deviceButtonVisible;
    }
    
    /**
     * Set the value of deviceButtonVisible.
     * @param v  Value to assign to deviceButtonVisible.
     */
    public void setDeviceButtonVisible(boolean  v) {
	this.deviceButtonVisible = v;
    }

    boolean descriptionVisible;
    
    /**
     * Get the value of descriptionVisible.
     * @return value of descriptionVisible.
     */
    public boolean isDescriptionVisible() {
	return descriptionVisible;
    }
    
    /**
     * Set the value of descriptionVisible.
     * @param v  Value to assign to descriptionVisible.
     */
    public void setDescriptionVisible(boolean  v) {
	this.descriptionVisible = v;
    }

    
    public void setModel(fr.esrf.tangoatk.core.CommandList list) {
        this.commandList = list;
        commands.setModel(list);

    }
    
    public fr.esrf.tangoatk.core.CommandList getModel() {
        return commandList;
    }

    public void setForeground(java.awt.Color color) {
	super.setForeground(color);
	if (commands == null)
	    return;

	commands.setForeground(color);
    }

    public void setBackground(java.awt.Color color) {
	super.setBackground(color);
	if (commands == null)
	    return;
	commands.setBackground(color);
    }

    public void setFont(java.awt.Font font) {
	if (commands == null)
	    return;
		
	commands.setFont(font);
    }

    public java.awt.Font getFont() {
	if (commands == null)
	    return super.getFont();
	
	return commands.getFont();
    }

    
    public static void main (String[] args) throws Exception {
	fr.esrf.tangoatk.core.CommandList clist =
	    new fr.esrf.tangoatk.core.CommandList();
	CommandComboViewer ccv = new CommandComboViewer();
	clist.add("eas/test-api/1/*");
	ccv.setModel(clist);
	JFrame f = new JFrame();
	f.getContentPane().add(ccv);
	f.pack();
	f.show();
	
    } // end of main ()

}
