/*
 * IconNumberSpectrumViewer.java
 *
 * Created on March 25, 2002, 4:06 PM
 */

package fr.esrf.tangoatk.widget.attribute;
import javax.swing.*;
	    
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.INumberSpectrum;
/**
 *
 * @author  root
 */
public class IconNumberSpectrumViewer extends javax.swing.JPanel implements fr.esrf.tangoatk.core.ISpectrumListener {
    JLabel[] iconViewers;
    /** Creates new form IconNumberSpectrumViewer */
    public IconNumberSpectrumViewer() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        setLayout(new java.awt.BorderLayout());

    }//GEN-END:initComponents

    public void errorChange(fr.esrf.tangoatk.core.ErrorEvent errorEvent) {
    }    

    public void stateChange(fr.esrf.tangoatk.core.AttributeStateEvent evt) {

    }

    protected void updateIcon(JLabel icon, int val) {
	try {
	    icon.setIcon(icons[val]);	     
	} catch (Exception e) {
	    icon.setIcon(getInvalidIcon());
	} 	


    }

    protected void updateText(JLabel icon ,String[] texts,  int val) {
	try {
	    icon.setText(texts[val]);
	} catch (Exception e) {
	    icon.setText("");
	} 

    }

    protected void updateColor(JLabel icon , int val) {
	try {
	    icon.setBackground(colors[val]);
	} catch (Exception e) {
	    icon.setBackground(getBackground());
	} 

    }

    
	
    public void spectrumChange(fr.esrf.tangoatk.core.NumberSpectrumEvent numberSpectrumEvent) {
	double []value = numberSpectrumEvent.getValue();
	int length = value.length;
	for (int i = 0; i < length; i++) {
	    int val = (int)value[i];
	    updateIcon(iconViewers[i], val);
	    updateText(iconViewers[i], texts[i], val);
	    updateColor(iconViewers[i], val);
	} // end of for ()
    }    

    Icon [] icons;
    
    INumberSpectrum model;

    int rows = 0;

    int columns = 1;

    Icon invalidIcon;

    String[][] texts;

    java.awt.Color[] colors;
    
    /**
     * Get the value of colors.
     * @return value of colors.
     */
    public java.awt.Color [] getColors() {
	return colors;
    }
    
    /**
     * Set the value of colors.
     * @param v  Value to assign to colors.
     */
    public void setColors(java.awt.Color[]  v) {
	this.colors = v;
    }
    
    /**
     * Get the value of texts.
     * @return value of texts.
     */
    public String[][] getTexts() {
	return texts;
    }
    
    /**
     * Set the value of texts.
     * @param v  Value to assign to texts.
     */
    public void setTexts(String[][]  v) {
	this.texts = v;
    }
    
    /**
     * Get the value of invalidIcon.
     * @return value of invalidIcon.
     */
    public Icon getInvalidIcon() {
	return invalidIcon;
    }
    
    /**
     * Set the value of invalidIcon.
     * @param v  Value to assign to invalidIcon.
     */
    public void setInvalidIcon(Icon  v) {
	this.invalidIcon = v;
    }
    
    
    /**
     * Get the value of columns.
     * @return value of columns.
     */
    public int getColumns() {
	return columns;
    }
    
    /**
     * Set the value of columns.
     * @param v  Value to assign to columns.
     */
    public void setColumns(int  v) {
	this.columns = v;
    }
    
    /**
     * Get the value of rows.
     * @return value of rows.
     */
    public int getRows() {
	return rows;
    }
    
    /**
     * Set the value of rows.
     * @param v  Value to assign to rows.
     */
    public void setRows(int  v) {
	this.rows = v;
    }
    
    /**
     * Get the value of model.
     * @return value of model.
     */
    public INumberSpectrum getModel() {
	return model;
    }
    
    /**
     * Set the value of model.
     * @param v  Value to assign to model.
     */
    public void setModel(INumberSpectrum  v) {
	if (model != null) {
	    model.removeSpectrumListener(this);
	}
	
	this.model = v;
	model.addSpectrumListener(this);
	iconViewers = new JLabel[model.getMaxXDimension()];
	
	removeAll();
	setLayout(new java.awt.GridLayout(rows, columns));
	for (int i = 0; i < iconViewers.length; i++) {
	    iconViewers[i] = new JLabel(Integer.toString(i));
	    iconViewers[i].setOpaque(true);
	    iconViewers[i].setBorder(BorderFactory.createEtchedBorder());
	    add(iconViewers[i]);
	} // end of for ()
    }


    public void setIconBorders(javax.swing.border.Border border) {
	for (int i = 0; i < iconViewers.length; i++) {
	    iconViewers[i].setBorder(border);
	}
    }

    public javax.swing.border.Border getIconBorders() {
	return iconViewers[0].getBorder();
    }

    public void setFont(java.awt.Font font) {
	if (iconViewers == null) return;
	
	for (int i = 0; i < iconViewers.length; i++) {
	    iconViewers[i].setFont(font);
	}
    }

    public java.awt.Font getFont() {
	if (iconViewers == null || iconViewers[0] == null)
	    return super.getFont();
	
	return iconViewers[0].getFont();
    }
    
    public void setHorizontalAlignment(int horizontalAlignment) {
	if (iconViewers == null) return;
	
	for (int i = 0; i < iconViewers.length; i++) {
	    iconViewers[i].setHorizontalAlignment(horizontalAlignment);
	}
    }

    public int getHorizontalAlignment() {
	if (iconViewers == null) return 0;
	
	return iconViewers[0].getHorizontalAlignment();
    }
    
	
	    
    /**
     * Get the value of icons.
     * @return value of icons.
     */
    public Icon [] getIcons() {
	return icons;
    }
    
    /**
     * Set the value of icons.
     * @param v  Value to assign to icons.
     */
    public void setIcons(Icon []  v) {
	this.icons = v;
    }

    public static void main (String[] args) throws Exception {
	Icon [] icons = new Icon[2];
	AttributeList list = new AttributeList();
	INumberSpectrum  ns = (INumberSpectrum)list.add("eas/test-api/1/Short_spec_attr");
	IconNumberSpectrumViewer insv = new IconNumberSpectrumViewer();
	icons[0] = new ImageIcon(insv.getClass().getResource("/fr/esrf/TangoATK/Widget/Attribute/NumberScalarViewer.gif"));
	icons[1] = new ImageIcon(insv.getClass().getResource("/fr/esrf/TangoATK/Widget/Attribute/JChartAdapter.gif"));
	insv.setIcons(icons);

	insv.setModel(ns);
	list.startRefresher();
	JFrame f = new JFrame();
	f.getContentPane().add(insv);
	f.pack();
	f.show();
    } // end of main ()
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables

}
