/*
 * AppLauncher.java
 *
 * Created on December 12, 2001, 10:34 AM
 */

package fr.esrf.tangoatk.util;
import javax.swing.*;
import javax.swing.event.*;
import java.util.*;
import java.io.*;
/**
 *
 * @author  root
 */
public class AppLauncher extends javax.swing.JFrame
    implements ListSelectionListener {
    Properties properties = new Properties();
    ThreadGroup applications = new ThreadGroup("Applications");

    Thread surveyer;
    /** Creates new form AppLauncher */
    public AppLauncher() {
	threads = new javax.swing.DefaultListModel();;    
	String appName, appClass;
	JMenuItem item;
	
        initComponents();
	threadList.addListSelectionListener(this);
	try {
	    properties.load(new FileInputStream(new File(".applauncher")));
	    for (Iterator i = properties.keySet().iterator(); i.hasNext();) {

		appName = (String)i.next();

		item = new JMenuItem(appName);

		item.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                    startApplication(evt.getActionCommand());
                }
            });

		runMenu.add(item);
	    } // end of for ()
	    
	} catch (Exception  e) {
	    JOptionPane.showMessageDialog(this, e, "Error",
					  JOptionPane.ERROR_MESSAGE);
	} // end of try-catch
	

    }

    public void valueChanged(ListSelectionEvent e) {
	Object source = e.getSource();
	int first = e.getFirstIndex();

	if (first < 0) return;

	int last  = e.getLastIndex();

	boolean changing = e.getValueIsAdjusting();

	if (changing ||!(first == last))  return ;

	JOptionPane.showMessageDialog(this,
				      threads.elementAt(first),
				      "Thread Info", 1);
    }

	
    protected void startApplication(String s) {
	String clazz = properties.getProperty(s);
	System.out.println("Creating new instance for " + clazz);
	try {
	    new Thread(applications,
		       (Runnable)Class.forName(clazz).newInstance(),
		       s).start();
	    applications.list();
	} catch (Exception e) {
	    JOptionPane.showMessageDialog(this, e, "Error",
					  JOptionPane.ERROR_MESSAGE);
	} // end of try-catch
    }
	
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
              menuBar = new javax.swing.JMenuBar();
              fileMenu = new javax.swing.JMenu();
              runMenu = new javax.swing.JMenu();
              appLabel = new javax.swing.JMenuItem();
              exitMenuItem = new javax.swing.JMenuItem();
              helpMenu = new javax.swing.JMenu();
	      threadList = new javax.swing.JList();
              
              fileMenu.setText("File");
              runMenu.setText("Run");
              appLabel.setText("Applications");
              appLabel.setEnabled(false);
              runMenu.add(appLabel);
              fileMenu.add(runMenu);
            exitMenuItem.setText("Exit");
            exitMenuItem.addActionListener(new java.awt.event.ActionListener() {
                public void actionPerformed(java.awt.event.ActionEvent evt) {
                    exitMenuItemActionPerformed(evt);
                }
            });
            
            fileMenu.add(exitMenuItem);
            menuBar.add(fileMenu);
          helpMenu.setText("Help");
          menuBar.add(helpMenu);
          
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });
        
	threadList.setModel(threads);
        getContentPane().add(menuBar, java.awt.BorderLayout.NORTH);
	getContentPane().add(threadList, java.awt.BorderLayout.CENTER);

        pack();
    }//GEN-END:initComponents

    private void exitMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitMenuItemActionPerformed
            // Add your handling code here:
        System.exit(0);
    }//GEN-LAST:event_exitMenuItemActionPerformed

    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        System.exit(0);
    }//GEN-LAST:event_exitForm

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        new AppLauncher().show();
    }

    private javax.swing.DefaultListModel threads;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuBar menuBar;
    private javax.swing.JMenu fileMenu;
    private javax.swing.JMenu runMenu;
    private javax.swing.JMenuItem appLabel;
    private javax.swing.JMenuItem exitMenuItem;
    private javax.swing.JMenu helpMenu;
    private javax.swing.JList threadList;
    // End of variables declaration//GEN-END:variables

}
