// File:          ShortSpectrumHelper.java
// Created:       2002-01-24 09:45:56, assum
// By:            <assum@esrf.fr>
// Time-stamp:    <2002-06-24 16:56:18, assum>
//
// $Id: UShortSpectrumHelper.java,v 1.1 2005/06/15 09:42:08 jlpons Exp $
//
// Description:
package fr.esrf.tangoatk.core.attribute;

import fr.esrf.tangoatk.core.*;


import fr.esrf.Tango.*;
import fr.esrf.TangoApi.*;

public class UShortSpectrumHelper extends ANumberSpectrumHelper {

  public UShortSpectrumHelper(IAttribute attribute) {
    init(attribute);
  }

  void init(IAttribute attribute) {
    super.init(attribute);
    imageHelper = new UShortImageHelper(attribute);
  }

  protected void insert(double[] d) {
    int[] tmp = new int[d.length];
    for (int i = 0; i < tmp.length; i++) {
      tmp[i] = new Double(d[i]).intValue();
    }

    deviceAttribute.insert_us(tmp, attribute.getXDimension(),
      attribute.getYDimension());
  }

  void setMinAlarm(double d) {
    setProperty("min_alarm", new Short((short) d));
  }

  void setMaxAlarm(double d) {
    setProperty("max_alarm", new Short((short) d));
  }

  void setMinValue(double d) {
    setProperty("min_value", new Short((short) d));
  }

  void setMaxValue(double d) {
    setProperty("max_value", new Short((short) d));
  }

  void setMinAlarm(double d, boolean writable) {
    setProperty("min_alarm", new Short((short) d), writable);
  }

  void setMaxAlarm(double d, boolean writable) {
    setProperty("max_alarm", new Short((short) d), writable);
  }

  void setMinValue(double d, boolean writable) {
    setProperty("min_value", new Short((short) d), writable);

  }

  void setMaxValue(double d, boolean writable) {
    setProperty("max_value", new Short((short) d), writable);
  }

  double[] getNumberSpectrumValue(DeviceAttribute deviceAttribute) throws DevFailed {

      int[] tmp = deviceAttribute.extractUShortArray();
      double[] retval = new double[tmp.length];
      for (int i = 0; i < tmp.length; i++) {
        retval[i] = (double) tmp[i];
      }
      return retval;

  }

  public String getVersion() {
    return "$Id: UShortSpectrumHelper.java,v 1.1 2005/06/15 09:42:08 jlpons Exp $";
  }
}
