// File:          SetErrorEvent.java
// Created:       2002-12-18 17:00:00, poncet
// By:            <poncet@esrf.fr>
// Time-stamp:    <2002-12-18 17:00:00, poncet>
// 
// $Id: ErrorEvent.java,v 1.2 2003/01/14 16:58:29 poncet Exp $
// 
// Description:       


package fr.esrf.tangoatk.core;

import java.util.EventObject;

public class ErrorEvent extends ATKEvent {
    Throwable error;
    
    public ErrorEvent(Object source, Throwable error, long timeStamp)
    {
	super(source, timeStamp);
	setError(error);
    }

    public Throwable getError()
    {
	return error;
    }

    public void setError(Throwable error)
    {
	this.error = error;
    }

    public void setSource(Object source)
    {
	this.source = source;
    }
    
    public String getVersion()
    {
	return "$Id: ErrorEvent.java,v 1.2 2003/01/14 16:58:29 poncet Exp $";
    }

    public Object clone()
    {
	return new ErrorEvent(source, error, timeStamp);
    }
}
