//+============================================================================
//
// file :               TangoAttrCheckVal.java
//
// description :        java source code for the BlackBoxElt class. This class 
//			is used to implement the 
//			tango device server black box. There is one
//			black box for each Tango device. This black box
//			keeps info. on all the activities on a device.
//			A client is able to retrieve these data via a Device
//			attribute. The BlackBoxElt class encapsulates all the
//			data stored for one request to the device
//
// project :            TANGO
//
// author(s) :          E.Taurel
//
// $Revision: 3.5 $
//
// $Log: TangoAttrCheckVal.java,v $
// Revision 3.5  2004/03/12 14:07:57  pascal_verdier
// Use JacORB-2.1
//
// Revision 2.0  2003/01/09 16:02:58  taurel
// - Update release number before using SourceForge
//
// Revision 1.1.1.1  2003/01/09 15:54:39  taurel
// Imported sources into CVS before using SourceForge
//
// Revision 1.6  2001/10/10 08:11:25  taurel
// See Tango WEB pages for list of changes
//
// Revision 1.5  2001/07/04 15:06:38  taurel
// Many changes due to new release
//
// Revision 1.2  2001/05/04 12:03:22  taurel
// Fix bug in the Util.get_device_by_name() method
//
// Revision 1.1.1.1  2001/04/04 08:23:54  taurel
// Imported sources
//
// Revision 1.3  2000/04/13 08:23:01  taurel
// Added attribute support
//
//
// copyleft :           European Synchrotron Radiation Facility
//                      BP 220, Grenoble 38043
//                      FRANCE
//
//-============================================================================

package fr.esrf.TangoDs;

import java.util.*;
import fr.esrf.Tango.*;

class TangoAttrCheckVal
{
	public int			lg;
	public short			sh;
	public double			db;
	
	public TangoAttrCheckVal()
	{
		lg = 0;
		sh = 0;
		db = 0.0;
	}
}
