//+======================================================================
// $Source: /cvsroot/tango-cs/tango/api/java/fr/esrf/TangoDs/StartPollingCmd.java,v $
//
// Project:   Tango
//
// Description: This class is a singleton class i.e only one object of
//				this class can be created.
//				It contains all properties and methods
//				which the DServer requires only once e.g. the commands.
//
// $Author: pascal_verdier $
//
// $Revision: 3.1 $
//
// $Log: StartPollingCmd.java,v $
// Revision 3.1  2004/05/14 13:47:58  pascal_verdier
// Compatibility with Tango-2.2.0 cpp
// (polling commands and attibites).
//
//
// Copyleft 2000 by European Synchrotron Radiation Facility, Grenoble, France
//-======================================================================
package fr.esrf.TangoDs;

/**
 * This class is a singleton class i.e only one object of
 * this class can be created.
 * It contains all properties and methods
 * which the DServer requires only once e.g. the commands.
 *
 * @author	$Author: pascal_verdier $
 * @version	$Revision: 3.1 $
 */

import org.omg.CORBA.*;
import java.io.*;
import java.util.*;

import fr.esrf.Tango.*;

public class StartPollingCmd extends Command
{
	//===============================================================
	/**
	 *	Constructor for Command class StartPollingCmd
	 */
	//===============================================================
	StartPollingCmd(String name, int in, int out)
	{
		super(name,in,out);
	}
	//===============================================================
	/**
	 *	Trigger the execution of the method really implemented
	 *	the command in the DServer class
	 */
	//===============================================================
	public Any execute(DeviceImpl device, Any in_any) throws DevFailed
	{

		Util.out4.println("StartPollingCmd.execute(): arrived ");

		// Call the device method and return to caller
		((DServer)(device)).start_polling();
		return insert();
	}
}
