//+======================================================================
// $Source: /cvsroot/tango-cs/tango/api/java/fr/esrf/TangoDs/PolledDeviceCmd.java,v $
//
// Project:   Tango
//
// Description: This class is a singleton class i.e only one object of
//				this class can be created.
//				It contains all properties and methods
//				which the DServer requires only once e.g. the commands.
//
// $Author: pascal_verdier $
//
// $Revision: 3.1 $
//
// $Log: PolledDeviceCmd.java,v $
// Revision 3.1  2004/05/14 13:47:56  pascal_verdier
// Compatibility with Tango-2.2.0 cpp
// (polling commands and attibites).
//
//
// Copyleft 2000 by European Synchrotron Radiation Facility, Grenoble, France
//-======================================================================


package fr.esrf.TangoDs;

/**
 * This class is a singleton class i.e only one object of
 * this class can be created.
 * It contains all properties and methods
 * which the DServer requires only once e.g. the commands.
 *
 * @author	$Author: pascal_verdier $
 * @version	$Revision: 3.1 $
 */

import org.omg.CORBA.*;
import java.io.*;
import java.util.*;

import fr.esrf.Tango.*;

public class PolledDeviceCmd extends Command
{
	//===============================================================
	/**
	 *	Constructor for Command class PolledDevice
	 */
	//===============================================================
	PolledDeviceCmd(String name, int in, int out, String out_desc)
	{
		super(name,in,out);
		set_out_type_desc(out_desc);
	}
	//===============================================================
	/**
	 *	Trigger the execution of the method really implemented
	 *	the command in the DServer class
	 */
	//===============================================================
	public Any execute(DeviceImpl device, Any in_any) throws DevFailed
	{

		Util.out4.println("PolledDeviceCmd.execute(): arrived ");

		// Call the device method and return to caller
		return insert(((DServer)(device)).polled_device());
	}
}
