//+============================================================================
//
// file :               MultiClasAttribute.java
//
// description :        Java source code for the MultiClassAttribute
//			class. This class handles all the Attribute
//			with properties defined at the class level
//
// project :            TANGO
//
// author(s) :          E.Taurel
//
// $Revision: 3.5 $
//
// $Log: MultiClassAttribute.java,v $
// Revision 3.5  2004/03/12 14:07:57  pascal_verdier
// Use JacORB-2.1
//
// Revision 2.0  2003/01/09 16:02:58  taurel
// - Update release number before using SourceForge
//
// Revision 1.1.1.1  2003/01/09 15:54:39  taurel
// Imported sources into CVS before using SourceForge
//
// Revision 1.6  2001/10/10 08:11:25  taurel
// See Tango WEB pages for list of changes
//
// Revision 1.5  2001/07/04 15:06:38  taurel
// Many changes due to new release
//
// Revision 1.2  2001/05/04 12:03:22  taurel
// Fix bug in the Util.get_device_by_name() method
//
// Revision 1.1.1.1  2001/04/04 08:23:54  taurel
// Imported sources
//
// Revision 1.3  2000/04/13 08:23:01  taurel
// Added attribute support
//
//
// copyleft :           European Synchrotron Radiation Facility
//                      BP 220, Grenoble 38043
//                      FRANCE
//
//-============================================================================

package fr.esrf.TangoDs;

import java.util.*;
import org.omg.CORBA.*;
import fr.esrf.Tango.*;
import fr.esrf.TangoApi.*;
 
class MultiClassAttribute implements TangoConst
{

	protected Vector		attr_list;
	
//+-------------------------------------------------------------------------
//
// method : 		MultiClassAttribute 
// 
// description : 	constructor for the MultiClassAttribute class
//
//--------------------------------------------------------------------------
 
	public MultiClassAttribute()
	{
		attr_list = new Vector();
	}

//+-------------------------------------------------------------------------
//
// method : 		MultiClassAttribute.init_class_attribute
// 
// description : 	Ask the database for properties defined at class
//			level and build the ClassAttribute object for
//			each attribute with defined properties
//
// argument : in : 	- class_name : The device class name
//
//--------------------------------------------------------------------------

	void init_class_attribute(String class_name,int base) throws DevFailed
	{
		Util.out4.println("Entering MultiClassAttribute.init_class_attribute");
		int i;
		
		int nb_attr=0;
		if (base == 0)
			nb_attr = attr_list.size();
		else
			nb_attr = 1;
		
		if ((nb_attr != 0) && (Util._UseDb == true))
		{
			Util tg = Util.instance();

//
// Get class attribute(s) properties from database
//

			String[] sent_param = new String[nb_attr + 1];
			
			sent_param[0] = class_name;
			for (i = 0;i < nb_attr;i++)
				sent_param[i + 1] = ((Attr)(attr_list.elementAt(i + base))).get_name();

			DeviceData send = new DeviceData();
			send.insert(sent_param);
			DeviceData received = tg.get_database().command_inout("DbGetClassAttributeProperty",send);

			String[] db_attr_prop_list = received.extractStringArray();

//
// Sort property for each attribute and create a ClassAttribute object for each
// of them
//

			int ind = 2;
			for (i = 0;i < nb_attr;i++)
			{
				Vector prop_list = new Vector();

				String attr_name = db_attr_prop_list[ind];		
				prop_list.addElement(new AttrProperty("name",attr_name));
				ind++;
		
				int nb_prop = Integer.parseInt(db_attr_prop_list[ind]);	
				ind++;
				
				for (int j = 0;j < nb_prop;j++)
				{
					prop_list.addElement(new AttrProperty(db_attr_prop_list[ind],db_attr_prop_list[ind + 1]));
					ind = ind + 2;
				}
				
				if (nb_prop != 0)
				{

//
// Find this attribute in the attribute list
//

					int k;
					for (k = 0;k < attr_list.size();k++)
					{
						if (attr_name.equals(((Attr)(attr_list.elementAt(k))).get_name()))
							break;
					}
					if (k == attr_list.size())
					{
						StringBuffer o = new StringBuffer("Attribute ");
						o.append(attr_name);
						o.append(" not found in class attribute(s)");
		
						Except.throw_exception("API_AttrNotFound",
							      	       o.toString(),
							      	       "MultiClassAttribute.init_class_attribute");
					}
					
//
// Add its class property list
//

					((Attr)(attr_list.elementAt(k))).set_class_properties(prop_list);
				}
			}

		}
		
		for (i = 0;i < nb_attr;i++)
			Util.out4.println(((Attr)(attr_list.elementAt(i + base))));
			
		Util.out4.println("Leaving MultiClassAttribute.init_class_attribute");
	}

//+-------------------------------------------------------------------------
//
// method : 		MultiClassAttribute.get_attr
// 
// description : 	Get the ClassAttribute object for the attribute with
//			name passed as parameter
//
// in :			attr_name : The attribute name
//
// This method returns a reference to the ClassAttribute object or throw
// an exceptionif the attribute is not found
//
//--------------------------------------------------------------------------


	Attr get_attr(String attr_name) throws DevFailed
	{

//
// Search for the wanted attribute in the attr_list vector from its name
//

		int i;
		int nb_attr = attr_list.size();
		
		for (i = 0;i < nb_attr;i++)
		{
			if (((Attr)(attr_list.elementAt(i))).get_name().equals(attr_name) == true)
				break;
		}

		if (i == nb_attr)
		{
			StringBuffer o = new StringBuffer("Attribute ");
			o.append(attr_name);
			o.append(" not found in class attribute(s)");
			
			Except.throw_exception("API_AttrWrongDefined",
					       o.toString(),
					       "ClassAttribute.get_attr()");
		}
		
		return ((Attr)(attr_list.elementAt(i)));
	}
		
//+-------------------------------------------------------------------------
//
// Methods to retrieve/set some data members from outside the class and all
// its inherited classes
//
//--------------------------------------------------------------------------

	Vector get_attr_list()
	{
		return attr_list;
	}
}
