//+======================================================================
// $Source: /cvsroot/tango-cs/tango/api/java/fr/esrf/TangoApi/events/TangoUser.java,v $
//
// Project:   Tango
//
// Description:  java source code for the TANGO clent/server API.
//
// $Author: pascal_verdier $
//
// $Revision: 1.3 $
//
// $Log: TangoUser.java,v $
// Revision 1.3  2005/08/10 08:24:33  pascal_verdier
// Synchronized done by a global object.
//
// Revision 1.2  2004/07/06 09:22:58  pascal_verdier
// subscribe event is now thread safe.
// notify daemon reconnection works.
//
// Revision 1.1  2004/03/19 10:24:35  ounsy
// Modification of the overall Java event client Api for synchronization with tango C++ Release 4
//
// Revision 1.1  2004/03/08 11:43:23  pascal_verdier
// *** empty log message ***
//
//
// Copyleftt 2003 by Synchrotron Soleil, France
//-======================================================================
/*
 * TangoPeriodic.java
 *
 * Created on September 22, 2003, 11:22 AM
 */

package fr.esrf.TangoApi.events;

import fr.esrf.Tango.*;
import fr.esrf.TangoApi.*;


/**
 *
 * @author  ounsy
 */
public class TangoUser extends EventDispatcher {
    
    /** Creates a new instance of AttrPeriodicChange */
    public TangoUser(DeviceProxy device_proxy, String attr_name, String[] filters) {
        super(device_proxy);
        this.attr_name = attr_name;
        this.filters = filters;
        event_identifier = -1;
    }
    
    public void addTangoUserListener(ITangoUserListener listener)
                throws DevFailed
    {
		event_listeners.add(ITangoUserListener.class,listener);
        event_identifier = subscribe_user_event(attr_name,filters);
    }
    

	public void removeTangoUserListener(ITangoUserListener listener) 
                throws DevFailed
    {
        event_listeners.remove(ITangoUserListener.class,listener);
        if ( event_listeners.getListenerCount() == 0 )
           unsubscribe_event(event_identifier);

    }
    
    public void dispatch_event(EventData event_data) {
            TangoUserEvent user_event = new TangoUserEvent(this,event_data);
            fireTangoUserEvent(user_event);
    }

    private void fireTangoUserEvent(TangoUserEvent user_event) {
        // Guaranteed to return a non null array
        Object [] listeners = event_listeners.getListenerList();
        // Process the listeners last to first, notifying
        // those that are interested in this event
        for (int i = listeners.length-2 ; i>=0 ; i-=2 ) {
            if (listeners[i] == ITangoPeriodicListener.class) {
                ((ITangoUserListener)listeners[i+1]).user(user_event);
            }
        }
    }
    
	//==============================================================
	//==============================================================

    String attr_name;
    int event_identifier;
    String[] filters;
}
