//+======================================================================
// $Source: /cvsroot/tango-cs/tango/api/java/fr/esrf/TangoApi/events/TangoQualityChangeEvent.java,v $
//
// Project:   Tango
//
// Description:  java source code for the TANGO clent/server API.
//
// $Author: ounsy $
//
// $Revision: 1.2 $
//
// $Log: TangoQualityChangeEvent.java,v $
// Revision 1.2  2004/03/19 10:24:34  ounsy
// Modification of the overall Java event client Api for synchronization with tango C++ Release 4
//
// Revision 1.1  2004/03/08 11:43:23  pascal_verdier
// *** empty log message ***
//
//
// Copyleftt 2003 by Synchrotron Soleil, France
//-======================================================================
/*
 * TangoQualityChangeEvent.java
 *
 * Created on September 26, 2003, 11:55 AM
 */

package fr.esrf.TangoApi.events;


import fr.esrf.Tango.*;
import fr.esrf.TangoApi.*;
import java.util.EventObject;

/**
 *
 * @author  ounsy
 */
public class TangoQualityChangeEvent  extends EventObject {
    
    /** Creates a new instance of TangoOnQualityChangeEvent */
    public TangoQualityChangeEvent(TangoQualityChange source, EventData event_data)
	{
		super(source);
		this.attr_value = event_data.attr_value;
		this.errors = event_data.errors;
	}
    
	public DeviceAttribute getValue() throws DevFailed
	{  
		if (attr_value == null)
		   throw new DevFailed(errors);
		return attr_value;
	}
        
	private DeviceAttribute attr_value;
	private DevError[] errors;
    
}
