//+======================================================================
// $Source: /cvsroot/tango-cs/tango/api/java/fr/esrf/TangoApi/events/TangoQualityChange.java,v $
//
// Project:   Tango
//
// Description:  java source code for the TANGO clent/server API.
//
// $Author: pascal_verdier $
//
// $Revision: 1.4 $
//
// $Log: TangoQualityChange.java,v $
// Revision 1.4  2005/08/10 08:24:33  pascal_verdier
// Synchronized done by a global object.
//
// Revision 1.3  2004/07/06 09:22:58  pascal_verdier
// subscribe event is now thread safe.
// notify daemon reconnection works.
//
// Revision 1.2  2004/03/19 10:24:35  ounsy
// Modification of the overall Java event client Api for synchronization with tango C++ Release 4
//
// Revision 1.1  2004/03/08 11:43:23  pascal_verdier
// *** empty log message ***
//
//
// Copyleftt 2003 by Synchrotron Soleil, France
//-======================================================================
/*
 * TangoQualityChange.java
 *
 * Created on September 26, 2003, 11:50 AM
 */

package fr.esrf.TangoApi.events;


import fr.esrf.Tango.*;
import fr.esrf.TangoApi.*;

/**
 *
 * @author  ounsy
 */
public class TangoQualityChange extends EventDispatcher {
    
    /** Creates a new instance of TangoOnQualityChange */
    public TangoQualityChange(DeviceProxy device_proxy , String attr_name, String[] filters) {
        super(device_proxy);
        this.attr_name = attr_name;
        this.filters = filters;
        event_identifier = -1;
    }
    
    public void addTangoQualityChangeListener(ITangoQualityChangeListener listener)
                throws DevFailed
    {
		event_listeners.add(ITangoQualityChangeListener.class,listener);
        event_identifier = subscribe_quality_change_event(attr_name,filters);
    }
    
    public void removeTangoQualityChangeListener(ITangoQualityChangeListener listener) 
                throws DevFailed
    {
        event_listeners.remove(ITangoQualityChangeListener.class,listener);
        if ( event_listeners.getListenerCount() == 0 )
           unsubscribe_event(event_identifier);
    }
    
    public void dispatch_event(EventData event_data) {
            TangoQualityChangeEvent onchange_event = new TangoQualityChangeEvent(this,event_data);
            fireTangoQualityChangeEvent(onchange_event);
    }

    private void fireTangoQualityChangeEvent(TangoQualityChangeEvent quality_change_event) {
        // Guaranteed to return a non null array
        Object [] listeners = event_listeners.getListenerList();
        // Process the listeners last to first, notifying
        // those that are interested in this event
        for (int i = listeners.length-2 ; i>=0 ; i-=2 ) {
            if (listeners[i] == ITangoQualityChangeListener.class) {
                ((ITangoQualityChangeListener)listeners[i+1]).qualityChange(quality_change_event);
            }
        }
    }
    
	//==============================================================
	//==============================================================

    String attr_name;
    int event_identifier;
    String[] filters;
}
