//+======================================================================
// $Source: /cvsroot/tango-cs/tango/api/java/fr/esrf/TangoApi/events/TangoArchive.java,v $
//
// Project:   Tango
//
// Description:  java source code for the TANGO clent/server API.
//
// $Author: pascal_verdier $
//
// $Revision: 1.4 $
//
// $Log: TangoArchive.java,v $
// Revision 1.4  2005/08/10 08:24:33  pascal_verdier
// Synchronized done by a global object.
//
// Revision 1.3  2004/07/06 09:22:58  pascal_verdier
// subscribe event is now thread safe.
// notify daemon reconnection works.
//
// Revision 1.2  2004/03/19 10:24:34  ounsy
// Modification of the overall Java event client Api for synchronization with tango C++ Release 4
//
// Revision 1.1  2004/03/08 11:43:23  pascal_verdier
// *** empty log message ***
//
//
// Copyleftt 2003 by Synchrotron Soleil, France
//-======================================================================
/*
 * TangoArchive.java
 *
 * Created on September 26, 2003, 11:57 AM
 */

package fr.esrf.TangoApi.events;


import fr.esrf.Tango.*;
import fr.esrf.TangoApi.*;

/**
 *
 * @author  ounsy
 */
public class TangoArchive extends EventDispatcher {
    
    /** Creates a new instance of TangoOnAlarm */
    public TangoArchive(DeviceProxy device_proxy , String attr_name,String[] filters) {
        super(device_proxy);
        this.attr_name = attr_name;
        this.filters = filters;
        event_identifier = -1;
    }
    
    public void addTangoArchiveListener(ITangoArchiveListener listener)
                throws DevFailed
    {
		event_identifier = subscribe_archive_event(attr_name,filters);
		event_listeners.add(ITangoArchiveListener.class,listener);
    }
    
    public void removeTangoArchiveListener(ITangoArchiveListener listener) 
                throws DevFailed
    {
        event_listeners.remove(ITangoArchiveListener.class,listener);
        if ( event_listeners.getListenerCount() == 0 )
           unsubscribe_event(event_identifier);
    }
    
    public void dispatch_event(EventData event_data) {
            TangoArchiveEvent archive_event = new TangoArchiveEvent(this,event_data);
            fireTangoArchiveEvent(archive_event);
    }

    private void fireTangoArchiveEvent(TangoArchiveEvent archive_event) {
        // Guaranteed to return a non null array
        Object [] listeners = event_listeners.getListenerList();
        // Process the listeners last to first, notifying
        // those that are interested in this event
        for (int i = listeners.length-2 ; i>=0 ; i-=2 ) {
            if (listeners[i] == ITangoArchiveListener.class) {
                ((ITangoArchiveListener)listeners[i+1]).archive(archive_event);
            }
        }
    }
    
    String attr_name;
    int event_identifier;
    String[] filters;
}
