//+======================================================================
// $Source: /cvsroot/tango-cs/tango/api/java/fr/esrf/TangoApi/PeriodicEventInfo.java,v $
//
// Project:   Tango
//
// Description:  java source code for the PeriodicEventInfo class definition .
//
// $Author: pascal_verdier $
//
// $Revision: 3.2 $
//
// $Log: PeriodicEventInfo.java,v $
// Revision 3.2  2004/12/07 09:30:29  pascal_verdier
// Exception classes inherited from DevFailed added.
//
// Revision 3.1  2004/11/05 11:59:21  pascal_verdier
// Attribute Info TANGO 5 compatibility.
//
//
// Copyright 2001 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================
package fr.esrf.TangoApi;

import org.omg.CORBA.*;
import fr.esrf.Tango.*;


/**
 *	Class Description: This class is the same class as PeriodicEventProp, 
 *	                   but created for C++ compatibility.
 *
 * @author  verdier
 * @version  $Revision: 3.2 $
 */
public class PeriodicEventInfo
{
	public String period = "";
	public String[] extensions;
	//-======================================================================
	//-======================================================================
	public PeriodicEventInfo(String period, String[] extensions)
	{
		this.period     = period;
		this.extensions = extensions;
	}
	//-======================================================================
	//-======================================================================
	public PeriodicEventInfo(PeriodicEventProp ev_prop)
	{
		this.period     = ev_prop.period;
		this.extensions = ev_prop.extensions;
	}
	//-======================================================================
	//-======================================================================
	public PeriodicEventProp getTangoObj()
	{
		return new PeriodicEventProp(period, extensions);
	}
}
