//+===========================================================================
// $Source: /cvsroot/tango-cs/tango/api/java/fr/esrf/TangoApi/IORdump.java,v $
//
// Project:   Tango API
//
// Description:  Java source for conversion between Tango/TACO library
//
// $Author: pascal_verdier $
//
// $Revision: 3.10 $
//
// $Log: IORdump.java,v $
// Revision 3.10  2005/05/18 12:50:04  pascal_verdier
// Remove unused data.
//
// Revision 3.9  2005/02/11 12:50:46  pascal_verdier
// DeviceInfo Object added (Start/Stop device dates).
//
// Revision 3.8  2004/12/07 09:30:30  pascal_verdier
// Exception classes inherited from DevFailed added.
//
// Revision 3.7  2004/11/05 12:05:34  pascal_verdier
// Use now JacORB_2_2_1.
//
// Revision 3.6  2004/05/14 14:21:34  pascal_verdier
// Add timeout at runtime.
// Some little bugs fixed.
//
// Revision 3.5  2004/03/12 13:15:23  pascal_verdier
// Using JacORB-2.1
//
// Revision 3.1  2003/07/22 14:15:35  pascal_verdier
// DeviceData are now in-methods objects.
// Minor change for TACO-TANGO common database.
//
// Revision 3.0  2003/04/29 08:03:28  pascal_verdier
// Asynchronous calls added.
// Logging related methods.
// little bugs fixed.
//
// Revision 2.0  2003/01/09 14:00:37  verdier
// jacORB is now the ORB used.
//
//
// Copyright 2001 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-===========================================================================
//         (c) - Software Engineering Group - ESRF
//============================================================================

package fr.esrf.TangoApi;

import fr.esrf.Tango.*;
import fr.esrf.TangoDs.*;
import java.util.List;

//import org.jacorb.orb.connection.CodeSet;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.*;
import org.jacorb.orb.iiop.IIOPProfile;

import org.omg.IOP.*;
import org.omg.GIOP.*;
import org.omg.IIOP.*;
import org.omg.SSLIOP.*;
import org.omg.CSIIOP.*;
import org.omg.CONV_FRAME.*;


import java.io.*;

/**
 *	Class descriptio: This class analyze a IOR string.
 */

public class IORdump 
{
	private String	iorString   = null;
	private String	type_id     = null;
	private String	iiopVersion = null;
	private String	host        = null;
	private int		port        = -1;
	private int		prg_number  = -1;		//	used by TACO
	private String	devname     = null;
	public  boolean	is_taco     = false;

//===============================================================
//===============================================================
	public IORdump(String devname, String iorString) throws  DevFailed
	{
		if (devname==null)
			this.devname   = "unknown";
		else
			this.devname   = devname;

		//	If ior null get it from database.
		if (iorString==null)
		{
			DeviceProxy		dev = new DeviceProxy(devname);
			iorString = dev.get_ior();
		}
		else
			this.iorString = iorString;

		if (iorString !=null)
			if (iorString.equals("nada")==true)
				iorString = null;
			else
				iorAnalysis(iorString);
	}
//===============================================================
//===============================================================
	public IORdump(String devname) throws  DevFailed
	{
		this.devname   = devname;

		//	Create device to know its IOR.
		DeviceProxy		dev = new DeviceProxy(devname);
		iorString = dev.get_ior();
		if (iorString !=null)
			if (iorString.equals("nada")==true)
				iorString = null;
			else
				iorAnalysis(iorString);
	}
//===============================================================
/**
 *	Return a string with ID type, IIOP version, host name, and port number.
 */
//===============================================================
	public String toString()
	{
		if (iorString == null)
			return new String(
						"No IOR found in database for " + devname + "\n" +
						"(Maybe, the device has never been exported...)");
		else
		{
			String str = new String(
							"Device:          " + devname + "\n" +
							"type_id:         " + get_type_id()		+ "\n");
				if (is_taco==false)
					str +=	"iiop_version:    " + get_iiop_version()	+ "\n";

				str +=		"host:            " + get_host()			+ "\n";
				if (is_taco==false)
					str +=	"port:            " + get_port();
				else
					str +=	"prg number:      " + get_prg_number();
			return str;
		}
	}
//===============================================================
/**
 *	Make the IOR analyse
 */
//===============================================================
	private void iorAnalysis(String iorString) throws  DevFailed
	{
		if(iorString==null)
			return;

		//	Check if ior string start with "rpc:" --> TACO protocole
		//	ior = rpc:hostname:prgnumber
		if (iorString.startsWith("rpc:"))
		{	
			is_taco = true;
			type_id = "Taco";
			host    = iorString.substring("rpc:".length(), 
						iorString.indexOf(":", "rpc:".length()+1));
			String	s = iorString.substring(iorString.indexOf(":", "rpc:".length()+1)+1);
			prg_number = Integer.parseInt(s);
			return;
		}
		else
		if (iorString.startsWith("IOR:")==false)
			return;
	
		//	Start Analysis  --  Code based on :
		//   org.jacorb.orb.util.PrintIOR.printIOR(pior, ApiUtil.get_orb());
		//-------------------------------------------------------------------
		ParsedIOR pior = new ParsedIOR( iorString, ApiUtil.get_orb(), null);
        org.omg.IOP.IOR ior = pior.getIOR();
		type_id = ior.type_id;
        List profiles = pior.getProfiles();
        for( int i = 0; i < profiles.size(); i++ )
		{
            IIOPProfile p = (IIOPProfile)profiles.get(i);
			iiopVersion = "" + (int)p.version().major + "." + 
			                   (int)p.version().minor;
		
            String	name =  p.getAddress().getHostname();
			try
			{
				java.net.InetAddress	iadd = 
						java.net.InetAddress.getByName(name);
				String
				add  = iadd.getHostAddress();
				name = iadd.getHostName();
				host = new String(name + " (" + add + ")");
			}
			catch(Exception e)
			{
				host = new String(name + " (" + e + ")" );
			}
            port = p.getAddress().getPort();
            if( port < 0 )  port += 65536;
		}
	}
//===============================================================
/**
 *	Return the ID type
 */
//===============================================================
	public String get_type_id()
	{
		return type_id;
	}
//===============================================================
/**
 *	Return the host where the process is running.
 */
//===============================================================
	public String get_host()
	{
		return host;
	}
//===============================================================
/**
 *	Return the connection port.
 */
//===============================================================
	public int get_port()
	{
		return port;
	}
//===============================================================
/**
 *	Return the connection TACO prg_number.
 */
//===============================================================
	public int get_prg_number()
	{
		return prg_number;
	}
//===============================================================
/**
 *	Return the IIOP version number.
 */
//===============================================================
	public String get_iiop_version()
	{
		return iiopVersion;
	}

//===============================================================
//===============================================================
	public static void printSyntax()
	{
		System.out.println("IORdump <ior string>      or");
		System.out.println("IORdump -f <ior file name>");
	}
//===============================================================
//===============================================================
	public static String getIor(String filename)
					throws	FileNotFoundException, 
							SecurityException,
							IOException
	{
		FileInputStream	fid = new FileInputStream(filename);
		int nb = fid.available();
		byte[]	inStr  = new byte[nb];
		fid.read(inStr);
		String str = new String(inStr);
		fid.close();
		return str;
	}
//===============================================================
//===============================================================
   public static void  main(String[] args)
    {
        try
        {
			switch (args.length)
			{
			case 1:
				System.out.println(
					new fr.esrf.TangoApi.IORdump(args[0]).toString());
				break;
			case 2:
				if (args[0].equals("-f"))
				{
				System.out.println(
					new fr.esrf.TangoApi.IORdump(null,getIor(args[1])).toString());
					break;
				}
			default:
				printSyntax();
			}
        }
		catch(DevFailed e)
		{
			Except.print_exception(e);
		}
		catch(ArrayIndexOutOfBoundsException e)
		{
			System.out.println("Device name ?");
		}
        catch(Exception ex)
        {
            ex.printStackTrace();
        }
    }
}

