//+======================================================================
// $Source: /cvsroot/tango-cs/tango/api/java/fr/esrf/TangoApi/DeviceData.java,v $
//
// Project:   Tango
//
// Description:  java source code for the TANGO clent/server API.
//
// $Author: pascal_verdier $
//
// $Revision: 3.9 $
//
// $Log: DeviceData.java,v $
// Revision 3.9  2005/09/14 07:33:33  pascal_verdier
// Bug fixed in getData() method.
//
// Revision 3.8  2005/08/10 08:11:29  pascal_verdier
// Default value modified in getType() method.
//
// Revision 3.7  2005/06/22 13:28:25  pascal_verdier
// getType() method added.
//
// Revision 3.6  2004/12/07 09:30:29  pascal_verdier
// Exception classes inherited from DevFailed added.
//
// Revision 3.5  2004/03/12 13:15:23  pascal_verdier
// Using JacORB-2.1
//
// Revision 3.1  2003/09/08 11:03:25  pascal_verdier
// *** empty log message ***
//
// Revision 3.0  2003/04/29 08:03:29  pascal_verdier
// Asynchronous calls added.
// Logging related methods.
// little bugs fixed.
//
// Revision 2.0  2003/01/09 14:00:37  verdier
// jacORB is now the ORB used.
//
// Revision 1.8  2002/06/26 09:02:17  verdier
// tested with atkpanel on a TACO device
//
// Revision 1.7  2002/04/09 12:21:51  verdier
// IDL 2 implemented.
//
// Revision 1.6  2002/01/09 12:18:15  verdier
// TACO signals can be read as TANGO attribute.
//
// Revision 1.5  2001/12/10 14:19:42  verdier
// TACO JNI Interface added.
// URL syntax used for connection.
// Connection on device without database added.
//
// Revision 1.4  2001/07/04 14:06:05  verdier
// Attribute management added.
//
// Revision 1.3  2001/04/02 08:32:05  verdier
// TangoApi package has users...
//
// Revision 1.1  2001/02/02 13:03:46  verdier
// Initial revision
//
// Copyright 2001 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================

package fr.esrf.TangoApi;

import org.omg.CORBA.*;
import fr.esrf.Tango.*;
import fr.esrf.TangoDs.*;

 
/** 
 *	Class Description:
 *	This class manage data object for Tango device access.
 *
 *	<Br><Br>
 *	<Br><b> Usage example: </b> <Br>
 *	<ul><i>
 *		String	status; <Br>
 *		DeviceProxy	dev = new DeviceProxy("sys/steppermotor/1"); <Br>
 *		try { <Br>	<ul>
 *			DeviceData	data = dev.command_inout("DevStatus"); <Br>
 *			status = data.extractString(); <Br>	</ul>
 *		} <Br>
 *		catch (DevFailed e) { <Br>	<ul>
 *			status = "Unknown status"; <Br>
 *			Except.print_exception(e); <Br>	</ul>
 *		} <Br>
 *	</ul></i>
 *
 * @author  verdier
 * @version  $Revision: 3.9 $
 */


public class DeviceData implements TangoConst
{
	Any	any;

	//===========================================================
	/**
	 *	Constructor for the TgApi Data Object.
	 *
	 *	@throws DevFailed if TgApi class not instancied.
	 */
	//===========================================================
	public DeviceData() throws DevFailed
	{
		any = ApiUtil.get_orb().create_any();
	}
	
	//===========================================================
	/**
	 *	Constructor for the TgApi Data Object.
	 *
	 *	@param orb	orb connection id.
	 *	@throws DevFailed if TgApi class not instancied.
	 */
	//===========================================================
	public DeviceData(ORB orb) throws DevFailed
	{
		any = orb.create_any();
	}
	//===========================================================
	/**
	 *	Constructor for the TgApi Data Object.
	 *
	 *	@param any	CORBA Any reference to be used in DeviceData.
	 *	@throws DevFailed if TgApi class not instancied.
	 */
	//===========================================================
	public DeviceData(Any any) throws DevFailed
	{
		this.any = any;
	}


	//**********	Insert Methods for basic types *********************
	
	
	//===========================================
	/**
	 *	Insert method for argin is void.
	 */
	//===========================================
	public void insert()
	{
	}
	//===========================================
	/**
	 *	Insert method for argin is Any (CORBA).
	 */
	//===========================================
	public void insert(Any any)
	{
		this.any = any;
	}
	//===========================================
	/**
	 *	Insert method for argin is boolean.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(boolean argin)
	{
		DevBooleanHelper.insert(any, argin);
		//any.insert_boolean(argin);
		//System.out.println("inserting "+any.extract_boolean());
	}
	//===========================================
	/**
	 *	Insert method for argin is short.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(short argin)
	{
		DevShortHelper.insert(any, argin);
	}
	//===========================================
	/**
	 *	Insert method for argin is long.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(long argin)
	{
		DevLongHelper.insert(any, (int)argin);
	}
	//===========================================
	/**
	 *	Insert method for argin is int.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(int argin)
	{
		DevLongHelper.insert(any, argin);
	}
	//===========================================
	/**
	 *	Insert method for argin is float.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(float argin)
	{
		DevFloatHelper.insert(any, argin);
	}
	//===========================================
	/**
	 *	Insert method for argin is double.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(double argin)
	{
		DevDoubleHelper.insert(any, argin);
	}
	//===========================================
	/**
	 *	Insert method for argin is String.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(String argin)
	{
		DevStringHelper.insert(any, argin);
	}
	//===========================================
	/**
	 *	Insert method for argin is DevState.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(DevState argin)
	{
		DevStateHelper.insert(any, argin);
	}

	//**********	Insert Methods for sequence types	*********************

	//===========================================
	/**
	 *	Insert method for argin is DevVarCharArray.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(byte[] argin)
	{
		DevVarCharArrayHelper.insert(any, argin);
	}
	//===========================================
	/**
	 *	Insert method for argin is DevVarShortArray.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(short[] argin)
	{
		DevVarShortArrayHelper.insert(any, argin);
	}
	//===========================================
	/**
	 *	Insert method for argin is DevVarLongArray.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(int[] argin)
	{
		DevVarLongArrayHelper.insert(any, argin);
	}
	//===========================================
	/**
	 *	Insert method for argin is DevVarFloatArray.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(float[] argin)
	{
		DevVarFloatArrayHelper.insert(any, argin);
	}
	//===========================================
	/**
	 *	Insert method for argin is DevVarDoubleArray.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(double[] argin)
	{
		DevVarDoubleArrayHelper.insert(any, argin);
	}

	//===========================================
	/**
	 *	Insert method for argin is DevVarStringArray.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(String[] argin)
	{
		DevVarStringArrayHelper.insert(any, argin);
	}
	//===========================================
	/**
	 *	Insert method for argin is DevVarLongStringArray.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(DevVarLongStringArray argin)
	{
		DevVarLongStringArrayHelper.insert(any, argin);
	}
	//===========================================
	/**
	 *	Insert method for argin is DevVarDoubleStringArray.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert(DevVarDoubleStringArray argin)
	{
		DevVarDoubleStringArrayHelper.insert(any, argin);
	}



	//**********	Insert Methods for unsigned types	*********************

	//===========================================
	/**
	 *	Insert method for argin int as unsigned short.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert_us(int argin)
	{
		short	val = (short)(argin & 0xFFFF);
		DevUShortHelper.insert(any, val);
	}
	//===========================================
	/**
	 *	Insert method for argin is unsigned short.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert_us(short argin)
	{
		DevUShortHelper.insert(any, argin);
	}
	//===========================================
	/**
	 *	Insert method for argin is unsigned short.
	 *
	 *	@param argin	argin value for next command.
	 *	@deprecated use insert_us(short/int argin)
	 */
	//===========================================
	public void insert_u(short argin)
	{
		DevUShortHelper.insert(any, argin);
	}
	//===========================================
	/**
	 *	Insert method for argin long ass unsigned int.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert_ul(long argin)
	{
		int		val = (int)(argin & 0xFFFFFFFF);
		DevULongHelper.insert(any, val);
	}
	//===========================================
	/**
	 *	Insert method for argin is unsigned int.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert_ul(int argin)
	{
		DevULongHelper.insert(any, argin);
	}
	//===========================================
	/**
	 *	Insert method for argin is unsigned int.
	 *
	 *	@param argin	argin value for next command.
	 *	@deprecated use insert_ul(int/long argin)
	 */
	//===========================================
	public void insert_u(int argin)
	{
		DevULongHelper.insert(any, argin);
	}

	//===========================================
	/**
	 *	Insert method for argin int as unsigned short array.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert_us(int[] argin)
	{
		short[]	val = new short[argin.length];
		for (int i=0 ; i<argin.length ; i++)
			val[i] = (short)(argin[i] & 0xFFFF);

		DevVarUShortArrayHelper.insert(any, val);
	}
	//===========================================
	/**
	 *	Insert method for argin is unsigned short array.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert_us(short[] argin)
	{
		DevVarUShortArrayHelper.insert(any, argin);
	}
	//===========================================
	/**
	 *	Insert method for argin is unsigned short array.
	 *
	 *	@param argin	argin value for next command.
	 *	@deprecated use insert_us(short[]/int[] argin)
	 */
	//===========================================
	public void insert_u(short[] argin)
	{
		DevVarUShortArrayHelper.insert(any, argin);
	}
	//===========================================
	/**
	 *	Insert method for argin long array as unsigned int array.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert_ul(long[] argin)
	{
		int[]	val = new int[argin.length];
		for (int i=0 ; i<argin.length ; i++)
			val[i] = (int)(argin[i] & 0xFFFFFFFF);

		DevVarULongArrayHelper.insert(any, val);
	}
	//===========================================
	/**
	 *	Insert method for argin is unsigned int array.
	 *
	 *	@param argin	argin value for next command.
	 */
	//===========================================
	public void insert_ul(int[] argin)
	{
		DevVarULongArrayHelper.insert(any, argin);
	}
	//===========================================
	/**
	 *	Insert method for argin is unsigned int array.
	 *
	 *	@param argin	argin value for next command.
	 *	@deprecated use insert_ul(int[]/long[] argin)
	 */
	//===========================================
	public void insert_u(int[] argin)
	{
		DevVarULongArrayHelper.insert(any, argin);
	}



	//**********	Extract Methods for basic types	*********************


	//===========================================
	/**
	 *	extract method for a CORBA Any.
	 */
	//===========================================
	public Any extractAny()
	{
		return any;
	}
	//===========================================
	/**
	 *	extract method for a boolean.
	 */
	//===========================================
	public boolean extractBoolean()
	{
		return DevBooleanHelper.extract(any);
	}
	//===========================================
	/**
	 *	extract method for a short.
	 */
	//===========================================
	public short extractShort()
	{
		return DevShortHelper.extract(any);
	}
	//===========================================
	/**
	 *	extract method for an unsigned short.
	 */
	//===========================================
	public int extractUShort()
	{
		short	tmp = DevUShortHelper.extract(any);
		int		val = 0xFFFF & tmp;
		return val;
	}
	//===========================================
	/**
	 *	extract method for a long.
	 */
	//===========================================
	public int extractLong()
	{
		return DevLongHelper.extract(any);
	}
	//===========================================
	/**
	 *	extract method for an unsigned long.
	 */
	//===========================================
	public long extractULong()
	{
		int		tmp = DevULongHelper.extract(any);
		long	mask = (long) 0x7fffffff;
		mask += ((long)1 << 31);
		long	val = (long) tmp & mask;
		return val;
	}
	//===========================================
	/**
	 *	extract method for a float.
	 */
	//===========================================
	public float extractFloat()
	{
		return DevFloatHelper.extract(any);
	}
	//===========================================
	/**
	 *	extract method for a double.
	 */
	//===========================================
	public double extractDouble()
	{
		return DevDoubleHelper.extract(any);
	}

	//===========================================
	/**
	 *	extract method for a String.
	 */
	//===========================================
	public String extractString()
	{
		return DevStringHelper.extract(any);
	}
	//===========================================
	/**
	 *	extract method for a DevState.
	 */
	//===========================================
	public DevState extractDevState()
	{
		return DevStateHelper.extract(any);
	}



	//**********	Extract Methods for sequence types	*********************


	//===========================================
	/**
	 *	extract method for a byte Array.
	 */
	//===========================================
	public byte[] extractByteArray()
	{
		return DevVarCharArrayHelper.extract(any);
	}
	//===========================================
	/**
	 *	extract method for a short Array.
	 */
	//===========================================
	public short[] extractShortArray()
	{
		return DevVarShortArrayHelper.extract(any);
	}
	//===========================================
	/**
	 *	extract method for an unsigned short Array.
	 *	@return extract value as int array
	 */
	//===========================================
	public int[] extractUShortArray()
	{
		short[]	argout = DevVarUShortArrayHelper.extract(any);
		int[]	val = new int[argout.length];
		for (int i=0 ; i<argout.length ; i++)
			val[i] = 0xFFFF & argout[i];
		return val;
	}
	//===========================================
	/**
	 *	extract method for a long Array.
	 */
	//===========================================
	public int[] extractLongArray()
	{
		return DevVarLongArrayHelper.extract(any);
	}
	//===========================================
	/**
	 *	extract method for an unsigned long Array.
	 *	@return extract value as long array
	 */
	//===========================================
	public long[] extractULongArray()
	{
		int[]	argout = DevVarULongArrayHelper.extract(any);
		long[]	val = new long[argout.length];
		long	mask = (long) 0x7fffffff;
		mask += ((long)1 << 31);

		for (int i=0 ; i<argout.length ; i++)
			val[i]  = (long) argout[i] & mask;

		return val;
	}
	//===========================================
	/**
	 *	extract method for a float Array.
	 */
	//===========================================
	public float[] extractFloatArray()
	{
		return DevVarFloatArrayHelper.extract(any);
	}
	//===========================================
	/**
	 *	extract method for a double Array.
	 */
	//===========================================
	public double[] extractDoubleArray()
	{
		return DevVarDoubleArrayHelper.extract(any);
	}

	//===========================================
	/**
	 *	extract method for a String Array.
	 */
	//===========================================
	public String[] extractStringArray()
	{
		if (any==null)	System.out.println("any = null !!");
		return DevVarStringArrayHelper.extract(any);
	}
	//===========================================
	/**
	 *	extract method for a DevVarLongStringArray.
	 */
	//===========================================
	public DevVarLongStringArray extractLongStringArray()
	{
		if (any==null)	System.out.println("any = null !!");
		return DevVarLongStringArrayHelper.extract(any);
	}
	//===========================================
	/**
	 *	extract method for a DevVarDoubleStringArray.
	 */
	//===========================================
	public DevVarDoubleStringArray extractDoubleStringArray()
	{
		return DevVarDoubleStringArrayHelper.extract(any);
	}


	public TypeCode type()
	{
		return any.type();
	}
	//===========================================
	//===========================================
	public int getType() throws DevFailed
	{
		int	type = Tango_DEV_VOID;
		boolean		is_array  = false;
		boolean		is_struct = false;
		TypeCode	tc = any.type();
		TCKind		kind;
		try {

			//	Special case for state
			if (tc.kind().value()==TCKind._tk_enum)
				return Tango_DEV_STATE;

			//	Check if struct
			if (tc.kind().value()==TCKind._tk_struct)
			{
				is_struct = true;
				//	Get first element of struct
				tc = tc.member_type(0);
			}

			//	Check if array
			if (tc.kind().value()==TCKind._tk_alias)
			{
				TypeCode	tc_alias = tc.content_type();
				if (tc_alias.kind().value()==TCKind._tk_sequence)
				{
					TypeCode	tc_seq   = tc_alias.content_type();
					kind = tc_seq.kind();
					is_array = true;
				}
				else
					kind = tc_alias.kind();
			}
			else
				kind = tc.kind();

			//	Set Tango type from TypeCode
			switch(kind.value())
			{
			case TCKind._tk_void:
				type = Tango_DEV_VOID;
				break;

			case TCKind._tk_boolean:
				type = Tango_DEV_BOOLEAN;
				break;

			case TCKind._tk_char:
				if (is_array)
					type = Tango_DEVVAR_CHARARRAY;
				else
					type = Tango_DEV_CHAR;
				break;

			case TCKind._tk_short:
				if (is_array)
					type = Tango_DEVVAR_SHORTARRAY;
				else
					type = Tango_DEV_SHORT;
				break;

			case TCKind._tk_ushort:
				if (is_array)
					type = Tango_DEVVAR_USHORTARRAY;
				else
					type = Tango_DEV_USHORT;
				break;

			case TCKind._tk_long:
				if (is_struct)
					type = Tango_DEVVAR_LONGSTRINGARRAY;
				else
				if (is_array)
					type = Tango_DEVVAR_LONGARRAY;
				else
					type = Tango_DEV_LONG;
				break;

			case TCKind._tk_ulong:
				if (is_array)
					type = Tango_DEVVAR_ULONGARRAY;
				else
					type = Tango_DEV_ULONG;
				break;

			case TCKind._tk_float:
				if (is_array)
					type = Tango_DEVVAR_FLOATARRAY;
				else
					type = Tango_DEV_FLOAT;
				break;

			case TCKind._tk_double:
				if (is_struct)
					type = Tango_DEVVAR_DOUBLESTRINGARRAY;
				else
				if (is_array)
					type = Tango_DEVVAR_DOUBLEARRAY;
				else
					type = Tango_DEV_DOUBLE;
				break;

			case TCKind._tk_string:
				if (is_array)
					type = Tango_DEVVAR_STRINGARRAY;
				else
					type = Tango_DEV_STRING;
				break;
			}
		}
		catch(org.omg.CORBA.TypeCodePackage.BadKind e)
		{
			e.printStackTrace();
			Except.throw_exception("Api_TypeCodePackage.BadKind",
						"Bad or unknown type ",
						"DeviceAttribute.getType()");
		}
		catch(org.omg.CORBA.TypeCodePackage.Bounds e)
		{
			Except.throw_exception("Api_TypeCodePackage.BadKind",
						"Bad or unknown type ",
						"DeviceAttribute.getType()");
		}
		return type;
	}
}

