//+======================================================================
// $Source: /cvsroot/tango-cs/tango/api/java/fr/esrf/TangoApi/ChangeEventInfo.java,v $
//
// Project:   Tango
//
// Description:  java source code for the ChangeEventInfo class definition .
//
// $Author: pascal_verdier $
//
// $Revision: 3.2 $
//
// $Log: ChangeEventInfo.java,v $
// Revision 3.2  2004/12/07 09:30:29  pascal_verdier
// Exception classes inherited from DevFailed added.
//
// Revision 3.1  2004/11/05 11:59:20  pascal_verdier
// Attribute Info TANGO 5 compatibility.
//
//
// Copyright 2001 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================
package fr.esrf.TangoApi;

import org.omg.CORBA.*;
import fr.esrf.Tango.*;


/**
 *	Class Description: This class is the same class as ChangeEventProp, 
 *	                   but created for C++ compatibility.
 *
 * @author  verdier
 * @version  $Revision: 3.2 $
 */
public class ChangeEventInfo
{
	public String	rel_change = "";
	public String	abs_change = "";
	public String[]	extensions;
	//-======================================================================
	//-======================================================================
	public ChangeEventInfo(String rel_change, String abs_change, String[] extensions)
	{
		this.rel_change = rel_change;
		this.abs_change = abs_change;
		this.extensions = extensions;
	}
	//-======================================================================
	//-======================================================================
	public ChangeEventInfo(ChangeEventProp ev_prop)
	{
		this.rel_change = ev_prop.rel_change;
		this.abs_change = ev_prop.abs_change;
		this.extensions = ev_prop.extensions;
	}
	//-======================================================================
	//-======================================================================
	public ChangeEventProp getTangoObj()
	{
		return new ChangeEventProp(rel_change, abs_change, extensions);
	}
	//-======================================================================
	//-======================================================================
}
