// File:          RunIU.java
// Created:       2002-09-26 10:50:19, erik
// By:            <erik@assum.net>
// Time-stamp:    <2003-01-30 12:55:10, erik>
// 
// $Id: RunUI.java,v 1.2 2005/08/26 13:44:40 ounsy Exp $
// 
// Description:       

package explorer.ui;

import java.awt.event.*;
import javax.swing.*;
import fr.esrf.tangoatk.core.IDevice;

public class RunUI {
    static boolean jive = false;
    static boolean atkpanel = false;
    public static String JIVE      = "jive.MainPanel";
    public static String ATKPANEL  = "atkpanel.MainPanel";
    
    static {
	jiveCheck();
	atkCheck();
    }

    public RunUI(JToolBar toolbar, DTMenuBar menubar) {
	JMenu menu = new JMenu("Run");
	UIBit jiveBit;
	UIBit atkPanelBit;

	
	jiveBit = new UIBit("Run jive...",
			    new ActionListener() {
				public void actionPerformed(ActionEvent e) {
				    runJive();
				}
			    });

	atkPanelBit = new UIBit("Run atkpanel...",
				new ActionListener() {
				    public void actionPerformed(ActionEvent e) {
					runAtkPanel();
				    }
				});

	jiveBit.setEnabled(jive);
	atkPanelBit.setEnabled(atkpanel);
	menu.setMnemonic('U');
	menu.add(jiveBit.getItem());
	//	menu.add(atkPanelBit.getItem());
	menubar.addMenu(menu);
    }

    /**
     * <code>runAtkPanel</code> runs ATKPanel if it is available.
     *
     */
    public static void runAtkPanel() {
	if (atkpanel) {
	    String[] args = new String[0];
	    new atkpanel.MainPanel(args);	    
	}
    }

    /**
     * <code>runAtkPanel</code> runs ATKPanel if it is available.
     *
     * @param deviceName a <code>String</code> containing the 
     */
    public static void runAtkPanel(IDevice device) {
	if (atkpanel) {
	    final String[] args = new String[1];
	    args[0] = device.getName();
	    new Thread() {
		public void run() {
		    new atkpanel.MainPanel(args);
		}
	    }.start();
	}
    }

    /**
     * <code>runJive</code> runs Jive if it is available.
     *
     */
    public static void runJive() {
	if (jive) {
	    new jive.MainPanel();
	}
    }

    /**
     * <code>isJiveAvailable</code>
     *
     * @return a <code>boolean</code> value which is true if
     * jive is available, that is <code>jive.MainPanel</code> is in
     * the CLASSPATH
     */
    public static boolean isJiveAvailable() {
	return jive;
    }

    /**
     * <code>isATKPanelAvailable</code>
     *
     * @return a <code>boolean</code> value which is true if
     * ATKPanel is available, that is <code>apps.atkpanel.MainPanel</code>
     * is in the CLASSPATH
     */
    public static boolean isATKPanelAvailable() {
	return atkpanel;
    }

    static protected void jiveCheck() {
	try {

	    Class.forName(JIVE);
	    jive = true;
	} catch (Exception e) {
	    ;
	}
    }

    static protected void atkCheck() {
	try {
	    Class.forName(ATKPANEL);
	    atkpanel = true;
	} catch (Exception e) {
	    ;
	}
    }
}
