// File:          RefreshUI.java
// Created:       2002-09-18 11:50:43, erik
// By:            <erik@assum.net>
// Time-stamp:    <2002-10-18 11:0:12, erik>
// 
// $Id: RefreshUI.java,v 1.2 2005/08/26 13:44:40 ounsy Exp $
// 
// Description:       

package explorer.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;

import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JSeparator;
import javax.swing.JToolBar;



/**
 * <code>RefreshUI</code> is responsible for handling the refresh part fo the 
 * user interface. 
 * @author <a href="mailto:erik@assum.net">Erik Assum</a>
 * @version $Revision: 1.2 $
 */
public class RefreshUI {
    UIBit startBit;
    UIBit stopBit;
    UIBit refreshBit;
    UIBit intervalBit;

    ImageIcon startIcon;
    ImageIcon stopIcon;
    ImageIcon refreshIcon;

    explorer.ui.Dialog rDialog;

    Preferences prefs;
    RefreshDialog refresh;
    Refresher main;
	    
    public RefreshUI(Refresher main, JToolBar toolbar,
		     DTMenuBar menubar) {

	JMenu menu = new JMenu("Refresh");				 
	this.main = main;
	
	refresh = new RefreshDialog(this);
	PreferencesDialog.getInstance().addTop("Refresh interval",
					       refresh);
	stopIcon =
	    new ImageIcon
	    (getClass().
	     getResource("/fr/esrf/tangoatk/widget/util/Pause16.gif"));

        startIcon =
	    new ImageIcon
	    (getClass().
	     getResource("/fr/esrf/tangoatk/widget/util/Play16.gif"));

        refreshIcon =
	    new ImageIcon
	    (getClass().getResource("/fr/esrf/tangoatk/widget/util/Refresh16.gif"));

	startBit = new UIBit("Start", "Start refresher",
			     new ActionListener() {
				 public void actionPerformed(ActionEvent e) {
				     startRefresher();
				 }
			     }, startIcon);

	refreshBit = new UIBit("Refresh", "Refresh",
			     new ActionListener() {
				 public void actionPerformed(ActionEvent e) {
				     refresh();
				 }
			     }, refreshIcon);

	refreshBit.setAccelerator("F5");
	
	stopBit = new UIBit("Stop", "Stop refresher",
			     new ActionListener() {
				 public void actionPerformed(ActionEvent e) {
				     stopRefresher();
				 }
			     }, stopIcon);

	intervalBit = new UIBit("Set refresh interval...",
				new ActionListener() {
				    public void actionPerformed(ActionEvent e) {
					showRefreshIntervalDialog();
				    }
				    
				});
				    
	menu.add(refreshBit.getItem());
	menu.add(startBit.getItem());
	menu.add(stopBit.getItem());
	menu.add(new JSeparator());
	menu.add(intervalBit.getItem());

	menu.setMnemonic('R');
	menubar.addMenu(menu);

	stopBit.setEnabled(false);

	toolbar.add(stopBit.getButton());
	toolbar.add(startBit.getButton());
	toolbar.add(refreshBit.getButton());

    }


	    
    /**
     * <code>showRefreshIntervalDialog</code> shows the refresh interval
     * dialog.
     */
    public void showRefreshIntervalDialog() {
	if (rDialog == null) {
	    rDialog = new explorer.ui.Dialog();
	    rDialog.setComponent(refresh);
	}

	rDialog.show();
    }


    /**
     * <code>setRefreshInterval</code> calls its Refresher
     * <code>setRefreshInterval</code> method.
     *
     * @param millisecond an <code>int</code> value specifying the
     * interval.
     */
    protected void setRefreshInterval(int milliseconds ) {
	main.setRefreshInterval(milliseconds);
    }
	    
    /**
     * <code>getRefreshInterval</code> calls its Refreshers
     * <code>getRefreshInterval</code> method.
     *
     * @return an <code>int</code> value
     */
    public int getRefreshInterval() {
	return main.getRefreshInterval();
    }
    

    /**
     * <code>startRefresher</code> calls its Refreshers
     * <code>startRefresher</code> method
     */
    public void startRefresher() {
	stopBit.setEnabled(true);
	startBit.setEnabled(false);
	refreshBit.setEnabled(false);
	main.startRefresher();
	
    }

    
    /**
     * <code>refresh</code> calls its Refreshers <code>refresh</code> method
     *
     */
    public void refresh() {
	main.refresh();
    }

    /**
     * <code>stopRefresher</code> calls its Refreshers
     * <code>stopRefresher</code> method.
     *
     */
    void stopRefresher() {
	startBit.setEnabled(true);
	stopBit.setEnabled(false);
	refreshBit.setEnabled(true);
	main.stopRefresher();
	
    }
}
