/*	Synchrotron Soleil 
 *  
 *   File          :  DTMenuBar.java
 *  
 *   Project       :  devicetree
 *  
 *   Description   :  
 *  
 *   Author        :  GIRARDOT
 *  
 *   Original      :  2 aot 2005 
 *  
 *   Revision:  					Author:  
 *   Date: 							State:  
 *  
 *   Log: DTMenuBar.java,v 
 *
 */

package explorer.ui;

import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import fr.esrf.tangoatk.widget.util.*;

/**
 * @author GIRARDOT
 * 
 * A Menu Bar for Device Tree
 */
public class DTMenuBar extends JMenuBar {

    JMenu file;
    JMenu view;
    JMenu edit;
    JMenu help;
    JMenuItem exitItem;
    JMenuItem aboutItem;
    JMenuItem errorItem;
    JMenuItem helpItem;
    GridBagConstraints constraints;
    ErrorHistory errorHistory;

    /**
     * Constructs the Menu Bar and associates an ErrorHistory
     * @param errorHistory the ErrorHistory
     */
    public DTMenuBar(ErrorHistory errorHistory) {
        this();
        setErrorHistory(errorHistory);
    }

    public void setErrorHistory(ErrorHistory errorHistory) {
        this.errorHistory = errorHistory;
    }

    public ErrorHistory getErrorHistory() {
        return errorHistory;
    }

    protected void showErrorHistory() {
        if (errorHistory == null)
            return;
        errorHistory.show();
    }

    protected void showHelpWindow() {
        HelpWindow.getInstance().show();
    }

    public DTMenuBar() {
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        setLayout(new GridBagLayout());

        add(file = new JMenu("File"), constraints);
        constraints.gridx++;
        add(edit = new JMenu("Edit"), constraints);
        constraints.gridx++;
        add(view = new JMenu("View"), constraints);

        constraints.fill = GridBagConstraints.HORIZONTAL;
        constraints.weightx = 0.1;
        constraints.gridx = 200;
        add(new JLabel(""), constraints);
        constraints.fill = GridBagConstraints.NONE;
        constraints.gridx = 201;
        constraints.weightx = 0;
        add(help = new JMenu("Help"), constraints);
        constraints.gridx = 3;

        exitItem = new JMenuItem("Quit");
        aboutItem = new JMenuItem("About...");
        helpItem = new JMenuItem("Help");

        file.setMnemonic('F');
        view.setMnemonic('V');
        edit.setMnemonic('E');
        help.setMnemonic('H');

        exitItem.setAccelerator(KeyStroke.getKeyStroke('Q', KeyEvent.CTRL_MASK));
        helpItem.setAccelerator(KeyStroke.getKeyStroke("F1"));
        helpItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                showHelpWindow();
            }
        });

        errorItem = new JMenuItem("Error history...");
        errorItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent evt) {
                showErrorHistory();
            }
        });
        errorItem.setAccelerator(KeyStroke.getKeyStroke('E', KeyEvent.CTRL_MASK));
        add2ViewMenu(errorItem, 0);

        file.add(new JSeparator());
        file.add(exitItem);

        help.add(aboutItem);
        help.add(helpItem);
    }

    public void setFont(Font f) {
        super.setFont(f);
        if (file == null)
            return;

        file.setFont(f);
        view.setFont(f);
        edit.setFont(f);
        help.setFont(f);
        exitItem.setFont(f);
        errorItem.setFont(f);
        aboutItem.setFont(f);
        helpItem.setFont(f);
    }

    public void setQuitHandler(ActionListener listener) {
        exitItem.addActionListener(listener);
    }

    public void setAboutHandler(ActionListener listener) {
        aboutItem.addActionListener(listener);
    }

    public void add2ViewMenu(JComponent item, int i) {
        item.setFont(getFont());
        view.add(item, i);
    }

    public void add2ViewMenu(JComponent item) {
        item.setFont(getFont());
        view.add(item);
    }

    public void add2EditMenu(JComponent item, int i) {
        item.setFont(getFont());
        edit.add(item, i);
    }

    public void add2EditMenu(JComponent item) {
        item.setFont(getFont());
        edit.add(item);
    }

    public void add2HelpMenu(JComponent item, int i) {
        item.setFont(getFont());
        help.add(item, i);
    }

    public void add2HelpMenu(JComponent item) {
        item.setFont(getFont());
        help.add(item);
    }

    public void add2FileMenu(JComponent item, int i) {
        item.setFont(getFont());
        file.add(item, i);
    }

    public void add2FileMenu(JComponent item) {
        item.setFont(getFont());
        file.add(item);
    }

    public void addMenu(JMenu menu) {
        constraints.gridx++;
        menu.setFont(getFont());
        add(menu, constraints);
    }
}