// File:          PropertySelector.java
// Created:       2002-09-12 14:44:21, erik
// By:            <erik@skiinfo.fr>
// Time-stamp:    <2003-01-16 13:19:37, erik>
// 
// $Id: ViewDialog.java,v 1.2 2005/08/26 13:44:40 ounsy Exp $
// 
// Description:       

package explorer;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import java.util.Vector;

import javax.swing.JCheckBox;
import javax.swing.JPanel;

import fr.esrf.tangoatk.widget.util.HelpWindow;
import fr.esrf.tangoatk.widget.util.IApplicable;
import fr.esrf.tangoatk.widget.util.IHelpful;

public class ViewDialog extends JPanel implements IApplicable,
						  IHelpful,
						  ColumnListener {
    java.util.List checkBoxes = new Vector();
    EntityTableModel tableModel;
    String helpUrl = "/explorer/html/ViewDialogHelp.html";

    public ViewDialog(EntityTableModel tableModel) {
	this.tableModel = tableModel;
	tableModel.addColumnListener(this);
	initComponents(tableModel);
    }

    public java.net.URL getHelpUrl() {
	return getClass().getResource(helpUrl);
    }

    public void apply() {
	boolean [] visible = new boolean[checkBoxes.size()];
	String [] names = new String[checkBoxes.size()];
	for (int i = 0; i < checkBoxes.size(); i++) {
	    JCheckBox tmp = (JCheckBox)checkBoxes.get(i);
	    visible[i] = tmp.isSelected();
	    names[i] =  tmp.getText();
	}
	tableModel.setVisible(names, visible);
    }

    public void cancel() {
	getRootPane().getParent().setVisible(false);
    }

    public void ok() {
	getRootPane().getParent().setVisible(false);
	apply();
    }

    public void help() {
	HelpWindow.getInstance().showUrl(getClass().getResource(helpUrl));
    }

    public void columnsChanged() {
	for (int i = 0; i < checkBoxes.size(); i++) {
	    JCheckBox tmp = (JCheckBox)checkBoxes.get(i);
	    tmp.setSelected(tableModel.isVisible(tmp.getText()));
	}
    }
    
    protected void initComponents(EntityTableModel tableModel) {
	HelpWindow.getInstance().addCategory("Dialogs", "View dialog",
					     getClass().getResource(helpUrl));
	List properties = tableModel.getAllColumnNames();

	setLayout(new GridBagLayout());
	GridBagConstraints constraints = new GridBagConstraints();

	constraints.gridx = 0;
	constraints.gridy = 0;
	constraints.fill=GridBagConstraints.HORIZONTAL;

	for (int i = 0; i < properties.size(); i++) {
	    String name = (String)properties.get(i);
	    if (name == AttributeTableModel.NAME ||
		name == CommandTableModel.COMMAND) continue;
	    
	    JCheckBox tmp = new JCheckBox(name, tableModel.isVisible(name));
	    checkBoxes.add(tmp);
	    add(tmp, constraints);
	    constraints.gridy++;
	    if (constraints.gridy == 4) {
		constraints.gridy = 0;
		constraints.gridx++;
	    }
	    
	}
	
	constraints.gridwidth = constraints.gridx + 1;
	constraints.gridy = 5;
	constraints.gridx = 0;
	constraints.weightx = 1;
    }

    public static void main(String [] args) {
	new ViewDialog(new AttributeTableModel(null,null)).show();
    }
}
