// File:          PropertySelector.java
// Created:       2002-09-12 14:44:21, erik
// By:            <erik@skiinfo.fr>
// Time-stamp:    <2002-09-12 15:11:14, erik>
// 
// $Id: PropertySelector.java,v 1.2 2005/08/26 13:44:40 ounsy Exp $
// 
// Description:       

package explorer;

import javax.swing.*;
import java.awt.*;

import fr.esrf.tangoatk.widget.util.*;

/**
 * Class that manages the property selection window (the one to choose which property 
 * you will see in Attribute panel). This class is no more used
 * @author Erik ASSUM
 */
public class PropertySelector extends JPanel implements IApplicable {

    /**
     * Class constructor, initializer
     */
    public PropertySelector() {

	initComponents();
    }

    /**
     * useless (epmty)
     */
    public void apply() {

    }

    /**
     * Closes/hides the window
     */
    public void cancel() {
	getRootPane().getParent().setVisible(false);
    }

    /**
     * Closes/hides the window and applies changes
     */
    public void ok() {
	getRootPane().getParent().setVisible(false);
	apply();
    }
    
    /**
     * Initializes the different components, like checkboxes
     */
    protected void initComponents() {
	setLayout(new GridBagLayout());
	GridBagConstraints constraints = new GridBagConstraints();
	constraints.gridx = 0;
	constraints.gridy = 0;
	constraints.fill=GridBagConstraints.HORIZONTAL;
	add(new JCheckBox("Device", true), constraints);
	constraints.gridy++;
	add(new JCheckBox("Label", true), constraints);
	constraints.gridy++;
	add(new JCheckBox("Value", true), constraints);
	constraints.gridy++;
	add(new JCheckBox("Display Unit", true), constraints);
	constraints.gridy++;
	add(new JCheckBox("Min Value", true), constraints);
	constraints.gridy++;
	add(new JCheckBox("Max Value", true), constraints);
	constraints.gridy++;
	add(new JCheckBox("Min Alarm", true), constraints);
	constraints.gridy = 0;
	constraints.gridx = 1;
	add(new JCheckBox("Max Alarm", true),constraints);
	constraints.gridy++;
	add(new JCheckBox("Unit", true), constraints);
	constraints.gridy++;
	add(new JCheckBox("Data Format", true), constraints);
	constraints.gridy++;
	add(new JCheckBox("Data Type", true), constraints);
	constraints.gridy++;
	add(new JCheckBox("Description", true), constraints);
	constraints.gridy++;
	add(new JCheckBox("Writable", true), constraints);
	constraints.gridy++;
	add(new JCheckBox("Writable name", true), constraints);
	constraints.gridy = 0;
	constraints.gridx = 2;
	add(new JCheckBox("Max x", true), constraints);
	constraints.gridy++;
	add(new JCheckBox("Max y", true), constraints);
	constraints.gridy++;
	add(new JCheckBox("Display Level", true), constraints);
	constraints.gridy++;
	add(new JCheckBox("Standard unit", true), constraints);
	constraints.gridy = 7;
	constraints.gridx = 0;
	constraints.gridwidth = 3;
	ButtonBar bb = new ButtonBar();
	bb.setControlee(this);
	add(bb, constraints);
    }

    public static void main(String [] args) {


	JFrame f = new JFrame();
	f.getContentPane().add(new PropertySelector());
	f.pack();
	f.show();
    }
	    
}
