// File:          Main.java
// Created:       2002-09-13 12:33:17, erik
// By:            <erik@assum.net>
// Time-stamp:    <2003-01-16 15:33:11, erik>
// 
// $Id: Main.java,v 1.5 2005/08/26 13:44:40 ounsy Exp $
// 
// Description:       


package explorer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;

import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

import explorer.ui.DTMenuBar;
import explorer.ui.EditUI;
import explorer.ui.FileHandler;
import explorer.ui.FileUI;
import explorer.ui.RefreshUI;
import explorer.ui.RunUI;
import explorer.ui.UIDialog;
import fr.esrf.tangoatk.core.AEntityList;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.IStatusListener;
import fr.esrf.tangoatk.core.StatusEvent;
import fr.esrf.tangoatk.widget.attribute.Trend;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import fr.esrf.tangoatk.widget.util.ErrorPopup;
import fr.esrf.tangoatk.widget.util.HelpWindow;
import fr.esrf.tangoatk.widget.util.Splash;



/**
 * Schema for the main class. This class contains what's common for the main "admin mode" and the main
 * "user mode"
 * @author Erik ASSUM
 */
public abstract class Main implements Status, FileHandler, IStatusListener {
    String done = "done";
    static String VERSION = "Device Tree : V1.3";
    public static boolean FULL = false;
    AttributePanel attributePanel;
    AttributeTable attributeTable;
    AttributeTableModel attributeTableModel;
    CommandTable commandTable;
    CommandTableModel commandTableModel;
    DTMenuBar menuBar;
    ErrorHistory errorHistory;
    ErrorPopup errorPopup;
    JFrame mainFrame;
    JToolBar refreshBar;
    JToolBar fileBar;
    File file;
    Preferences preferences;
    explorer.ui.Dialog trendFrame;

    JPopupMenu entityPopup;
    JPopupMenu treePopup;
    JProgressBar progress;
    JLabel status;
    JCheckBoxMenuItem trendVisible;
    JSplitPane tableSplit;
    JSplitPane viewSplit;
    FileManager fileManager;
    static Trend globalTrend;
    boolean isAdmin;
    Splash splash;
    boolean runningFromShell=true;
    int windowX, windowY, windowWidth, windowHeight, tableSplitWidth,
	tableSplitHeight;
    int viewSplitDividerLocation, tableSplitDividerLocation,
	mainSplitDividerLocation;
    boolean globalTrendVisible;

    boolean fileRecordable = true;

    public static final int DEFAULT_WINDOW_X = 50;
    public static final int DEFAULT_WINDOW_Y = 50;
    public static final int DEFAULT_WINDOW_WIDTH = 800;
    public static final int DEFAULT_WINDOW_HEIGHT = 600;
    public static final int DEFAULT_TABLE_SPLIT_DIVIDER_LOCATION = 200;
    public static final int DEFAULT_TABLE_SPLIT_WIDTH = 800;
    public static final int DEFAULT_TABLE_SPLIT_HEIGHT = 400;
    public static final int DEFAULT_VIEW_SPLIT_DIVIDER_LOCATION = 400;
    public static final boolean DEFAULT_GLOBAL_TREND_VISIBLE = true;
    public static final int DEFAULT_MAIN_SPLIT_DIVIDER_LOCATION = 300;

    public static final String MAIN_SPLIT_DIVIDER_LOCATION_KEY =
	"MAIN_SPLIT_DIVIDER_LOCATION";
    public static final String WINDOW_X_KEY = "MAIN_WINDOW_X";
    public static final String WINDOW_Y_KEY = "MAIN_WINDOW_Y";
    public static final String WINDOW_WIDTH_KEY = "MAIN_WINDOW_WIDTH";
    public static final String WINDOW_HEIGHT_KEY = "MAIN_WINDOW_HEIGHT";
    public static final String TABLE_SPLIT_DIVIDER_LOCATION_KEY =
	"TABLE_SPLIT_DIVIDER_LOCATION";
    public static final String VIEW_SPLIT_DIVIDER_LOCATION_KEY =
	"VIEW_SPLIT_DIVIDER_LOCATION";
    public static final String TABLE_SPLIT_WIDTH_KEY = "TABLE_SPLIT_WIDTH";
    public static final String TABLE_SPLIT_HEIGHT_KEY = "TABLE_SPLIT_HEIGHT";
    public static final String GLOBAL_TREND_VISIBLE_KEY =
	"GLOBAL_TREND_VISIBLE";

    /**
     * Initialization of help page
     */
    protected void initHelp() {
	if( runningFromShell ) splash.setMessage("Setting up help...");
	HelpWindow.getInstance()
	    .setTop("Explorer", getClass().getResource
				("/explorer/html/MainHelp.html"));
	    
	HelpWindow.getInstance()
	    .addCategory("Main", "Device tree", getClass().getResource
				("/explorer/html/DeviceTreeHelp.html"));
	HelpWindow.getInstance()
	    .addCategory("Main", "Tool bar", getClass().getResource
				("/explorer/html/ToolBarHelp.html"));
	    
	HelpWindow.getInstance()
	    .addCategory("Main", "Menu bar", getClass().getResource
				("/explorer/html/MenuBarHelp.html"));
	if( runningFromShell ) splash.setMessage("Setting up help..." + done);
    }

    /**
     * Initialization of trend panel
     */
    protected void initTrend() {
	if( runningFromShell ) splash.setMessage("Setting up trend...");	    

	trendVisible = new JCheckBoxMenuItem("Global trend...");

	globalTrend = new Trend();
//	globalTrend.setListVisible(false);
	//	globalTrend.setVisible(false);
//	globalTrend.setLegendVisible(true);
	trendFrame = new explorer.ui.Dialog(globalTrend);

	trendVisible.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent evt) {
		    //		    globalTrend.setVisible(trendVisible.isSelected());
		    int loc = tableSplit.getDividerLocation();

		    if (trendVisible.isSelected()) {
			viewSplit.setDividerLocation(0.5d);
		    } else {
			viewSplit.setDividerLocation(1.0d);
		    }
		    
		    tableSplit.setDividerLocation(loc);		    

		    
		    //		    trendFrame.setVisible(true);
		}
	    });

	globalTrend.setButtonBarVisible(false);

	attributeTable.setGlobalTrend(globalTrend);
	
	menuBar.add2ViewMenu(trendVisible, 1);
	if( runningFromShell ) splash.setMessage("Setting up trend..." + done);
    }

    /**
     * Initialaztion of file manager
     */
    protected void initFileManager() {
	fileManager = FileManager.getInstance();
	fileManager.addErrorListener(errorHistory);
    }
    
    /**
     * Initialization of tables (attributes, command, etc...)
     */
    protected void initTables() {
	if( runningFromShell ) splash.setMessage("Initializing components...");	           

	attributeTableModel.addErrorListener(errorHistory);
	attributeTableModel.addErrorListener(errorPopup);
	commandTableModel.addErrorListener(errorHistory);
	commandTableModel.addErrorListener(errorPopup);

	if( runningFromShell ) splash.setMessage("Initializing collections..." + done);	
    }

    /**
     * Sets preferences default values
     */
    protected void resetPreferences() {
	windowX = preferences.getInt(WINDOW_X_KEY, DEFAULT_WINDOW_X);
	windowY = preferences.getInt(WINDOW_Y_KEY, DEFAULT_WINDOW_Y);
	windowWidth =
	    preferences.getInt(WINDOW_WIDTH_KEY, DEFAULT_WINDOW_WIDTH);
	windowHeight =
	    preferences.getInt(WINDOW_HEIGHT_KEY, DEFAULT_WINDOW_HEIGHT);
	tableSplitHeight = preferences.getInt(TABLE_SPLIT_HEIGHT_KEY,
					      DEFAULT_TABLE_SPLIT_HEIGHT);
	tableSplitWidth = preferences.getInt(TABLE_SPLIT_WIDTH_KEY,
					     DEFAULT_TABLE_SPLIT_WIDTH);

	tableSplitDividerLocation =
	    preferences.getInt(TABLE_SPLIT_DIVIDER_LOCATION_KEY,
			       DEFAULT_TABLE_SPLIT_DIVIDER_LOCATION);
	viewSplitDividerLocation =
	    preferences.getInt(VIEW_SPLIT_DIVIDER_LOCATION_KEY,
			       DEFAULT_VIEW_SPLIT_DIVIDER_LOCATION);

	mainSplitDividerLocation =
	    preferences.getInt(MAIN_SPLIT_DIVIDER_LOCATION_KEY,
			       DEFAULT_MAIN_SPLIT_DIVIDER_LOCATION);
    }

    /**
     * Preferences initialization. You have to initialize file manager first
     */
    protected void initPreferences() {
	if( runningFromShell ) splash.setMessage("Getting preferences...");
	preferences = FileManager.getInstance().getPreferences();
	resetPreferences();
	if( runningFromShell ) splash.setMessage("Getting preferences..." + done);
    }

    /**
     * Main window initialization.
     * @param isAdmin to know if UI is launched in "admin" (<code>true</code>) 
     * or "user" (<code>false</code>) mode
     */
    protected void initUI(boolean isAdmin) {
	if( runningFromShell ) splash.setMessage("Initializing ui...");

	Font font = new Font("Dialog", 0, 12);
	UIManager.put("Label.font", font);
	UIManager.put("MenuBar.font",font);
	UIManager.put("MenuItem.font", font);
	UIManager.put("Menu.font", font);
	UIManager.put("Button.font",font);
	UIManager.put("TabbedPane.font",font);
	UIManager.put("CheckBox.font",font);
	UIManager.put("ProgressBar.font", font);
	
	errorPopup   = new ErrorPopup();
	menuBar = new DTMenuBar(errorHistory);
	
	refreshBar = new JToolBar();
	fileBar = new JToolBar();
	mainFrame = new JFrame(VERSION);
	status    = new JLabel();
	status.setBorder(BorderFactory.createLoweredBevelBorder());
	status.setText("Ready...");
	progress = new JProgressBar();
	progress.setBorder(BorderFactory.createLoweredBevelBorder());
	mainFrame.setJMenuBar(menuBar);
	mainFrame.setBounds(windowX, windowY, windowWidth, windowHeight);

	attributeTableModel = new AttributeTableModel(this, preferences);
	attributeTable = new AttributeTable(attributeTableModel,
					    preferences, isAdmin);

	commandTableModel = new CommandTableModel(this, preferences);
	commandTable = new CommandTable(commandTableModel,
					preferences, isAdmin);
	
	new RefreshUI(attributeTableModel, refreshBar, menuBar);
	new FileUI(this, fileBar, menuBar, isAdmin, mainFrame);
	new EditUI(attributeTableModel, commandTableModel, fileBar, menuBar, isAdmin);
	new RunUI(fileBar, menuBar);
	
	UIDialog.getInstance().addComponent(mainFrame);
	attributePanel = new AttributePanel();

	attributePanel.setTable(attributeTable);
	
	if( runningFromShell ) splash.setMessage("Initializing ui..." + done);
    }
    
    /**
     * Initialization of the different components of the application
     */
    protected void initComponents() {
	Runtime.getRuntime().addShutdownHook(new Thread() {
		public void run() {
		   exit();
		}
	    });
	    
	if( runningFromShell ) {
	  splash = new Splash();
	  splash.setTitle(VERSION);
	  splash.setMaxProgress(10);
	  splash.progress(1);
	}
	
	DeviceFactory.setAutoStart(false);
	errorHistory = new ErrorHistory();
	initFileManager();
	initPreferences();
	if( runningFromShell ) splash.progress(2);
	initUI(isAdmin);

	// allowing printing

	if( runningFromShell ) splash.progress(3);
	initTables();
	if( runningFromShell ) splash.progress(4);

	if( runningFromShell ) splash.progress(6);
	initHelp();
	if( runningFromShell ) splash.progress(7);
	initTrend();
	if( runningFromShell ) splash.progress(8);

	if( runningFromShell ) splash.setMessage("Setting up frame...");	           

	// There seems to be a bug in jdk1.4 which makes JSplitPane
	// angry if you try to specify its size when adding its
	// subcomponents in the constructor. Therefore I've chosen
	// to add them after I've specified the size
	// Erik.
	
	tableSplit =
	    new JSplitPane(JSplitPane.VERTICAL_SPLIT);

	tableSplit.setPreferredSize(new Dimension(tableSplitWidth,
						  tableSplitHeight));
	tableSplit.setDividerSize(9);
	
	tableSplit.setTopComponent(attributePanel);
	tableSplit.setBottomComponent(commandTable);

	tableSplit.setOneTouchExpandable(true);
	
	tableSplit.setDividerLocation(DEFAULT_TABLE_SPLIT_DIVIDER_LOCATION); 
	tableSplit.setResizeWeight(0.5);

	viewSplit = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
	
	viewSplit.setPreferredSize(new Dimension(800,200));
	viewSplit.setDividerSize(9);
	
	viewSplit.setTopComponent(tableSplit);
	viewSplit.setBottomComponent(new JScrollPane(globalTrend));
	
	viewSplit.setOneTouchExpandable(true);
	
	viewSplit.setDividerLocation(DEFAULT_VIEW_SPLIT_DIVIDER_LOCATION); 
	viewSplit.setResizeWeight(2d/3d);
	
	mainFrame.getContentPane().setLayout(new GridBagLayout());

	GridBagConstraints constraints = new GridBagConstraints();

	constraints.weightx = 0;
	constraints.gridy = 0;
	constraints.gridx = 0;
	mainFrame.getContentPane().add(refreshBar, constraints);
	constraints.gridx = 1;
	mainFrame.getContentPane().add(fileBar, constraints);
	constraints.fill = GridBagConstraints.BOTH;
	constraints.gridx = 2;
	constraints.weightx = 1;
	mainFrame.getContentPane().add(new JLabel(), constraints);
	constraints.gridx = 0;
	constraints.gridy = 1;
	constraints.weighty = 0.5;
	constraints.fill = GridBagConstraints.BOTH;
	constraints.gridwidth = GridBagConstraints.REMAINDER;

	constraints.gridx = 0;

	if( runningFromShell ) splash.setMessage("Setting up frame..." + done);
	if( runningFromShell ) splash.progress(9);
	specificSetup(constraints);
	if( runningFromShell ) splash.progress(10);
	//	constraints.gridy++;
	//	mainFrame.getContentPane().add(globalTrend, constraints);

	initStatus(constraints);
	menuBar.setAboutHandler(new ActionListener() {
		public void actionPerformed(ActionEvent evt) {
		    new About().show();

		}
	    });
	
	mainFrame.addWindowListener(new WindowAdapter() {
		public void windowClosing(WindowEvent we) {
		    quit();

		}
	    });

	//	commandTableModel.addEntities(fileManager.getCommandList());
	//	attributeTableModel.addEntities(fileManager.getAttributeList());
	if( runningFromShell ) splash.setVisible(false);
	if( runningFromShell ) splash.dispose();
    }

    /**
     * Initialization of status panel following constraints
     * @param constraints the constraints
     */
    protected void initStatus(GridBagConstraints constraints) {
	JPanel p = new JPanel();	
	constraints.gridy++;
	constraints.weightx = 0.1;
	constraints.weighty = 0;
	constraints.gridx = 0;
	constraints.fill = GridBagConstraints.BOTH;
	constraints.anchor = GridBagConstraints.WEST;
	constraints.gridwidth = GridBagConstraints.REMAINDER;
	constraints.gridx = 0;
	constraints.weightx = 0.9;
	mainFrame.getContentPane().add(p, constraints);
	p.setLayout(new GridBagLayout());
	constraints.gridx = 0;
	constraints.gridy = 0;
	constraints.gridwidth = 1;
	constraints.weightx = 0;
	p.add(progress, constraints);
	constraints.gridx = 1;
	constraints.weightx = 1;
	p.add(status, constraints);
    }

    /**
     * Opens a file
     * @param file the file
     */
    public void open(File file) {
	this.file = file;
	fileRecordable = open(file.getAbsolutePath());
    }
    
    /**
     * Opens a file following a path
     * @param source the path
     */
    protected boolean open(String source) {
	mainFrame.setTitle(source);
	final String src = source;
	attributePanel.clear();
	progress.setIndeterminate(true);
	progress.setStringPainted(true);
	boolean success = false;
	try {
	    success = fileManager.open(source);
	    resetPreferences();

	    tableSplit.setDividerLocation(tableSplitDividerLocation);
	    tableSplit.setPreferredSize(new Dimension(tableSplitWidth,
						      tableSplitHeight));
	    mainFrame.setBounds(windowX, windowY, windowWidth, windowHeight);

	    SwingUtilities.updateComponentTreeUI(mainFrame);
	    viewSplit.setDividerLocation(viewSplitDividerLocation);
	    AEntityList attributes = fileManager.getAttributeList();
	    AEntityList commands = fileManager.getCommandList();
	    attributeTable.setPreferences(preferences);
	    commandTable.setPreferences(preferences);
	    attributeTableModel.setPreferences(preferences);
	    commandTableModel.setPreferences(preferences);
	    attributeTableModel.addEntities(attributes);
	    commandTableModel.addEntities(commands);
	    
	    // Restore trenp options
	    EntityTableModel model = (EntityTableModel)attributeTable.getModel();	
            for(int i=0;i<model.getRowCount();i++) {
              IEntity att = model.getEntityAt(i);
	      if( att instanceof INumberSpectrum ) {
	        String keyname = att.getName() + ".GraphSettings";
                String st  = preferences.getString(keyname,"");
		String err = attributePanel.setSpectrumGraphSettings(att,st);
		if( err.length()>0 ) JOptionPane.showMessageDialog(null,"Failed apply trend configuration: " + err,"Error",JOptionPane.ERROR_MESSAGE);
	      }
	    }

	} catch (Exception e) {
	    status("Could not open " + file, e);
	    e.printStackTrace();
	    return false;
	}

	progress.setIndeterminate(false);
	return success;
    }

    /**
     * Displays the status panel
     * @param msg the message to display in status panel
     * @param e exception received to display in status panel
     */
    public void status(String msg, Exception e) {
	status(mainFrame ,msg, e);
    }

    /**
     * Displays the status panel
     * @param comp the component in whch the status panel will be displayed
     * @param msg the message to display in status panel
     * @param e exception received to display in status panel
     */
    public static void status(Component comp, String msg, Exception e) {
	JOptionPane.showMessageDialog(comp, msg + " " + e.toString(), "Error",
				JOptionPane.ERROR_MESSAGE);
    }

    /**
     * To display changes in status panel
     * @param evt the event that changed the status
     */
    public void statusChange(StatusEvent evt) {
	status.setText(evt.getStatus());
    }

    /**
     * To quit
     */
    public void quit() {
	if(runningFromShell) System.exit(0);
	else               {
	  mainFrame.hide();
	  mainFrame.dispose();
	}
    }

    /**
     * useless, empty
     */
    public void exit() {

    }

    /**
     * To run application with specific setup defined by constraints
     * @param constraints the constraints
     */
    protected abstract void specificSetup(GridBagConstraints constraints);

    public static void main(String [] args) {
	FULL = true;
	if (args.length == 0) {
	    new AdminMain(args);
	} else {
	    new ViewerMain(args);
	}
    }
}
