/*
 *  
 *   File          :   StringSpectrumPanel.java
 *  
 *   Project       :   atkpanel generic java application
 *  
 *   Description   :   The panel to display a  string spectrum attribute
 *  
 *   Author        :   Faranguiss Poncet
 *  
 *   Original      :   Decmber 2003
 *  
 *   $Revision: 1.16 $				$Author: poncet $
 *   $Date: 2005/05/03 17:02:03 $					$State: Exp $
 *  
 *   $Log: StringSpectrumPanel.java,v $
 *   Revision 1.16  2005/05/03 17:02:03  poncet
 *   Added an new attribute list for state and status attributes without events.
 *
 *   Revision 1.15  2005/04/15 12:16:29  poncet
 *   Added the BooleanScalarAttribute, stateAttributeViewer and statusAttributeViewer.
 *
 *   Revision 1.14  2004/11/24 14:11:56  poncet
 *   Added new constructor (Boolean arguments instead of boolean) to be used in synoptics.
 *
 *   Revision 1.13  2004/11/23 09:37:12  poncet
 *   Added ReadOnly mode for MainPanel which supresses all commands. Removed the
 *   TabbedPanel in the MainPanel when the device has no attribute at all. This
 *   Allows to have a smaller window for gauges for example.
 *
 *   Revision 1.11  2004/10/12 12:57:02  poncet
 *   Committed to keep the same CVS revision number for all files.
 *
 *   Revision 1.10  2003/12/16 17:56:56  poncet
 *   Added the handling of StringSpectrum Attributes in atkpanel.
 *
 *  
 *   Copyright (c) 2003 by European Synchrotron Radiation Facility,
 *  		       Grenoble, France
 *  
 *                         All Rights Reserved
 *  
 *  
 */
 
package atkpanel;

/**
 *
 * @author  poncet
 */
import java.util.*;
import java.lang.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import fr.esrf.tangoatk.core.*;
import fr.esrf.tangoatk.widget.attribute.*;

public class StringSpectrumPanel extends javax.swing.JPanel
{


    private SimpleStringSpectrumViewer       simpleStrSpectrumViewer;

    private IStringSpectrum                  strSpecModel;
    
    
    
    /** Creates new form StringSpectrumPanel */
    public StringSpectrumPanel()
    {
        strSpecModel = null;
	initComponents();
    }

    /** Creates new form StringSpectrumPanel to display a StringSpectrum attribute */
    public StringSpectrumPanel(IStringSpectrum  strspecAtt)
    {
        initComponents();
	strSpecModel = strspecAtt;
        simpleStrSpectrumViewer.setModel(strspecAtt);
    }

    private void initComponents()
    {
       simpleStrSpectrumViewer = new SimpleStringSpectrumViewer();            

       setLayout(new java.awt.GridBagLayout());
       java.awt.GridBagConstraints gridBagConstraints1;

       gridBagConstraints1 = new java.awt.GridBagConstraints();
       gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
       gridBagConstraints1.insets = new java.awt.Insets(1,1,1,1);
       gridBagConstraints1.weightx = 1.0;
       gridBagConstraints1.weighty = 1.0;
       add(simpleStrSpectrumViewer, gridBagConstraints1);        
    }
    
    
    protected IStringSpectrum getModel()
    {
       return strSpecModel;
    }

}
