/*
 *  
 *   File          :   SpectrumPanel.java
 *  
 *   Project       :   atkpanel generic java application
 *  
 *   Description   :   The panel to display a  number spectrum attribute
 *  
 *   Author        :   Faranguiss Poncet
 *  
 *   Original      :   Mars 2002
 *  
 *   $Revision: 1.16 $				$Author: poncet $
 *   $Date: 2005/05/03 17:02:03 $					$State: Exp $
 *  
 *   $Log: SpectrumPanel.java,v $
 *   Revision 1.16  2005/05/03 17:02:03  poncet
 *   Added an new attribute list for state and status attributes without events.
 *
 *   Revision 1.15  2005/04/15 12:16:29  poncet
 *   Added the BooleanScalarAttribute, stateAttributeViewer and statusAttributeViewer.
 *
 *   Revision 1.14  2004/11/24 14:11:56  poncet
 *   Added new constructor (Boolean arguments instead of boolean) to be used in synoptics.
 *
 *   Revision 1.13  2004/11/23 09:37:12  poncet
 *   Added ReadOnly mode for MainPanel which supresses all commands. Removed the
 *   TabbedPanel in the MainPanel when the device has no attribute at all. This
 *   Allows to have a smaller window for gauges for example.
 *
 *   Revision 1.11  2004/10/12 12:57:02  poncet
 *   Committed to keep the same CVS revision number for all files.
 *
 *   Revision 1.10  2003/12/16 17:56:56  poncet
 *   Added the handling of StringSpectrum Attributes in atkpanel.
 *
 *   Revision 1.9  2003/09/25 15:10:50  poncet
 *   Fixed a bug in the handling of keepStateRefresher flag. Stop state refresher
 *   when this flag is set to false and the menu bar command preferences->Stop
 *   refreshing is called.
 *
 *   Revision 1.8  2003/09/19 08:01:18  poncet
 *   Tagged to the same revision number all files.
 *
 *   Revision 1.6  2003/09/19 07:59:19  poncet
 *   Added the operator and expert modes handling. Scalars now displayed by
 *   ATK ScalarListViewer. The Image attributes now displayed by the new
 *   ATK viewer NumberImageViewer.
 *
 *   Revision 1.5  2003/02/03 15:48:11  poncet
 *   Fixed a bug in SpectrumPanel.java related to JTableAdapter.
 *
 *   Revision 1.4  2003/02/03 15:32:09  poncet
 *   Committed to have a coherent and identical revision numbers to
 *   avoid using tags.
 *
 *   Revision 1.3  2003/02/03 15:28:08  poncet
 *   The NumberSpectrumViewer used in SpectrumPanel.java instead of
 *   NumberSpectrumJChartAdapter. With this change there is no need
 *   for Sitraka product JClassChart to run atkpanel.
 *
 *   Revision 1.2  2003/01/28 16:57:42  poncet
 *   Added bin and doc directory
 *
 *   Revision 1.1.1.1  2003/01/28 16:35:55  poncet
 *   Initial import
 *
 *  
 *   Copyright (c) 2002 by European Synchrotron Radiation Facility,
 *  		       Grenoble, France
 *  
 *                         All Rights Reserved
 *  
 *  
 */
 
package atkpanel;

/**
 *
 * @author  poncet
 */
import java.util.*;
import java.lang.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import fr.esrf.tangoatk.core.*;
import fr.esrf.tangoatk.widget.attribute.*;

public class SpectrumPanel extends javax.swing.JPanel
{

    private INumberSpectrum     nsModel;
    /** Creates new form SpectrumPanel */
    public SpectrumPanel()
    {
        nsModel = null;
	initComponents();
    }

    /** Creates new form SpectrumPanel to display a NumberSpectrum attribute */
    public SpectrumPanel(INumberSpectrum  nsAtt)
    {
        initComponents();
	nsModel = nsAtt;
        numberSpectrumViewer.setModel(nsAtt);
        numberImageJTableAdapter1.setViewer(jTable1);
        numberImageJTableAdapter1.setModel(nsAtt);
        jTable1.setVisible(false);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
            numberSpectrumViewer = new fr.esrf.tangoatk.widget.attribute.NumberSpectrumViewer();
            numberImageJTableAdapter1 = new fr.esrf.tangoatk.widget.attribute.NumberImageJTableAdapter();
            jScrollPane1 = new javax.swing.JScrollPane();
            jPanel1 = new javax.swing.JPanel();
            jTable1 = new javax.swing.JTable();
            jCheckBox1 = new javax.swing.JCheckBox();
            
            
            setLayout(new java.awt.GridBagLayout());
            java.awt.GridBagConstraints gridBagConstraints1;
            
            jPanel1.setLayout(new java.awt.GridBagLayout());
            java.awt.GridBagConstraints gridBagConstraints2;
            
            gridBagConstraints2 = new java.awt.GridBagConstraints();
            gridBagConstraints2.fill = java.awt.GridBagConstraints.BOTH;
            gridBagConstraints2.insets = new java.awt.Insets(3, 3, 3, 3);
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            jPanel1.add(numberSpectrumViewer, gridBagConstraints2);
            
            jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
            ) {
                Class[] types = new Class [] {
                    java.lang.Object.class, java.lang.Object.class, java.lang.Object.class, java.lang.Object.class
                };
                
                public Class getColumnClass(int columnIndex) {
                    return types [columnIndex];
                }
            });
            gridBagConstraints2 = new java.awt.GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.fill = java.awt.GridBagConstraints.BOTH;
            gridBagConstraints2.insets = new java.awt.Insets(3, 3, 3, 3);
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.weighty = 1.0;
            jPanel1.add(jTable1, gridBagConstraints2);
            
            jScrollPane1.setViewportView(jPanel1);
          
          gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.insets = new java.awt.Insets(3, 3, 3, 5);
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        add(jScrollPane1, gridBagConstraints1);
        
        jCheckBox1.setSelected(true);
        jCheckBox1.setText("View Graph");
        jCheckBox1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                viewGraphActionPerformed(evt);
            }
        });
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.insets = new java.awt.Insets(0, 5, 0, 5);
        add(jCheckBox1, gridBagConstraints1);
        
    }//GEN-END:initComponents

    private void viewGraphActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_viewGraphActionPerformed
        // Add your handling code here:
	if (jCheckBox1.isSelected())
	{
	   jTable1.setVisible(false);
	   numberSpectrumViewer.setVisible(true);
	}
	else
	{
	   jTable1.setVisible(true);
	   numberSpectrumViewer.setVisible(false);
	}
    }//GEN-LAST:event_viewGraphActionPerformed
    
    protected INumberSpectrum getModel()
    {
       return nsModel;
    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private fr.esrf.tangoatk.widget.attribute.NumberSpectrumViewer numberSpectrumViewer;
    private fr.esrf.tangoatk.widget.attribute.NumberImageJTableAdapter numberImageJTableAdapter1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JTable jTable1;
    private javax.swing.JCheckBox jCheckBox1;
    // End of variables declaration//GEN-END:variables

}
