/*
 *  
 *   File          :   ImagePanel.java
 *  
 *   Project       :   atkpanel generic java application
 *  
 *   Description   :   The panel to display a  number image attribute
 *  
 *   Author        :   Faranguiss Poncet
 *  
 *   Original      :   Mars 2002
 *  
 *   $Revision: 1.16 $				$Author: poncet $
 *   $Date: 2005/05/03 17:02:00 $					$State: Exp $
 *  
 *   $Log: ImagePanel.java,v $
 *   Revision 1.16  2005/05/03 17:02:00  poncet
 *   Added an new attribute list for state and status attributes without events.
 *
 *   Revision 1.15  2005/04/15 12:16:28  poncet
 *   Added the BooleanScalarAttribute, stateAttributeViewer and statusAttributeViewer.
 *
 *   Revision 1.14  2004/11/24 14:11:54  poncet
 *   Added new constructor (Boolean arguments instead of boolean) to be used in synoptics.
 *
 *   Revision 1.13  2004/11/23 09:37:11  poncet
 *   Added ReadOnly mode for MainPanel which supresses all commands. Removed the
 *   TabbedPanel in the MainPanel when the device has no attribute at all. This
 *   Allows to have a smaller window for gauges for example.
 *
 *   Revision 1.11  2004/10/12 12:55:41  poncet
 *   Committed to keep the same CVS revision number for all files.
 *
 *   Revision 1.10  2003/12/16 17:56:56  poncet
 *   Added the handling of StringSpectrum Attributes in atkpanel.
 *
 *   Revision 1.9  2003/09/25 15:10:50  poncet
 *   Fixed a bug in the handling of keepStateRefresher flag. Stop state refresher
 *   when this flag is set to false and the menu bar command preferences->Stop
 *   refreshing is called.
 *
 *   Revision 1.8  2003/09/19 08:01:15  poncet
 *   Tagged to the same revision number all files.
 *
 *   Revision 1.6  2003/09/19 07:59:18  poncet
 *   Added the operator and expert modes handling. Scalars now displayed by
 *   ATK ScalarListViewer. The Image attributes now displayed by the new
 *   ATK viewer NumberImageViewer.
 *
 *   Revision 1.5  2003/02/03 15:48:09  poncet
 *   Fixed a bug in SpectrumPanel.java related to JTableAdapter.
 *
 *   Revision 1.4  2003/02/03 15:32:09  poncet
 *   Committed to have a coherent and identical revision numbers to
 *   avoid using tags.
 *
 *   Revision 1.2  2003/01/28 16:57:40  poncet
 *   Added bin and doc directory
 *
 *   Revision 1.1.1.1  2003/01/28 16:35:55  poncet
 *   Initial import
 *
 *  
 *   Copyright (c) 2002 by European Synchrotron Radiation Facility,
 *  		       Grenoble, France
 *  
 *                         All Rights Reserved
 *  
 *  
 */

package atkpanel;

/**
 *
 * @author  poncet
 */
import java.util.*;
import java.lang.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import fr.esrf.tangoatk.core.*;
import fr.esrf.tangoatk.widget.attribute.*;

public class ImagePanel extends javax.swing.JPanel
{

    private JScrollPane             jScrollPane1;
    private JPanel                  jPanel1;
    private NumberImageViewer       imageViewer1;
    private INumberImage            niModel;


    /** Creates new form ImagePanel */
    public ImagePanel()
    {
        niModel = null;
	initComponents();
    }

    /** Creates new form ImagePanel to display a NumberSpectrum attribute */
    public ImagePanel(INumberImage  niAtt)
    {
        initComponents();
	niModel = niAtt;
        imageViewer1.setModel(niAtt);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents()
    {
            java.awt.GridBagConstraints       gridBagConstraints1;
	    
	    
            gridBagConstraints1 = new java.awt.GridBagConstraints();
            jScrollPane1 = new javax.swing.JScrollPane();
            jPanel1 = new javax.swing.JPanel();
            imageViewer1 = new NumberImageViewer();
            
            
            setLayout(new java.awt.GridBagLayout());

            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
            gridBagConstraints1.insets = new java.awt.Insets(3, 3, 3, 5);
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            add(jScrollPane1, gridBagConstraints1);
        
            
            jPanel1.setLayout(new java.awt.GridBagLayout());
            
            gridBagConstraints1.gridx = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.weighty = 1.0;
            jPanel1.add(imageViewer1, gridBagConstraints1);
            
            jScrollPane1.setViewportView(jPanel1);
        
    }
    
    protected INumberImage getModel()
    {
       return niModel;
    }

}
