//+======================================================================
// $Source: /cvsroot/tango-cs/tango/tools/astor/NewStarterDialog.java,v $
//
// Project:   Tango
//
// Description:  java source code for the TempClass class definition .
//
// $Author: pascal_verdier $
//
// $Revision: 3.7 $
//
// $Log: NewStarterDialog.java,v $
// Revision 3.7  2005/04/22 09:30:45  pascal_verdier
// Use events management in starter properies dialog added.
//
// Revision 3.6  2004/09/28 07:01:51  pascal_verdier
// Problem on two events server list fixed.
//
// Revision 3.5  2004/02/04 14:37:43  pascal_verdier
// Starter logging added
// Database info added on CtrlServersDialog.
//
// Revision 3.4  2003/11/25 15:56:46  pascal_verdier
// Label on hosts added.
// Notifyd begin to be controled.
//
// Revision 3.3  2003/11/05 10:34:57  pascal_verdier
// Main Panel screen centering.
// Starter multi path added.
// little bugs fixed.
//
// Revision 3.2  2003/09/08 11:05:28  pascal_verdier
// *** empty log message ***
//
// Revision 3.1  2003/06/19 12:57:57  pascal_verdier
// Add a new host option.
// Controlled servers list option.
//
// Revision 1.1  2003/06/19 12:27:03  pascal_verdier
// Add host option.
// Controlled servers list option.
//
//
// Copyleft 2003 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================

package admin.astor;

/**
 *	This class is the Astor dialog
 *	to create a new Starter server in TANGO database
 *	and add a new host in AstorTree.
 *
 * @author  root
 */

import fr.esrf.Tango.*;
import fr.esrf.TangoDs.*;
import fr.esrf.TangoApi.*;


import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class NewStarterDialog extends JDialog implements AstorDefs{


	private JFrame		parent;
	private TangoHost[]	hosts;
	private	TangoHost	h;
	private String[]	collec;
	private int			retVal = JOptionPane.CANCEL_OPTION;
	private boolean		creating;

	//======================================================================
	//======================================================================
	private boolean getUseEvents()
	{
		//	Check if use events
		//	Do not use host field because it could 
		//	have been reseted if notifd is stopped !!!!!
		boolean	ue = false;
		try
		{
			DbDatum	data = h.get_property("UseEvents");
			if (data.is_empty()==false)
				ue = data.extractBoolean();
		} catch(Exception e){}
		return ue;
	}
	//======================================================================
    /**
	 *	Creates new NewStarterDialog for editing properties
	 */
	//======================================================================
    public NewStarterDialog(JFrame parent, TangoHost h,
				String[] collec, TangoHost[] hosts, boolean creating)
	{
        super(parent, true);
		this.parent = parent;
		this.hosts  = hosts;
		this.creating  = creating;
		//	Take Off Database (first one)
		this.collec = new String[collec.length-1];
		for (int i=1 ; i<collec.length ; i++)
			this.collec[i-1] = collec[i];

        initComponents();
		
		//	Init text fields with h object fields
		this.h = h;
		if (h!=null)
		{
			String		hostname = h.getName();
			String[]	ds_path = h.getPath();
			for (int i=0 ; i<ds_path.length ; i++)
				pathText.append(ds_path[i] + "\n");
				
			usageText.setText(h.usage);
			familyText.setText(h.getFamily());
			hostText.setText(hostname);

			useEventsBtn.setSelected(getUseEvents());
			if (creating)
			{
				familyText.setText(h.getFamily());
				hostText.setText(hostname);
 				hostText.select(0, hostname.length());
			}
			else
			{
				jLabel3.setText("Change property for " +
									hostname + " starter in database");
				jLabel2.setText("  ");
				hostText.setVisible(false);
				jLabel4.setVisible(false);
				familyText.setVisible(false);
				familyBtn.setVisible(false);
				createBtn.setText("Apply");
			}
		}
		pack();
		AstorUtil.centerDialog(this, parent);
   }
	
	//======================================================================
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
	//======================================================================
   private void initComponents() {//GEN-BEGIN:initComponents
         jPanel1 = new javax.swing.JPanel();
         createBtn = new javax.swing.JButton();
         jLabel1 = new javax.swing.JLabel();
         cancelBtn = new javax.swing.JButton();
         jPanel3 = new javax.swing.JPanel();
         jLabel3 = new javax.swing.JLabel();
         jPanel4 = new javax.swing.JPanel();
         jLabel4 = new javax.swing.JLabel();
         jLabel5 = new javax.swing.JLabel();
         hostText = new javax.swing.JTextField();
         jLabel2 = new javax.swing.JLabel();
         familyText = new javax.swing.JTextField();
         pathBtn = new javax.swing.JButton();
         familyBtn = new javax.swing.JButton();
         jScrollPane1 = new javax.swing.JScrollPane();
         pathText = new javax.swing.JTextArea();
         jLabel6 = new javax.swing.JLabel();
         jLabel7 = new javax.swing.JLabel();
         jLabel8 = new javax.swing.JLabel();
         usageText = new javax.swing.JTextField();
         useEventsBtn = new javax.swing.JRadioButton();
         
         addWindowListener(new java.awt.event.WindowAdapter() {
             public void windowClosing(java.awt.event.WindowEvent evt) {
                 closeDialog(evt);
             }
         });
         
         createBtn.setText("Create");
         createBtn.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                 createBtnActionPerformed(evt);
             }
         });
         
         jPanel1.add(createBtn);
         
         jLabel1.setText("          ");
         jPanel1.add(jLabel1);
         
         cancelBtn.setText("Cancel");
         cancelBtn.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                 cancelBtnActionPerformed(evt);
             }
         });
         
         jPanel1.add(cancelBtn);
         
         getContentPane().add(jPanel1, java.awt.BorderLayout.SOUTH);
         
         jLabel3.setFont(new java.awt.Font("Dialog", 1, 14));
         jLabel3.setText("Create a Starter in Database For a New Host");
         jPanel3.add(jLabel3);
         
         getContentPane().add(jPanel3, java.awt.BorderLayout.NORTH);
         
         jPanel4.setLayout(new java.awt.GridBagLayout());
         java.awt.GridBagConstraints gridBagConstraints1;
         
         jLabel4.setText("Host name :");
         gridBagConstraints1 = new java.awt.GridBagConstraints();
         gridBagConstraints1.gridx = 1;
         gridBagConstraints1.gridy = 1;
         gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
         jPanel4.add(jLabel4, gridBagConstraints1);
         
         jLabel5.setText("Device Servers PATH :");
         gridBagConstraints1 = new java.awt.GridBagConstraints();
         gridBagConstraints1.gridx = 1;
         gridBagConstraints1.gridy = 6;
         gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
         jPanel4.add(jLabel5, gridBagConstraints1);
         
         hostText.setColumns(20);
         hostText.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                 hostTextActionPerformed(evt);
             }
         });
         
         gridBagConstraints1 = new java.awt.GridBagConstraints();
         gridBagConstraints1.gridx = 2;
         gridBagConstraints1.gridy = 1;
         gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
         jPanel4.add(hostText, gridBagConstraints1);
         
         jLabel2.setText("Host Family:");
         gridBagConstraints1 = new java.awt.GridBagConstraints();
         gridBagConstraints1.gridx = 1;
         gridBagConstraints1.gridy = 3;
         gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
         jPanel4.add(jLabel2, gridBagConstraints1);
         
         familyText.setColumns(20);
         gridBagConstraints1 = new java.awt.GridBagConstraints();
         gridBagConstraints1.gridx = 2;
         gridBagConstraints1.gridy = 3;
         gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
         jPanel4.add(familyText, gridBagConstraints1);
         
         pathBtn.setText("...");
         pathBtn.setMargin(new java.awt.Insets(2, 5, 2, 5));
         pathBtn.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                 pathBtnActionPerformed(evt);
             }
         });
         
         gridBagConstraints1 = new java.awt.GridBagConstraints();
         gridBagConstraints1.gridx = 3;
         gridBagConstraints1.gridy = 6;
         jPanel4.add(pathBtn, gridBagConstraints1);
         
         familyBtn.setText("...");
         familyBtn.setMargin(new java.awt.Insets(2, 5, 2, 5));
         familyBtn.addActionListener(new java.awt.event.ActionListener() {
             public void actionPerformed(java.awt.event.ActionEvent evt) {
                 familyBtnActionPerformed(evt);
             }
         });
         
         gridBagConstraints1 = new java.awt.GridBagConstraints();
         gridBagConstraints1.gridx = 3;
         gridBagConstraints1.gridy = 3;
         jPanel4.add(familyBtn, gridBagConstraints1);
         
         jScrollPane1.setPreferredSize(new java.awt.Dimension(300, 180));
           jScrollPane1.setViewportView(pathText);
           
           gridBagConstraints1 = new java.awt.GridBagConstraints();
         gridBagConstraints1.gridx = 1;
         gridBagConstraints1.gridy = 7;
         gridBagConstraints1.gridwidth = 4;
         gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
         jPanel4.add(jScrollPane1, gridBagConstraints1);
         
         jLabel6.setText("   ");
         gridBagConstraints1 = new java.awt.GridBagConstraints();
         gridBagConstraints1.gridx = 1;
         gridBagConstraints1.gridy = 5;
         jPanel4.add(jLabel6, gridBagConstraints1);
         
         jLabel7.setText("   ");
         jLabel7.setPreferredSize(new java.awt.Dimension(220, 15));
         gridBagConstraints1 = new java.awt.GridBagConstraints();
         gridBagConstraints1.gridx = 2;
         gridBagConstraints1.gridy = 6;
         jPanel4.add(jLabel7, gridBagConstraints1);
         
         jLabel8.setText("Host Usage:");
         gridBagConstraints1 = new java.awt.GridBagConstraints();
         gridBagConstraints1.gridx = 1;
         gridBagConstraints1.gridy = 2;
         gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
         jPanel4.add(jLabel8, gridBagConstraints1);
         
         usageText.setColumns(20);
         gridBagConstraints1 = new java.awt.GridBagConstraints();
         gridBagConstraints1.gridx = 2;
         gridBagConstraints1.gridy = 2;
         gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
         jPanel4.add(usageText, gridBagConstraints1);
         
         useEventsBtn.setText("Use Events");
         gridBagConstraints1 = new java.awt.GridBagConstraints();
         gridBagConstraints1.gridx = 2;
         gridBagConstraints1.gridy = 4;
         gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
         gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
         jPanel4.add(useEventsBtn, gridBagConstraints1);
         
         getContentPane().add(jPanel4, java.awt.BorderLayout.CENTER);
       
       pack();
   }//GEN-END:initComponents

	//======================================================================
	//======================================================================
    private void hostTextActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_hostTextActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_hostTextActionPerformed

	//======================================================================
	//======================================================================
    private void familyBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_familyBtnActionPerformed

		//	Create the list for host family
		PropListDialog	list = new PropListDialog(parent, collec);
		list.showDialog();

		String	family = list.getSelectedItem();
		if (family!=null)
			familyText.setText(family);
    }//GEN-LAST:event_familyBtnActionPerformed

	//======================================================================
	//======================================================================
    private void pathBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_pathBtnActionPerformed

		//	Create the list for Start DS Path
		new PropListDialog(parent, pathText, hosts).showDialog();
    }//GEN-LAST:event_pathBtnActionPerformed

	//======================================================================
	//======================================================================
	private void cancelBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelBtnActionPerformed
		retVal = JOptionPane.CANCEL_OPTION;
		doClose();
	}//GEN-LAST:event_cancelBtnActionPerformed

	//======================================================================
	//======================================================================
	private void createBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_createBtnActionPerformed
		String	hostname = hostText.getText();
		String	usage    = usageText.getText();
		String	family   = familyText.getText();
		String	str_ds_path  = pathText.getText().trim();
		if (hostname.length()==0 || str_ds_path.length()==0)
		{
			JOptionPane.showMessageDialog(parent,
								"Fill the fields before creation !",
								"Warning",
								JOptionPane.WARNING_MESSAGE);
			return;
		}
		try
		{
			String	classname= "Starter";
			String	servname = classname + "/" + hostname;
			String	devname  = starterDeviceHeader + hostname;
			String	admindev = "dserver/" + classname + "/" + hostname;

			if (creating)
			{
				//	create server info
				//	create the new Starter server
				System.out.println("Create server");
				DbDevInfo[]	devinfo = new DbDevInfo[2];
				devinfo[0] = new DbDevInfo(admindev, classname, servname);
				devinfo[1] = new DbDevInfo(devname, classname, servname);
				Database	db = ApiUtil.get_db_obj(AstorUtil.getTangoHost());
				//db.add_server(servname, devinfo);
				db.add_device(devname, classname, servname);
			}
			else
				System.out.println("Update properties");


			//	Set PATH property as String array
			str_ds_path = manageBackSlash(str_ds_path);
			String[]	ds_path = AstorUtil.string2StringArray(str_ds_path);
			DeviceProxy	dev = new 	DeviceProxy(devname);
			dev.put_property(new DbDatum("StartDsPath", ds_path));

			//	Set usage property
			if (usage.length()>0)
				dev.put_property(new DbDatum(usage_property, usage));
			//	And if not creating set usage to Host object 
			if (h!=null && !creating)
				if (usage.equals(h.usage)==false)
				{
					h.usage = usage;
					//	Re-create node to resize.
					Astor	astor = (Astor)parent;
					astor.tree.changeHostNode(h);
				}

			//	add host family property
			if (family.length()>0 && creating)
				dev.put_property(new DbDatum(collec_property, family));

			//	Set logging properties (will be done at creation only later)
			String[]	valStr = new String[3];
			valStr[0] = "WARNING";
			valStr[1] = "file::/tmp/ds.log/starter_" + hostname + ".log";
			valStr[2] = new Integer(500).toString();
			DbDatum[]	datum = new DbDatum[logging_properties.length];
			for (int i=0 ; i<logging_properties.length ; i++)
				datum[i] = new DbDatum(logging_properties[i], valStr[i]);
			dev.put_property(datum);

			//	Manage use events if needed.
			manageUseEvents(dev);

			String message;
			if (creating)
				message =
					"A Starter server has been created in TANGO database.\n\n"+
					"You can now start it on " + hostname + " machine." ;
			else
			{
				message = "The property has been modified in database";
				try
				{
					dev.command_inout("Init");
					message += "\nand the device has been re-initialized.";
				}
				catch (DevFailed e){
					//	may be it is stopped
				}
			}
			JOptionPane.showMessageDialog(parent, 
					message, "Command Done", JOptionPane.INFORMATION_MESSAGE);

		}
		catch (DevFailed e)
		{
			app_util.PopupError.show(parent, e);
			return;
		}
		retVal = JOptionPane.OK_OPTION;
		doClose();
	}//GEN-LAST:event_createBtnActionPerformed
	//===============================================================
	//===============================================================
	private void manageUseEvents(DeviceProxy dev) throws DevFailed
	{
		if (useEventsBtn.getSelectedObjects()!=null)
		{
			DbDatum	data = new DbDatum("UseEvents", 1);
			dev.put_property(data);

			DbAttribute	att = new DbAttribute("HostState");
			att.add("abs_change", 1);
			dev.put_attribute_property(att);
		}
		else
		{
			DbDatum	data = new DbDatum("UseEvents", 0);
			dev.put_property(data);
		}
	}
	//===============================================================
	//===============================================================
	static String manageBackSlash(String str)
	{
		String	ret = "";
		int idx = 0;
		while ((idx=str.indexOf("\\", idx))>=0)
		{
			idx++;
			ret += str.substring(0, idx);
			ret += "\\";
			str = str.substring(idx);
			idx = 0;
		}
		ret += str;
		return ret;
	}
	//======================================================================
	//======================================================================
	int	getValue()
	{
		return retVal;
	}
	//======================================================================
    /**
	 *	Closes the dialog
	 */
	//======================================================================
	private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
		retVal = JOptionPane.CANCEL_OPTION;
		doClose();
	}//GEN-LAST:event_closeDialog
	//======================================================================
	//======================================================================
	private void doClose()
	{
		setVisible(false);
		dispose();
	}
	//======================================================================
	//======================================================================


	//======================================================================
        // Variables declaration - do not modify//GEN-BEGIN:variables
        private javax.swing.JPanel jPanel1;
        private javax.swing.JButton createBtn;
        private javax.swing.JLabel jLabel1;
        private javax.swing.JButton cancelBtn;
        private javax.swing.JPanel jPanel3;
        private javax.swing.JLabel jLabel3;
        private javax.swing.JPanel jPanel4;
        private javax.swing.JLabel jLabel4;
        private javax.swing.JLabel jLabel5;
        private javax.swing.JTextField hostText;
        private javax.swing.JLabel jLabel2;
        private javax.swing.JTextField familyText;
        private javax.swing.JButton pathBtn;
        private javax.swing.JButton familyBtn;
        private javax.swing.JScrollPane jScrollPane1;
        private javax.swing.JTextArea pathText;
        private javax.swing.JLabel jLabel6;
        private javax.swing.JLabel jLabel7;
        private javax.swing.JLabel jLabel8;
        private javax.swing.JTextField usageText;
        private javax.swing.JRadioButton useEventsBtn;
        // End of variables declaration//GEN-END:variables
	//======================================================================

}
