//+======================================================================
// $Source: /cvsroot/tango-cs/tango/tools/astor/ManagePollingDialog.java,v $
//
// Project:   Tango
//
// Description:  java source code for the Pogo class definition .
//
// $Author: pascal_verdier $
//
// $Revision: 3.2 $
//
// $Log: ManagePollingDialog.java,v $
// Revision 3.2  2004/09/28 07:01:51  pascal_verdier
// Problem on two events server list fixed.
//
// Revision 3.1  2003/06/19 12:57:57  pascal_verdier
// Add a new host option.
// Controlled servers list option.
//
// Revision 2.0  2003/01/16 15:22:35  verdier
// Last ci before CVS usage
//
// Revision 1.1  2002/09/13 08:43:07  verdier
// Initial revision
//

//
// Copyleft 2003 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================

package admin.astor;

/** 
 *	This class is a dialog to manage polling device commands.
 *
 * @author  verdier
 * @Revision 
 */


import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import fr.esrf.Tango.*;
import fr.esrf.TangoDs.*;
import fr.esrf.TangoApi.*;

public class ManagePollingDialog extends javax.swing.JDialog implements TangoConst{

	private JFrame			root_frame;
	private String[]		commands;
	private String[]		attributes;
	
	private TangoServer		server;

	//====================================================
	//====================================================
	private void setCmdAttrBox()
	{
		//	Check selected items
		String[]	strArray;
    	if (cmdBtn.getSelectedObjects()!=null)
		{
			cmdLabel.setText("Command Selection");
			strArray = commands;
		}
		else
		{
			cmdLabel.setText("Attribute Selection");
			strArray = attributes;
		}
		//	And add to combo box
		cmdBox.removeAllItems();
		for (int i=0 ; i<strArray.length ; i++)
			cmdBox.addItem(strArray[i]);
		pack();
	}
	//====================================================
	/**
	 *	Init Components from Devices read.
	 */
	//====================================================
	private void initComponentsFromDevices()
	{
		try
		{
			//	Get device list on admin device
			String[]	devices = server.queryDevice();
			for (int i=0 ; i<devices.length ; i++)
				devicesBox.addItem(devices[i]);
			devicesBox.addItem("*");
			devicesBox.addActionListener(new java.awt.event.ActionListener() {
				public void actionPerformed(java.awt.event.ActionEvent evt) {
					devSelectionActionPerformed(evt);
				}});

			cmdBtn.setSelected(false);
			attrBtn.setSelected(true);
			getAttrCmdLists(devices[0]);
		}
		catch (DevFailed e){
			app_util.PopupError.show(this, e);
		}

	}
	//====================================================
	//====================================================
	private void getAttrCmdLists(String devname)
	{
		try
		{
			//	get the command list on device itself
			DeviceProxy		dev = new DeviceProxy(devname);
			CommandInfo[]	cmd_list = dev.command_list_query();
			//	keep only command without argin and not Init
			int	nb=0;
			for (int i=0 ; i<cmd_list.length ; i++)
				if (cmd_list[i].in_type==Tango_DEV_VOID)
					if (cmd_list[i].cmd_name.equals("Init")==false)
						nb++;
			//	Allocate and fill array
			commands = new String[nb];
			for (int i=0, j=0 ; i<cmd_list.length ; i++)
				if (cmd_list[i].in_type==Tango_DEV_VOID)
					if (cmd_list[i].cmd_name.equals("Init")==false)
						commands[j++] = cmd_list[i].cmd_name;
			//	get attribute list
			attributes = dev.get_attribute_list();
			setCmdAttrBox();
		}
		catch(DevFailed e)
		{
			app_util.PopupError.show(this, e);
			return;
		}
	}
	//====================================================
	//====================================================
	private void devSelectionActionPerformed(java.awt.event.ActionEvent evt)
	{
		String		devname = devicesBox.getSelectedItem().toString();
		System.out.println(devname);
		if (devname.equals("*")==false)
		{
			getAttrCmdLists(devname);
		}
	}
	//====================================================
	/**
	 *	Creates new form ManagePollingDialog
	 */
	//====================================================
    public ManagePollingDialog(JFrame frame, JDialog parent, TangoServer server, Point p)
	{
        super(parent, true);
		root_frame  = frame;
		this.server = server;
		setTitle("Device Polling Management Window");
        initComponents();
		initComponentsFromDevices();
		setLocation(p);
		pack();
    }

	//====================================================
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
	//====================================================
    private void initComponents() {//GEN-BEGIN:initComponents
          jPanel1 = new javax.swing.JPanel();
          jLabel1 = new javax.swing.JLabel();
          cmdBtn = new javax.swing.JRadioButton();
          attrBtn = new javax.swing.JRadioButton();
          jLabel7 = new javax.swing.JLabel();
          jPanel2 = new javax.swing.JPanel();
          jButton1 = new javax.swing.JButton();
          jPanel3 = new javax.swing.JPanel();
          devicesBox = new javax.swing.JComboBox();
          cmdBox = new javax.swing.JComboBox();
          jLabel2 = new javax.swing.JLabel();
          cmdLabel = new javax.swing.JLabel();
          addBtn = new javax.swing.JButton();
          jLabel3 = new javax.swing.JLabel();
          removeBtn = new javax.swing.JButton();
          statusBtn = new javax.swing.JButton();
          jLabel4 = new javax.swing.JLabel();
          jLabel5 = new javax.swing.JLabel();
          jLabel6 = new javax.swing.JLabel();
          
          addWindowListener(new java.awt.event.WindowAdapter() {
              public void windowClosing(java.awt.event.WindowEvent evt) {
                  closeDialog(evt);
              }
          });
          
          jPanel1.setLayout(new java.awt.GridBagLayout());
          java.awt.GridBagConstraints gridBagConstraints2;
          
          jLabel1.setText("Polling  on   ");
          jLabel1.setForeground(java.awt.Color.black);
          gridBagConstraints2 = new java.awt.GridBagConstraints();
          gridBagConstraints2.gridx = 1;
          gridBagConstraints2.gridy = 1;
          gridBagConstraints2.gridwidth = 2;
          jPanel1.add(jLabel1, gridBagConstraints2);
          
          cmdBtn.setText("Command");
          cmdBtn.addActionListener(new java.awt.event.ActionListener() {
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                  cmdBtnActionPerformed(evt);
              }
          });
          
          gridBagConstraints2 = new java.awt.GridBagConstraints();
          gridBagConstraints2.gridx = 1;
          gridBagConstraints2.gridy = 2;
          jPanel1.add(cmdBtn, gridBagConstraints2);
          
          attrBtn.setText("Attribute");
          attrBtn.addActionListener(new java.awt.event.ActionListener() {
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                  attrBtnActionPerformed(evt);
              }
          });
          
          gridBagConstraints2 = new java.awt.GridBagConstraints();
          gridBagConstraints2.gridx = 2;
          gridBagConstraints2.gridy = 2;
          jPanel1.add(attrBtn, gridBagConstraints2);
          
          jLabel7.setText("   ");
          gridBagConstraints2 = new java.awt.GridBagConstraints();
          gridBagConstraints2.gridx = 1;
          gridBagConstraints2.gridy = 5;
          jPanel1.add(jLabel7, gridBagConstraints2);
          
          getContentPane().add(jPanel1, java.awt.BorderLayout.NORTH);
          
          jButton1.setText("Dismiss");
          jButton1.addActionListener(new java.awt.event.ActionListener() {
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                  jButton1ActionPerformed(evt);
              }
          });
          
          jPanel2.add(jButton1);
          
          getContentPane().add(jPanel2, java.awt.BorderLayout.SOUTH);
          
          jPanel3.setLayout(new java.awt.GridBagLayout());
          java.awt.GridBagConstraints gridBagConstraints1;
          
          gridBagConstraints1 = new java.awt.GridBagConstraints();
          gridBagConstraints1.gridx = 1;
          gridBagConstraints1.gridy = 2;
          gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
          jPanel3.add(devicesBox, gridBagConstraints1);
          
          gridBagConstraints1 = new java.awt.GridBagConstraints();
          gridBagConstraints1.gridx = 5;
          gridBagConstraints1.gridy = 2;
          gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
          jPanel3.add(cmdBox, gridBagConstraints1);
          
          jLabel2.setText("Device Selection");
          jLabel2.setForeground(java.awt.Color.black);
          gridBagConstraints1 = new java.awt.GridBagConstraints();
          gridBagConstraints1.gridx = 1;
          gridBagConstraints1.gridy = 1;
          jPanel3.add(jLabel2, gridBagConstraints1);
          
          cmdLabel.setText("command :");
          cmdLabel.setForeground(java.awt.Color.black);
          gridBagConstraints1 = new java.awt.GridBagConstraints();
          gridBagConstraints1.gridx = 5;
          gridBagConstraints1.gridy = 1;
          jPanel3.add(cmdLabel, gridBagConstraints1);
          
          addBtn.setText("Add / Update");
          addBtn.addActionListener(new java.awt.event.ActionListener() {
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                  addBtnActionPerformed(evt);
              }
          });
          
          gridBagConstraints1 = new java.awt.GridBagConstraints();
          gridBagConstraints1.gridx = 1;
          gridBagConstraints1.gridy = 5;
          jPanel3.add(addBtn, gridBagConstraints1);
          
          jLabel3.setText("  ");
          jLabel3.setFont(new java.awt.Font("Dialog", 0, 36));
          gridBagConstraints1 = new java.awt.GridBagConstraints();
          gridBagConstraints1.gridx = 1;
          gridBagConstraints1.gridy = 3;
          jPanel3.add(jLabel3, gridBagConstraints1);
          
          removeBtn.setText("Remove");
          removeBtn.addActionListener(new java.awt.event.ActionListener() {
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                  removeBtnActionPerformed(evt);
              }
          });
          
          gridBagConstraints1 = new java.awt.GridBagConstraints();
          gridBagConstraints1.gridx = 3;
          gridBagConstraints1.gridy = 5;
          jPanel3.add(removeBtn, gridBagConstraints1);
          
          statusBtn.setText("Polling Status");
          statusBtn.addActionListener(new java.awt.event.ActionListener() {
              public void actionPerformed(java.awt.event.ActionEvent evt) {
                  statusBtnActionPerformed(evt);
              }
          });
          
          gridBagConstraints1 = new java.awt.GridBagConstraints();
          gridBagConstraints1.gridx = 5;
          gridBagConstraints1.gridy = 5;
          jPanel3.add(statusBtn, gridBagConstraints1);
          
          jLabel4.setText("  ");
          jLabel4.setFont(new java.awt.Font("Dialog", 0, 36));
          gridBagConstraints1 = new java.awt.GridBagConstraints();
          gridBagConstraints1.gridx = 1;
          gridBagConstraints1.gridy = 8;
          jPanel3.add(jLabel4, gridBagConstraints1);
          
          jLabel5.setText("   ");
          gridBagConstraints1 = new java.awt.GridBagConstraints();
          gridBagConstraints1.gridx = 2;
          gridBagConstraints1.gridy = 5;
          jPanel3.add(jLabel5, gridBagConstraints1);
          
          jLabel6.setText("   ");
          gridBagConstraints1 = new java.awt.GridBagConstraints();
          gridBagConstraints1.gridx = 4;
          gridBagConstraints1.gridy = 5;
          jPanel3.add(jLabel6, gridBagConstraints1);
          
          getContentPane().add(jPanel3, java.awt.BorderLayout.CENTER);
        
        pack();
    }//GEN-END:initComponents

	//=========================================================
	/**
	 *	If '*' is selected returns all device names
	 *	else returns only selected device name.
	 */
	//=========================================================
	private String[] selectedDevices()
	{
		String		item = devicesBox.getSelectedItem().toString();
		String[]	names;
		if (item.equals("*"))
		{
			int	nb = devicesBox.getItemCount()-1;	//	-1 because dont take '*'
			names = new String[nb];
			for (int i =0 ; i<nb ; i++)
				names[i] = devicesBox.getItemAt(i).toString();
		}
		else
		{
			names = new String[1];
			names[0] = item;
		}
		return names;
	}
	//=========================================================
	//=========================================================
	private void statusBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_statusBtnActionPerformed
		//	Get selected device name(s).
		String[]		devnames = selectedDevices();
		StringBuffer	message = new StringBuffer("        Polling Status\n\n");
		for (int i=0 ; i<devnames.length ; i++)
		{
			try
			{
				message.append("=============================================\n");
				message.append(devnames[i] + " :\n\n");
				//	import device and send command
				DeviceProxy		dev = new DeviceProxy(devnames[i]);
				String[]		status = dev.polling_status();
				//	Add separators
				for (int st=0 ; st<status.length ; st++)
				{
					message.append(status[st]+"\n");
					if (st<status.length-1)
						message.append("   ---------------------------------\n");
				}
				if (status.length>0)
					message.append("\n\n");
  			}
			catch(DevFailed e)
			{
				app_util.PopupError.show(this, e);
				return;
			}
		}
		//	Display result
		if (devnames.length==1)
			app_util.PopupMessage.show(this, message.toString());
		else
		{
			app_util.PopupText	ppt = new app_util.PopupText(root_frame, true);
			ppt.show(message.toString());
		}
	}//GEN-LAST:event_statusBtnActionPerformed

	//=========================================================
	//=========================================================
	private void removeBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_removeBtnActionPerformed

		//	Get selected device name(s).
		String[]	devnames = selectedDevices();
		String		polled_obj_name = cmdBox.getSelectedItem().toString();
		StringBuffer	message = new StringBuffer(polled_obj_name +
									" polling has been removed for:\n");
		for (int i=0 ; i<devnames.length ; i++)
		{
			try
			{
				//	import device and send command
				DeviceProxy	dev = new DeviceProxy(devnames[i]);

	    		if (cmdBtn.getSelectedObjects()!=null)
					dev.stop_poll_command(polled_obj_name);
				else
					dev.stop_poll_attribute(polled_obj_name);
				message.append(devnames[i] + "\n");
 			}
			catch(DevFailed e)
			{
				app_util.PopupError.show(this, e);
				return;
			}
		}
		app_util.PopupMessage.show(this, message.toString());
	}//GEN-LAST:event_removeBtnActionPerformed

	//=========================================================
	//=========================================================
    private void addBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addBtnActionPerformed

		//	Get selected device name(s).
		String[]	devnames = selectedDevices();
		boolean ok = false;
		String	strval = "";
		int	polling_period = 0;


		//	Get polling period while not ok
		while (ok==false)
		{
			//	Get polling period as string
			strval =(String) JOptionPane.showInputDialog(this,
									"Polling period (ms)  ?",
									"Polling period",
									JOptionPane.INFORMATION_MESSAGE,
									null, null, strval);
			if (strval==null)
				return;
			//	Convert to int
			try {
				polling_period = Integer.parseInt(strval);
				//	Check value
				if (polling_period<20)
					app_util.PopupError.show(this,
								"The polling period minimum value is 20ms");
				else
					ok = true;
			}
			catch(NumberFormatException e)
			{
				app_util.PopupError.show(this, e.toString() +
									"\n\nBad Value in Polling period field !");
			}
		}
		String		polled_obj_name = cmdBox.getSelectedItem().toString();
		StringBuffer	message = new StringBuffer(polled_obj_name +
									" polling has been added for:\n");
		for (int i=0 ; i<devnames.length ; i++)
		{
			try
			{
				//	import device and send command
				DeviceProxy	dev = new DeviceProxy(devnames[i]);

	    		if (cmdBtn.getSelectedObjects()!=null)
					dev.poll_command(polled_obj_name, polling_period);
				else
					dev.poll_attribute(polled_obj_name, polling_period);
				message.append(devnames[i] + "\n");
 			}
			catch(DevFailed e)
			{
				app_util.PopupError.show(this, e);
			}
		}
 		app_util.PopupMessage.show(this, message.toString());
  }//GEN-LAST:event_addBtnActionPerformed

	//=========================================================
	//=========================================================
    private void attrBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_attrBtnActionPerformed
    	if (attrBtn.getSelectedObjects()!=null)
			cmdBtn.setSelected(false);
		setCmdAttrBox();
    }//GEN-LAST:event_attrBtnActionPerformed

	//=========================================================
	//=========================================================
    private void cmdBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cmdBtnActionPerformed
    	if (cmdBtn.getSelectedObjects()!=null)
			attrBtn.setSelected(false);
		setCmdAttrBox();
    }//GEN-LAST:event_cmdBtnActionPerformed

 	//=========================================================
    /**
	 *	Closes the dialog
	 */
	//=========================================================
   private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        setVisible(false);
        dispose();
    }//GEN-LAST:event_jButton1ActionPerformed

	//=========================================================
    /**
	 *	Closes the dialog
	 */
	//=========================================================
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        dispose();
    }//GEN-LAST:event_closeDialog


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JRadioButton cmdBtn;
    private javax.swing.JRadioButton attrBtn;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JButton jButton1;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JComboBox devicesBox;
    private javax.swing.JComboBox cmdBox;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel cmdLabel;
    private javax.swing.JButton addBtn;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JButton removeBtn;
    private javax.swing.JButton statusBtn;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    // End of variables declaration//GEN-END:variables

}
