//+======================================================================
// $Source: /cvsroot/tango-cs/tango/tools/astor/ListDialog.java,v $
//
// Project:   Tango
//
// Description:  java source code for the TempClass class definition .
//
// $Author: pascal_verdier $
//
// $Revision: 3.2 $
//
// $Log: ListDialog.java,v $
// Revision 3.2  2004/09/28 07:01:51  pascal_verdier
// Problem on two events server list fixed.
//
// Revision 3.1  2003/06/19 12:57:57  pascal_verdier
// Add a new host option.
// Controlled servers list option.
//
//
// Copyleft 2003 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================
 
package admin.astor;

/** 
 *
 * @author  verdier
 * @version 
 */
 
 
 
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import fr.esrf.Tango.*;
import fr.esrf.TangoDs.*;
import fr.esrf.TangoApi.*;

//===============================================================
public class ListDialog extends javax.swing.JDialog {
	private static String	str_filter = "*";
	private static String	previous_item = null;
	private JFrame			parent;
	private	String			selectedItem = null;

	
	//======================================================
	//======================================================
	private void setList()	throws DevFailed
	{
		str_filter = filterTxt.getText();
		String[] servlist = ApiUtil.get_db_obj().get_server_list(str_filter);
		jList.setListData(servlist);

		//	Search if previous selection exists
		//----------------------------------------
		for (int i=0 ; i<servlist.length ; i++)
			if (servlist[i].equals(previous_item))
				jList.setSelectedIndex(i);
	}

	//======================================================
	/**
	 *	Creates new form ListDialog
	 */
	//======================================================
	public ListDialog(JFrame parent) {
		super ((Frame)parent, true);
		this.parent = parent;
		initComponents ();

		//	fix str filter and add a mouse listener on list
		//---------------------------------------------------
		filterTxt.setText(str_filter);
		MouseListener mouseListener = new MouseAdapter() {
			public void mouseClicked(MouseEvent e) {
				listSelectionPerformed(e);
			}
		};
		jList.addMouseListener(mouseListener);

		pack ();
	}

 	//======================================================
	/** This method is called from within the constructor to
	* initialize the form.
	* WARNING: Do NOT modify this code. The content of this method is
	* always regenerated by the FormEditor.
	*/
 	//======================================================
  private void initComponents () {//GEN-BEGIN:initComponents
    jPanel1 = new javax.swing.JPanel ();
    startBtn = new javax.swing.JButton ();
    cancelBtn = new javax.swing.JButton ();
    jScrollPane1 = new javax.swing.JScrollPane ();
    jList = new javax.swing.JList ();
    jPanel2 = new javax.swing.JPanel ();
    jLabel1 = new javax.swing.JLabel ();
    filterTxt = new javax.swing.JTextField ();
    addWindowListener (new java.awt.event.WindowAdapter () {
      public void windowClosing (java.awt.event.WindowEvent evt) {
        closeDialog (evt);
      }
    }
    );


      startBtn.setText ("Start");
      startBtn.setHorizontalAlignment (javax.swing.SwingConstants.RIGHT);
      startBtn.setFont (new java.awt.Font ("Dialog", 0, 12));
      startBtn.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          startBtnActionPerformed (evt);
        }
      }
      );
  
      jPanel1.add (startBtn);
  
      cancelBtn.setHorizontalTextPosition (javax.swing.SwingConstants.RIGHT);
      cancelBtn.setText ("Cancel");
      cancelBtn.setHorizontalAlignment (javax.swing.SwingConstants.RIGHT);
      cancelBtn.setFont (new java.awt.Font ("Dialog", 0, 12));
      cancelBtn.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          cancelBtnActionPerformed (evt);
        }
      }
      );
  
      jPanel1.add (cancelBtn);
  

    getContentPane ().add (jPanel1, java.awt.BorderLayout.SOUTH);

    jScrollPane1.setPreferredSize (new java.awt.Dimension(250, 300));
    jScrollPane1.setMinimumSize (new java.awt.Dimension(250, 300));

      jList.setFont (new java.awt.Font ("Courier", 1, 12));
  
      jScrollPane1.setViewportView (jList);
  

    getContentPane ().add (jScrollPane1, java.awt.BorderLayout.CENTER);


      jLabel1.setText ("Filter : ");
      jLabel1.setForeground (java.awt.Color.black);
      jLabel1.setFont (new java.awt.Font ("Courier", 1, 12));
  
      jPanel2.add (jLabel1);
  
      filterTxt.setPreferredSize (new java.awt.Dimension(100, 19));
      filterTxt.setMinimumSize (new java.awt.Dimension(100, 19));
      filterTxt.setText ("*");
      filterTxt.setFont (new java.awt.Font ("Courier", 1, 12));
      filterTxt.addActionListener (new java.awt.event.ActionListener () {
        public void actionPerformed (java.awt.event.ActionEvent evt) {
          filterTxtActionPerformed (evt);
        }
      }
      );
  
      jPanel2.add (filterTxt);
  

    getContentPane ().add (jPanel2, java.awt.BorderLayout.NORTH);

  }//GEN-END:initComponents

	//======================================================
	//======================================================
	private void filterTxtActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_filterTxtActionPerformed
		try {
			setList();
		}
		catch(DevFailed e)
		{
			app_util.PopupError.show(parent, e);
		}
	}//GEN-LAST:event_filterTxtActionPerformed

	//======================================================
	//======================================================
	private void cancelBtnActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelBtnActionPerformed
		setVisible (false);
		dispose ();
	}//GEN-LAST:event_cancelBtnActionPerformed

	//======================================================
	//======================================================
	private void startBtnActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_startBtnActionPerformed
		retreiveSelectedItem();
	}//GEN-LAST:event_startBtnActionPerformed
	//======================================================
	//======================================================
	private void listSelectionPerformed(MouseEvent evt)
	{
		//	save selected item to set selection  later.
		//----------------------------------------------------
		previous_item = new String((String) jList.getSelectedValue());

		//	Check if double click
		//-----------------------------
		if (evt.getClickCount() == 2)
			retreiveSelectedItem();
		/*
		{
			int index = jList.locationToIndex(e.getPoint());
			System.out.println("Double clicked on Item " + index);
		}
		*/
	}
	//======================================================
	//======================================================
	private void retreiveSelectedItem()
	{
		//	At first try if already running
		//------------------------------------
		String servname = (String) jList.getSelectedValue();
		try {
			String		devname = new String("dserver/" + servname);
			DeviceProxy	dev = new DeviceProxy(devname);
			try {
				dev.ping();
				//	ping works  --> already running
				app_util.PopupError.show(parent, 
					new String(servname + "  is Already Running  !!  " ));
// COMMENTS					new fr.esrf.TangoApi.IorDump(devname).get_host() + " !"));
				return;
			}
			catch(DevFailed e) {}
		}
		catch (DevFailed e)
		{
			app_util.PopupError.show(parent, e);
			return;
		}

		selectedItem = servname;
		setVisible (false);
		dispose ();
	}
	//======================================================
	//======================================================
	private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
		setVisible (false);
		dispose ();
	}//GEN-LAST:event_closeDialog
	//======================================================
	//======================================================
	public void showDialog()
	{
		try {
			setList();
		}
		catch(DevFailed e)
		{
			app_util.PopupError.show(parent, e);
		}
		setVisible(true);
	}
	//======================================================
	//======================================================
	public String getSelectedItem()
	{
		return selectedItem;
	}

 	//======================================================
	//======================================================
        // Variables declaration - do not modify//GEN-BEGIN:variables
        private javax.swing.JPanel jPanel1;
        private javax.swing.JButton startBtn;
        private javax.swing.JButton cancelBtn;
        private javax.swing.JScrollPane jScrollPane1;
        private javax.swing.JList jList;
        private javax.swing.JPanel jPanel2;
        private javax.swing.JLabel jLabel1;
        private javax.swing.JTextField filterTxt;
        // End of variables declaration//GEN-END:variables

  /**
  * @param args the command line arguments
  public static void main (String args[]) {
    new ListDialog (new javax.swing.JFrame (), true).show ();
  }
  */
}
