//+======================================================================
// $Source: /cvsroot/tango-cs/tango/tools/astor/DeviceTreeDialog.java,v $
//
// Project:   Tango
//
// Description:  java source code for the Pogo class definition .
//
// $Author: pascal_verdier $
//
// $Revision: 3.9 $: $
//
// Copyleft 2003 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================

package admin.astor; 

import fr.esrf.Tango.*;
import fr.esrf.TangoDs.*;
import fr.esrf.TangoApi.*;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.text.*;


/** 
 *	Display a Server/Device tree to find host where running.
 *
 * @author  verdier
 * @version 
 */
public class DeviceTreeDialog extends javax.swing.JDialog {

	private DeviceTree			tree;
	private Astor				parent;
	private TangoHost[]			hosts;
	private DeviceTreeDialog	dialog;
	//========================================================
	/**
	 *	Creates new form DeviceTreeDialog
	 */
	//========================================================
	public DeviceTreeDialog(Astor parent, TangoHost[] hosts) {
		super (parent, false);
		this.parent = parent;
		this.hosts  = hosts;
		this.dialog = this;
		
		initComponents ();

		//	Start a Thread to update monitor during database browsing
		new DisplayMonitor().start();

		pack ();
		AstorUtil.rightShiftDialog(this, parent);
	}

	//========================================================
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the FormEditor.
	 */
	//========================================================
	private void initComponents () {//GEN-BEGIN:initComponents
		buttonPanel = new javax.swing.JPanel ();
		ctrlServersButton = new javax.swing.JButton ();
		cancelButton = new javax.swing.JButton ();
		jScrollPane1 = new javax.swing.JScrollPane ();
		csInfoLabel = new javax.swing.JTextArea ();
		infoLabel = new javax.swing.JTextArea ("   ");
		addWindowListener (new java.awt.event.WindowAdapter () {
		public void windowClosing (java.awt.event.WindowEvent evt) {
			closeDialog (evt);
			}}
		);

		infoLabel.setEditable(false);
		infoLabel.setColumns(30);
		infoLabel.setRows(10);
		csInfoLabel.setEditable(false);
		JPanel	panel = new JPanel(new java.awt.BorderLayout());
		
		JLabel title = new JLabel("TANGO Control System");
		title.setFont(new Font("helvetica", Font.BOLD, 18));
		panel.add (title, java.awt.BorderLayout.NORTH);

		csInfoLabel.setFont(new Font("helvetica", Font.BOLD, 14));
		panel.add (csInfoLabel, java.awt.BorderLayout.CENTER);
		panel.add (infoLabel, java.awt.BorderLayout.SOUTH);
		getContentPane ().add (panel, java.awt.BorderLayout.EAST);

		buttonPanel.setLayout (new java.awt.FlowLayout (FlowLayout.CENTER, 50, 5));

		ctrlServersButton.setText ("Not Controlled Servers");
		ctrlServersButton.addActionListener (new java.awt.event.ActionListener () {
		public void actionPerformed (java.awt.event.ActionEvent evt) {
			ctrlServersButtonActionPerformed (evt);
			}}
		);
  		buttonPanel.add (ctrlServersButton);
  	//	buttonPanel.add (new JLabel("   "));

		cancelButton.setText ("Dismiss");
		cancelButton.addActionListener (new java.awt.event.ActionListener () {
		public void actionPerformed (java.awt.event.ActionEvent evt) {
			cancelButtonActionPerformed (evt);
			}}
		);
  		buttonPanel.add (cancelButton);
		getContentPane ().add (buttonPanel, java.awt.BorderLayout.SOUTH);

		getContentPane ().add (jScrollPane1, java.awt.BorderLayout.CENTER);

	}//GEN-END:initComponents

	//============================================================
	/**
	 *	Display NOT controlled servers
	 */
	//============================================================
	private app_util.PopupTable	tableDialog = null;
	private void ctrlServersButtonActionPerformed (java.awt.event.ActionEvent evt) {

		if (tableDialog==null)
		{
			try
			{
				String[][]	servers = tree.getNotCtrlServers();
				String		title   = 
					"" + servers.length + "  NOT controlled servers";
				String[]	columns = { "Server Name", "Last exported date" };
				tableDialog = new app_util.PopupTable(this, title, columns, servers);
			}
			catch(DevFailed e)
			{
				app_util.PopupError.show(this, e);
			}
		}
		tableDialog.setVisible(true);
	}
	//============================================================
	/**
	 *	Closes the dialog
	 */
	//============================================================
	private void cancelButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
		doClose();
	}//GEN-LAST:event_cancelButtonActionPerformed

	//============================================================
	/**
	 *	Closes the dialog
	 */
	//============================================================
	private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
		doClose();
	}//GEN-LAST:event_closeDialog

	//============================================================
	/**
	 *	Closes the dialog
	 */
	//============================================================
	void doClose () {
		setVisible (false);
		dispose ();
	}
	//======================================================
	//======================================================
	


	//======================================================
	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JPanel buttonPanel;
	private javax.swing.JButton cancelButton;
	private javax.swing.JButton ctrlServersButton;
	private javax.swing.JScrollPane jScrollPane1;
	private javax.swing.JTextArea 	csInfoLabel;
	private javax.swing.JTextArea 	infoLabel;
	// End of variables declaration//GEN-END:variables
	//======================================================



	//===============================================================
	//===============================================================
	class DisplayMonitor extends Thread
	{

		private Monitor		monitor;
		//=======================================================
		//=======================================================
		DisplayMonitor()
		{
			monitor = new Monitor(parent,
				"Browsing TANGO database for Servers and Devices....", "");
		}
		//=======================================================
		/**
		 *	Execute the servers commands.
		 */
		//=======================================================
		public void run()
		{
			//	Build the tree (updates the monitor)
			tree = new DeviceTree(parent, monitor,
					infoLabel, "TANGO " + AstorUtil.getTangoHost());
			//	Show the result
			jScrollPane1.setPreferredSize(new Dimension(280, 400));
			jScrollPane1.setViewportView (tree);
			setTitle("Tree Dialog");
			pack();
			AstorUtil.centerDialog(dialog, parent);
			monitor.setProgressValue(1.1, "Done");
			csInfoLabel.setText(tree.csInfo());
    		setVisible (true);
		}
	}//	End of DisplayMonitor thread
}
