//+======================================================================
// $Source: /cvsroot/tango-cs/tango/tools/astor/CtrlServersDialog.java,v $
//
// Project:   Tango
//
// Description:  java source code for the Pogo class definition .
//
// $Author: pascal_verdier $
//
// $Revision: 3.9 $: $
//
// $Log: CtrlServersDialog.java,v $
// Revision 3.9  2004/12/02 10:04:23  pascal_verdier
// Number of devices and classes added to display.
//
// Revision 3.8  2004/09/28 07:01:51  pascal_verdier
// Problem on two events server list fixed.
//
// Revision 3.7  2004/07/08 11:22:58  pascal_verdier
// First revision able to use events.
//
// Revision 3.6  2004/05/04 07:05:27  pascal_verdier
// Bug on notify daemon fixed.
// server reconection transparency added.
//
// Revision 3.5  2004/02/04 14:37:42  pascal_verdier
// Starter logging added
// Database info added on CtrlServersDialog.
//
// Revision 3.4  2003/11/25 15:56:45  pascal_verdier
// Label on hosts added.
// Notifyd begin to be controled.
//
// Revision 3.3  2003/09/08 11:08:53  pascal_verdier
// *** empty log message ***
//
// Revision 3.1  2003/06/19 12:57:57  pascal_verdier
// Add a new host option.
// Controlled servers list option.
//
// Revision 1.1  2003/06/19 12:27:03  pascal_verdier
// Add host option.
// Controlled servers list option.
//
//
// Copyleft 2003 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================

package admin.astor; 

import fr.esrf.Tango.*;
import fr.esrf.TangoDs.*;
import fr.esrf.TangoApi.*;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.text.*;


/** 
 *	Start a thread to query database, count controlled servers and
 *	display result in a scrowled JText
 *
 * @author  verdier
 * @version 
 */
public class CtrlServersDialog extends javax.swing.JDialog {

	private static final String separator =
		"___________________________________________________";


	private Astor		parent;
	private TangoHost[]	hosts;
	private JTextArea	dbInfoArea;
	private JTextArea	servInfoArea;
	//========================================================
	/**
	 *	Creates new form CtrlServersDialog
	 */
	//========================================================
	public CtrlServersDialog(Astor parent, TangoHost[] hosts) {
		super (parent, false);
		this.parent = parent;
		this.hosts  = hosts;
		initComponents ();

		pack ();
		new DisplayThread().start();
	}

	//========================================================
	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the FormEditor.
	 */
	//========================================================
	private void initComponents () {//GEN-BEGIN:initComponents
		buttonPanel = new javax.swing.JPanel ();
		middlePanel = new javax.swing.JPanel ();
		cancelButton = new javax.swing.JButton ();
		jScrollPane1 = new javax.swing.JScrollPane ();
		addWindowListener (new java.awt.event.WindowAdapter () {
		public void windowClosing (java.awt.event.WindowEvent evt) {
			closeDialog (evt);
			}}
		);

		buttonPanel.setLayout (new java.awt.FlowLayout (2, 5, 5));

		cancelButton.setText ("Dismiss");
		cancelButton.addActionListener (new java.awt.event.ActionListener () {
		public void actionPerformed (java.awt.event.ActionEvent evt) {
			cancelButtonActionPerformed (evt);
			}}
		);

		middlePanel.setLayout(new java.awt.BorderLayout());
		//	Add area for Servers info
		servInfoArea = new JTextArea("Servers Info");
		servInfoArea.setBackground(java.awt.Color.lightGray);
		servInfoArea.setEditable(false);
		servInfoArea.setFont(new java.awt.Font("Dialog", 1, 14));
		getContentPane().add(servInfoArea, java.awt.BorderLayout.NORTH);

		//	Add Scroll pane for Servers tree
		getContentPane().add(jScrollPane1, java.awt.BorderLayout.CENTER);

		//	Add area for database info
		dbInfoArea = new JTextArea("DB info.");
		dbInfoArea.setBackground(java.awt.Color.lightGray);
		dbInfoArea.setEditable(false);
		dbInfoArea.setFont(new java.awt.Font("Dialog", 1, 10));
		middlePanel.add (dbInfoArea, java.awt.BorderLayout.NORTH);



		//	Add a Dismiss Button
		cancelButton.setBackground(java.awt.Color.lightGray);
		buttonPanel.add (cancelButton);
		buttonPanel.setBackground(java.awt.Color.lightGray);
		middlePanel.add (buttonPanel, java.awt.BorderLayout.SOUTH);

		getContentPane ().add (middlePanel, java.awt.BorderLayout.SOUTH);
	}//GEN-END:initComponents

	//============================================================
	/**
	 *	Closes the dialog
	 */
	//============================================================
	private void cancelButtonActionPerformed (java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
		doClose();
	}//GEN-LAST:event_cancelButtonActionPerformed

	//============================================================
	/**
	 *	Closes the dialog
	 */
	//============================================================
	private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
		doClose();
	}//GEN-LAST:event_closeDialog

	//============================================================
	/**
	 *	Closes the dialog
	 */
	//============================================================
	void doClose () {
		setVisible (false);
		dispose ();
	}

	//============================================================
	/** 
	 *	Display a message in a scrowlled Pane.
	 */
	//============================================================
	public void show(String title, Vector servnames, Vector servers_info)
	{
		ServersTree	tree =	new ServersTree(parent,
				"Controlled Servers", servnames, servers_info);
		jScrollPane1.setViewportView (tree);
		servInfoArea.setText(title);
		pack();
		AstorUtil.rightShiftDialog(this, parent);
    	setVisible (true);
	}
	//======================================================
	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JPanel buttonPanel;
	private javax.swing.JPanel middlePanel;
	private javax.swing.JButton cancelButton;
	private javax.swing.JScrollPane jScrollPane1;
	// End of variables declaration//GEN-END:variables
	//======================================================




	//======================================================
	/**
	 *	A thread class to query database and display.
	 */
	//======================================================
	class  DisplayThread extends Thread
	{
		private Monitor	monitor = null;
		//===============================================================
		//===============================================================
		public DisplayThread()
		{
		}
		//=======================================================
		/**
		 *	Update the PrograessMonitor
		 */
		//=======================================================
		private void updateProgressMonitor(String hostname, int hostnum)
		{
			if (monitor==null)
			{
				monitor = new Monitor(parent, "Browsing TANGO database",
						"Reading host");
			}
			double	ratio = (double)(hostnum+1) / (hosts.length);
			monitor.setProgressValue(ratio, "Query servers for " + hostname);
		}
		//===============================================================
		//===============================================================
		public DbServInfo[] getControledServers(String hostname) throws DevFailed
		{
			//	Query database for servers list
			Database	db = ApiUtil.get_db_obj();
			DeviceData	argin = new DeviceData();
			argin.insert(hostname);
			DeviceData	argout = db.command_inout("DbGetHostServerList", argin);
			String[]	servnames = argout.extractStringArray();
			//	Query database for control mode.
			java.util.Vector		servers = new java.util.Vector();
			for (int i=0 ; i<servnames.length ; i++)
			{
				DbServInfo	s = db.get_server_info(servnames[i]);
				//	store only controlled servers
				if (s.controlled)
					servers.add(s);
			}
			//	copy result to arg out
			DbServInfo[]	servinfo = new DbServInfo[servers.size()];
			for (int i=0 ; i<servers.size() ; i++)
				servinfo[i] = (DbServInfo)servers.elementAt(i);
			return servinfo;
		}
		//===============================================================
		//===============================================================
		private synchronized void wait_next_loop(long ms)
		{
			try
			{
				wait(ms);
			}
			catch(InterruptedException e) {}
		}
		//===============================================================
		/**
		 *	The thread main loop
		 */
		//===============================================================
		public void run()
		{
			int	nb_programs   = 0;
			int	nb_servers = 0;
			StringBuffer	sb = new StringBuffer();
			Vector	servnames = new Vector();
			Vector	servers_info = new Vector();

			//	Read DB info first
			try
			{
				int[]		line_displayed = { 4, 5, 6,7, 9, 10 };
				DeviceData	argout = ApiUtil.get_db_obj().command_inout("DbInfo");
				String[]	res = argout.extractStringArray();
				String		str = "Database Information:\n\n";
				for (int i=0 ; i<line_displayed.length ; i++)
				{
					str += res[line_displayed[i]];
					if (i<line_displayed.length-1)
						str += "\n";
				}
				dbInfoArea.setText(str);
			}
			catch (DevFailed e)
			{
				app_util.PopupError.show(parent, e);
			}
			
			int	nb_on_events = 0;
			int	nb_classes = 0;
			int	nb_devices = 0;
			for (int i=0 ; i<hosts.length ; i++)
			{
				//	Start progress monitor
				//-----------------------------
				updateProgressMonitor(hosts[i].getName(), i);

				if (hosts[i].use_events)
					nb_on_events++;
				DbServInfo[]	servinfo = new DbServInfo[0];
				try
				{
					//	Get servers list
					servinfo = getControledServers(hosts[i].getName());
					for (int s=0 ; s<servinfo.length ; s++)
					{
						//	Get class list
						DbServer	dbs = new DbServer(servinfo[s].name);
						String[]	classes = dbs.get_class_list();
						nb_classes += classes.length;
						for (int c=0 ; c<classes.length ; c++)
						{
							//	get device list
							String[]	dn = dbs.get_device_name(classes[c]);
							nb_devices += dn.length;
						}
					}
				}
				catch(DevFailed e){
					Except.print_exception(e);
				}
				//	Add host name and nb sxervers
				sb.append(hosts[i].getName() +
					" (" + servinfo.length + " server");
				if (servinfo.length>1)
					sb.append("s");
				sb.append("):\n");
				//	Append servers list
				servers_info.add(servinfo);
				for (int s=0 ; s<servinfo.length ; s++)
				{
					nb_servers++;
					sb.append("\t" + servinfo[s].name +
								"\tStartup level: " + 
								servinfo[s].startup_level + "\n");

					//	Check if this vector already exists
					//		with another instance name
					int	start_instance = servinfo[s].name.indexOf("/");
					if (start_instance<0)
						break;
					String	sname = servinfo[s].name.substring(0, start_instance);
					boolean	found = false;
					for (int j=0 ; j<servnames.size() && !found ; j++)
					{
						String str = (String)servnames.elementAt(j);
						found = str.equals(sname);
					}
					if (!found)
					{
						nb_programs++;
						servnames.add(sname);
					}
				}
				sb.append(separator + "\n\n");


				//	Wait a bit to do not overload database server
				wait_next_loop((long)50);
			}
			/*
			for (int j=0 ; j<servnames.size() ; j++)
				System.out.println(j + " - " + (String)servnames.elementAt(j));

			*/
			monitor.setProgressValue(100.0);
			
			//	Sort for alphabetical order
			Collections.sort(servnames, AstorUtil.getInstance().compare);

			//	Display title and result
			String	title = new String(hosts.length + " hosts in control system");
			if (nb_on_events>0)
				title += " (" + nb_on_events + " controlled on events)";
			title += "\n" + nb_programs  + " different servers \n"   +
							nb_servers   + " controlled instances\n" +
							nb_classes   + " classes  -  " +
							nb_devices   + " devices."; 

			show(title, servnames, servers_info);
		}
	}
}
