//+======================================================================
// $Source:  $
//
// Project:   Tango
//
// Description:  Basic Dialog Class to display info
//
// $Author: pascal_verdier $
//
// $Revision:  $
// $Log:  $
//
//
// Copyleft 2005 by European Synchrotron Radiation Facility, Grenoble, France
//               All Rights Reversed
//-======================================================================

//package admin.astor;
import admin.astor.*;

import fr.esrf.Tango.*;
import fr.esrf.TangoDs.*;
import fr.esrf.TangoApi.*;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import javax.swing.*;


//===============================================================
/**
 *	Class Description: Basic Dialog Class to display info
 *
 *	@author  root
 */
//===============================================================


public class AttrConfigDialog extends JDialog {
	private JFrame		parent;
	private	TangoServer	server;
	private int			retVal = JOptionPane.OK_OPTION;

	//===============================================================
	/**
	 *	Creates new form AttrConfigDialog
	 */
	//===============================================================
	public AttrConfigDialog(JFrame parent, TangoServer server) throws DevFailed
	{
		super(parent, true);
		this.parent = parent;
		this.server = server;
		initComponents();

		initTangoComponents();
		titleLabel.setText("Attribute Config for " + server);
		pack();
	}
	//===============================================================
	//===============================================================
	private	DeviceProxy[]	devices = null;
	private void initTangoComponents() throws DevFailed
	{	
		GridBagConstraints gbc = new GridBagConstraints();
		int	idx = 0;
		int	y   = 0;
		gbc.gridx  = 1;
		gbc.anchor = java.awt.GridBagConstraints.WEST;

		String[]	devnames = server.queryDevice();
		devices = new DeviceProxy[devnames.length];
		for (int i=0 ; i<devnames.length ; i++)
		{
			devices[i] = new DeviceProxy(devnames[i]);

			JLabel	lbl = new JLabel(devnames[i]);
			lbl.setFont(new java.awt.Font("Dialog", 1, 16));
			gbc.gridx = 1;
			gbc.gridy = y++;
			gbc.gridwidth = 2;
			gbc.fill  = GridBagConstraints.HORIZONTAL;
			mainPanel.add(lbl, gbc);

			gbc.gridx = 1;
			gbc.gridy = y;
			gbc.gridwidth = 1;
			mainPanel.add(new JLabel("     "), gbc);






/***************************/
			//	Initialise the final XML objects
			model = new DataTableModel();

			// Create the table
			final JTable table = new JTable(model);
			table.setRowSelectionAllowed(true);
			table.setColumnSelectionAllowed(true);
			table.setDragEnabled(true); 
			table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
			table.getTableHeader().setFont(new java.awt.Font("Dialog", 1, 14));
			table.getTableHeader().addMouseListener (new java.awt.event.MouseAdapter () {
				public void mouseClicked (java.awt.event.MouseEvent evt) {
					tableActionPerformed(evt);
				}
			});

			//	Put it in a scrolled pane
			JScrollPane scrollPane = new JScrollPane(table);
			scrollPane.setMinimumSize(new Dimension(150, 150));
			scrollPane.setPreferredSize(new Dimension(650, 450));

			getContentPane().add(scrollPane, BorderLayout.CENTER);
			my_table = table;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			Except.throw_exception("INIT_ERROR",
							e.toString(),
							"PopupTable.initMyComponents()");
		}


/*
			String[]	attnames = devices[i].get_attribute_list();
			for (int j=0 ; j<attnames.length ; j++)
			{
				
				lbl = new JLabel(attnames[j]);
				lbl.setFont(new java.awt.Font("Dialog", 0, 14));
				gbc.gridx = 2;
				gbc.gridy = y++;
				gbc.gridwidth = 1;
				gbc.fill  = GridBagConstraints.HORIZONTAL;
				mainPanel.add(lbl, gbc);
				//System.out.println(devices[i].name() + "/" + attnames[j]);
			}
		}
*/
	}
	//===============================================================
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
	//===============================================================
    private void initComponents() {//GEN-BEGIN:initComponents
        bottomPanel = new javax.swing.JPanel();
        okBtn = new javax.swing.JButton();
        cancelBtn = new javax.swing.JButton();
        tilePanel = new javax.swing.JPanel();
        titleLabel = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        mainPanel = new javax.swing.JPanel();

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        okBtn.setText("OK");
        okBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okBtnActionPerformed(evt);
            }
        });

        bottomPanel.add(okBtn);

        cancelBtn.setText("Cancel");
        cancelBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelBtnActionPerformed(evt);
            }
        });

        bottomPanel.add(cancelBtn);

        getContentPane().add(bottomPanel, java.awt.BorderLayout.SOUTH);

        titleLabel.setFont(new java.awt.Font("Dialog", 1, 18));
        titleLabel.setText("Dialog Title");
        tilePanel.add(titleLabel);

        getContentPane().add(tilePanel, java.awt.BorderLayout.NORTH);

        mainPanel.setLayout(new java.awt.GridBagLayout());

        jScrollPane1.setViewportView(mainPanel);

        getContentPane().add(jScrollPane1, java.awt.BorderLayout.CENTER);

        pack();
    }//GEN-END:initComponents

	//===============================================================
	//===============================================================
	private void okBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okBtnActionPerformed
		retVal = JOptionPane.OK_OPTION;
		doClose();
	}//GEN-LAST:event_okBtnActionPerformed

	//===============================================================
	//===============================================================
	private void cancelBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelBtnActionPerformed
		retVal = JOptionPane.CANCEL_OPTION;
		doClose();
	}//GEN-LAST:event_cancelBtnActionPerformed

	//===============================================================
	/**
	 *	Closes the dialog
	 */
	//===============================================================
	private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
		retVal = JOptionPane.CANCEL_OPTION;
		doClose();
	}//GEN-LAST:event_closeDialog

	//===============================================================
	/**
	 *	Closes the dialog
	 */
	//===============================================================
	private void doClose()
	{
		setVisible(false);
		dispose();
System.exit(0);
	}
	//===============================================================
	//===============================================================
	public int showDialog()
	{
		setVisible(true);
		return retVal;
	}

	//===============================================================
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel titleLabel;
    private javax.swing.JPanel tilePanel;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JButton okBtn;
    private javax.swing.JPanel bottomPanel;
    private javax.swing.JPanel mainPanel;
    private javax.swing.JButton cancelBtn;
    // End of variables declaration//GEN-END:variables
	//===============================================================




	//===============================================================
	/**
	* @param args the command line arguments
	*/
	//===============================================================
	public static void main(String args[]) {
	
		String	servname = "PowerSupply/pv";
		if (args.length>0)
			servname = args[0];
		TangoServer	server = null;
		try {
			server = new TangoServer("dserver/"+servname);
			new AttrConfigDialog(new javax.swing.JFrame(), server).show();
		}
		catch (DevFailed e) {
			Except.print_exception(e);
			System.exit(0);
		}
	}

}
