//+======================================================================
// $Source: /cvsroot/tango-cs/tango/tools/logviewer/LogConsumer/LogConsumerClass.java,v $
//
// Project:   	Tango Device Server
//
// Description:	java source code for the LogConsumer class .
//              This class is a singleton class and implements everything
//              which exists only once for all the  LogConsumer object
//              It inherits from the DeviceClass class.
//
// $Author: nleclercq $
//
// $Revision: 1.1 $
//
// $Log: LogConsumerClass.java,v $
// Revision 1.1  2004/03/18 15:34:37  nleclercq
// Added new file hierarchy
//
// Revision 1.3  2003/11/04 17:58:58  nleclercq
// Changes in Main.java
//
// Revision 1.2  2003/11/04 13:00:31  nleclercq
// Added Register/Unregister to the LogConsumer interface
//
// Revision 1.1  2003/03/11 18:27:55  nleclercq
// Added the TANGO LogViewer
//
//
// copyleft :    European Synchrotron Radiation Facility
//               BP 220, Grenoble 38043
//               FRANCE
//
//-======================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//         (c) - Software Engineering Group - ESRF
//=============================================================================

package LogConsumer;

import fr.esrf.Tango.*;
import fr.esrf.TangoDs.*;

public class LogConsumerClass extends DeviceClass implements TangoConst
{
	/**
	 *	LogConsumerClass class instance (it is a singleton).
	 */
	private static LogConsumerClass	_instance = null;

	//--------- Start of properties data members ----------

	//--------- End of properties data members ----------


//===================================================================			
//
// method : 		instance()
// 
// description : 	static method to retrieve the LogConsumerClass object 
//					once it has been initialised
//
//===================================================================			
	public static LogConsumerClass instance()
	{
		if (_instance == null)
		{
			System.err.println("LogConsumerClass is not initialised !!!");
			System.err.println("Exiting");
			System.exit(-1);
		}
		return _instance;
	}

//===================================================================			
//
// method : 		Init()
// 
// description : 	static method to create/retrieve the LogConsumerClass
//					object. This method is the only one which enables a 
//					user to create the object
//
// in :			- class_name : The class name
//
//===================================================================			
	public static LogConsumerClass init(String class_name) throws DevFailed
	{
		if (_instance == null)
		{
			_instance = new LogConsumerClass(class_name);
		}
		return _instance;
	}
	
//===================================================================			
//
// method : 		LogConsumerClass()
// 
// description : 	constructor for the LogConsumerClass class
//
// argument : in : 	- name : The class name
//
//===================================================================			
	protected LogConsumerClass(String name) throws DevFailed
	{
		super(name);

		Util.out2.println("Entering LogConsumerClass constructor");
	
		Util.out2.println("Leaving LogConsumerClass constructor");
	}
	
//===================================================================			
//
// method : 		command_factory()
// 
// description : 	Create the command object(s) and store them in the
//					command list
//===================================================================			
	public void command_factory()
	{
		command_list.addElement(new RegisterCmd("Register",
			Tango_DEV_STRING, Tango_DEV_VOID,
			"The name of logging source to register",
			"None"));
    	command_list.addElement(new UnRegisterCmd("UnRegister",
			Tango_DEV_STRING, Tango_DEV_VOID,
			"The name of logging source to unregister",
			"None"));
		command_list.addElement(new LogCmd("Log",
			Tango_DEVVAR_STRINGARRAY, Tango_DEV_VOID,
			"The log",
			"None"));
		command_list.addElement(new LogXmlCmd("LogXml",
			Tango_DEV_STRING, Tango_DEV_VOID,
			"The log",
			"None"));
	}


//===================================================================			
//
// method : 		device_factory()
// 
// description : 	Create the device object(s) and store them in the 
//					device list
//
// argument : in : 	String[] devlist : The device name list
//
//===================================================================			
	public void device_factory(String[] devlist) throws DevFailed
	{
	
		for (int i=0 ; i<devlist.length ; i++)
		{
			Util.out4.println("Device name : " + devlist[i]);
						
			// Create device and add it into the device list
			//----------------------------------------------
			device_list.addElement(new LogConsumer(this, devlist[i]));

			// Export device to the outside world
			//----------------------------------------------
			export_device(((DeviceImpl)(device_list.elementAt(i))));
		}
	}
}
