//+============================================================================
// $Source: /cvsroot/tango-cs/tango/tools/logviewer/LogConsumer/LogConsumer.java,v $
//
// project :     Tango Device Server
//
// Description:	java source code for the LogConsumer class and its commands.
//              This class is derived from DeviceImpl class.
//              It represents the CORBA servant obbject which
//              will be accessed from the network. All commands which
//              can be executed on the LogConsumer are implemented
//              in this file.
//
// $Author: nleclercq $
//
// $Revision: 1.1 $
//
// $Log: LogConsumer.java,v $
// Revision 1.1  2004/03/18 15:34:37  nleclercq
// Added new file hierarchy
//
// Revision 1.5  2003/11/04 17:58:58  nleclercq
// Changes in Main.java
//
// Revision 1.4  2003/11/04 13:00:30  nleclercq
// Added Register/Unregister to the LogConsumer interface
//
// Revision 1.3  2003/05/19 14:41:48  nleclercq
// Fixed cmd line args management
// Misc. minor modifications
//
// Revision 1.2  2003/04/22 09:56:51  nleclercq
// Minor modifications
//
// Revision 1.1  2003/03/11 18:27:55  nleclercq
// Added the TANGO LogViewer
//
//
// copyleft :   European Synchrotron Radiation Facility
//              BP 220, Grenoble 38043
//              FRANCE
//
//-============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//         (c) - Software Engineering Group - ESRF
//=============================================================================

package LogConsumer;

// Tango stuffs
import fr.esrf.Tango.*;
import fr.esrf.TangoDs.*;

// Log4j stuffs
import org.apache.log4j.Level;

// Chainsaw stuffs
import fr.esrf.logviewer.EventDetails;
import fr.esrf.logviewer.MyTableModel;

/**
 *	Class Description:
 *	A device that consumes logs produced by TANGO devices
 *
 * @author	$Author: nleclercq $
 * @version	$Revision: 1.1 $
 */

//--------- Start of States Description ----------
/*
 *	Device States Description:
 */
//--------- End of States Description ----------


public class LogConsumer extends DeviceImpl implements TangoConst
{
    protected	int	state;

    //--------- Start of attributes data members ----------

    //--------- End of attributes data members ----------


    //--------- Start of properties data members ----------

    //--------- End of properties data members ----------

    
    //	Add your own data members here
    //--------------------------------------
    private MyTableModel mModel;

//=========================================================
/**
 *	Constructor for simulated Time Device Server.
 *
 *	@param	cl	The DeviceClass object
 *	@param	s	The Device name.
 */
//=========================================================
LogConsumer(DeviceClass cl, String s) throws DevFailed
{
    super(cl,s);
    init_device();
}
//=========================================================
/**
 *	Constructor for simulated Time Device Server.
 *
 *	@param	cl	The DeviceClass object
 *	@param	s	The Device name.
 *	@param	d	Device description.
 */
//=========================================================
LogConsumer(DeviceClass cl, String s, String d) throws DevFailed
{
    super(cl,s,d);
    init_device();
}

//=========================================================
/**
 *	Initialize the device.
 */
//=========================================================
public void init_device() throws DevFailed
{
    get_logger().debug("LogConsumer ctor: allocating " + device_name + " resources");
    set_state(DevState.ON);
}

//=========================================================
/**
 *	Delete the device.
 */
//=========================================================
public void delete_device() throws DevFailed
{
    get_logger().debug("LogConsumer dtor: releasing " + device_name + " resources");
    set_state(DevState.OFF);
}

//=========================================================
/**
 *	Method always executed before command execution.
 */
//=========================================================
public void always_executed_hook()
{	
    Util.out2.println("In always_executed_hook method()");
}

//=========================================================
/**
 *	Execute command "Log" on device.
 *	Consumes a log encapsuled into a DevVar_LongStringArray
 *
 * @param	argin	The log
 */
//=========================================================
public void log (String[] argin) throws DevFailed
{
    // ---Add your Own code to control device here ---
    int num_logs = argin.length / 6;
    if (num_logs != 0) {
        try {
            int idx = 0;
            String[] loc = {""};
            for (int i = 0; i < num_logs; i++) {
                mModel.addEvent(new EventDetails(Long.parseLong(argin[idx]),
                                                 Level.toLevel(argin[idx + 1]),
                                                 argin[idx + 2],
                                                 argin[idx + 4],
                                                 argin[idx + 5],
                                                 argin[idx + 3],
                                                 loc,
                                                 ""));
                idx += 6;
            
            } 
        }
        catch (java.lang.OutOfMemoryError e) {
            get_logger().debug("mModel.addEvent failed: OutOfMemoryError caught");  
        }
        catch (java.lang.Throwable e) {
            get_logger().debug("mModel.addEvent failed: unknown exception caught");  
            get_logger().debug(e);  
        }
    }
}


//=========================================================
/**
 *	Execute command "LogXml" on device.
 *	Consumes an XML  log 
 *
 * @param	argin	The log
 */
//=========================================================
public void log_xml (String argin) throws DevFailed
{
    // ---Add your Own code to control device here ---
    get_logger().debug(argin);
}

//=========================================================
/**
 *	Execute command "Register" on device.
 *	Register a logging source
 *
 * @param	argin	The device to register
 */
//=========================================================
public void register (String argin) throws DevFailed
{
  String[] loc = {""};
  mModel.addEvent(new EventDetails(System.currentTimeMillis(),
                                   Level.toLevel("INFO"),
                                   "LogViewer",
                                   "",
                                   "Local Thread",
                                   "Registering logging source: " + argin,
                                   loc,
                                   ""));
  SourceSet.instance().add(argin);
}

//=========================================================
/**
 *	Execute command "UnRegister" on device.
 *	Register a logging source
 *
 * @param	argin	The device to register
 */
//=========================================================
public void unregister (String argin) throws DevFailed
{
  String[] loc = {""}; 
  mModel.addEvent(new EventDetails(System.currentTimeMillis(),
                                   Level.toLevel("INFO"),
                                   "LogViewer",
                                   "",
                                   "Local Thread",
                                   "Unregistering logging source: " + argin,
                                   loc,
                                   ""));
  SourceSet.instance().remove(argin);
}

public void setModel (MyTableModel aModel)
{
    mModel = aModel;
}   

}

//--------------------------------------------------------------------------
/* end of $Source: /cvsroot/tango-cs/tango/tools/logviewer/LogConsumer/LogConsumer.java,v $ */