//=============================================================================
//
// file :         TangoTestClass.h
//
// description :  Include for the TangoTestClass root class.
//                This class is represents the singleton class for
//                the TangoTest device class.
//                It contains all properties and methods which the 
//                TangoTest requires only once e.g. the commands.
//			
// project :      TANGO Device Server
//
// $Author: taurel $
//
// $Revision: 1.2 $
//
// $Log: TangoTestClass.h,v $
// Revision 1.2  2005/01/14 13:45:08  taurel
// - Ported to Tango V5
//
// Revision 1.1.1.1  2004/05/07 12:43:45  taurel
// Initial import
//
//
// copyleft :     European Synchrotron Radiation Facility
//                BP 220, Grenoble 38043
//                FRANCE
//
//=============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//         (c) - Software Engineering Group - ESRF
//=============================================================================

#ifndef _TANGOTESTCLASS_H
#define _TANGOTESTCLASS_H

#include <tango.h>
#include <TangoTest.h>


namespace TangoTest
{
//=====================================
//	Define classes for attributes
//=====================================
class waveAttrib: public Tango::SpectrumAttr
{
public:
	waveAttrib():SpectrumAttr("wave", Tango::DEV_DOUBLE, Tango::READ, 4096) {};
	~waveAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_wave(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_wave_allowed(ty);}
};

class ampliAttrib: public Tango::Attr
{
public:
	ampliAttrib():Attr("ampli", Tango::DEV_DOUBLE, Tango::WRITE) {};
	~ampliAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_ampli(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_ampli(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_ampli_allowed(ty);}
};

class double_scalar_rwwAttrib: public Tango::Attr
{
public:
	double_scalar_rwwAttrib():Attr("double_scalar_rww", Tango::DEV_DOUBLE, Tango::READ_WITH_WRITE, "double_scalar_w") {};
	~double_scalar_rwwAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_double_scalar_rww(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_double_scalar_rww_allowed(ty);}
};

class double_scalar_wAttrib: public Tango::Attr
{
public:
	double_scalar_wAttrib():Attr("double_scalar_w", Tango::DEV_DOUBLE, Tango::WRITE) {};
	~double_scalar_wAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_double_scalar_w(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_double_scalar_w(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_double_scalar_w_allowed(ty);}
};

class long_scalar_rwwAttrib: public Tango::Attr
{
public:
	long_scalar_rwwAttrib():Attr("long_scalar_rww", Tango::DEV_LONG, Tango::READ_WITH_WRITE, "long_scalar_w") {};
	~long_scalar_rwwAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_long_scalar_rww(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_long_scalar_rww_allowed(ty);}
};

class long_scalar_wAttrib: public Tango::Attr
{
public:
	long_scalar_wAttrib():Attr("long_scalar_w", Tango::DEV_LONG, Tango::WRITE) {};
	~long_scalar_wAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_long_scalar_w(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_long_scalar_w(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_long_scalar_w_allowed(ty);}
};

class short_scalar_rwwAttrib: public Tango::Attr
{
public:
	short_scalar_rwwAttrib():Attr("short_scalar_rww", Tango::DEV_SHORT, Tango::READ_WITH_WRITE, "short_scalar_w") {};
	~short_scalar_rwwAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_short_scalar_rww(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_short_scalar_rww_allowed(ty);}
};

class short_scalar_wAttrib: public Tango::Attr
{
public:
	short_scalar_wAttrib():Attr("short_scalar_w", Tango::DEV_SHORT, Tango::WRITE) {};
	~short_scalar_wAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_short_scalar_w(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_short_scalar_w(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_short_scalar_w_allowed(ty);}
};

class double_imageAttrib: public Tango::ImageAttr
{
public:
	double_imageAttrib():ImageAttr("double_image", Tango::DEV_DOUBLE, Tango::READ, 251, 251) {};
	~double_imageAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_double_image(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_double_image_allowed(ty);}
};

class long_imageAttrib: public Tango::ImageAttr
{
public:
	long_imageAttrib():ImageAttr("long_image", Tango::DEV_LONG, Tango::READ, 251, 251) {};
	~long_imageAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_long_image(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_long_image_allowed(ty);}
};

class short_imageAttrib: public Tango::ImageAttr
{
public:
	short_imageAttrib():ImageAttr("short_image", Tango::DEV_SHORT, Tango::READ, 251, 251) {};
	~short_imageAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_short_image(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_short_image_allowed(ty);}
};

class double_spectrumAttrib: public Tango::SpectrumAttr
{
public:
	double_spectrumAttrib():SpectrumAttr("double_spectrum", Tango::DEV_DOUBLE, Tango::READ, 4096) {};
	~double_spectrumAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_double_spectrum(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_double_spectrum_allowed(ty);}
};

class long_spectrumAttrib: public Tango::SpectrumAttr
{
public:
	long_spectrumAttrib():SpectrumAttr("long_spectrum", Tango::DEV_LONG, Tango::READ, 4096) {};
	~long_spectrumAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_long_spectrum(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_long_spectrum_allowed(ty);}
};

class short_spectrumAttrib: public Tango::SpectrumAttr
{
public:
	short_spectrumAttrib():SpectrumAttr("short_spectrum", Tango::DEV_SHORT, Tango::READ, 4096) {};
	~short_spectrumAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_short_spectrum(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_short_spectrum_allowed(ty);}
};

class string_scalarAttrib: public Tango::Attr
{
public:
	string_scalarAttrib():Attr("string_scalar", Tango::DEV_STRING, Tango::READ_WRITE) {};
	~string_scalarAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_string_scalar(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_string_scalar(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_string_scalar_allowed(ty);}
};

class double_scalarAttrib: public Tango::Attr
{
public:
	double_scalarAttrib():Attr("double_scalar", Tango::DEV_DOUBLE, Tango::READ_WRITE) {};
	~double_scalarAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_double_scalar(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_double_scalar(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_double_scalar_allowed(ty);}
};

class long_scalarAttrib: public Tango::Attr
{
public:
	long_scalarAttrib():Attr("long_scalar", Tango::DEV_LONG, Tango::READ_WRITE) {};
	~long_scalarAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_long_scalar(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_long_scalar(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_long_scalar_allowed(ty);}
};

class short_scalarAttrib: public Tango::Attr
{
public:
	short_scalarAttrib():Attr("short_scalar", Tango::DEV_SHORT, Tango::READ_WRITE) {};
	~short_scalarAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_short_scalar(att);}
	virtual void write(Tango::DeviceImpl *dev,Tango::WAttribute &att)
	{(static_cast<TangoTest *>(dev))->write_short_scalar(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_short_scalar_allowed(ty);}
};

class short_scalar_roAttrib: public Tango::Attr
{
public:
	short_scalar_roAttrib():Attr("short_scalar_ro", Tango::DEV_SHORT, Tango::READ) {};
	~short_scalar_roAttrib() {};
	
	virtual void read(Tango::DeviceImpl *dev,Tango::Attribute &att)
	{(static_cast<TangoTest *>(dev))->read_short_scalar_ro(att);}
	virtual bool is_allowed(Tango::DeviceImpl *dev,Tango::AttReqType ty)
	{return (static_cast<TangoTest *>(dev))->is_short_scalar_ro_allowed(ty);}
};

//=========================================
//	Define classes for commands
//=========================================
class DevVarDoubleStringArrayCmd : public Tango::Command
{
public:
	DevVarDoubleStringArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevVarDoubleStringArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevVarDoubleStringArrayCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarDoubleStringArray_allowed(any);}
};



class DevVarLongStringArrayCmd : public Tango::Command
{
public:
	DevVarLongStringArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevVarLongStringArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevVarLongStringArrayCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarLongStringArray_allowed(any);}
};



class DevVarStringArrayCmd : public Tango::Command
{
public:
	DevVarStringArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevVarStringArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevVarStringArrayCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarStringArray_allowed(any);}
};



class DevVarDoubleArrayCmd : public Tango::Command
{
public:
	DevVarDoubleArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevVarDoubleArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevVarDoubleArrayCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarDoubleArray_allowed(any);}
};



class DevVarFloatArrayCmd : public Tango::Command
{
public:
	DevVarFloatArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevVarFloatArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevVarFloatArrayCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarFloatArray_allowed(any);}
};



class DevVarULongArrayCmd : public Tango::Command
{
public:
	DevVarULongArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevVarULongArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevVarULongArrayCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarULongArray_allowed(any);}
};



class DevVarLongArrayCmd : public Tango::Command
{
public:
	DevVarLongArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevVarLongArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevVarLongArrayCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarLongArray_allowed(any);}
};



class DevVarUShortArrayCmd : public Tango::Command
{
public:
	DevVarUShortArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevVarUShortArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevVarUShortArrayCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarUShortArray_allowed(any);}
};



class DevVarShortArrayCmd : public Tango::Command
{
public:
	DevVarShortArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevVarShortArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevVarShortArrayCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarShortArray_allowed(any);}
};



class DevVarCharArrayCmd : public Tango::Command
{
public:
	DevVarCharArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevVarCharArrayCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevVarCharArrayCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVarCharArray_allowed(any);}
};



class DevStringCmd : public Tango::Command
{
public:
	DevStringCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevStringCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevStringCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevString_allowed(any);}
};



class DevDoubleCmd : public Tango::Command
{
public:
	DevDoubleCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevDoubleCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevDoubleCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevDouble_allowed(any);}
};



class DevFloatCmd : public Tango::Command
{
public:
	DevFloatCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevFloatCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevFloatCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevFloat_allowed(any);}
};



class DevULongCmd : public Tango::Command
{
public:
	DevULongCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevULongCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevULongCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevULong_allowed(any);}
};



class DevLongCmd : public Tango::Command
{
public:
	DevLongCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevLongCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevLongCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevLong_allowed(any);}
};



class DevUShortCmd : public Tango::Command
{
public:
	DevUShortCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevUShortCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevUShortCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevUShort_allowed(any);}
};



class DevShortCmd : public Tango::Command
{
public:
	DevShortCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevShortCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevShortCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevShort_allowed(any);}
};



class DevBooleanCmd : public Tango::Command
{
public:
	DevBooleanCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevBooleanCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevBooleanCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevBoolean_allowed(any);}
};



class DevVoidCmd : public Tango::Command
{
public:
	DevVoidCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out,
				   const char        *in_desc,
				   const char        *out_desc,
				   Tango::DispLevel  level)
	:Command(name,in,out,in_desc,out_desc, level)	{};

	DevVoidCmd(const char   *name,
	               Tango::CmdArgType in,
				   Tango::CmdArgType out)
	:Command(name,in,out)	{};
	~DevVoidCmd() {};
	
	virtual CORBA::Any *execute (Tango::DeviceImpl *dev, const CORBA::Any &any);
	virtual bool is_allowed (Tango::DeviceImpl *dev, const CORBA::Any &any)
	{return (static_cast<TangoTest *>(dev))->is_DevVoid_allowed(any);}
};



//
// The TangoTestClass singleton definition
//

class TangoTestClass : public Tango::DeviceClass
{
public:

//	add your own data members here
//------------------------------------

public:
	Tango::DbData	cl_prop;

//	Method prototypes
	static TangoTestClass *init(const char *);
	static TangoTestClass *instance();
	~TangoTestClass();
	Tango::DbDatum	get_class_property(string &);
	
protected:
	TangoTestClass(string &);
	static TangoTestClass *_instance;
	void command_factory();
	void attribute_factory(vector<Tango::Attr *> &);
	void write_class_property();

private:
	void device_factory(const Tango::DevVarStringArray *);
};


}	//	namespace TangoTest

#endif // _TANGOTESTCLASS_H
