static const char *RcsId = "$Header: /cvsroot/tango-cs/tango/cppserver/TangoTest/TangoTestClass.cpp,v 1.3 2005/01/14 13:45:08 taurel Exp $";
//+=============================================================================
//
// file :        TangoTestClass.cpp
//
// description : C++ source for the TangoTestClass. A singleton
//               class derived from DeviceClass. It implements the
//               command list and all properties and methods required
//               by the TangoTest once per process.
//
// project :     TANGO Device Server
//
// $Author: taurel $
//
// $Revision: 1.3 $
//
// $Log: TangoTestClass.cpp,v $
// Revision 1.3  2005/01/14 13:45:08  taurel
// - Ported to Tango V5
//
// Revision 1.2  2004/09/28 10:32:28  nleclercq
// Fixed a bug in creation/allocation of the <wave> spectrum attribute
//
// Revision 1.1.1.1  2004/05/07 12:43:45  taurel
// Initial import
//
//
// copyleft :   European Synchrotron Radiation Facility
//              BP 220, Grenoble 38043 
//              FRANCE
//
//-=============================================================================
//
//  		This file is generated by POGO
//	(Program Obviously used to Generate tango Object)
//
//         (c) - Software Engineering Group - ESRF
//=============================================================================


#include <tango.h>

#include <TangoTest.h>
#include <TangoTestClass.h>


namespace TangoTest 
{


//+----------------------------------------------------------------------------
//
// method : 		DevVoidCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevVoidCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevVoidCmd::execute(): arrived" << endl;

	((static_cast<TangoTest *>(device))->dev_void());
	return new CORBA::Any();
}

//+----------------------------------------------------------------------------
//
// method : 		DevBooleanCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevBooleanCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevBooleanCmd::execute(): arrived" << endl;

	Tango::DevBoolean	argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_boolean(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevShortCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevShortCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevShortCmd::execute(): arrived" << endl;

	Tango::DevShort	argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_short(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevUShortCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevUShortCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevUShortCmd::execute(): arrived" << endl;

	Tango::DevUShort	argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_ushort(argin));
}

//+----------------------------------------------------------------------------
//


// method : 		DevLongCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevLongCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevLongCmd::execute(): arrived" << endl;

	Tango::DevLong	argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_long(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevULongCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevULongCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevULongCmd::execute(): arrived" << endl;

	Tango::DevULong	argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_ulong(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevFloatCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevFloatCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevFloatCmd::execute(): arrived" << endl;

	Tango::DevFloat	argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_float(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevDoubleCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevDoubleCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevDoubleCmd::execute(): arrived" << endl;

	Tango::DevDouble	argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_double(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevStringCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevStringCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevStringCmd::execute(): arrived" << endl;

	Tango::DevString	argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_string(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevVarCharArrayCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevVarCharArrayCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevVarCharArrayCmd::execute(): arrived" << endl;

	const Tango::DevVarCharArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_var_char_array(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevVarShortArrayCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevVarShortArrayCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevVarShortArrayCmd::execute(): arrived" << endl;

	const Tango::DevVarShortArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_var_short_array(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevVarUShortArrayCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevVarUShortArrayCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevVarUShortArrayCmd::execute(): arrived" << endl;

	const Tango::DevVarUShortArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_var_ushort_array(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevVarLongArrayCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevVarLongArrayCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevVarLongArrayCmd::execute(): arrived" << endl;

	const Tango::DevVarLongArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_var_long_array(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevVarULongArrayCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevVarULongArrayCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevVarULongArrayCmd::execute(): arrived" << endl;

	const Tango::DevVarULongArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_var_ulong_array(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevVarFloatArrayCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevVarFloatArrayCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevVarFloatArrayCmd::execute(): arrived" << endl;

	const Tango::DevVarFloatArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_var_float_array(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevVarDoubleArrayCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevVarDoubleArrayCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevVarDoubleArrayCmd::execute(): arrived" << endl;

	const Tango::DevVarDoubleArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_var_double_array(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevVarStringArrayCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevVarStringArrayCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevVarStringArrayCmd::execute(): arrived" << endl;

	const Tango::DevVarStringArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_var_string_array(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevVarLongStringArrayCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)

//
//-----------------------------------------------------------------------------
CORBA::Any *DevVarLongStringArrayCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevVarLongStringArrayCmd::execute(): arrived" << endl;

	const Tango::DevVarLongStringArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_var_long_string_array(argin));
}

//+----------------------------------------------------------------------------
//
// method : 		DevVarDoubleStringArrayCmd::execute()
// 
// description : 	method to trigger the execution of the command.
//                PLEASE DO NOT MODIFY this method core without pogo   
//
// in : - device : The device on which the command must be excuted
//		- in_any : The command input data
//
// returns : The command output data (packed in the Any object)
//
//-----------------------------------------------------------------------------
CORBA::Any *DevVarDoubleStringArrayCmd::execute(Tango::DeviceImpl *device,const CORBA::Any &in_any)
{

	cout2 << "DevVarDoubleStringArrayCmd::execute(): arrived" << endl;

	const Tango::DevVarDoubleStringArray	*argin;
	extract(in_any, argin);

	return insert((static_cast<TangoTest *>(device))->dev_var_double_string_array(argin));
}

//
//----------------------------------------------------------------
//	Initialize pointer for singleton pattern
//----------------------------------------------------------------
//
TangoTestClass *TangoTestClass::_instance = NULL;

//+----------------------------------------------------------------------------
//
// method : 		TangoTestClass::TangoTestClass(string &s)
// 
// description : 	constructor for the TangoTestClass
//
// in : - s : The class name
//
//-----------------------------------------------------------------------------
TangoTestClass::TangoTestClass(string &s):DeviceClass(s)
{

	cout2 << "Entering TangoTestClass constructor" << endl;
	write_class_property();
	
	cout2 << "Leaving TangoTestClass constructor" << endl;

}
//+----------------------------------------------------------------------------
//
// method : 		TangoTestClass::~TangoTestClass()
// 
// description : 	destructor for the TangoTestClass
//
//-----------------------------------------------------------------------------
TangoTestClass::~TangoTestClass()
{
	_instance = NULL;
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTestClass::instance
// 
// description : 	Create the object if not already done. Otherwise, just
//			return a pointer to the object
//
// in : - name : The class name
//
//-----------------------------------------------------------------------------
TangoTestClass *TangoTestClass::init(const char *name)
{
	if (_instance == NULL)
	{
		try
		{
			string s(name);
			_instance = new TangoTestClass(s);
		}
		catch (bad_alloc)
		{
			throw;
		}		
	}		
	return _instance;
}

TangoTestClass *TangoTestClass::instance()
{
	if (_instance == NULL)
	{
		cerr << "Class is not initialised !!" << endl;
		exit(-1);
	}
	return _instance;
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTestClass::command_factory
// 
// description : 	Create the command object(s) and store them in the 
//			command list
//
//-----------------------------------------------------------------------------
void TangoTestClass::command_factory()
{
	command_list.push_back(new DevVoidCmd("DevVoid",
		Tango::DEV_VOID, Tango::DEV_VOID,
		"N/A",
		"N/A",
		Tango::OPERATOR));
	command_list.push_back(new DevBooleanCmd("DevBoolean",
		Tango::DEV_BOOLEAN, Tango::DEV_BOOLEAN,
		"Any boolean value",
		"Echo of the argin value",
		Tango::OPERATOR));
	command_list.push_back(new DevShortCmd("DevShort",
		Tango::DEV_SHORT, Tango::DEV_SHORT,
		"Any DevShort value",
		"Echo of the argin value",
		Tango::OPERATOR));
	command_list.push_back(new DevUShortCmd("DevUShort",
		Tango::DEV_USHORT, Tango::DEV_USHORT,
		"Any DevUShort value",
		"Echo of the argin value",
		Tango::OPERATOR));
	command_list.push_back(new DevLongCmd("DevLong",
		Tango::DEV_LONG, Tango::DEV_LONG,
		"Any DevLong value",
		"Echo of the argin value",
		Tango::OPERATOR));
	command_list.push_back(new DevULongCmd("DevULong",
		Tango::DEV_ULONG, Tango::DEV_ULONG,
		"Any DevULong",
		"Echo of the argin value",
		Tango::OPERATOR));
	command_list.push_back(new DevFloatCmd("DevFloat",
		Tango::DEV_FLOAT, Tango::DEV_FLOAT,
		"Any DevFloat value",
		"Echo of the argin value",
		Tango::OPERATOR));
	command_list.push_back(new DevDoubleCmd("DevDouble",
		Tango::DEV_DOUBLE, Tango::DEV_DOUBLE,
		"Any DevDouble value",
		"Echo of the argin value",
		Tango::OPERATOR));
	command_list.push_back(new DevStringCmd("DevString",
		Tango::DEV_STRING, Tango::DEV_STRING,
		"-",
		"-",
		Tango::OPERATOR));
	command_list.push_back(new DevVarCharArrayCmd("DevVarCharArray",
		Tango::DEVVAR_CHARARRAY, Tango::DEVVAR_CHARARRAY,
		"-",
		"-",
		Tango::OPERATOR));
	command_list.push_back(new DevVarShortArrayCmd("DevVarShortArray",
		Tango::DEVVAR_SHORTARRAY, Tango::DEVVAR_SHORTARRAY,
		"-",
		"-",
		Tango::OPERATOR));
	command_list.push_back(new DevVarUShortArrayCmd("DevVarUShortArray",
		Tango::DEVVAR_USHORTARRAY, Tango::DEVVAR_USHORTARRAY,
		"-",
		"-",
		Tango::OPERATOR));
	command_list.push_back(new DevVarLongArrayCmd("DevVarLongArray",
		Tango::DEVVAR_LONGARRAY, Tango::DEVVAR_LONGARRAY,
		"-",
		"-",
		Tango::OPERATOR));
	command_list.push_back(new DevVarULongArrayCmd("DevVarULongArray",
		Tango::DEVVAR_ULONGARRAY, Tango::DEVVAR_ULONGARRAY,
		"-",
		"-",
		Tango::OPERATOR));
	command_list.push_back(new DevVarFloatArrayCmd("DevVarFloatArray",
		Tango::DEVVAR_FLOATARRAY, Tango::DEVVAR_FLOATARRAY,
		"-",
		"-",
		Tango::OPERATOR));
	command_list.push_back(new DevVarDoubleArrayCmd("DevVarDoubleArray",
		Tango::DEVVAR_DOUBLEARRAY, Tango::DEVVAR_DOUBLEARRAY,
		"-",
		"-",
		Tango::OPERATOR));
	command_list.push_back(new DevVarStringArrayCmd("DevVarStringArray",
		Tango::DEVVAR_STRINGARRAY, Tango::DEVVAR_STRINGARRAY,
		"-",
		"-",
		Tango::OPERATOR));
	command_list.push_back(new DevVarLongStringArrayCmd("DevVarLongStringArray",
		Tango::DEVVAR_LONGSTRINGARRAY, Tango::DEVVAR_LONGSTRINGARRAY,
		"-",
		"-",
		Tango::OPERATOR));
	command_list.push_back(new DevVarDoubleStringArrayCmd("DevVarDoubleStringArray",
		Tango::DEVVAR_DOUBLESTRINGARRAY, Tango::DEVVAR_DOUBLESTRINGARRAY,
		"-",
		"-",
		Tango::OPERATOR));

	//	add polling if any
	for (unsigned int i=0 ; i<command_list.size(); i++)
	{
	}
}

//+----------------------------------------------------------------------------
//
// method : 		TangoTestClass::get_class_property
// 
// description : 	Get the class property for specified name.
//
// in :		string	name : The property name
//
//+----------------------------------------------------------------------------
Tango::DbDatum TangoTestClass::get_class_property(string &name)
{
	for (int i=0 ; i<cl_prop.size() ; i++)
		if (cl_prop[i].name == name)
			return cl_prop[i];
	//	if not found, return  an empty DbDatum
	return Tango::DbDatum(name);
}
//+----------------------------------------------------------------------------
//
// method : 		TangoTestClass::device_factory
// 
// description : 	Create the device object(s) and store them in the 
//			device list
//
// in :		Tango::DevVarStringArray *devlist_ptr : The device name list
//
//-----------------------------------------------------------------------------
void TangoTestClass::device_factory(const Tango::DevVarStringArray *devlist_ptr)
{

	//	Create all devices.(Automatic code generation)
	//-------------------------------------------------------------
	for (unsigned long i=0 ; i < devlist_ptr->length() ; i++)
	{
		cout4 << "Device name : " << (*devlist_ptr)[i].in() << endl;
						
		// Create devices and add it into the device list
		//----------------------------------------------------
		device_list.push_back(new TangoTest(this, (*devlist_ptr)[i]));							 

		// Export device to the outside world
		// Check before if database used.
		//---------------------------------------------
		if ((Tango::Util::_UseDb == true) && (Tango::Util::_FileDb == false))
			export_device(device_list.back());
		else
			export_device(device_list.back(), (*devlist_ptr)[i]);
	}
	//	End of Automatic code generation
	//-------------------------------------------------------------

}
//+----------------------------------------------------------------------------
//	Method: TangoTestClass::attribute_factory(vector<Tango::Attr *> &att_list)
//-----------------------------------------------------------------------------
void TangoTestClass::attribute_factory(vector<Tango::Attr *> &att_list)
{
	//	Attribute : short_scalar_ro
	short_scalar_roAttrib	*short_scalar_ro = new short_scalar_roAttrib();
	att_list.push_back(short_scalar_ro);

	//	Attribute : short_scalar
	short_scalarAttrib	*short_scalar = new short_scalarAttrib();
	att_list.push_back(short_scalar);

	//	Attribute : long_scalar
	long_scalarAttrib	*long_scalar = new long_scalarAttrib();
	att_list.push_back(long_scalar);

	//	Attribute : double_scalar
	double_scalarAttrib	*double_scalar = new double_scalarAttrib();
	att_list.push_back(double_scalar);

	//	Attribute : string_scalar
	string_scalarAttrib	*string_scalar = new string_scalarAttrib();
	att_list.push_back(string_scalar);

	//	Attribute : short_spectrum
	short_spectrumAttrib	*short_spectrum = new short_spectrumAttrib();
	att_list.push_back(short_spectrum);

	//	Attribute : long_spectrum
	long_spectrumAttrib	*long_spectrum = new long_spectrumAttrib();
	att_list.push_back(long_spectrum);

	//	Attribute : double_spectrum
	double_spectrumAttrib	*double_spectrum = new double_spectrumAttrib();
	att_list.push_back(double_spectrum);

	//	Attribute : short_image
	short_imageAttrib	*short_image = new short_imageAttrib();
	att_list.push_back(short_image);

	//	Attribute : long_image
	long_imageAttrib	*long_image = new long_imageAttrib();
	att_list.push_back(long_image);

	//	Attribute : double_image
	double_imageAttrib	*double_image = new double_imageAttrib();
	att_list.push_back(double_image);

	//	Attribute : short_scalar_w
	short_scalar_wAttrib	*short_scalar_w = new short_scalar_wAttrib();
	att_list.push_back(short_scalar_w);

	//	Attribute : short_scalar_rww
	short_scalar_rwwAttrib	*short_scalar_rww = new short_scalar_rwwAttrib();
	att_list.push_back(short_scalar_rww);

	//	Attribute : long_scalar_w
	long_scalar_wAttrib	*long_scalar_w = new long_scalar_wAttrib();
	att_list.push_back(long_scalar_w);

	//	Attribute : long_scalar_rww
	long_scalar_rwwAttrib	*long_scalar_rww = new long_scalar_rwwAttrib();
	att_list.push_back(long_scalar_rww);

	//	Attribute : double_scalar_w
	double_scalar_wAttrib	*double_scalar_w = new double_scalar_wAttrib();
	att_list.push_back(double_scalar_w);

	//	Attribute : double_scalar_rww
	double_scalar_rwwAttrib	*double_scalar_rww = new double_scalar_rwwAttrib();
	att_list.push_back(double_scalar_rww);

	//	Attribute : ampli
	ampliAttrib	*ampli = new ampliAttrib();
	att_list.push_back(ampli);

	//	Attribute : wave
	waveAttrib	*wave = new waveAttrib();
	att_list.push_back(wave);

}
//+----------------------------------------------------------------------------
//
// method : 		TangoTestClass::write_class_property
// 
// description : 	Set class description as property in database
//
//-----------------------------------------------------------------------------
void TangoTestClass::write_class_property()
{
	//	First time, check if database used
	//--------------------------------------------
	if (Tango::Util::_UseDb == false)
		return;

	//	Prepeare DbDatum
	//--------------------------------------------
	Tango::DbDatum	title("ProjectTitle");
	string	str_title("TANGO Device Server for testing generic clients");
	title << str_title;

	Tango::DbDatum	description("Description");
	vector<string>	str_desc;
	str_desc.push_back("A device to test generic clients. It offers a \"echo\" like command for");
	str_desc.push_back("each TANGO data type (i.e. each command returns an exact copy of <argin>).");
	description << str_desc;
	
	Tango::DbData	data;
	data.push_back(title);
	data.push_back(description);

	//	Call database and and values
	//--------------------------------------------
	get_db_class()->put_property(data);
}

}	// namespace
