/*
 * Decompiled with CFR 0.152.
 */
package explorer.ui;

import explorer.ui.DTMenuBar;
import explorer.ui.Dialog;
import explorer.ui.PreferencesDialog;
import explorer.ui.RefreshDialog;
import explorer.ui.Refresher;
import explorer.ui.UIBit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JSeparator;
import javax.swing.JToolBar;

public class RefreshUI {
    UIBit startBit;
    UIBit stopBit;
    UIBit refreshBit;
    UIBit intervalBit;
    ImageIcon startIcon;
    ImageIcon stopIcon;
    ImageIcon refreshIcon;
    Dialog rDialog;
    Preferences prefs;
    RefreshDialog refresh;
    Refresher main;

    public RefreshUI(Refresher main, JToolBar toolbar, DTMenuBar menubar) {
        JMenu menu = new JMenu("Refresh");
        this.main = main;
        this.refresh = new RefreshDialog(this);
        PreferencesDialog.getInstance().addTop("Refresh interval", this.refresh);
        this.stopIcon = new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/Pause16.gif"));
        this.startIcon = new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/Play16.gif"));
        this.refreshIcon = new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/util/Refresh16.gif"));
        this.startBit = new UIBit("Start", "Start refresher", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RefreshUI.this.startRefresher();
            }
        }, this.startIcon);
        this.refreshBit = new UIBit("Refresh", "Refresh", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RefreshUI.this.refresh();
            }
        }, this.refreshIcon);
        this.refreshBit.setAccelerator("F5");
        this.stopBit = new UIBit("Stop", "Stop refresher", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RefreshUI.this.stopRefresher();
            }
        }, this.stopIcon);
        this.intervalBit = new UIBit("Set refresh interval...", new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RefreshUI.this.showRefreshIntervalDialog();
            }
        });
        menu.add(this.refreshBit.getItem());
        menu.add(this.startBit.getItem());
        menu.add(this.stopBit.getItem());
        menu.add(new JSeparator());
        menu.add(this.intervalBit.getItem());
        menu.setMnemonic('R');
        menubar.addMenu(menu);
        this.stopBit.setEnabled(false);
        toolbar.add(this.stopBit.getButton());
        toolbar.add(this.startBit.getButton());
        toolbar.add(this.refreshBit.getButton());
    }

    public void showRefreshIntervalDialog() {
        if (this.rDialog == null) {
            this.rDialog = new Dialog();
            this.rDialog.setComponent(this.refresh);
        }
        this.rDialog.show();
    }

    protected void setRefreshInterval(int milliseconds) {
        this.main.setRefreshInterval(milliseconds);
    }

    public int getRefreshInterval() {
        return this.main.getRefreshInterval();
    }

    public void startRefresher() {
        this.stopBit.setEnabled(true);
        this.startBit.setEnabled(false);
        this.refreshBit.setEnabled(false);
        this.main.startRefresher();
    }

    public void refresh() {
        this.main.refresh();
    }

    void stopRefresher() {
        this.startBit.setEnabled(true);
        this.stopBit.setEnabled(false);
        this.refreshBit.setEnabled(true);
        this.main.stopRefresher();
    }
}

