/*
 * Decompiled with CFR 0.152.
 */
package explorer;

import explorer.EntityTableModel;
import explorer.Main;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.IStatusListener;
import fr.esrf.tangoatk.widget.device.Tree;
import fr.esrf.tangoatk.widget.dnd.AttributeNode;
import fr.esrf.tangoatk.widget.dnd.CommandNode;
import fr.esrf.tangoatk.widget.dnd.EntityNode;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class AdminMain
extends Main {
    JTree deviceTree;
    JSplitPane mainSplit;

    public AdminMain(String[] args) {
        this.isAdmin = true;
        this.initComponents();
        this.initTree();
        JMenuItem refreshTreeItem = new JMenuItem("Refresh Tree...");
        refreshTreeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMain.this.refreshTree();
            }
        });
        Container menuContain = this.menuBar.getParent();
        menuContain.remove(this.menuBar);
        this.menuBar.add2EditMenu(refreshTreeItem);
        menuContain.add(this.menuBar);
        this.mainFrame.pack();
        this.mainFrame.show();
    }

    public AdminMain() {
        this.runningFromShell = false;
        this.isAdmin = true;
        this.initComponents();
        this.initTree();
        JMenuItem refreshTreeItem = new JMenuItem("Refresh Tree...");
        refreshTreeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMain.this.refreshTree();
            }
        });
        Container menuContain = this.menuBar.getParent();
        menuContain.remove(this.menuBar);
        this.menuBar.add2EditMenu(refreshTreeItem);
        menuContain.add(this.menuBar);
        this.viewSplit.setLastDividerLocation(this.tableSplitHeight / 3);
        this.mainFrame.pack();
        this.viewSplit.setDividerLocation(1.0);
        this.mainFrame.show();
    }

    protected void specificSetup(GridBagConstraints constraints) {
        this.deviceTree = this.initTree();
        this.splash.setMessage("Adding tree...");
        JScrollPane treePane = new JScrollPane(this.deviceTree);
        treePane.setPreferredSize(new Dimension(300, 600));
        this.mainSplit = new JSplitPane(1, treePane, this.viewSplit);
        this.mainSplit.setDividerSize(9);
        this.mainSplit.setOneTouchExpandable(true);
        this.mainSplit.setDividerLocation(this.mainSplitDividerLocation);
        this.mainFrame.getContentPane().add((Component)this.mainSplit, constraints);
        this.splash.setMessage("Adding tree..." + this.done);
    }

    public void newFile() {
        this.attributeTableModel.clear();
        this.commandTableModel.clear();
    }

    public void open(File file) {
        this.open(file.getAbsolutePath());
        this.mainSplit.setDividerLocation(this.mainSplitDividerLocation);
    }

    public void save(File file) {
        String name = file.getAbsolutePath();
        this.mainFrame.setTitle(name);
        this.progress.setIndeterminate(true);
        this.status.setText("Saving to " + file.getAbsolutePath());
        try {
            this.storePreferences();
            this.fileManager.setAttributes((AttributeList)this.attributeTableModel.getList());
            this.fileManager.setCommands((CommandList)this.commandTableModel.getList());
            this.fileManager.save(file);
            this.status.setText("Saving ok");
        }
        catch (Exception e) {
            Main.status(this.mainFrame, "Could not save " + file, e);
        }
        this.progress.setValue(this.progress.getMinimum());
        this.progress.setIndeterminate(false);
    }

    protected JTree initTree() {
        String message = "Initializing device tree...";
        this.splash.setMessage(message);
        Tree tree = (Tree)this.treeInitialization();
        message = message + "done";
        this.splash.setMessage(message);
        return tree;
    }

    protected JTree treeInitialization() {
        Tree tree = new Tree();
        tree.addErrorListener((IErrorListener)this.errorHistory);
        tree.importFromDb();
        this.treePopup = new JPopupMenu();
        tree.addStatusListener((IStatusListener)this);
        tree.setShowEntities(true);
        this.entityPopup = new JPopupMenu();
        JMenuItem refreshItem = new JMenuItem("Refresh Tree...");
        JMenuItem addItem = new JMenuItem("Add to table");
        addItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMain.this.add2Table();
            }
        });
        refreshItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMain.this.refreshTree();
            }
        });
        this.treePopup.add(refreshItem);
        this.entityPopup.add(addItem);
        tree.getSelectionModel().setSelectionMode(1);
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                AdminMain.this.treeClicked(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                AdminMain.this.treeClicked(evt);
            }
        });
        tree.setDragEnabled(true);
        return tree;
    }

    public void refreshTree() {
        this.status.setText("Refreshing Tree...");
        Container c = this.deviceTree.getParent();
        c.remove(this.deviceTree);
        ((Tree)this.deviceTree).removeListeners();
        this.deviceTree = null;
        this.deviceTree = this.treeInitialization();
        c.add(this.deviceTree);
        this.status.setText("Tree Refreshed");
    }

    public void treeClicked(MouseEvent evt) {
        int selectedRow = this.deviceTree.getRowForLocation(evt.getX(), evt.getY());
        if (selectedRow != -1 && evt.isPopupTrigger()) {
            Object n = this.deviceTree.getLastSelectedPathComponent();
            if (n == null && !(n instanceof DefaultMutableTreeNode)) {
                return;
            }
            Object node = ((DefaultMutableTreeNode)n).getUserObject();
            if (node instanceof EntityNode) {
                this.entityPopup.show(evt.getComponent(), evt.getX(), evt.getY());
                return;
            }
            if (selectedRow == 0) {
                this.treePopup.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }
    }

    public void add2Table() {
        Object n = this.deviceTree.getLastSelectedPathComponent();
        if (n == null && !(n instanceof DefaultMutableTreeNode)) {
            return;
        }
        Object node = ((DefaultMutableTreeNode)n).getUserObject();
        if (node instanceof AttributeNode) {
            try {
                this.attributeTableModel.load(((AttributeNode)node).getFQName());
            }
            catch (ConnectionException e) {
                Main.status(this.mainFrame, "Error loading attribute ", (Exception)((Object)e));
            }
            return;
        }
        if (node instanceof CommandNode) {
            try {
                this.commandTableModel.load(((CommandNode)node).getFQName());
            }
            catch (ConnectionException e) {
                Main.status(this.mainFrame, "Error loading command ", (Exception)((Object)e));
            }
            return;
        }
    }

    public void storePreferences() {
        this.attributeTable.storePreferences();
        this.commandTable.storePreferences();
        this.preferences.putInt("MAIN_WINDOW_WIDTH", this.mainFrame.getWidth());
        this.preferences.putInt("MAIN_WINDOW_HEIGHT", this.mainFrame.getHeight());
        this.preferences.putInt("MAIN_WINDOW_X", this.mainFrame.getX());
        this.preferences.putInt("MAIN_WINDOW_Y", this.mainFrame.getY());
        this.preferences.putInt("TABLE_SPLIT_DIVIDER_LOCATION", this.tableSplit.getDividerLocation());
        this.preferences.putInt("MAIN_SPLIT_DIVIDER_LOCATION", this.mainSplit.getDividerLocation());
        this.preferences.putDouble("VIEW_SPLIT_DIVIDER_LOCATION", this.viewSplit.getDividerLocation());
        this.preferences.putInt("TABLE_SPLIT_WIDTH", this.tableSplit.getWidth());
        this.preferences.putInt("TABLE_SPLIT_HEIGHT", this.tableSplit.getHeight());
        this.preferences.putBoolean("GLOBAL_TREND_VISIBLE", (double)this.viewSplit.getDividerLocation() == 1.0);
        this.fileManager.setPreferences(this.preferences);
        EntityTableModel model = (EntityTableModel)this.attributeTable.getModel();
        int i = 0;
        while (i < model.getRowCount()) {
            IEntity att = model.getEntityAt(i);
            if (att instanceof INumberSpectrum) {
                String keyname = att.getName() + ".GraphSettings";
                this.preferences.putString(keyname, this.attributePanel.getSpectrumGraphSettings(att));
            }
            ++i;
        }
    }

    public void quit() {
        this.storePreferences();
        if (this.file != null && this.fileRecordable) {
            this.save(this.file);
        }
        System.exit(0);
    }

    public void exit() {
        this.storePreferences();
        if (this.file != null && this.fileRecordable) {
            this.save(this.file);
        }
    }
}

