/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.booleanMapEntry;
import fr.esrf.tangoatk.widget.util.jdraw.colorMapEntry;
import fr.esrf.tangoatk.widget.util.jdraw.integerMapEntry;
import fr.esrf.tangoatk.widget.util.jdraw.mapEntry;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

public class JDValueProgram {
    public static final int MAP_BY_VALUE = 0;
    public static final int MAP_LINEAR = 1;
    public static final int MAP_REMAP = 2;
    public static final int INTEGER_TYPE = 1;
    public static final int COLOR_TYPE = 2;
    public static final int BOOLEAN_TYPE = 3;
    private int mode;
    private int type;
    private Vector tableMap;
    private mapEntry defaultValue;
    private int parsePos;

    public JDValueProgram(int n) {
        this.mode = 0;
        this.type = n;
        this.tableMap = new Vector();
        switch (n) {
            case 1: {
                this.defaultValue = new integerMapEntry(0, 1, 0);
                break;
            }
            case 3: {
                this.defaultValue = new booleanMapEntry(0, 1, false);
                break;
            }
            case 2: {
                this.defaultValue = new colorMapEntry(0, 1, Color.GRAY);
            }
        }
    }

    JDValueProgram copy() {
        if (this.mode == 0 && this.getEntryNumber() == 0) {
            return null;
        }
        JDValueProgram jDValueProgram = new JDValueProgram(this.type);
        jDValueProgram.mode = this.mode;
        int n = 0;
        while (n < this.getEntryNumber()) {
            jDValueProgram.tableMap.add(((mapEntry)this.tableMap.get(n)).copy());
            ++n;
        }
        jDValueProgram.defaultValue = this.defaultValue.copy();
        return jDValueProgram;
    }

    public int getType() {
        return this.type;
    }

    public boolean setMode(int n) {
        if (this.type != 1 && (n == 1 || n == 2)) {
            return false;
        }
        this.mode = n;
        return true;
    }

    public int getMode() {
        return this.mode;
    }

    public void addNewEntry() {
        switch (this.type) {
            case 1: {
                this.tableMap.add(new integerMapEntry(0, 0, this.getIntegerMapping(this.defaultValue)));
                break;
            }
            case 3: {
                this.tableMap.add(new booleanMapEntry(0, 0, this.getBooleanMapping(this.defaultValue)));
                break;
            }
            case 2: {
                this.tableMap.add(new colorMapEntry(0, 0, this.getColorMapping(this.defaultValue)));
            }
        }
    }

    public void removeEntry(int n) {
        this.tableMap.remove(n);
    }

    public int getEntryNumber() {
        return this.tableMap.size();
    }

    public String getDefaultMapping() {
        return this.getStrValue(this.defaultValue);
    }

    public boolean setDefaultMapping(String string) {
        switch (this.type) {
            case 1: {
                return this.setIntegerMapping((integerMapEntry)this.defaultValue, string);
            }
            case 3: {
                return this.setBooleanMapping((booleanMapEntry)this.defaultValue, string);
            }
            case 2: {
                return this.setColorMapping((colorMapEntry)this.defaultValue, string);
            }
        }
        return false;
    }

    public Color getDefaultColorMapping() {
        return this.getColorMapping(this.defaultValue);
    }

    public boolean getDefaultBooleanMapping() {
        return this.getBooleanMapping(this.defaultValue);
    }

    public int getDefaultIntegerMapping() {
        return this.getIntegerMapping(this.defaultValue);
    }

    public String getValue(int n) {
        mapEntry mapEntry2 = (mapEntry)this.tableMap.get(n);
        if (mapEntry2.minValue == mapEntry2.maxValue) {
            return Integer.toString(mapEntry2.minValue);
        }
        return Integer.toString(mapEntry2.minValue) + ".." + Integer.toString(mapEntry2.maxValue);
    }

    public String getCompleteValue(int n) {
        mapEntry mapEntry2 = (mapEntry)this.tableMap.get(n);
        return Integer.toString(mapEntry2.minValue) + "," + Integer.toString(mapEntry2.maxValue);
    }

    public boolean setValueAt(int n, String string) {
        mapEntry mapEntry2 = (mapEntry)this.tableMap.get(n);
        this.parsePos = 0;
        try {
            mapEntry2.minValue = this.parseNumber(string);
            if (this.parsePos + 2 <= string.length() && string.substring(this.parsePos, this.parsePos + 2).equals("..")) {
                this.parsePos += 2;
                mapEntry2.maxValue = this.parseNumber(string);
            } else if (this.parsePos + 2 > string.length()) {
                mapEntry2.maxValue = mapEntry2.minValue;
            } else {
                return false;
            }
            return mapEntry2.minValue <= mapEntry2.maxValue;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getMapping(int n) {
        return this.getStrValue((mapEntry)this.tableMap.get(n));
    }

    public boolean setMappingAt(int n, String string) {
        switch (this.type) {
            case 1: {
                return this.setIntegerMapping((integerMapEntry)this.tableMap.get(n), string);
            }
            case 3: {
                return this.setBooleanMapping((booleanMapEntry)this.tableMap.get(n), string);
            }
            case 2: {
                return this.setColorMapping((colorMapEntry)this.tableMap.get(n), string);
            }
        }
        return false;
    }

    public Color getColorMappingAt(int n) {
        return this.getColorMapping((mapEntry)this.tableMap.get(n));
    }

    public boolean getBooleanMappingAt(int n) {
        return this.getBooleanMapping((mapEntry)this.tableMap.get(n));
    }

    public int getIntegerMappingAt(int n) {
        return this.getIntegerMapping((mapEntry)this.tableMap.get(n));
    }

    boolean getBooleanMappingFor(JDObject jDObject) {
        booleanMapEntry booleanMapEntry2 = (booleanMapEntry)this.findEntry(jDObject.getValue());
        if (booleanMapEntry2 == null) {
            return ((booleanMapEntry)this.defaultValue).value;
        }
        return booleanMapEntry2.value;
    }

    Color getColorMappingFor(JDObject jDObject) {
        colorMapEntry colorMapEntry2 = (colorMapEntry)this.findEntry(jDObject.getValue());
        if (colorMapEntry2 == null) {
            return ((colorMapEntry)this.defaultValue).color;
        }
        return colorMapEntry2.color;
    }

    int getIntegerMappingFor(JDObject jDObject, JDObject jDObject2) {
        switch (this.mode) {
            case 0: {
                integerMapEntry integerMapEntry2 = (integerMapEntry)this.findEntry(jDObject.getValue());
                if (integerMapEntry2 == null) {
                    return ((integerMapEntry)this.defaultValue).value;
                }
                return integerMapEntry2.value;
            }
            case 1: {
                double d = (double)(jDObject.getValue() - jDObject.getMinValue()) / (double)(jDObject.getMaxValue() - jDObject.getMinValue());
                return this.defaultValue.minValue + (int)(d * (double)(this.defaultValue.maxValue - this.defaultValue.minValue) + 0.5);
            }
            case 2: {
                double d = (double)(jDObject.getValue() - jDObject.getMinValue()) / (double)(jDObject.getMaxValue() - jDObject.getMinValue());
                Rectangle rectangle = jDObject2.getBoundRect();
                switch (jDObject2.getValueChangeMode()) {
                    case 2: {
                        return (int)((double)rectangle.width * d) - rectangle.width / 2;
                    }
                    case 3: {
                        return -((int)((double)rectangle.width * d)) + rectangle.width / 2;
                    }
                    case 4: {
                        return (int)((double)rectangle.height * d) - rectangle.height / 2;
                    }
                    case 5: {
                        return -((int)((double)rectangle.height * d)) + rectangle.height / 2;
                    }
                }
            }
        }
        return 0;
    }

    public int getMinLinearMapping() {
        return this.defaultValue.minValue;
    }

    public int getMaxLinearMapping() {
        return this.defaultValue.maxValue;
    }

    public void setMinLinearValue(int n) {
        this.defaultValue.minValue = n;
    }

    public void setMaxLinearValue(int n) {
        this.defaultValue.maxValue = n;
    }

    public void saveObject(FileWriter fileWriter, String string) throws IOException {
        String string2 = string + "mapping_type:" + this.type + "\n";
        fileWriter.write(string2);
        string2 = string + "mode:" + this.mode + "\n";
        fileWriter.write(string2);
        string2 = string + "default:" + this.getDefaultMapping() + "\n";
        fileWriter.write(string2);
        switch (this.mode) {
            case 0: {
                int n = 0;
                while (n < this.getEntryNumber()) {
                    string2 = string + "map:" + this.getCompleteValue(n) + "," + this.getMapping(n) + "\n";
                    fileWriter.write(string2);
                    ++n;
                }
                break;
            }
            case 1: {
                string2 = string + "lmin:" + this.getMinLinearMapping() + "\n";
                fileWriter.write(string2);
                string2 = string + "lmax:" + this.getMaxLinearMapping() + "\n";
                fileWriter.write(string2);
            }
        }
    }

    public JDValueProgram(JDFileLoader jDFileLoader) throws IOException {
        int n = jDFileLoader.getCurrentLine();
        this.type = -1;
        this.mode = 0;
        this.tableMap = new Vector();
        this.defaultValue = null;
        jDFileLoader.startBlock();
        block10: while (!jDFileLoader.isEndBlock()) {
            Color color;
            boolean bl;
            int n2;
            String string = jDFileLoader.parseProperyName();
            if (string.equals("mapping_type")) {
                this.type = (int)jDFileLoader.parseDouble();
                continue;
            }
            if (string.equals("mode")) {
                this.mode = (int)jDFileLoader.parseDouble();
                continue;
            }
            if (string.equals("lmin")) {
                if (this.defaultValue != null) {
                    this.defaultValue.minValue = (int)jDFileLoader.parseDouble();
                    continue;
                }
                throw new IOException("default must be specified before lmin line " + jDFileLoader.getCurrentLine());
            }
            if (string.equals("lmax")) {
                if (this.defaultValue != null) {
                    this.defaultValue.maxValue = (int)jDFileLoader.parseDouble();
                    continue;
                }
                throw new IOException("default must be specified before lmax at line " + jDFileLoader.getCurrentLine());
            }
            if (string.equals("default")) {
                switch (this.type) {
                    case 1: {
                        n2 = (int)jDFileLoader.parseDouble();
                        this.defaultValue = new integerMapEntry(0, 1, n2);
                        break;
                    }
                    case 3: {
                        bl = jDFileLoader.parseBoolean();
                        this.defaultValue = new booleanMapEntry(0, 1, bl);
                        break;
                    }
                    case 2: {
                        color = jDFileLoader.parseColor();
                        this.defaultValue = new colorMapEntry(0, 1, color);
                    }
                }
                continue;
            }
            if (string.equals("map")) {
                int n3 = (int)jDFileLoader.parseDouble();
                jDFileLoader.jumpLexem(3);
                int n4 = (int)jDFileLoader.parseDouble();
                jDFileLoader.jumpLexem(3);
                switch (this.type) {
                    case 1: {
                        n2 = (int)jDFileLoader.parseDouble();
                        this.tableMap.add(new integerMapEntry(n3, n4, n2));
                        continue block10;
                    }
                    case 3: {
                        bl = jDFileLoader.parseBoolean();
                        this.tableMap.add(new booleanMapEntry(n3, n4, bl));
                        continue block10;
                    }
                    case 2: {
                        color = jDFileLoader.parseColor();
                        this.tableMap.add(new colorMapEntry(n3, n4, color));
                        continue block10;
                    }
                    default: {
                        throw new IOException("No mapping_type specified for the ValueMapper at line " + n);
                    }
                }
            }
            System.out.println("Unknown property found:" + string);
            jDFileLoader.jumpPropertyValue();
        }
        jDFileLoader.endBlock();
        if (this.defaultValue == null) {
            throw new IOException("No default specified for the ValueMapper at line " + n);
        }
        if (this.type == -1) {
            throw new IOException("No mapping_type specified for the ValueMapper at line " + n);
        }
        if (this.mode == 0 && this.getEntryNumber() == 0) {
            throw new IOException("No mapping table found for the ValueMapper at line " + n);
        }
    }

    private boolean isNumber(char c) {
        return c >= '0' && c <= '9' || c == '-';
    }

    private String getStrValue(mapEntry mapEntry2) {
        if (mapEntry2 instanceof colorMapEntry) {
            Color color = ((colorMapEntry)mapEntry2).color;
            return color.getRed() + "," + color.getGreen() + "," + color.getBlue();
        }
        if (mapEntry2 instanceof integerMapEntry) {
            return Integer.toString(((integerMapEntry)mapEntry2).value);
        }
        if (mapEntry2 instanceof booleanMapEntry) {
            return Boolean.toString(((booleanMapEntry)mapEntry2).value);
        }
        return "Invalid mapping";
    }

    private Color getColorMapping(mapEntry mapEntry2) {
        return ((colorMapEntry)mapEntry2).color;
    }

    private int getIntegerMapping(mapEntry mapEntry2) {
        return ((integerMapEntry)mapEntry2).value;
    }

    private boolean getBooleanMapping(mapEntry mapEntry2) {
        return ((booleanMapEntry)mapEntry2).value;
    }

    private boolean setColorMapping(colorMapEntry colorMapEntry2, String string) {
        this.parsePos = 0;
        try {
            int n = this.parseNumber(string);
            if (string.charAt(this.parsePos) != ',') {
                return false;
            }
            ++this.parsePos;
            int n2 = this.parseNumber(string);
            if (string.charAt(this.parsePos) != ',') {
                return false;
            }
            ++this.parsePos;
            int n3 = this.parseNumber(string);
            colorMapEntry2.color = new Color(n, n2, n3);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean setBooleanMapping(booleanMapEntry booleanMapEntry2, String string) {
        booleanMapEntry2.value = Boolean.valueOf(string);
        return true;
    }

    private boolean setIntegerMapping(integerMapEntry integerMapEntry2, String string) {
        this.parsePos = 0;
        try {
            integerMapEntry2.value = this.parseNumber(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private int parseNumber(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        boolean bl = true;
        while (this.parsePos < n && bl) {
            bl = this.isNumber(string.charAt(this.parsePos));
            if (!bl) continue;
            stringBuffer.append(string.charAt(this.parsePos));
            ++this.parsePos;
        }
        return Integer.parseInt(stringBuffer.toString());
    }

    private mapEntry findEntry(int n) {
        boolean bl = false;
        int n2 = 0;
        mapEntry mapEntry2 = null;
        while (!bl && n2 < this.tableMap.size()) {
            mapEntry2 = (mapEntry)this.tableMap.get(n2);
            boolean bl2 = bl = n >= mapEntry2.minValue && n <= mapEntry2.maxValue;
            if (bl) continue;
            ++n2;
        }
        if (bl) {
            return mapEntry2;
        }
        return null;
    }
}

