/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDFileLoader;
import fr.esrf.tangoatk.widget.util.jdraw.JDGroup;
import fr.esrf.tangoatk.widget.util.jdraw.JDLine;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyConvert;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangular;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import fr.esrf.tangoatk.widget.util.jdraw.JLXObject;
import fr.esrf.tangoatk.widget.util.jdraw.UndoBuffer;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

public class JDGroup
extends JDRectangular {
    private Vector children;
    private double x1;
    private double y1;
    private double x2;
    private double y2;
    private boolean vFlat = false;
    private boolean hFlat = false;

    public JDGroup(String string, Vector vector) {
        this.initDefault();
        this.children = new Vector();
        int n = 0;
        while (n < vector.size()) {
            this.children.add(vector.get(n));
            ++n;
        }
        this.summit = new Point2D.Double[8];
        this.name = string;
        this.createSummit();
        this.computeSummitCoordinates();
        this.updateShape();
    }

    JDGroup(JDGroup jDGroup, int n, int n2) {
        this.cloneObject(jDGroup, n, n2);
        this.children = new Vector();
        int n3 = 0;
        while (n3 < jDGroup.children.size()) {
            this.children.add(((JDObject)jDGroup.children.get(n3)).copy(n, n2));
            ++n3;
        }
        this.computeGroupBoundRect();
        this.updateShape();
    }

    public JDObject copy(int n, int n2) {
        return new JDGroup(this, n, n2);
    }

    JDGroup(JLXObject jLXObject, Vector vector) {
        this.initDefault();
        this.loadObject(jLXObject);
        this.children = vector;
        this.summit = new Point2D.Double[8];
        this.createSummit();
        this.computeSummitCoordinates();
        this.updateShape();
    }

    private boolean canPaint() {
        if (!this.visible) {
            return false;
        }
        if (this.hFlat) {
            return this.boundRect.width > 1 || !(Math.abs(this.summit[4].x - this.summit[0].x) < 0.5);
        }
        if (this.vFlat) {
            return this.boundRect.height > 1 || !(Math.abs(this.summit[4].y - this.summit[0].y) < 0.5);
        }
        return this.boundRect.width > 1 && this.boundRect.height > 1 || !(Math.abs(this.summit[4].x - this.summit[0].x) < 0.5) && !(Math.abs(this.summit[4].y - this.summit[0].y) < 0.5);
    }

    public void paint(JDrawEditor jDrawEditor, Graphics graphics) {
        if (this.canPaint()) {
            int n = 0;
            while (n < this.children.size()) {
                ((JDObject)this.children.get(n)).paint(jDrawEditor, graphics);
                ++n;
            }
        }
    }

    void paintShadows(Graphics graphics) {
    }

    public boolean isInsideObject(int n, int n2) {
        if (!super.isInsideObject(n, n2)) {
            return false;
        }
        boolean bl = false;
        int n3 = this.children.size() - 1;
        while (n3 >= 0 && !bl) {
            bl = ((JDObject)this.children.get(n3)).isInsideObject(n, n2);
            --n3;
        }
        return bl;
    }

    void updateShape() {
        double d;
        if (this.hFlat ? Math.abs(this.summit[4].x - this.summit[0].x) < 0.5 : (this.vFlat ? Math.abs(this.summit[4].y - this.summit[0].y) < 0.5 : Math.abs(this.summit[4].x - this.summit[0].x) < 0.5 || Math.abs(this.summit[4].y - this.summit[0].y) < 0.5)) {
            return;
        }
        double d2 = this.summit[0].x;
        double d3 = this.summit[0].y;
        double d4 = this.summit[4].x;
        double d5 = this.summit[4].y;
        double d6 = d2 - this.x1;
        double d7 = d3 - this.y1;
        double d8 = this.vFlat ? 1.0 : (d4 - d2) / (this.x2 - this.x1);
        double d9 = d = this.hFlat ? 1.0 : (d5 - d3) / (this.y2 - this.y1);
        if (d8 == 1.0 && d == 1.0) {
            int n = 0;
            while (n < this.children.size()) {
                ((JDObject)this.children.get(n)).translate(d6, d7);
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.children.size()) {
                ((JDObject)this.children.get(n)).scaleTranslate(this.x1, this.y1, d8, d, d6, d7);
                ++n;
            }
        }
        this.computeGroupBoundRect();
        this.computeBoundRect();
    }

    public void restoreTransform() {
        int n = 0;
        while (n < this.children.size()) {
            ((JDObject)this.children.get(n)).restoreTransform();
            ++n;
        }
        this.computeGroupBoundRect();
        super.restoreTransform();
    }

    public void saveTransform() {
        int n = 0;
        while (n < this.children.size()) {
            ((JDObject)this.children.get(n)).saveTransform();
            ++n;
        }
        super.saveTransform();
    }

    public void rotate90(double d, double d2) {
        int n = 0;
        while (n < this.getChildrenNumber()) {
            this.getChildAt(n).rotate90(d, d2);
            ++n;
        }
        this.computeSummitCoordinates();
        this.updateShape();
    }

    int getSummitMotion(int n) {
        if (this.hFlat) {
            if (n == 1 || n == 5) {
                return 0;
            }
            return 1;
        }
        if (this.vFlat) {
            if (n == 7 || n == 3) {
                return 0;
            }
            return 2;
        }
        return super.getSummitMotion(n);
    }

    public void moveSummit(int n, double d, double d2) {
        if (this.hFlat) {
            switch (n) {
                case 0: 
                case 6: 
                case 7: {
                    super.moveSummit(7, d, d2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    super.moveSummit(3, d, d2);
                }
            }
            return;
        }
        if (this.vFlat) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: {
                    super.moveSummit(1, d, d2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    super.moveSummit(5, d, d2);
                }
            }
            return;
        }
        super.moveSummit(n, d, d2);
    }

    void paintSummit(Graphics graphics, double d) {
        int n = (int)(d / 2.0 + 1.0);
        if (this.hFlat) {
            graphics.setColor(Color.black);
            graphics.setXORMode(Color.white);
            graphics.fillRect((int)(this.summit[0].x - (double)n), (int)(this.summit[0].y - (double)n), 2 * n, 2 * n);
            graphics.fillRect((int)(this.summit[2].x - (double)n), (int)(this.summit[2].y - (double)n), 2 * n, 2 * n);
            graphics.setPaintMode();
            return;
        }
        if (this.vFlat) {
            graphics.setColor(Color.black);
            graphics.setXORMode(Color.white);
            graphics.fillRect((int)(this.summit[0].x - (double)n), (int)(this.summit[0].y - (double)n), 2 * n, 2 * n);
            graphics.fillRect((int)(this.summit[6].x - (double)n), (int)(this.summit[6].y - (double)n), 2 * n, 2 * n);
            graphics.setPaintMode();
            return;
        }
        super.paintSummit(graphics, d);
    }

    void setParent(JDrawEditor jDrawEditor) {
        super.setParent(jDrawEditor);
        int n = 0;
        while (n < this.getChildrenNumber()) {
            this.getChildAt(n).setParent(jDrawEditor);
            ++n;
        }
    }

    Rectangle getRepaintRect() {
        Rectangle rectangle = null;
        int n = 0;
        while (n < this.children.size()) {
            rectangle = n == 0 ? ((JDObject)this.children.get(n)).getRepaintRect() : rectangle.union(((JDObject)this.children.get(n)).getRepaintRect());
            ++n;
        }
        if (rectangle == null) {
            int n2 = this.lineWidth + 1;
            return new Rectangle(this.boundRect.x - n2, this.boundRect.y - n2, this.boundRect.width + n2 * 2, this.boundRect.height + n2 * 2);
        }
        return rectangle;
    }

    public void setBackground(Color color) {
        this.background = color;
        int n = 0;
        while (n < this.children.size()) {
            ((JDObject)this.children.get(n)).setBackground(color);
            ++n;
        }
    }

    public void setForeground(Color color) {
        this.foreground = color;
        int n = 0;
        while (n < this.children.size()) {
            ((JDObject)this.children.get(n)).setForeground(color);
            ++n;
        }
    }

    public void setFillStyle(int n) {
        this.fillStyle = n;
        int n2 = 0;
        while (n2 < this.children.size()) {
            ((JDObject)this.children.get(n2)).setFillStyle(n);
            ++n2;
        }
    }

    public void setLineStyle(int n) {
        this.lineStyle = n;
        int n2 = 0;
        while (n2 < this.children.size()) {
            ((JDObject)this.children.get(n2)).setLineStyle(n);
            ++n2;
        }
    }

    public void setAntiAlias(boolean bl) {
        this.antiAlias = bl;
        int n = 0;
        while (n < this.children.size()) {
            ((JDObject)this.children.get(n)).setAntiAlias(bl);
            ++n;
        }
    }

    public void setLineWidth(int n) {
        this.lineWidth = n;
        int n2 = 0;
        while (n2 < this.children.size()) {
            ((JDObject)this.children.get(n2)).setLineWidth(n);
            ++n2;
        }
    }

    public void setShadow(boolean bl) {
        this.isShadowed = bl;
        int n = 0;
        while (n < this.children.size()) {
            ((JDObject)this.children.get(n)).setShadow(bl);
            ++n;
        }
    }

    public void setInverseShadow(boolean bl) {
        this.invertShadow = bl;
        int n = 0;
        while (n < this.children.size()) {
            ((JDObject)this.children.get(n)).setInverseShadow(bl);
            ++n;
        }
    }

    public void setShadowWidth(int n) {
        this.shadowThickness = n;
        int n2 = 0;
        while (n2 < this.children.size()) {
            ((JDObject)this.children.get(n2)).setShadowWidth(n);
            ++n2;
        }
    }

    void setVal(int n, JDObject jDObject) {
        int n2 = 0;
        while (n2 < this.children.size()) {
            ((JDObject)this.children.get(n2)).setVal(n, jDObject);
            ++n2;
        }
        super.setVal(n, jDObject);
    }

    void initVal(JDObject jDObject) {
        JDObject jDObject2 = this.isInteractive() ? this : jDObject;
        super.initVal(jDObject2);
        int n = 0;
        while (n < this.children.size()) {
            this.getChildAt(n).initVal(jDObject2);
            ++n;
        }
    }

    public void setMinValue(int n) {
        int n2 = 0;
        while (n2 < this.children.size()) {
            this.getChildAt(n2).setMinValue(n);
            ++n2;
        }
        super.setMinValue(n);
    }

    public void setMaxValue(int n) {
        int n2 = 0;
        while (n2 < this.children.size()) {
            this.getChildAt(n2).setMaxValue(n);
            ++n2;
        }
        super.setMaxValue(n);
    }

    public void setInitValue(int n) {
        int n2 = 0;
        while (n2 < this.children.size()) {
            this.getChildAt(n2).setInitValue(n);
            ++n2;
        }
        super.setInitValue(n);
    }

    void findObjectsAt(int n, int n2, Vector vector) {
        if (this.isInteractive()) {
            super.findObjectsAt(n, n2, vector);
            return;
        }
        int n3 = 0;
        while (n3 < this.children.size()) {
            this.getChildAt(n3).findObjectsAt(n, n2, vector);
            ++n3;
        }
    }

    void getUserValueList(Vector vector) {
        if (this.isInteractive()) {
            vector.add(this);
        } else {
            int n = 0;
            while (n < this.children.size()) {
                this.getChildAt(n).getUserValueList(vector);
                ++n;
            }
        }
    }

    void getObjectsByClassList(Vector vector, Class clazz) {
        int n = 0;
        while (n < this.children.size()) {
            this.getChildAt(n).getObjectsByClassList(vector, clazz);
            ++n;
        }
    }

    public void getObjectsByName(Vector vector, String string, boolean bl) {
        super.getObjectsByName(vector, string, bl);
        int n = 0;
        while (n < this.children.size() && bl) {
            this.getChildAt(n).getObjectsByName(vector, string, bl);
            ++n;
        }
    }

    public boolean isProgrammed() {
        boolean bl = super.isProgrammed();
        int n = 0;
        while (n < this.children.size()) {
            bl |= this.getChildAt(n).isProgrammed();
            ++n;
        }
        return bl;
    }

    public JDObject getChildAt(int n) {
        return (JDObject)this.children.get(n);
    }

    public int getChildrenNumber() {
        return this.children.size();
    }

    public void setChildrenList(Vector vector) {
        this.children = new Vector();
        int n = 0;
        while (n < vector.size()) {
            this.children.add(vector.get(n));
            ++n;
        }
        this.computeSummitCoordinates();
        this.updateShape();
    }

    public Vector getChildren() {
        return this.children;
    }

    public void generateJavaClass(FileWriter fileWriter) throws IOException {
        int n;
        Object object;
        int n2 = this.boundRect.x + this.boundRect.width / 2;
        int n3 = this.boundRect.y + this.boundRect.height / 2;
        class ObjInfo {
            int type;
            boolean closed;
            int[] xPolys;
            int[] yPolys;
            int backgroundId;
            int foregroundId;
            private final /* synthetic */ JDGroup this$0;

            ObjInfo(JDGroup jDGroup) {
                this.this$0 = jDGroup;
            }

            void setValue(JDPolyline jDPolyline, int n, int n2, ColorManager colorManager) {
                this.type = 1;
                this.xPolys = new int[jDPolyline.getSummitNumber()];
                this.yPolys = new int[jDPolyline.getSummitNumber()];
                int n3 = 0;
                while (n3 < jDPolyline.getSummitNumber()) {
                    this.xPolys[n3] = (int)jDPolyline.getSummit((int)n3).x - n;
                    this.yPolys[n3] = (int)jDPolyline.getSummit((int)n3).y - n2;
                    ++n3;
                }
                if (jDPolyline.getName().equalsIgnoreCase("body")) {
                    this.backgroundId = -3;
                    this.foregroundId = -1;
                } else {
                    class ColorManager {
                        Vector colors;
                        private final /* synthetic */ JDGroup this$0;

                        ColorManager(JDGroup jDGroup) {
                            this.this$0 = jDGroup;
                            this.colors = new Vector<E>();
                        }

                        int addColor(Color color) {
                            if (color.equals(Color.black)) {
                                return -1;
                            }
                            if (color.equals(Color.white)) {
                                return -2;
                            }
                            int n = 0;
                            boolean bl = false;
                            while (n < this.colors.size() && !bl) {
                                boolean bl2 = bl = ((Color)this.colors.get(n)).getRGB() == color.getRGB();
                                if (bl) continue;
                                ++n;
                            }
                            if (!bl) {
                                this.colors.add(color);
                            }
                            return n;
                        }

                        Color get(int n) {
                            return (Color)this.colors.get(n);
                        }

                        String getName(int n) {
                            if (n == -1) {
                                return "Color.black";
                            }
                            if (n == -2) {
                                return "Color.white";
                            }
                            if (n == -3) {
                                return "backColor";
                            }
                            return "sColor" + n;
                        }
                    }
                    this.backgroundId = colorManager.addColor(jDPolyline.getBackground());
                    this.foregroundId = colorManager.addColor(jDPolyline.getForeground());
                }
                this.closed = jDPolyline.isClosed();
            }
        }
        ObjInfo[] objInfoArray = new ObjInfo[this.getChildrenNumber()];
        ColorManager colorManager = new ColorManager(this);
        int n4 = 0;
        while (n4 < this.getChildrenNumber()) {
            objInfoArray[n4] = new ObjInfo(this);
            if (this.getChildAt(n4) instanceof JDPolyConvert) {
                object = ((JDPolyConvert)((Object)this.getChildAt(n4))).convertToPolyline();
                objInfoArray[n4].setValue((JDPolyline)object, n2, n3, colorManager);
            } else if (this.getChildAt(n4) instanceof JDPolyline) {
                object = (JDPolyline)this.getChildAt(n4);
                objInfoArray[n4].setValue((JDPolyline)object, n2, n3, colorManager);
            } else if (this.getChildAt(n4) instanceof JDLine) {
                object = (JDLine)this.getChildAt(n4);
                objInfoArray[n4].type = 2;
                objInfoArray[n4].xPolys = new int[2];
                objInfoArray[n4].yPolys = new int[2];
                objInfoArray[n4].xPolys[0] = (int)((JDObject)object).getSummit((int)0).x - n2;
                objInfoArray[n4].yPolys[0] = (int)((JDObject)object).getSummit((int)0).y - n3;
                objInfoArray[n4].xPolys[1] = (int)((JDObject)object).getSummit((int)1).x - n2;
                objInfoArray[n4].yPolys[1] = (int)((JDObject)object).getSummit((int)1).y - n3;
                objInfoArray[n4].foregroundId = colorManager.addColor(((JDObject)object).getForeground());
            } else {
                throw new IOException("generateJavaClass() supports only Line or Polyline");
            }
            ++n4;
        }
        fileWriter.write("/** ---------- " + this.getName() + " class ---------- */\n");
        fileWriter.write("public class " + this.getName() + " {\n\n");
        fileWriter.write("  private static int[][] xPolys = null;\n");
        fileWriter.write("  private static int[][] yPolys = null;\n\n");
        n4 = 0;
        while (n4 < colorManager.colors.size()) {
            object = colorManager.get(n4);
            fileWriter.write("  private static Color sColor" + n4 + " = new Color(" + ((Color)object).getRed() + "," + ((Color)object).getGreen() + "," + ((Color)object).getBlue() + ");\n");
            ++n4;
        }
        fileWriter.write("\n");
        fileWriter.write("  private static int[][] xOrgPolys = {\n");
        n4 = 0;
        while (n4 < this.getChildrenNumber()) {
            if (objInfoArray[n4].type == 1) {
                fileWriter.write("    {");
                n = 0;
                while (n < objInfoArray[n4].xPolys.length) {
                    fileWriter.write(Integer.toString(objInfoArray[n4].xPolys[n]));
                    if (n < objInfoArray[n4].xPolys.length - 1) {
                        fileWriter.write(",");
                    }
                    ++n;
                }
                fileWriter.write("},\n");
            }
            ++n4;
        }
        fileWriter.write("  };\n\n");
        fileWriter.write("  private static int[][] yOrgPolys = {\n");
        n4 = 0;
        while (n4 < this.getChildrenNumber()) {
            if (objInfoArray[n4].type == 1) {
                fileWriter.write("    {");
                n = 0;
                while (n < objInfoArray[n4].yPolys.length) {
                    fileWriter.write(Integer.toString(objInfoArray[n4].yPolys[n]));
                    if (n < objInfoArray[n4].yPolys.length - 1) {
                        fileWriter.write(",");
                    }
                    ++n;
                }
                fileWriter.write("},\n");
            }
            ++n4;
        }
        fileWriter.write("  };\n\n");
        fileWriter.write("  static public void paint(Graphics g,Color backColor,int x,int y,double size) {\n\n");
        fileWriter.write("    // Allocate array once\n");
        fileWriter.write("    if( xPolys == null ) {\n");
        fileWriter.write("      xPolys = new int [xOrgPolys.length][];\n");
        fileWriter.write("      yPolys = new int [yOrgPolys.length][];\n");
        fileWriter.write("      for( int i=0 ; i<xOrgPolys.length ; i++ ) {\n");
        fileWriter.write("        xPolys[i] = new int [xOrgPolys[i].length];\n");
        fileWriter.write("        yPolys[i] = new int [yOrgPolys[i].length];\n");
        fileWriter.write("      }\n");
        fileWriter.write("    }\n\n");
        fileWriter.write("    // Scale and translate poly\n");
        fileWriter.write("    for( int i=0 ; i<xOrgPolys.length ; i++ ) {\n");
        fileWriter.write("      for( int j=0 ; j<xOrgPolys[i].length ; j++ ) {\n");
        fileWriter.write("        xPolys[i][j] = (int)((double)xOrgPolys[i][j]*size+0.5) + x;\n");
        fileWriter.write("        yPolys[i][j] = (int)((double)yOrgPolys[i][j]*size+0.5) + y;\n");
        fileWriter.write("      }\n");
        fileWriter.write("    }\n\n");
        fileWriter.write("    // Paint object\n");
        int n5 = 0;
        n4 = 0;
        while (n4 < this.getChildrenNumber()) {
            if (objInfoArray[n4].type == 1) {
                if (this.getChildAt(n4).getFillStyle() != 0) {
                    fileWriter.write("    g.setColor(" + colorManager.getName(objInfoArray[n4].backgroundId) + ");g.fillPolygon(xPolys[" + n5 + "],yPolys[" + n5 + "],xPolys[" + n5 + "].length);\n");
                }
                if (objInfoArray[n4].closed) {
                    fileWriter.write("    g.setColor(" + colorManager.getName(objInfoArray[n4].foregroundId) + ");g.drawPolygon(xPolys[" + n5 + "],yPolys[" + n5 + "],xPolys[" + n5 + "].length);\n");
                } else {
                    fileWriter.write("    g.setColor(" + colorManager.getName(objInfoArray[n4].foregroundId) + ");g.drawPolyline(xPolys[" + n5 + "],yPolys[" + n5 + "],xPolys[" + n5 + "].length);\n");
                }
                ++n5;
            } else {
                fileWriter.write("    g.setColor(" + colorManager.getName(objInfoArray[n4].foregroundId) + ");\n");
                fileWriter.write("    g.drawLine((int)(" + objInfoArray[n4].xPolys[0] + ".0*size+0.5)+x, (int)(" + objInfoArray[n4].yPolys[0] + ".0*size+0.5)+y, (int)(" + objInfoArray[n4].xPolys[1] + ".0*size+0.5)+x, (int)(" + objInfoArray[n4].yPolys[1] + ".0*size+0.5)+y);\n");
            }
            ++n4;
        }
        fileWriter.write("\n  }\n\n");
        fileWriter.write("  static public void setBoundRect(int x,int y,double size,Rectangle bound) {\n");
        fileWriter.write("    bound.setRect((int)(" + (this.boundRect.x - n2) + ".0*size+0.5)+x,(int)(" + (this.boundRect.y - n3) + ".0*size+0.5)+y,(int)(" + this.boundRect.width + ".0*size+0.5),(int)(" + this.boundRect.height + ".0*size+0.5));");
        fileWriter.write("\n  }\n\n");
        fileWriter.write("}\n\n");
    }

    void saveObject(FileWriter fileWriter, int n) throws IOException {
        if (this.children.size() > 0) {
            String string = this.saveObjectHeader(fileWriter, n);
            String string2 = string + "children: {\n";
            fileWriter.write(string2, 0, string2.length());
            int n2 = 0;
            while (n2 < this.children.size()) {
                ((JDObject)this.children.get(n2)).saveObject(fileWriter, n + 2);
                ++n2;
            }
            string2 = string + "}\n";
            fileWriter.write(string2, 0, string2.length());
            this.closeObjectHeader(fileWriter, n);
        }
    }

    JDGroup(JDFileLoader jDFileLoader) throws IOException {
        this.children = new Vector();
        this.initDefault();
        jDFileLoader.startBlock();
        this.summit = jDFileLoader.parseRectangularSummitArray();
        while (!jDFileLoader.isEndBlock()) {
            String string = jDFileLoader.parseProperyName();
            if (string.equals("children")) {
                jDFileLoader.startBlock();
                while (!jDFileLoader.isEndBlock()) {
                    this.children.add(jDFileLoader.parseObject());
                }
                jDFileLoader.endBlock();
                continue;
            }
            this.loadDefaultPropery(jDFileLoader, string);
        }
        jDFileLoader.endBlock();
        this.computeGroupBoundRect();
        this.updateShape();
    }

    UndoPattern getUndoPattern() {
        UndoPattern undoPattern = new UndoPattern(2);
        this.fillUndoPattern(undoPattern);
        undoPattern.gChildren = new Vector();
        int n = 0;
        while (n < this.children.size()) {
            undoPattern.gChildren.add(((JDObject)this.children.get(n)).getUndoPattern());
            ++n;
        }
        return undoPattern;
    }

    JDGroup(UndoPattern undoPattern) {
        this.initDefault();
        this.applyUndoPattern(undoPattern);
        this.children = new Vector();
        int n = 0;
        while (n < undoPattern.gChildren.size()) {
            UndoPattern undoPattern2 = (UndoPattern)undoPattern.gChildren.get(n);
            UndoBuffer.rebuildObject(undoPattern2, this.children);
            ++n;
        }
        this.computeGroupBoundRect();
        this.updateShape();
    }

    private void computeGroupBoundRect() {
        double d;
        this.x1 = 65536.0;
        this.y1 = 65536.0;
        this.x2 = -65536.0;
        this.y2 = -65536.0;
        int n = 0;
        while (n < this.children.size()) {
            JDObject jDObject = (JDObject)this.children.get(n);
            int n2 = 0;
            while (n2 < jDObject.summit.length) {
                if (jDObject.summit[n2].x < this.x1) {
                    this.x1 = jDObject.summit[n2].x;
                }
                if (jDObject.summit[n2].y < this.y1) {
                    this.y1 = jDObject.summit[n2].y;
                }
                if (jDObject.summit[n2].x > this.x2) {
                    this.x2 = jDObject.summit[n2].x;
                }
                if (jDObject.summit[n2].y > this.y2) {
                    this.y2 = jDObject.summit[n2].y;
                }
                ++n2;
            }
            ++n;
        }
        this.hFlat = this.y2 == this.y1;
        boolean bl = this.vFlat = this.x2 == this.x1;
        if (this.summit[0].x > this.summit[4].x) {
            d = this.x1;
            this.x1 = this.x2;
            this.x2 = d;
        }
        if (this.summit[0].y > this.summit[4].y) {
            d = this.y1;
            this.y1 = this.y2;
            this.y2 = d;
        }
    }

    private void computeSummitCoordinates() {
        this.computeGroupBoundRect();
        if (this.children.size() >= 0) {
            this.summit[0].x = this.x1;
            this.summit[0].y = this.y1;
            this.summit[2].x = this.x2;
            this.summit[2].y = this.y1;
            this.summit[4].x = this.x2;
            this.summit[4].y = this.y2;
            this.summit[6].x = this.x1;
            this.summit[6].y = this.y2;
            this.centerSummit();
        }
        this.setOrigin(new Point2D.Double((this.x2 - this.x1) / 2.0, (this.y2 - this.y1) / 2.0));
    }
}

