/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDBar;
import fr.esrf.tangoatk.widget.util.jdraw.JDUtils;
import fr.esrf.tangoatk.widget.util.jdraw.JDrawEditor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class JDBarPanel
extends JPanel
implements ActionListener {
    JCheckBox outLineCheckBox;
    private JLabel valueLabel;
    private JTextField valueText;
    private JLabel minValueLabel;
    private JTextField minValueText;
    private JLabel maxValueLabel;
    private JTextField maxValueText;
    private JButton applyValueBtn;
    private JLabel orientationLabel;
    private JComboBox orientationCombo;
    private JDBar[] allObjects = null;
    private JDrawEditor invoker;
    private Rectangle oldRect;
    private boolean isUpdating = false;

    public JDBarPanel(JDBar[] jDBarArray, JDrawEditor jDrawEditor) {
        this.invoker = jDrawEditor;
        this.setLayout(null);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(380, 290));
        JPanel jPanel = new JPanel(null);
        jPanel.setBorder(JDUtils.createTitleBorder("Bar Value"));
        jPanel.setBounds(5, 5, 370, 55);
        this.valueLabel = JDUtils.createLabel("Val");
        this.valueLabel.setBounds(10, 20, 30, 25);
        jPanel.add(this.valueLabel);
        this.valueText = new JTextField();
        this.valueText.setEditable(true);
        this.valueText.setFont(JDUtils.labelFont);
        this.valueText.setBounds(45, 20, 50, 24);
        this.valueText.addActionListener(this);
        jPanel.add(this.valueText);
        this.minValueLabel = JDUtils.createLabel("Min");
        this.minValueLabel.setBounds(100, 20, 30, 25);
        jPanel.add(this.minValueLabel);
        this.minValueText = new JTextField();
        this.minValueText.setEditable(true);
        this.minValueText.setFont(JDUtils.labelFont);
        this.minValueText.setBounds(135, 20, 50, 24);
        this.minValueText.addActionListener(this);
        jPanel.add(this.minValueText);
        this.maxValueLabel = JDUtils.createLabel("Max");
        this.maxValueLabel.setBounds(190, 20, 30, 25);
        jPanel.add(this.maxValueLabel);
        this.maxValueText = new JTextField();
        this.maxValueText.setEditable(true);
        this.maxValueText.setFont(JDUtils.labelFont);
        this.maxValueText.setBounds(225, 20, 50, 24);
        this.maxValueText.addActionListener(this);
        jPanel.add(this.maxValueText);
        this.applyValueBtn = new JButton("Apply");
        this.applyValueBtn.setFont(JDUtils.labelFont);
        this.applyValueBtn.setMargin(new Insets(0, 0, 0, 0));
        this.applyValueBtn.setForeground(Color.BLACK);
        this.applyValueBtn.addActionListener(this);
        this.applyValueBtn.setBounds(285, 20, 75, 25);
        jPanel.add(this.applyValueBtn);
        this.add(jPanel);
        JPanel jPanel2 = new JPanel(null);
        jPanel2.setBorder(JDUtils.createTitleBorder("Styles"));
        jPanel2.setBounds(5, 70, 370, 90);
        this.outLineCheckBox = new JCheckBox("Show Outline");
        this.outLineCheckBox.setFont(JDUtils.labelFont);
        this.outLineCheckBox.setBounds(5, 50, 150, 24);
        this.outLineCheckBox.addActionListener(this);
        jPanel2.add(this.outLineCheckBox);
        this.orientationLabel = JDUtils.createLabel("Orientation");
        this.orientationLabel.setBounds(10, 20, 100, 20);
        jPanel2.add(this.orientationLabel);
        this.orientationCombo = new JComboBox();
        this.orientationCombo.setFont(JDUtils.labelFont);
        this.orientationCombo.addItem("Left to Right");
        this.orientationCombo.addItem("Right To Left");
        this.orientationCombo.addItem("Top to Bottom");
        this.orientationCombo.addItem("Bottom to Top");
        this.orientationCombo.addActionListener(this);
        this.orientationCombo.setBounds(120, 20, 240, 25);
        jPanel2.add(this.orientationCombo);
        this.add(jPanel2);
        this.updatePanel(jDBarArray);
    }

    public void updatePanel(JDBar[] jDBarArray) {
        this.allObjects = jDBarArray;
        this.isUpdating = true;
        if (jDBarArray == null || jDBarArray.length <= 0) {
            this.outLineCheckBox.setSelected(false);
            this.valueText.setText("");
            this.minValueText.setText("");
            this.maxValueText.setText("");
            this.orientationCombo.setSelectedIndex(-1);
        } else {
            this.refreshControls();
        }
        this.isUpdating = false;
    }

    private void refreshControls() {
        JDBar jDBar = this.allObjects[0];
        this.isUpdating = true;
        this.outLineCheckBox.setSelected(jDBar.isOutLineVisible());
        this.valueText.setText(Double.toString(jDBar.getBarValue()));
        this.minValueText.setText(Double.toString(jDBar.getMinimum()));
        this.maxValueText.setText(Double.toString(jDBar.getMaximum()));
        this.orientationCombo.setSelectedIndex(jDBar.getOrientation());
        this.isUpdating = false;
    }

    private void initRepaint() {
        if (this.allObjects == null) {
            return;
        }
        this.oldRect = this.allObjects[0].getRepaintRect();
        int n = 1;
        while (n < this.allObjects.length) {
            this.oldRect = this.oldRect.union(this.allObjects[n].getRepaintRect());
            ++n;
        }
    }

    private void repaintObjects() {
        if (this.allObjects == null) {
            return;
        }
        Rectangle rectangle = this.allObjects[0].getRepaintRect();
        int n = 1;
        while (n < this.allObjects.length) {
            rectangle = rectangle.union(this.allObjects[n].getRepaintRect());
            ++n;
        }
        this.invoker.repaint(rectangle.union(this.oldRect));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        if (this.allObjects == null || this.isUpdating) {
            return;
        }
        this.initRepaint();
        Object object = actionEvent.getSource();
        if (object == this.outLineCheckBox) {
            int n2 = 0;
            while (n2 < this.allObjects.length) {
                this.allObjects[n2].setOutLineVisible(this.outLineCheckBox.isSelected());
                ++n2;
            }
            this.invoker.setNeedToSave(true, "Change OutLine");
        } else if (object == this.minValueText) {
            try {
                double d = Double.parseDouble(this.minValueText.getText());
                int n3 = 0;
                while (n3 < this.allObjects.length) {
                    this.allObjects[n3].setMinimum(d);
                    ++n3;
                }
                this.invoker.setNeedToSave(true, "Change minimum bar value");
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Invalid syntax for min value");
            }
            this.refreshControls();
        } else if (object == this.maxValueText) {
            try {
                double d = Double.parseDouble(this.maxValueText.getText());
                int n4 = 0;
                while (n4 < this.allObjects.length) {
                    this.allObjects[n4].setMaximum(d);
                    ++n4;
                }
                this.invoker.setNeedToSave(true, "Change maximum bar value");
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Invalid syntax for max value");
            }
            this.refreshControls();
        } else if (object == this.valueText) {
            try {
                double d = Double.parseDouble(this.valueText.getText());
                int n5 = 0;
                while (n5 < this.allObjects.length) {
                    this.allObjects[n5].setBarValue(d);
                    ++n5;
                }
                this.invoker.setNeedToSave(true, "Change bar value");
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, "Invalid syntax for value");
            }
            this.refreshControls();
        } else if (object == this.applyValueBtn) {
            try {
                double d = Double.parseDouble(this.minValueText.getText());
                double d2 = Double.parseDouble(this.maxValueText.getText());
                double d3 = Double.parseDouble(this.valueText.getText());
                int n6 = 0;
                while (n6 < this.allObjects.length) {
                    this.allObjects[n6].setMinimum(d);
                    this.allObjects[n6].setMaximum(d2);
                    this.allObjects[n6].setBarValue(d3);
                    ++n6;
                }
                this.invoker.setNeedToSave(true, "Change bar value range");
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, "One or more value are incorrect");
            }
            this.refreshControls();
        } else if (object == this.orientationCombo && (n = this.orientationCombo.getSelectedIndex()) >= 0) {
            int n7 = 0;
            while (n7 < this.allObjects.length) {
                this.allObjects[n7].setOrientation(n);
                ++n7;
            }
            this.invoker.setNeedToSave(true, "Change bar orientation");
        }
        this.repaintObjects();
    }
}

