/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart;

import fr.esrf.tangoatk.widget.util.ATKGraphicsUtils;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.IJLChartActionListener;
import fr.esrf.tangoatk.widget.util.chart.IJLChartListener;
import fr.esrf.tangoatk.widget.util.chart.JLAxis;
import fr.esrf.tangoatk.widget.util.chart.JLChartActionEvent;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLChartOption;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import fr.esrf.tangoatk.widget.util.chart.JLDataViewOption;
import fr.esrf.tangoatk.widget.util.chart.JLTable;
import fr.esrf.tangoatk.widget.util.chart.LabelRect;
import fr.esrf.tangoatk.widget.util.chart.OFormat;
import fr.esrf.tangoatk.widget.util.chart.SearchInfo;
import fr.esrf.tangoatk.widget.util.chart.TabbedLine;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileWriter;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.EventListenerList;

public class JLChart
extends JComponent
implements MouseListener,
MouseMotionListener,
ActionListener {
    public static final int LABEL_DOWN = 0;
    public static final int LABEL_UP = 1;
    public static final int LABEL_RIGHT = 2;
    public static final int LABEL_LEFT = 3;
    private String header = null;
    private boolean headerVisible = false;
    private Font headerFont;
    private Color headerColor;
    private boolean labelVisible = true;
    private int labelMode = 0;
    private Font labelFont;
    private Vector labelRect;
    private boolean ipanelVisible = false;
    private boolean paintAxisFirst = true;
    private Color chartBackground;
    private double displayDuration;
    private JPopupMenu chartMenu;
    private JMenuItem optionMenuItem;
    private JMenuItem fileMenuItem;
    private JMenuItem zoomBackMenuItem;
    private JMenuItem printMenuItem;
    private JSeparator sepMenuItem;
    private JMenu tableMenu;
    private JMenuItem tableAllMenuItem;
    private JMenuItem[] tableSingleY1MenuItem = new JMenuItem[0];
    private JMenuItem[] tableSingleY2MenuItem = new JMenuItem[0];
    private JMenu dvMenu;
    private JMenuItem[] dvY1MenuItem = new JMenuItem[0];
    private JMenuItem[] dvY2MenuItem = new JMenuItem[0];
    private JMenuItem[] userActionMenuItem;
    private String[] userAction;
    private boolean zoomDrag;
    private boolean zoomDragAllowed;
    private int zoomX;
    private int zoomY;
    private JButton zoomButton;
    private int lastX;
    private int lastY;
    private SearchInfo lastSearch;
    private Rectangle headerR;
    private Rectangle labelR;
    private Rectangle viewR;
    private Dimension margin;
    private int labelSHeight;
    private int labelWidth;
    private int labelHeight;
    private int headerWidth;
    private int axisHeight;
    private int axisWidth;
    private int axisFontUp;
    private int axisFontDown;
    private int y1AxisThickness;
    private int y2AxisThickness;
    private JLAxis xAxis;
    private JLAxis y1Axis;
    private JLAxis y2Axis;
    private boolean xAxisOnBottom = true;
    private IJLChartListener listener;
    private JLTable theTable = null;
    static /* synthetic */ Class class$fr$esrf$tangoatk$widget$util$chart$IJLChartActionListener;

    public JLChart() {
        Color color = new Color(180, 180, 180);
        this.setBackground(color);
        this.setChartBackground(color);
        this.setForeground(Color.black);
        this.setOpaque(true);
        this.setFont(new Font("Dialog", 0, 12));
        this.headerFont = this.getFont();
        this.headerColor = this.getForeground();
        this.labelFont = this.getFont();
        this.margin = new Dimension(10, 10);
        this.headerR = new Rectangle(0, 0, 0, 0);
        this.viewR = new Rectangle(0, 0, 0, 0);
        this.labelR = new Rectangle(0, 0, 0, 0);
        this.xAxis = new JLAxis(this, 1);
        this.xAxis.setAnnotation(1);
        this.xAxis.setAutoScale(true);
        this.xAxis.setAxeName("(X)");
        this.y1Axis = new JLAxis(this, 6);
        this.y1Axis.setAxeName("(Y1)");
        this.y2Axis = new JLAxis(this, 5);
        this.y2Axis.setAxeName("(Y2)");
        this.displayDuration = Double.POSITIVE_INFINITY;
        this.labelRect = new Vector();
        this.zoomDrag = false;
        this.zoomDragAllowed = false;
        this.chartMenu = new JPopupMenu();
        this.optionMenuItem = new JMenuItem("Chart properties");
        this.optionMenuItem.addActionListener(this);
        this.fileMenuItem = new JMenuItem("Save data File");
        this.fileMenuItem.addActionListener(this);
        this.tableMenu = new JMenu("Show table");
        this.tableAllMenuItem = new JMenuItem("All");
        this.tableAllMenuItem.addActionListener(this);
        this.zoomBackMenuItem = new JMenuItem("Zoom back");
        this.zoomBackMenuItem.addActionListener(this);
        this.printMenuItem = new JMenuItem("Print graph");
        this.printMenuItem.addActionListener(this);
        this.dvMenu = new JMenu("Data View properties");
        this.chartMenu.add(this.zoomBackMenuItem);
        this.chartMenu.add(new JSeparator());
        this.chartMenu.add(this.optionMenuItem);
        this.chartMenu.add(this.dvMenu);
        this.chartMenu.add(this.tableMenu);
        this.chartMenu.add(new JSeparator());
        this.chartMenu.add(this.fileMenuItem);
        this.chartMenu.add(this.printMenuItem);
        this.sepMenuItem = new JSeparator();
        this.chartMenu.add(this.sepMenuItem);
        this.userActionMenuItem = new JMenuItem[0];
        this.userAction = new String[0];
        this.sepMenuItem.setVisible(false);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.listener = null;
        this.listenerList = new EventListenerList();
        this.zoomButton = new JButton("Zoom back");
        this.zoomButton.setFont(this.labelFont);
        this.zoomButton.setMargin(new Insets(2, 2, 1, 1));
        this.zoomButton.setVisible(false);
        this.zoomButton.addActionListener(this);
        this.add(this.zoomButton);
    }

    public JLAxis getXAxis() {
        return this.xAxis;
    }

    public JLAxis getY1Axis() {
        return this.y1Axis;
    }

    public JLAxis getY2Axis() {
        return this.y2Axis;
    }

    public void setXAxisOnBottom(boolean bl) {
        this.xAxisOnBottom = bl;
        this.getXAxis().setXAxisOnBottom(bl);
        this.getY1Axis().setXAxisOnBottom(bl);
        this.getY2Axis().setXAxisOnBottom(bl);
    }

    public boolean isXAxisOnBottom() {
        return this.xAxisOnBottom;
    }

    public void setHeaderFont(Font font) {
        this.headerFont = font;
    }

    public Font getHeaderFont() {
        return this.headerFont;
    }

    public void setMargin(Dimension dimension) {
        this.margin = dimension;
    }

    public Dimension getMargin() {
        return this.margin;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
    }

    public void setChartBackground(Color color) {
        this.chartBackground = color;
    }

    public Color getChartBackground() {
        return this.chartBackground;
    }

    public void setPaintAxisFirst(boolean bl) {
        this.paintAxisFirst = bl;
    }

    public boolean isPaintAxisFirst() {
        return this.paintAxisFirst;
    }

    public void setHeaderVisible(boolean bl) {
        this.headerVisible = bl;
    }

    public void setHeader(String string) {
        this.header = string;
        if (string != null && string.length() == 0) {
            this.header = null;
        }
        this.setHeaderVisible(this.header != null);
    }

    public String getHeader() {
        return this.header;
    }

    public void setDisplayDuration(double d) {
        this.displayDuration = d;
        this.getXAxis().setAxisDuration(d);
    }

    public double getDisplayDuration() {
        return this.displayDuration;
    }

    public void setHeaderColor(Color color) {
        this.headerColor = color;
        this.setHeaderVisible(true);
    }

    public void setLabelVisible(boolean bl) {
        this.labelVisible = bl;
    }

    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    public void setLabelPlacement(int n) {
        this.labelMode = n;
    }

    public int getLabelPlacement() {
        return this.labelMode;
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void showOptionDialog() {
        Container container = this.getRootPane().getParent();
        JLChartOption jLChartOption = container instanceof JDialog ? new JLChartOption((JDialog)container, this) : (container instanceof JFrame ? new JLChartOption((JFrame)container, this) : new JLChartOption((JFrame)null, this));
        ATKGraphicsUtils.centerDialog(jLChartOption);
        jLChartOption.setVisible(true);
    }

    public void showDataOptionDialog(JLDataView jLDataView) {
        Container container = this.getRootPane().getParent();
        JLDataViewOption jLDataViewOption = container instanceof JDialog ? new JLDataViewOption((JDialog)container, this, jLDataView) : (container instanceof JFrame ? new JLDataViewOption((JFrame)container, this, jLDataView) : new JLDataViewOption((JFrame)null, this, jLDataView));
        ATKGraphicsUtils.centerDialog(jLDataViewOption);
        jLDataViewOption.setVisible(true);
    }

    public boolean isZoomed() {
        return this.xAxis.isZoomed() || this.y1Axis.isZoomed() || this.y2Axis.isZoomed();
    }

    public void enterZoom() {
        if (!this.zoomDragAllowed) {
            this.zoomDragAllowed = true;
            this.setCursor(new Cursor(1));
        }
    }

    public void setJLChartListener(IJLChartListener iJLChartListener) {
        this.listener = iJLChartListener;
    }

    public void addUserAction(String string) {
        String[] stringArray = new String[this.userAction.length + 1];
        int n = 0;
        while (n < this.userAction.length) {
            stringArray[n] = this.userAction[n];
            ++n;
        }
        stringArray[n] = string;
        n = 0;
        while (n < this.userActionMenuItem.length) {
            this.chartMenu.remove(this.userActionMenuItem[n]);
            this.userActionMenuItem[n].removeActionListener(this);
            this.userActionMenuItem[n] = null;
            ++n;
        }
        JMenuItem[] jMenuItemArray = new JMenuItem[stringArray.length];
        n = 0;
        while (n < stringArray.length) {
            jMenuItemArray[n] = stringArray[n].startsWith("chk") ? new JCheckBoxMenuItem(stringArray[n].substring(3)) : new JMenuItem(stringArray[n]);
            jMenuItemArray[n].addActionListener(this);
            this.chartMenu.add(jMenuItemArray[n]);
            ++n;
        }
        this.userActionMenuItem = jMenuItemArray;
        this.userAction = stringArray;
        this.sepMenuItem.setVisible(true);
    }

    public void addJLChartActionListener(IJLChartActionListener iJLChartActionListener) {
        this.listenerList.add(class$fr$esrf$tangoatk$widget$util$chart$IJLChartActionListener == null ? (class$fr$esrf$tangoatk$widget$util$chart$IJLChartActionListener = JLChart.class$("fr.esrf.tangoatk.widget.util.chart.IJLChartActionListener")) : class$fr$esrf$tangoatk$widget$util$chart$IJLChartActionListener, iJLChartActionListener);
    }

    public void exitZoom() {
        this.xAxis.unzoom();
        this.y1Axis.unzoom();
        this.y2Axis.unzoom();
        this.zoomDragAllowed = false;
        this.setCursor(Cursor.getDefaultCursor());
        this.repaint();
    }

    public void removeJLChartActionListener(IJLChartActionListener iJLChartActionListener) {
        this.listenerList.remove(class$fr$esrf$tangoatk$widget$util$chart$IJLChartActionListener == null ? (class$fr$esrf$tangoatk$widget$util$chart$IJLChartActionListener = JLChart.class$("fr.esrf.tangoatk.widget.util.chart.IJLChartActionListener")) : class$fr$esrf$tangoatk$widget$util$chart$IJLChartActionListener, iJLChartActionListener);
    }

    public void applyConfiguration(CfFileReader cfFileReader) {
        Vector vector = cfFileReader.getParam("graph_title");
        if (vector != null) {
            this.setHeader(OFormat.getName(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("label_visible")) != null) {
            this.setLabelVisible(OFormat.getBoolean(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("label_placement")) != null) {
            this.setLabelPlacement(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam("label_font")) != null) {
            this.setLabelFont(OFormat.getFont(vector));
        }
        if ((vector = cfFileReader.getParam("graph_background")) != null) {
            this.setBackground(OFormat.getColor(vector));
        }
        if ((vector = cfFileReader.getParam("chart_background")) != null) {
            this.setChartBackground(OFormat.getColor(vector));
        }
        if ((vector = cfFileReader.getParam("title_font")) != null) {
            this.setHeaderFont(OFormat.getFont(vector));
        }
        if ((vector = cfFileReader.getParam("display_duration")) != null) {
            this.setDisplayDuration(OFormat.getDouble(vector.get(0).toString()));
        }
    }

    public String getConfiguration() {
        String string = "";
        string = string + "graph_title:'" + this.getHeader() + "'\n";
        string = string + "label_visible:" + this.isLabelVisible() + "\n";
        string = string + "label_placement:" + this.getLabelPlacement() + "\n";
        string = string + "label_font:" + OFormat.font(this.getLabelFont()) + "\n";
        string = string + "graph_background:" + OFormat.color(this.getBackground()) + "\n";
        string = string + "chart_background:" + OFormat.color(this.getChartBackground()) + "\n";
        string = string + "title_font:" + OFormat.font(this.getHeaderFont()) + "\n";
        string = string + "display_duration:" + this.getDisplayDuration() + "\n";
        return string;
    }

    public String getHelpString() {
        return "-- Global chart settings --\n\ngraph_title:'title'   Chart title ('null' to disable)\nlabel_visible:true or false  Show legend\nlabel_placement:value   (0 Down,1 Up,2 Right, 3 Left)\nlabel_font:name,style(0 Plain,1 Bold,2 italic),size \ngraph_background:r,g,b   Component background \nchart_background:r,g,b   Graph area background \ntitle_font:name,style(0 Plain,1 Bold,2 italic),size\ndisplay_duration:milliSec   X axis duration (time monitoring)\n\n-- Axis settings --\n  Parameter name is preceded by the axis name.\n\ngrid:true or false   Displays the grid\nsubgrid:true or false   Displays the sub grid\ngrid_style:style   (0 Solid,1 Dot, 2 Dash, 3 Long Dash)\nmin:value Axis minimum\nmax:value Axis maximum\nautoscale:true or false Axis autoscale\nscale:s   Axis scale (0 Linear ,1 Log)\nformat:format   Axis format (0 Auto,1 Sci,2 Time,3 Dec,4 Hex,5 Bin))\ntitle:'title'   Axis title ('null' to disable)\ncolor:r,g,b   Axis color\nlabel_font:name,style(0 Plain,1 Bold,2 italic),size\n\n-- Dataview settings --\n  Parameter name is preceded by the dataview name.\n\nlinecolor:r,g,b  Curve color\nlinewidth:width  Curve width\nlinestyle:style  Line style (0 Solid,1 Dot, 2 Dash, 3 Long Dash,...)\nfillcolor:r,g,b  Curve fill color\nfillmethod:m   Bar filling method (0 Top,1 Zero,2 Bottom)\nfillstyle:style  Curve filling style (0 No fill,1 Solid,...)\nviewtype:type   Type of plot (0 Line, 1 Bar)\nbarwidth:width   Bar width in pixel (0 autoscale)\nmarkercolor:r,g,b   Marker color\nmarkersize:size   Marker size\nmarkerstyle:style  Marker style (0 No marker,1 Dot,2 Box,...)\nA0,A1,A2:value   Vertical transfrom Y = A0 + A1*y + A2*y*y\nA0,A1,A2:value   Vertical transfrom Y = A0 + A1*y + A2*y*y\nlabelvisible:true or false   Displays legend of this view\nclickable:true or false  Shows tooltip on mouse click\n";
    }

    public void unselectAll() {
        this.getY1Axis().clearDataView();
        this.getY2Axis().clearDataView();
        this.getXAxis().clearDataView();
    }

    public void printGraph() {
        ATKGraphicsUtils.printComponent(this, "Print Graph", true, 0);
    }

    private void fireActionPerfromed(String string, boolean bl) {
        IJLChartActionListener[] iJLChartActionListenerArray = (IJLChartActionListener[])this.listenerList.getListeners(class$fr$esrf$tangoatk$widget$util$chart$IJLChartActionListener == null ? (class$fr$esrf$tangoatk$widget$util$chart$IJLChartActionListener = JLChart.class$("fr.esrf.tangoatk.widget.util.chart.IJLChartActionListener")) : class$fr$esrf$tangoatk$widget$util$chart$IJLChartActionListener);
        JLChartActionEvent jLChartActionEvent = new JLChartActionEvent(this, string, bl);
        int n = 0;
        while (n < iJLChartActionListenerArray.length) {
            iJLChartActionListenerArray[n].actionPerformed(jLChartActionEvent);
            ++n;
        }
    }

    private boolean fireGetActionState(String string) {
        IJLChartActionListener[] iJLChartActionListenerArray = (IJLChartActionListener[])this.listenerList.getListeners(class$fr$esrf$tangoatk$widget$util$chart$IJLChartActionListener == null ? (class$fr$esrf$tangoatk$widget$util$chart$IJLChartActionListener = JLChart.class$("fr.esrf.tangoatk.widget.util.chart.IJLChartActionListener")) : class$fr$esrf$tangoatk$widget$util$chart$IJLChartActionListener);
        JLChartActionEvent jLChartActionEvent = new JLChartActionEvent(this, string);
        boolean bl = true;
        int n = 0;
        while (n < iJLChartActionListenerArray.length) {
            bl = iJLChartActionListenerArray[n].getActionState(jLChartActionEvent) && bl;
            ++n;
        }
        return bl;
    }

    private void saveDataFile(String string) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            Vector vector = new Vector();
            if (this.xAxis.isXY()) {
                vector.addAll(this.xAxis.getViews());
            }
            vector.addAll(this.y1Axis.getViews());
            vector.addAll(this.y2Axis.getViews());
            TabbedLine tabbedLine = new TabbedLine(vector.size());
            int n = 0;
            while (n < vector.size()) {
                tabbedLine.add(n, (JLDataView)vector.get(n));
                ++n;
            }
            String string2 = tabbedLine.getFirstLine(this.xAxis.getAnnotation());
            while (string2 != null) {
                fileWriter.write(string2);
                string2 = tabbedLine.getNextLine();
            }
            fileWriter.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Error during saving file.\n" + exception.getMessage());
        }
    }

    private void showTableSingle(JLDataView jLDataView) {
        TabbedLine tabbedLine = new TabbedLine(1);
        tabbedLine.add(0, jLDataView);
        if (this.theTable == null) {
            this.theTable = new JLTable();
        }
        Vector<String[]> vector = new Vector<String[]>();
        String[] stringArray = tabbedLine.getFirstFields(this.xAxis.getAnnotation(), !this.xAxis.isXY());
        String[] stringArray2 = tabbedLine.getNextFields();
        while (stringArray2 != null) {
            vector.add(stringArray2);
            stringArray2 = tabbedLine.getNextFields();
        }
        int n = vector.size();
        int n2 = stringArray.length;
        Object[][] objectArray = new Object[n][n2];
        int n3 = 0;
        while (n3 < n) {
            Object[] objectArray2 = (Object[])vector.get(n3);
            int n4 = 0;
            while (n4 < n2) {
                objectArray[n3][n4] = objectArray2[n4];
                ++n4;
            }
            ++n3;
        }
        this.theTable.setData(objectArray, stringArray);
        if (!this.theTable.isVisible()) {
            this.theTable.centerWindow();
        }
        this.theTable.setVisible(true);
    }

    private void showTableAll() {
        Vector vector = new Vector();
        if (this.xAxis.isXY()) {
            vector.addAll(this.xAxis.getViews());
        }
        vector.addAll(this.y1Axis.getViews());
        vector.addAll(this.y2Axis.getViews());
        TabbedLine tabbedLine = new TabbedLine(vector.size());
        int n = 0;
        while (n < vector.size()) {
            tabbedLine.add(n, (JLDataView)vector.get(n));
            ++n;
        }
        if (this.theTable == null) {
            this.theTable = new JLTable();
        }
        Vector<String[]> vector2 = new Vector<String[]>();
        String[] stringArray = tabbedLine.getFirstFields(this.xAxis.getAnnotation(), !this.xAxis.isXY());
        String[] stringArray2 = tabbedLine.getNextFields();
        while (stringArray2 != null) {
            vector2.add(stringArray2);
            stringArray2 = tabbedLine.getNextFields();
        }
        int n2 = vector2.size();
        int n3 = stringArray.length;
        Object[][] objectArray = new Object[n2][n3];
        int n4 = 0;
        while (n4 < n2) {
            Object[] objectArray2 = (Object[])vector2.get(n4);
            int n5 = 0;
            while (n5 < n3) {
                objectArray[n4][n5] = objectArray2[n5];
                ++n5;
            }
            ++n4;
        }
        this.theTable.setData(objectArray, stringArray);
        if (!this.theTable.isVisible()) {
            this.theTable.centerWindow();
        }
        this.theTable.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.optionMenuItem) {
            this.showOptionDialog();
        } else if (object == this.zoomBackMenuItem || object == this.zoomButton) {
            this.exitZoom();
        } else if (object == this.printMenuItem) {
            this.printGraph();
        } else if (object == this.tableAllMenuItem) {
            this.showTableAll();
        } else if (object == this.fileMenuItem) {
            File file;
            int n = 0;
            JFileChooser jFileChooser = new JFileChooser(".");
            jFileChooser.setDialogTitle("Save Graph Data (Text file with TAB separated fields)");
            int n2 = jFileChooser.showSaveDialog(this);
            if (n2 == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                if (file.exists()) {
                    n = JOptionPane.showConfirmDialog(this, "Do you want to overwrite " + file.getName() + " ?", "Confirm overwrite", 0);
                }
                if (n == 0) {
                    this.saveDataFile(file.getAbsolutePath());
                }
            }
        } else {
            boolean bl = false;
            int n = 0;
            while (n < this.userActionMenuItem.length && !bl) {
                boolean bl2 = bl = this.userActionMenuItem[n] == actionEvent.getSource();
                if (bl) continue;
                ++n;
            }
            if (bl) {
                if (this.userActionMenuItem[n] instanceof JCheckBoxMenuItem) {
                    JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)this.userActionMenuItem[n];
                    this.fireActionPerfromed(jCheckBoxMenuItem.getText(), jCheckBoxMenuItem.getState());
                } else {
                    this.fireActionPerfromed(this.userActionMenuItem[n].getText(), false);
                }
                return;
            }
            n = 0;
            while (n < this.dvY1MenuItem.length && !bl) {
                boolean bl3 = bl = this.dvY1MenuItem[n] == actionEvent.getSource();
                if (bl) continue;
                ++n;
            }
            if (bl) {
                this.showDataOptionDialog(this.y1Axis.getDataView(n));
                return;
            }
            n = 0;
            while (n < this.dvY2MenuItem.length && !bl) {
                boolean bl4 = bl = this.dvY2MenuItem[n] == actionEvent.getSource();
                if (bl) continue;
                ++n;
            }
            if (bl) {
                this.showDataOptionDialog(this.y2Axis.getDataView(n));
                return;
            }
            n = 0;
            while (n < this.tableSingleY1MenuItem.length && !bl) {
                boolean bl5 = bl = this.tableSingleY1MenuItem[n] == actionEvent.getSource();
                if (bl) continue;
                ++n;
            }
            if (bl) {
                this.showTableSingle(this.y1Axis.getDataView(n));
                return;
            }
            n = 0;
            while (n < this.tableSingleY2MenuItem.length && !bl) {
                boolean bl6 = bl = this.tableSingleY2MenuItem[n] == actionEvent.getSource();
                if (bl) continue;
                ++n;
            }
            if (bl) {
                this.showTableSingle(this.y2Axis.getDataView(n));
                return;
            }
        }
    }

    private void paintLabelAndHeader(Graphics2D graphics2D) {
        int n;
        int n2 = this.y1Axis.getViews().size();
        int n3 = this.y2Axis.getViews().size();
        if (this.headerR.width > 0) {
            graphics2D.setFont(this.headerFont);
            n = (this.headerR.width - this.headerWidth) / 2;
            graphics2D.setColor(this.headerColor);
            graphics2D.drawString(this.header, n, this.headerR.y + graphics2D.getFontMetrics(this.headerFont).getAscent() - 2);
        }
        this.labelRect.clear();
        if (this.labelR.width > 0) {
            int n4;
            JLDataView jLDataView;
            graphics2D.setFont(this.labelFont);
            int n5 = graphics2D.getFontMetrics(this.labelFont).getAscent();
            int n6 = 0;
            n = this.labelR.x + (this.labelR.width - this.labelWidth) / 2 + 2;
            int n7 = this.labelR.y + (this.labelR.height - this.labelHeight) / 2 + 2;
            int n8 = 0;
            while (n8 < n2) {
                jLDataView = (JLDataView)this.y1Axis.getViews().get(n8);
                if (jLDataView.isLabelVisible()) {
                    graphics2D.setColor(jLDataView.getColor());
                    n4 = n7 + this.labelSHeight * n6 + this.labelSHeight / 2;
                    JLAxis.drawSampleLine(graphics2D, n, n4 - 2, jLDataView);
                    graphics2D.setColor(Color.BLACK);
                    graphics2D.drawString(jLDataView.getExtendedName() + " " + this.y1Axis.getAxeName(), n + 44, n4 + this.labelSHeight - n5);
                    this.labelRect.add(new LabelRect(n, n4 - n5, this.labelWidth + 44, this.labelSHeight, jLDataView));
                    ++n6;
                }
                ++n8;
            }
            n8 = 0;
            while (n8 < n3) {
                jLDataView = (JLDataView)this.y2Axis.getViews().get(n8);
                if (jLDataView.isLabelVisible()) {
                    graphics2D.setColor(jLDataView.getColor());
                    n4 = n7 + this.labelSHeight * n6 + this.labelSHeight / 2;
                    JLAxis.drawSampleLine(graphics2D, n, n4 - 2, jLDataView);
                    graphics2D.setColor(Color.BLACK);
                    graphics2D.drawString(jLDataView.getExtendedName() + " " + this.y2Axis.getAxeName(), n + 44, n4 + this.labelSHeight - n5);
                    this.labelRect.add(new LabelRect(n, n4 - n5, this.labelWidth + 44, this.labelSHeight, jLDataView));
                    ++n6;
                }
                ++n8;
            }
        }
    }

    private void measureGraphItems(Graphics2D graphics2D, FontRenderContext fontRenderContext, int n, int n2, Vector vector) {
        Rectangle2D rectangle2D = null;
        int n3 = this.margin.width;
        int n4 = this.margin.height;
        this.headerR.setBounds(0, 0, 0, 0);
        this.viewR.setBounds(0, 0, 0, 0);
        this.labelR.setBounds(0, 0, 0, 0);
        this.labelWidth = 0;
        this.labelHeight = 0;
        this.headerWidth = 0;
        this.axisWidth = 0;
        this.axisHeight = 0;
        this.axisFontUp = 0;
        this.axisFontDown = 0;
        this.y1AxisThickness = 0;
        this.y2AxisThickness = 0;
        if (this.headerVisible && this.header != null && this.headerFont != null) {
            rectangle2D = this.headerFont.getStringBounds(this.header, fontRenderContext);
            this.headerWidth = (int)rectangle2D.getWidth();
            this.headerR.setBounds(n3, n4, n - 2 * n3, (int)rectangle2D.getHeight());
        }
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.y1Axis.getViews().size()) {
            if (((JLDataView)this.y1Axis.getViews().get(n6)).isLabelVisible()) {
                ++n5;
            }
            ++n6;
        }
        n6 = 0;
        while (n6 < this.y2Axis.getViews().size()) {
            if (((JLDataView)this.y2Axis.getViews().get(n6)).isLabelVisible()) {
                ++n5;
            }
            ++n6;
        }
        if (this.labelVisible && n5 > 0 && this.labelFont != null) {
            JLDataView jLDataView;
            n6 = 0;
            double d = 0.0;
            n6 = 0;
            while (n6 < this.y1Axis.getViews().size()) {
                jLDataView = (JLDataView)this.y1Axis.getViews().get(n6);
                if (jLDataView.isLabelVisible() && (rectangle2D = this.labelFont.getStringBounds(jLDataView.getExtendedName() + " " + this.y1Axis.getAxeName(), fontRenderContext)).getWidth() > d) {
                    d = rectangle2D.getWidth();
                }
                ++n6;
            }
            n6 = 0;
            while (n6 < this.y2Axis.getViews().size()) {
                jLDataView = (JLDataView)this.y2Axis.getViews().get(n6);
                if (jLDataView.isLabelVisible() && (rectangle2D = this.labelFont.getStringBounds(jLDataView.getExtendedName() + " " + this.y2Axis.getAxeName(), fontRenderContext)).getWidth() > d) {
                    d = rectangle2D.getWidth();
                }
                ++n6;
            }
            this.labelSHeight = (int)rectangle2D.getHeight() + 2;
            this.labelHeight = this.labelSHeight * n5;
            this.labelWidth = (int)(d + 45.0);
            switch (this.labelMode) {
                case 1: {
                    this.labelR.setBounds(n3, n4 + this.headerR.height, n - 2 * n3, this.labelHeight);
                    break;
                }
                case 0: {
                    this.labelR.setBounds(n3, n2 - n4 - this.labelHeight, n - 2 * n3, this.labelHeight);
                    break;
                }
                case 2: {
                    this.labelR.setBounds(n - n3 - this.labelWidth, n4 + this.headerR.height, this.labelWidth, n2 - 2 * n4 - this.headerR.height);
                    break;
                }
                case 3: {
                    this.labelR.setBounds(n3, n4 + this.headerR.height, this.labelWidth, n2 - 2 * n4 - this.headerR.height);
                }
            }
        }
        switch (this.labelMode) {
            case 1: {
                this.viewR.setBounds(n3, n4 + this.headerR.height + this.labelR.height, n - 2 * n3, n2 - 2 * n4 - this.headerR.height - this.labelR.height);
                break;
            }
            case 0: {
                this.viewR.setBounds(n3, n4 + this.headerR.height, n - 2 * n3, n2 - 2 * n4 - this.headerR.height - this.labelR.height);
                break;
            }
            case 2: {
                this.viewR.setBounds(n3, n4 + this.headerR.height, n - 2 * n3 - this.labelR.width, n2 - 2 * n4 - this.headerR.height);
                break;
            }
            case 3: {
                this.viewR.setBounds(n3 + this.labelR.width, n4 + this.headerR.height, n - 2 * n3 - this.labelR.width, n2 - 2 * n4 - this.headerR.height);
            }
        }
        this.xAxis.computeXScale(vector);
        if (this.y1Axis.isVisible() && this.y1Axis.getViews().size() > 0) {
            this.axisFontUp = this.y1Axis.getFontHeight(graphics2D);
        } else if (this.y2Axis.isVisible() && this.y2Axis.getViews().size() > 0) {
            this.axisFontUp = this.y2Axis.getFontHeight(graphics2D);
        }
        this.axisFontDown = this.xAxis.getFontHeight(graphics2D);
        this.axisHeight = this.viewR.height - (this.axisFontUp + this.axisFontDown);
        this.y1Axis.measureAxis(graphics2D, fontRenderContext, 0, this.axisHeight);
        this.y2Axis.measureAxis(graphics2D, fontRenderContext, 0, this.axisHeight);
        this.y1AxisThickness = this.y1Axis.getThickness();
        this.y2AxisThickness = this.y2Axis.getThickness();
        this.axisWidth = this.viewR.width - (this.y1AxisThickness + this.y2AxisThickness);
        this.xAxis.measureAxis(graphics2D, fontRenderContext, this.axisWidth, 0);
    }

    private void paintZoomButton(int n, int n2) {
        if (this.isZoomed()) {
            int n3 = this.zoomButton.getPreferredSize().width;
            int n4 = this.zoomButton.getPreferredSize().height;
            this.zoomButton.setBounds(n + 7, n2 + 5, n3, n4);
            this.zoomButton.setVisible(n3 < this.axisWidth - 7 && n4 < this.axisHeight - 5);
        } else {
            this.zoomButton.setVisible(false);
        }
    }

    private void paintZoomSelection(Graphics graphics) {
        if (this.zoomDrag) {
            graphics.setColor(Color.black);
            Rectangle rectangle = this.buildRect(this.zoomX, this.zoomY, this.lastX, this.lastY);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        Vector vector = new Vector(this.y1Axis.getViews());
        vector.addAll(this.y2Axis.getViews());
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        graphics.setPaintMode();
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n, n2);
        }
        this.measureGraphItems(graphics2D, fontRenderContext, n, n2, vector);
        this.paintLabelAndHeader(graphics2D);
        int n3 = this.viewR.x + this.y1AxisThickness;
        int n4 = this.isXAxisOnBottom() || this.getY1Axis().getScale() == 1 ? this.viewR.y + this.axisFontUp + this.axisHeight : (int)this.getY1Axis().transform(0.0, 0.0, this.getXAxis()).getY();
        int n5 = this.viewR.x;
        int n6 = this.viewR.x + this.y1AxisThickness + this.axisWidth;
        int n7 = this.viewR.y + this.axisFontUp;
        if (!this.chartBackground.equals(this.getBackground()) && this.axisWidth > 0 && this.axisHeight > 0) {
            graphics.setColor(this.chartBackground);
            graphics.fillRect(n3, n4 - this.axisHeight, this.axisWidth, this.axisHeight);
        }
        this.paintZoomSelection(graphics);
        this.paintZoomButton(n3, n7);
        if (this.paintAxisFirst) {
            this.y1Axis.paintAxis(graphics, fontRenderContext, n5, n7, this.xAxis, n3, n4, this.getBackground(), !this.y2Axis.isVisible() || this.y2Axis.getViewNumber() == 0);
            this.y2Axis.paintAxis(graphics, fontRenderContext, n6, n7, this.xAxis, n3, n4, this.getBackground(), !this.y1Axis.isVisible() || this.y1Axis.getViewNumber() == 0);
            if (this.xAxis.getPosition() == 4) {
                this.xAxis.paintAxis(graphics, fontRenderContext, n3, n4, this.y2Axis, 0, 0, this.getBackground(), true);
            } else {
                this.xAxis.paintAxis(graphics, fontRenderContext, n3, n4, this.y1Axis, 0, 0, this.getBackground(), true);
            }
            this.y1Axis.paintDataViews(graphics, this.xAxis, n3, n4);
            this.y2Axis.paintDataViews(graphics, this.xAxis, n3, n4);
        } else {
            this.y1Axis.paintDataViews(graphics, this.xAxis, n3, n4);
            this.y2Axis.paintDataViews(graphics, this.xAxis, n3, n4);
            this.y1Axis.paintAxis(graphics, fontRenderContext, n5, n7, this.xAxis, n3, n4, this.getBackground(), !this.y2Axis.isVisible() || this.y2Axis.getViewNumber() == 0);
            this.y2Axis.paintAxis(graphics, fontRenderContext, n6, n7, this.xAxis, n3, n4, this.getBackground(), !this.y1Axis.isVisible() || this.y1Axis.getViewNumber() == 0);
            if (this.xAxis.getPosition() == 4) {
                this.xAxis.paintAxis(graphics, fontRenderContext, n3, n4, this.y2Axis, 0, 0, this.getBackground(), true);
            } else {
                this.xAxis.paintAxis(graphics, fontRenderContext, n3, n4, this.y1Axis, 0, 0, this.getBackground(), true);
            }
        }
        this.redrawPanel(graphics);
        this.paintComponents(graphics);
        this.paintBorder(graphics);
    }

    private Rectangle buildRect(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle();
        if (n < n3) {
            if (n2 < n4) {
                rectangle.setRect(n, n2, n3 - n, n4 - n2);
            } else {
                rectangle.setRect(n, n4, n3 - n, n2 - n4);
            }
        } else if (n2 < n4) {
            rectangle.setRect(n3, n2, n - n3, n4 - n2);
        } else {
            rectangle.setRect(n3, n4, n - n3, n2 - n4);
        }
        return rectangle;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.zoomDrag) {
            Rectangle rectangle = this.buildRect(this.zoomX, this.zoomY, this.lastX, this.lastY);
            ++rectangle.width;
            ++rectangle.height;
            this.repaint(rectangle);
            this.lastX = mouseEvent.getX();
            this.lastY = mouseEvent.getY();
            rectangle = this.buildRect(this.zoomX, this.zoomY, this.lastX, this.lastY);
            ++rectangle.width;
            ++rectangle.height;
            this.repaint(rectangle);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.zoomDrag) {
            Rectangle rectangle = this.buildRect(this.zoomX, this.zoomY, mouseEvent.getX(), mouseEvent.getY());
            this.zoomDrag = false;
            this.xAxis.zoom(rectangle.x, rectangle.x + rectangle.width);
            this.y1Axis.zoom(rectangle.y, rectangle.y + rectangle.height);
            this.y2Axis.zoom(rectangle.y, rectangle.y + rectangle.height);
        }
        this.ipanelVisible = false;
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Object object;
        if (mouseEvent.getButton() == 1) {
            if (mouseEvent.isControlDown() || this.zoomDragAllowed) {
                this.zoomDrag = true;
                this.zoomX = mouseEvent.getX();
                this.zoomY = mouseEvent.getY();
                this.lastX = mouseEvent.getX();
                this.lastY = mouseEvent.getY();
                return;
            }
            object = null;
            object = this.y1Axis.searchNearest(mouseEvent.getX(), mouseEvent.getY(), this.xAxis);
            SearchInfo searchInfo = this.y2Axis.searchNearest(mouseEvent.getX(), mouseEvent.getY(), this.xAxis);
            if (searchInfo.found && searchInfo.dist < ((SearchInfo)object).dist) {
                object = searchInfo;
            }
            if (((SearchInfo)object).found) {
                Graphics graphics = this.getGraphics();
                this.showPanel(graphics, (SearchInfo)object);
                graphics.dispose();
                return;
            }
            int n = 0;
            boolean bl = false;
            while (n < this.labelRect.size() && !bl) {
                LabelRect labelRect = (LabelRect)this.labelRect.get(n);
                bl = labelRect.rect.contains(mouseEvent.getX(), mouseEvent.getY());
                if (bl) {
                    this.showDataOptionDialog(labelRect.view);
                }
                ++n;
            }
        }
        if (mouseEvent.getButton() == 3) {
            this.zoomBackMenuItem.setEnabled(this.isZoomed());
            int n = 0;
            while (n < this.userActionMenuItem.length) {
                if (this.userActionMenuItem[n] instanceof JCheckBoxMenuItem) {
                    object = (JCheckBoxMenuItem)this.userActionMenuItem[n];
                    ((AbstractButton)object).setSelected(this.fireGetActionState(((AbstractButton)object).getText()));
                }
                ++n;
            }
            this.tableMenu.removeAll();
            this.tableMenu.add(this.tableAllMenuItem);
            if (this.y1Axis.getViewNumber() > 0) {
                this.tableMenu.add(new JSeparator());
            }
            n = 0;
            while (n < this.tableSingleY1MenuItem.length) {
                this.tableSingleY1MenuItem[n].removeActionListener(this);
                ++n;
            }
            this.tableSingleY1MenuItem = new JMenuItem[this.y1Axis.getViewNumber()];
            n = 0;
            while (n < this.y1Axis.getViewNumber()) {
                this.tableSingleY1MenuItem[n] = new JMenuItem(this.y1Axis.getDataView(n).getName());
                this.tableSingleY1MenuItem[n].addActionListener(this);
                this.tableMenu.add(this.tableSingleY1MenuItem[n]);
                ++n;
            }
            if (this.y1Axis.getViewNumber() > 0 && this.y2Axis.getViewNumber() > 0) {
                this.tableMenu.add(new JSeparator());
            }
            n = 0;
            while (n < this.tableSingleY2MenuItem.length) {
                this.tableSingleY2MenuItem[n].removeActionListener(this);
                ++n;
            }
            this.tableSingleY2MenuItem = new JMenuItem[this.y2Axis.getViewNumber()];
            n = 0;
            while (n < this.y2Axis.getViewNumber()) {
                this.tableSingleY2MenuItem[n] = new JMenuItem(this.y2Axis.getDataView(n).getName());
                this.tableSingleY2MenuItem[n].addActionListener(this);
                this.tableMenu.add(this.tableSingleY2MenuItem[n]);
                ++n;
            }
            this.dvMenu.removeAll();
            n = 0;
            while (n < this.dvY1MenuItem.length) {
                this.dvY1MenuItem[n].removeActionListener(this);
                ++n;
            }
            n = 0;
            while (n < this.dvY2MenuItem.length) {
                this.dvY2MenuItem[n].removeActionListener(this);
                ++n;
            }
            this.dvY1MenuItem = new JMenuItem[this.y1Axis.getViewNumber()];
            this.dvY2MenuItem = new JMenuItem[this.y2Axis.getViewNumber()];
            n = 0;
            while (n < this.y1Axis.getViewNumber()) {
                this.dvY1MenuItem[n] = new JMenuItem(this.y1Axis.getDataView(n).getName());
                this.dvY1MenuItem[n].addActionListener(this);
                this.dvMenu.add(this.dvY1MenuItem[n]);
                ++n;
            }
            n = 0;
            while (n < this.y2Axis.getViewNumber()) {
                this.dvY2MenuItem[n] = new JMenuItem(this.y2Axis.getDataView(n).getName());
                this.dvY2MenuItem[n].addActionListener(this);
                this.dvMenu.add(this.dvY2MenuItem[n]);
                ++n;
            }
            this.chartMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void redrawPanel(Graphics graphics) {
        if (!this.ipanelVisible) {
            return;
        }
        JLDataView jLDataView = this.lastSearch.dataView;
        JLDataView jLDataView2 = this.lastSearch.xdataView;
        DataList dataList = this.lastSearch.value;
        DataList dataList2 = this.lastSearch.xvalue;
        JLAxis jLAxis = this.lastSearch.axis;
        Point point = this.xAxis.isXY() ? jLAxis.transform(jLDataView2.getTransformedValue(dataList2.y), jLDataView.getTransformedValue(dataList.y), this.xAxis) : jLAxis.transform(dataList.x, jLDataView.getTransformedValue(dataList.y), this.xAxis);
        this.lastSearch.x = point.x;
        this.lastSearch.y = point.y;
        this.showPanel(graphics, this.lastSearch);
    }

    private String[] buildPanelString(SearchInfo searchInfo) {
        String[] stringArray = null;
        stringArray = this.xAxis.isXY() ? new String[]{searchInfo.dataView.getExtendedName() + " " + searchInfo.axis.getAxeName(), "Time= " + JLAxis.formatTimeValue(searchInfo.value.x), "X= " + searchInfo.xdataView.formatValue(searchInfo.xdataView.getTransformedValue(searchInfo.xvalue.y)), "Y= " + searchInfo.dataView.formatValue(searchInfo.dataView.getTransformedValue(searchInfo.value.y)) + " " + searchInfo.dataView.getUnit()} : new String[]{searchInfo.dataView.getExtendedName() + " " + searchInfo.axis.getAxeName(), "Time= " + JLAxis.formatTimeValue(searchInfo.value.x), "Y= " + searchInfo.dataView.formatValue(searchInfo.dataView.getTransformedValue(searchInfo.value.y)) + " " + searchInfo.dataView.getUnit()};
        return stringArray;
    }

    public void showPanel(Graphics graphics, SearchInfo searchInfo) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        String[] stringArray = null;
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        graphics.setPaintMode();
        graphics.setFont(this.labelFont);
        if (this.listener != null) {
            JLChartEvent jLChartEvent = new JLChartEvent(this, searchInfo);
            stringArray = this.listener.clickOnChart(jLChartEvent);
        }
        if (stringArray == null) {
            stringArray = this.buildPanelString(searchInfo);
        }
        if (stringArray.length <= 0) {
            return;
        }
        Rectangle2D rectangle2D = graphics.getFont().getStringBounds(stringArray[0], fontRenderContext);
        n3 = (int)rectangle2D.getWidth();
        n2 = n = (int)rectangle2D.getHeight();
        int n6 = 1;
        while (n6 < stringArray.length) {
            rectangle2D = graphics.getFont().getStringBounds(stringArray[n6], fontRenderContext);
            if ((int)rectangle2D.getWidth() > n3) {
                n3 = (int)rectangle2D.getWidth();
            }
            n = (int)((double)n + rectangle2D.getHeight());
            ++n6;
        }
        n3 += 10;
        n += 10;
        graphics.setColor(Color.black);
        switch (searchInfo.placement) {
            case 3: {
                n4 = searchInfo.x + 10;
                n5 = searchInfo.y + 10;
                graphics.drawLine(searchInfo.x, searchInfo.y, searchInfo.x + 10, searchInfo.y + 10);
                break;
            }
            case 2: {
                n4 = searchInfo.x - 10 - n3;
                n5 = searchInfo.y + 10;
                graphics.drawLine(searchInfo.x, searchInfo.y, searchInfo.x - 10, searchInfo.y + 10);
                break;
            }
            case 1: {
                n4 = searchInfo.x + 10;
                n5 = searchInfo.y - 10 - n;
                graphics.drawLine(searchInfo.x, searchInfo.y, searchInfo.x + 10, searchInfo.y - 10);
                break;
            }
            case 0: {
                n4 = searchInfo.x - 10 - n3;
                n5 = searchInfo.y - 10 - n;
                graphics.drawLine(searchInfo.x, searchInfo.y, searchInfo.x - 10, searchInfo.y - 10);
            }
        }
        graphics.setColor(Color.white);
        graphics.fillRect(n4, n5, n3, n);
        graphics.setColor(Color.black);
        graphics.drawRect(n4, n5, n3, n);
        graphics.setColor(Color.black);
        int n7 = 0;
        while (n7 < stringArray.length) {
            graphics.drawString(stringArray[n7], n4 + 3, n5 + 3 + (n7 + 1) * n2);
            ++n7;
        }
        this.lastSearch = searchInfo;
        this.ipanelVisible = true;
    }

    public int garbageData(JLDataView jLDataView) {
        int n = 0;
        if (this.displayDuration != Double.POSITIVE_INFINITY) {
            n = jLDataView.garbagePointTime(this.displayDuration);
        }
        return n;
    }

    public void addData(JLDataView jLDataView, double d, double d2) {
        DataList dataList = null;
        boolean bl = false;
        if (jLDataView.getDataLength() > 0) {
            dataList = jLDataView.getLastValue();
        }
        jLDataView.add(d, d2);
        int n = this.garbageData(jLDataView);
        if (n > 0 && jLDataView.getAxis() != null) {
            bl = true;
        }
        if (this.zoomDrag) {
            return;
        }
        if (this.xAxis.isXY()) {
            this.repaint();
            return;
        }
        JLAxis jLAxis = jLDataView.getAxis();
        if (jLAxis != null) {
            Point point = null;
            Point point2 = jLAxis.transform(d, jLDataView.getTransformedValue(d2), this.xAxis);
            if (dataList != null) {
                point = jLAxis.transform(dataList.x, jLDataView.getTransformedValue(dataList.y), this.xAxis);
            }
            if (jLAxis.getBoundRect().contains(point2) && !bl) {
                jLAxis.drawFast(this.getGraphics(), point, point2, jLDataView);
            } else {
                this.repaint();
            }
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        final JLChart jLChart = new JLChart();
        JLDataView jLDataView = new JLDataView();
        JLDataView jLDataView2 = new JLDataView();
        double d = System.currentTimeMillis() / 1000L * 1000L;
        jLChart.setHeaderFont(new Font("Times", 1, 18));
        jLChart.setLabelFont(new Font("Times", 1, 12));
        jLChart.setHeader("Test DataView");
        jLChart.getY1Axis().setName("mA");
        jLChart.getY1Axis().setAutoScale(true);
        jLChart.getY2Axis().setName("unit");
        jLChart.getXAxis().setAutoScale(true);
        jLChart.getXAxis().setName("Value");
        jLChart.getXAxis().setGridVisible(true);
        jLChart.getXAxis().setSubGridVisible(true);
        jLChart.getXAxis().setAnnotation(2);
        jLChart.getY1Axis().setGridVisible(true);
        jLChart.getY1Axis().setSubGridVisible(true);
        jLChart.getY2Axis().setVisible(false);
        jLDataView.add(-6.0, -10.0);
        jLDataView.add(-5.0, -15.0);
        jLDataView.add(-4.0, 17.0);
        jLDataView.add(-3.0, 21.0);
        jLDataView.add(-2.0, 22.0);
        jLDataView.add(-1.0, 24.0);
        jLDataView.add(0.0, 98.0);
        jLDataView.add(1.0, Double.NaN);
        jLDataView.add(2.0, 21.0);
        jLDataView.add(3.0, 99.0);
        jLDataView.add(4.0, 50.0);
        jLDataView.add(5.0, 40.0);
        jLDataView.add(6.0, 30.0);
        jLDataView.add(7.0, 20.0);
        jLDataView.setMarker(9);
        jLDataView.setStyle(2);
        jLDataView.setName("Le signal 1");
        jLDataView.setUnit("std");
        jLDataView.setClickable(true);
        jLDataView.setUserFormat("%5.2f");
        jLChart.getY1Axis().addDataView(jLDataView);
        jLDataView2.add(-6.0, -10.0);
        jLDataView2.add(-5.0, -5.0);
        jLDataView2.add(-4.0, 7.0);
        jLDataView2.add(-3.0, 11.0);
        jLDataView2.add(-2.0, 12.0);
        jLDataView2.add(-1.0, 14.0);
        jLDataView2.add(0.0, 78.0);
        jLDataView2.add(1.0, Double.NaN);
        jLDataView2.add(2.0, 22.0);
        jLDataView2.add(3.0, 55.0);
        jLDataView2.add(4.0, 42.0);
        jLDataView2.add(5.0, 11.0);
        jLDataView2.add(6.0, 47.0);
        jLDataView2.add(7.0, 12.0);
        jLDataView2.setName("Le signal 2");
        jLDataView2.setUnit("std");
        jLDataView2.setColor(Color.blue);
        jLDataView2.setLineWidth(3);
        jLDataView2.setFillColor(Color.orange);
        jLDataView2.setFillStyle(1);
        jLDataView2.setViewType(1);
        jLChart.getY2Axis().addDataView(jLDataView2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        JButton jButton = new JButton("Exit");
        jButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                System.exit(0);
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton("Options");
        jButton2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                jLChart.showOptionDialog();
            }
        });
        jPanel.add(jButton2);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)jLChart, "Center");
        jFrame.getContentPane().add((Component)jPanel, "South");
        jFrame.setSize(800, 600);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setVisible(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

