/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.chart;

import com.braju.format.Format;
import fr.esrf.tangoatk.widget.util.chart.CfFileReader;
import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.GraphicsUtils;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import fr.esrf.tangoatk.widget.util.chart.LabelInfo;
import fr.esrf.tangoatk.widget.util.chart.OFormat;
import fr.esrf.tangoatk.widget.util.chart.SearchInfo;
import fr.esrf.tangoatk.widget.util.chart.XYData;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.RectangularShape;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.JComponent;

public class JLAxis {
    public static final int HORIZONTAL_DOWN = 1;
    public static final int HORIZONTAL_UP = 2;
    public static final int HORIZONTAL_ORG1 = 3;
    public static final int HORIZONTAL_ORG2 = 4;
    public static final int VERTICAL_RIGHT = 5;
    public static final int VERTICAL_LEFT = 6;
    public static final int VERTICAL_ORG = 7;
    public static final int TIME_ANNO = 1;
    public static final int VALUE_ANNO = 2;
    public static final int LINEAR_SCALE = 0;
    public static final int LOG_SCALE = 1;
    public static final int AUTO_FORMAT = 0;
    public static final int SCIENTIFIC_FORMAT = 1;
    public static final int TIME_FORMAT = 2;
    public static final int DECINT_FORMAT = 3;
    public static final int HEXINT_FORMAT = 4;
    public static final int BININT_FORMAT = 5;
    public static final int SCIENTIFICINT_FORMAT = 6;
    static final double YEAR = 3.1536E10;
    static final double MONTH = 2.592E9;
    static final double DAY = 8.64E7;
    static final double HOUR = 3600000.0;
    static final double MINU = 60000.0;
    static final double SECO = 1000.0;
    private boolean visible;
    private double min = 0.0;
    private double max = 100.0;
    private double minimum = 0.0;
    private double maximum = 100.0;
    private boolean autoScale = false;
    private int scale = 0;
    private Color labelColor;
    private Font labelFont;
    private int labelFormat;
    private Vector labels;
    private int orientation;
    private int dOrientation;
    private boolean subtickVisible;
    private Dimension csize = null;
    private String name = null;
    private int annotation = 2;
    private Vector dataViews;
    private JComponent parent;
    private double ln10;
    private boolean gridVisible;
    private boolean subGridVisible;
    private int gridStyle;
    private Rectangle boundRect;
    private boolean lastAutoScate;
    private boolean isZoomed;
    private double percentScrollback;
    private double axisDuration = Double.POSITIVE_INFINITY;
    private String axeName;
    private SimpleDateFormat useFormat;
    private double desiredPrec;
    private boolean drawOpposite;
    private int tickLength;
    private int subtickLength;
    private int fontOverWidht;
    private boolean inverted = false;
    private double tickStep;
    private double minTickStep;
    private int subTickStep;
    private boolean xAxisOnBottom = true;
    static final GregorianCalendar calendar = new GregorianCalendar();
    static final SimpleDateFormat genFormat = new SimpleDateFormat("dd/MM/yy HH:mm:ss.SSS");
    static final SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy");
    static final SimpleDateFormat monthFormat = new SimpleDateFormat("MMMMM yy");
    static final SimpleDateFormat weekFormat = new SimpleDateFormat("dd/MM/yy");
    static final SimpleDateFormat dayFormat = new SimpleDateFormat("EEE dd");
    static final SimpleDateFormat hour12Format = new SimpleDateFormat("EEE HH:mm");
    static final SimpleDateFormat hourFormat = new SimpleDateFormat("HH:mm");
    static final SimpleDateFormat secFormat = new SimpleDateFormat("HH:mm:ss");
    static final double[] timePrecs = new double[]{1000.0, 5000.0, 10000.0, 30000.0, 60000.0, 300000.0, 600000.0, 1800000.0, 3600000.0, 1.08E7, 2.16E7, 4.32E7, 8.64E7, 6.048E8, 2.592E9, 3.1536E10, 1.5768E11, 3.1536E11};
    static final SimpleDateFormat[] timeFormats = new SimpleDateFormat[]{secFormat, secFormat, secFormat, secFormat, secFormat, secFormat, secFormat, hourFormat, hourFormat, hourFormat, hourFormat, hour12Format, dayFormat, weekFormat, monthFormat, yearFormat, yearFormat, yearFormat};
    static final String[] labelFomats = new String[]{"%g", "", "%02d:%02d:%02d", "%d", "%X", "%b"};
    static final int[] triangleX = new int[]{0, 4, -4};
    static final int[] triangleY = new int[]{-3, 3, 3};
    static final Polygon triangleShape = new Polygon(triangleX, triangleY, 3);
    static final int[] diamondX = new int[]{0, 4, 0, -4};
    static final int[] diamondY = new int[]{4, 0, -4, 0};
    static final Polygon diamondShape = new Polygon(diamondX, diamondY, 4);
    static double[] logStep = new double[]{0.301, 0.477, 0.602, 0.699, 0.778, 0.845, 0.903, 0.954};

    public JLAxis(JComponent jComponent, int n) {
        this.labels = new Vector();
        this.labelFont = new Font("Dialog", 1, 11);
        this.labelColor = Color.black;
        this.orientation = n;
        this.dOrientation = n;
        this.inverted = !this.isHorizontal();
        this.dataViews = new Vector();
        this.parent = jComponent;
        this.ln10 = Math.log(10.0);
        this.gridVisible = false;
        this.subGridVisible = false;
        this.gridStyle = 1;
        this.labelFormat = 0;
        this.subtickVisible = true;
        this.boundRect = new Rectangle(0, 0, 0, 0);
        this.isZoomed = false;
        this.percentScrollback = 0.0;
        this.axeName = "";
        this.visible = true;
        this.drawOpposite = true;
        this.tickLength = 4;
        this.subtickLength = this.tickLength / 2;
        this.fontOverWidht = 0;
        this.minTickStep = 10.0;
    }

    public void setXAxisOnBottom(boolean bl) {
        this.xAxisOnBottom = bl;
    }

    public boolean isXAxisOnBottom() {
        return this.xAxisOnBottom;
    }

    public void setPercentScrollback(double d) {
        this.percentScrollback = d / 100.0;
    }

    public double getPercentScrollback() {
        return this.percentScrollback;
    }

    public void setAxisColor(Color color) {
        this.labelColor = color;
    }

    public Color getAxisColor() {
        return this.labelColor;
    }

    public void setLabelFormat(int n) {
        this.labelFormat = n;
    }

    public int getLabelFormat() {
        return this.labelFormat;
    }

    public void setGridVisible(boolean bl) {
        this.gridVisible = bl;
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public void setDrawOpposite(boolean bl) {
        this.drawOpposite = bl;
    }

    public boolean isDrawOpposite() {
        return this.drawOpposite;
    }

    public void setSubGridVisible(boolean bl) {
        this.subGridVisible = bl;
    }

    public boolean isSubGridVisible() {
        return this.subGridVisible;
    }

    public void setGridStyle(int n) {
        this.gridStyle = n;
    }

    public int getGridStyle() {
        return this.gridStyle;
    }

    public void setFont(Font font) {
        this.labelFont = font;
    }

    public Font getFont() {
        return this.labelFont;
    }

    public void setAnnotation(int n) {
        this.annotation = n;
    }

    public int getAnnotation() {
        return this.annotation;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isZoomed() {
        return this.isZoomed;
    }

    public boolean isXY() {
        return this.dataViews.size() > 0;
    }

    public void setMinimum(double d) {
        this.minimum = d;
        if (!this.autoScale) {
            if (this.scale == 1) {
                if (d <= 0.0) {
                    d = 1.0;
                }
                this.min = Math.log(d) / this.ln10;
            } else {
                this.min = d;
            }
        }
    }

    public double getMinimum() {
        return this.minimum;
    }

    public void setMaximum(double d) {
        this.maximum = d;
        if (!this.autoScale) {
            if (this.scale == 1) {
                if (this.max <= 0.0) {
                    this.max = this.min * 10.0;
                }
                this.max = Math.log(d) / this.ln10;
            } else {
                this.max = d;
            }
        }
    }

    public double getMaximum() {
        return this.maximum;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public boolean isAutoScale() {
        return this.autoScale;
    }

    public void setAutoScale(boolean bl) {
        this.autoScale = bl;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int n) {
        this.scale = n;
        if (this.scale == 1 && (this.minimum <= 0.0 || this.maximum <= 0.0)) {
            this.minimum = 1.0;
            this.maximum = 10.0;
        }
        if (this.scale == 1) {
            this.min = Math.log(this.minimum) / this.ln10;
            this.max = Math.log(this.maximum) / this.ln10;
        } else {
            this.min = this.minimum;
            this.max = this.maximum;
        }
    }

    public void setOrientation(int n) {
        this.orientation = n;
        this.dOrientation = n;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void zoom(int n, int n2) {
        if (!this.isZoomed) {
            this.lastAutoScate = this.autoScale;
        }
        if (this.isHorizontal()) {
            if (n < this.boundRect.x) {
                n = this.boundRect.x;
            }
            if (n2 > this.boundRect.x + this.boundRect.width) {
                n2 = this.boundRect.x + this.boundRect.width;
            }
            if (n2 - n < 10) {
                return;
            }
            double d = (double)(n - this.boundRect.x) / (double)this.boundRect.width;
            double d2 = (double)(n2 - this.boundRect.x) / (double)this.boundRect.width;
            double d3 = this.min + (this.max - this.min) * d;
            double d4 = this.min + (this.max - this.min) * d2;
            this.min = d3;
            this.max = d4;
        } else {
            if (n < this.boundRect.y) {
                n = this.boundRect.y;
            }
            if (n2 > this.boundRect.y + this.boundRect.height) {
                n2 = this.boundRect.y + this.boundRect.height;
            }
            if (n2 - n < 10) {
                return;
            }
            double d = (double)(this.boundRect.y + this.boundRect.height - n2) / (double)this.boundRect.height;
            double d5 = (double)(this.boundRect.y + this.boundRect.height - n) / (double)this.boundRect.height;
            double d6 = this.min + (this.max - this.min) * d;
            double d7 = this.min + (this.max - this.min) * d5;
            this.min = d6;
            this.max = d7;
        }
        this.autoScale = false;
        this.isZoomed = true;
    }

    public void unzoom() {
        this.autoScale = this.lastAutoScate;
        if (!this.lastAutoScate) {
            this.setMinimum(this.getMinimum());
            this.setMaximum(this.getMaximum());
        }
        this.isZoomed = false;
    }

    public int getTick() {
        return (int)this.minTickStep;
    }

    public double getTickSpacing() {
        return this.minTickStep;
    }

    public void setTickSpacing(double d) {
        this.minTickStep = d;
    }

    public void setTick(int n) {
        this.minTickStep = n;
    }

    public void setTickLength(int n) {
        this.tickLength = n;
        this.subtickLength = this.tickLength / 2;
    }

    public int getTickLength() {
        return this.tickLength;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        int n = 0;
        if (string != null) {
            n = string.length();
        }
        this.name = n > 0 ? string : null;
    }

    public void setPosition(int n) {
        if (this.isHorizontal()) {
            if (n >= 1 && n <= 4) {
                this.orientation = n;
            }
        } else if (n >= 5 && n <= 7) {
            this.orientation = n;
        }
    }

    int getPosition() {
        return this.orientation;
    }

    public String getAxeName() {
        return this.axeName;
    }

    public void setAxeName(String string) {
        this.axeName = string;
    }

    public void addDataView(JLDataView jLDataView) {
        if (this.dataViews.contains(jLDataView)) {
            return;
        }
        if (!this.isHorizontal()) {
            this.dataViews.add(jLDataView);
            jLDataView.setAxis(this);
        } else {
            this.dataViews.clear();
            this.dataViews.add(jLDataView);
            jLDataView.setAxis(this);
            this.setAnnotation(2);
        }
    }

    public void addDataViewAt(int n, JLDataView jLDataView) {
        if (this.dataViews.contains(jLDataView)) {
            return;
        }
        if (!this.isHorizontal()) {
            this.dataViews.add(n, jLDataView);
            jLDataView.setAxis(this);
        } else {
            this.addDataView(jLDataView);
        }
    }

    public JLDataView getDataView(int n) {
        if (n < 0 || n >= this.dataViews.size()) {
            System.out.println("JLChart.getDataView(): index out of bounds.");
            return null;
        }
        return (JLDataView)this.dataViews.get(n);
    }

    public void removeDataView(JLDataView jLDataView) {
        this.dataViews.remove(jLDataView);
        jLDataView.setAxis(null);
        if (this.isHorizontal()) {
            this.setAnnotation(1);
            if (this.scale != 0) {
                this.setScale(0);
            }
        }
    }

    public void clearDataView() {
        int n = this.dataViews.size();
        int n2 = 0;
        while (n2 < n) {
            JLDataView jLDataView = (JLDataView)this.dataViews.get(n2);
            jLDataView.setAxis(null);
            ++n2;
        }
        this.dataViews.clear();
    }

    public Vector getViews() {
        return this.dataViews;
    }

    public int getViewNumber() {
        return this.dataViews.size();
    }

    public void setInverted(boolean bl) {
        this.inverted = bl;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public Rectangle getBoundRect() {
        return this.boundRect;
    }

    /*
     * Unable to fully structure code
     */
    public String toScientific(double var1_1) {
        block4: {
            var3_2 = Math.abs(var1_1);
            var5_3 = 0;
            var6_4 = "%.2fe%d";
            if (var3_2 == 0.0) break block4;
            if (!(var3_2 < 1.0)) ** GOTO lbl13
            while (var3_2 < 1.0) {
                var3_2 *= 10.0;
                --var5_3;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                var3_2 /= 10.0;
                ++var5_3;
lbl13:
                // 2 sources

                ** while (var3_2 >= 10.0)
            }
        }
        if (var3_2 >= 9.999999999) {
            var3_2 /= 10.0;
            ++var5_3;
        }
        if (var1_1 < 0.0) {
            var3_2 = -var3_2;
        }
        var7_5 = new Object[]{new Double(var3_2), new Integer(var5_3)};
        return Format.sprintf((String)var6_4, (Object[])var7_5);
    }

    /*
     * Unable to fully structure code
     */
    public String toScientificInt(double var1_1) {
        block4: {
            var3_2 = Math.abs(var1_1);
            var5_3 = 0;
            var6_4 = "%de%d";
            if (var3_2 == 0.0) break block4;
            if (!(var3_2 < 1.0)) ** GOTO lbl13
            while (var3_2 < 1.0) {
                var3_2 *= 10.0;
                --var5_3;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                var3_2 /= 10.0;
                ++var5_3;
lbl13:
                // 2 sources

                ** while (var3_2 >= 10.0)
            }
        }
        if (var3_2 >= 9.999999999) {
            var3_2 /= 10.0;
            ++var5_3;
        }
        if (var1_1 < 0.0) {
            var3_2 = -var3_2;
        }
        var7_5 = new Object[]{new Integer((int)Math.rint(var3_2)), new Integer(var5_3)};
        return Format.sprintf((String)var6_4, (Object[])var7_5);
    }

    public static String formatTimeValue(double d) {
        calendar.setTimeInMillis((long)d);
        Date date = calendar.getTime();
        return genFormat.format(date);
    }

    private void computeDateformat(int n) {
        boolean bl = false;
        int n2 = 0;
        while (n2 < timePrecs.length && !bl) {
            int n3 = (int)((this.max - this.min) / timePrecs[n2]);
            boolean bl2 = bl = n3 <= n;
            if (bl) continue;
            ++n2;
        }
        if (!bl) {
            --n2;
            this.desiredPrec = 3.1536E11;
            this.useFormat = yearFormat;
        } else {
            this.desiredPrec = timePrecs[n2];
            this.useFormat = timeFormats[n2];
        }
    }

    public String formatValue(double d, double d2) {
        if (d2 != 0.0 && this.scale == 0) {
            long l;
            if (d >= 0.0) {
                d = d / d2 * 100000.0;
                l = (long)(d + 0.5);
                d = (double)l * d2 / 100000.0;
            } else {
                d = -d / d2 * 100000.0;
                l = (long)(d + 0.5);
                d = -((double)l * d2) / 100000.0;
            }
        }
        switch (this.labelFormat) {
            case 1: {
                return this.toScientific(d);
            }
            case 6: {
                return this.toScientificInt(d);
            }
            case 3: 
            case 4: 
            case 5: {
                Object[] objectArray = new Object[]{new Integer((int)(Math.abs(d) + 0.5))};
                if (d < 0.0) {
                    return "-" + Format.sprintf((String)labelFomats[this.labelFormat], (Object[])objectArray);
                }
                return Format.sprintf((String)labelFomats[this.labelFormat], (Object[])objectArray);
            }
            case 2: {
                int n = (int)Math.abs(d);
                Object[] objectArray = new Object[]{new Integer(n / 3600), new Integer(n % 3600 / 60), new Integer(n % 60)};
                if (d < 0.0) {
                    return "-" + Format.sprintf((String)labelFomats[this.labelFormat], (Object[])objectArray);
                }
                return Format.sprintf((String)labelFomats[this.labelFormat], (Object[])objectArray);
            }
        }
        return Double.toString(d);
    }

    private boolean isHorizontal() {
        return this.dOrientation == 1 || this.dOrientation == 2;
    }

    private double computeHighTen(double d) {
        int n = (int)(Math.log(d) / this.ln10);
        return Math.pow(10.0, n + 1);
    }

    private double computeLowTen(double d) {
        int n = (int)(Math.log(d) / this.ln10);
        return Math.pow(10.0, n);
    }

    private void computeAutoScale() {
        int n = 0;
        int n2 = this.dataViews.size();
        double d = 0.0;
        double d2 = 0.0;
        if (this.autoScale && n2 > 0) {
            this.min = Double.MAX_VALUE;
            this.max = -1.7976931348623157E308;
            n = 0;
            while (n < n2) {
                JLDataView jLDataView = (JLDataView)this.dataViews.get(n);
                if (jLDataView.hasTransform()) {
                    double[] dArray = jLDataView.computeTransformedMinMax();
                    d = dArray[0];
                    d2 = dArray[1];
                } else {
                    d = jLDataView.getMinimum();
                    d2 = jLDataView.getMaximum();
                }
                if (this.scale == 1) {
                    if (d <= 0.0) {
                        d = jLDataView.computePositiveMin();
                    }
                    if (d != Double.MAX_VALUE) {
                        d = Math.log(d) / this.ln10;
                    }
                    d2 = d2 <= 0.0 ? -1.7976931348623157E308 : Math.log(d2) / this.ln10;
                }
                if (d2 > this.max) {
                    this.max = d2;
                }
                if (d < this.min) {
                    this.min = d;
                }
                ++n;
            }
            if (this.min == Double.MAX_VALUE && this.max == -1.7976931348623157E308) {
                if (this.scale == 1) {
                    this.min = 0.0;
                    this.max = 1.0;
                } else {
                    this.min = 0.0;
                    this.max = 99.99;
                }
            }
            if (this.max - this.min < 1.0E-100) {
                this.max += 0.999;
                this.min -= 0.999;
            }
            double d3 = this.computeLowTen(this.max - this.min);
            if (this.scale == 1 && d3 < 1.0) {
                d3 = 1.0;
            }
            this.min = this.min < 0.0 ? (double)((int)(this.min / d3) - 1) * d3 : (double)((int)(this.min / d3)) * d3;
            this.max = this.max < 0.0 ? (double)((int)(this.max / d3)) * d3 : (double)((int)(this.max / d3) + 1) * d3;
        }
    }

    public void setAxisDuration(double d) {
        this.axisDuration = d;
    }

    public void computeXScale(Vector vector) {
        int n = 0;
        int n2 = vector.size();
        if (this.isHorizontal() && this.autoScale && n2 > 0) {
            if (!this.isXY()) {
                this.min = Double.MAX_VALUE;
                this.max = -1.7976931348623157E308;
                n = 0;
                while (n < n2) {
                    JLDataView jLDataView = (JLDataView)vector.get(n);
                    double d = jLDataView.getMaxTime();
                    double d2 = jLDataView.getMinTime();
                    if (this.scale == 1) {
                        if (d2 <= 0.0) {
                            d2 = jLDataView.getPositiveMinTime();
                        }
                        if (d2 != Double.MAX_VALUE) {
                            d2 = Math.log(d2) / this.ln10;
                        }
                        d = d <= 0.0 ? -1.7976931348623157E308 : Math.log(d) / this.ln10;
                    }
                    if (d > this.max) {
                        this.max = d;
                    }
                    if (d2 < this.min) {
                        this.min = d2;
                    }
                    ++n;
                }
                if (this.min == Double.MAX_VALUE && this.max == -1.7976931348623157E308) {
                    if (this.scale == 1) {
                        this.min = 0.0;
                        this.max = 1.0;
                    } else if (this.annotation == 1) {
                        this.min = (double)System.currentTimeMillis() - 3600000.0;
                        this.max = System.currentTimeMillis();
                    } else {
                        this.min = 0.0;
                        this.max = 99.99;
                    }
                }
                if (this.annotation == 1) {
                    if (this.axisDuration != Double.POSITIVE_INFINITY) {
                        this.min = this.max - this.axisDuration;
                    }
                    this.max += (this.max - this.min) * this.percentScrollback;
                }
                if (this.max - this.min < 1.0E-100) {
                    this.max += 0.999;
                    this.min -= 0.999;
                }
            } else {
                this.computeAutoScale();
            }
        }
    }

    public int getFontHeight(Graphics graphics) {
        if (!this.visible) {
            return 5;
        }
        if (this.isHorizontal()) {
            if (this.name != null) {
                return 2 * graphics.getFontMetrics(this.labelFont).getHeight() + 5;
            }
            return graphics.getFontMetrics(this.labelFont).getHeight() + 5;
        }
        if (this.name != null) {
            return graphics.getFontMetrics(this.labelFont).getHeight();
        }
        return 5;
    }

    public int getFontOverWidht() {
        return this.fontOverWidht;
    }

    public int getThickness() {
        if (this.csize != null && this.visible) {
            if (!this.isHorizontal()) {
                return this.csize.width;
            }
            return this.csize.height;
        }
        return 0;
    }

    public int getLength() {
        if (this.csize != null) {
            if (this.isHorizontal()) {
                return this.csize.width;
            }
            return this.csize.height;
        }
        return 0;
    }

    public void measureAxis(Graphics graphics, FontRenderContext fontRenderContext, int n, int n2) {
        int n3 = 10;
        int n4 = 0;
        graphics.setFont(this.labelFont);
        this.computeAutoScale();
        if (!this.isHorizontal()) {
            this.computeLabels(fontRenderContext, n2);
        } else {
            this.computeLabels(fontRenderContext, n);
        }
        int n5 = 0;
        while (n5 < this.labels.size()) {
            LabelInfo labelInfo = (LabelInfo)this.labels.get(n5);
            if (labelInfo.getWidth() > n3) {
                n3 = labelInfo.getWidth();
            }
            if (labelInfo.getHeight() > n4) {
                n4 = labelInfo.getHeight();
            }
            ++n5;
        }
        this.fontOverWidht = n3 / 2 + 1;
        this.csize = !this.isHorizontal() ? new Dimension(n3 + 5, n2) : new Dimension(n, n4);
    }

    public Point transform(double d, double d2, JLAxis jLAxis) {
        double d3;
        double d4;
        if (this.csize == null) {
            return new Point(-100, -100);
        }
        double d5 = jLAxis.getMax() - jLAxis.getMin();
        int n = this.boundRect.x;
        int n2 = this.boundRect.y + this.getLength();
        if (Double.isNaN(d2) || Double.isNaN(d)) {
            return new Point(-100, -100);
        }
        if (jLAxis.getScale() == 1) {
            if (d <= 0.0) {
                return new Point(-100, -100);
            }
            d4 = Math.log(d) / this.ln10;
        } else {
            d4 = d;
        }
        if (this.scale == 1) {
            if (d2 <= 0.0) {
                return new Point(-100, -100);
            }
            d3 = Math.log(d2) / this.ln10;
        } else {
            d3 = d2;
        }
        double d6 = (d4 - jLAxis.getMin()) / d5 * (double)jLAxis.getLength();
        double d7 = -(d3 - this.min) / (this.max - this.min) * (double)this.csize.height;
        if (d6 < -32000.0) {
            d6 = -32000.0;
        }
        if (d6 > 32000.0) {
            d6 = 32000.0;
        }
        if (d7 < -32000.0) {
            d7 = -32000.0;
        }
        if (d7 > 32000.0) {
            d7 = 32000.0;
        }
        return new Point((int)d6 + n, (int)d7 + n2);
    }

    private int distance2(int n, int n2, int n3, int n4) {
        return (n3 - n) * (n3 - n) + (n4 - n2) * (n4 - n2);
    }

    public SearchInfo searchNearestNormal(int n, int n2, JLAxis jLAxis) {
        int n3 = this.dataViews.size();
        int n4 = 0;
        DataList dataList = null;
        Point point = null;
        int n5 = Integer.MAX_VALUE;
        JLDataView jLDataView = null;
        int n6 = 0;
        int n7 = -1;
        Rectangle rectangle = new Rectangle();
        rectangle.setBounds(this.boundRect.x - 2, this.boundRect.y - 2, this.boundRect.width + 4, this.boundRect.height + 4);
        int n8 = 0;
        while (n8 < n3) {
            JLDataView jLDataView2 = (JLDataView)this.dataViews.get(n8);
            if (jLDataView2.isClickable()) {
                DataList dataList2 = jLDataView2.getData();
                n4 = 0;
                while (dataList2 != null) {
                    int n9;
                    Point point2 = this.transform(dataList2.x, jLDataView2.getTransformedValue(dataList2.y), jLAxis);
                    if (rectangle.contains(point2) && (n9 = this.distance2(n, n2, point2.x, point2.y)) < n5) {
                        n5 = n9;
                        dataList = dataList2;
                        jLDataView = jLDataView2;
                        point = point2;
                        n7 = n4;
                        n6 = point2.x < this.boundRect.x + this.boundRect.width / 2 ? (point2.y < this.boundRect.y + this.boundRect.height / 2 ? 3 : 1) : (point2.y < this.boundRect.y + this.boundRect.height / 2 ? 2 : 0);
                    }
                    dataList2 = dataList2.next;
                    ++n4;
                }
            }
            ++n8;
        }
        if (n5 == Integer.MAX_VALUE) {
            return new SearchInfo();
        }
        return new SearchInfo(point.x, point.y, jLDataView, this, dataList, n5, n6, n7);
    }

    public SearchInfo searchNearestXY(int n, int n2, JLAxis jLAxis) {
        Object object;
        int n3 = this.dataViews.size();
        DataList dataList = null;
        DataList dataList2 = null;
        Point point = null;
        int n4 = Integer.MAX_VALUE;
        Object object2 = null;
        int n5 = 0;
        JLDataView jLDataView = (JLDataView)jLAxis.getViews().get(0);
        Rectangle rectangle = new Rectangle();
        rectangle.setBounds(this.boundRect.x - 2, this.boundRect.y - 2, this.boundRect.width + 4, this.boundRect.height + 4);
        int n6 = 0;
        while (n6 < n3) {
            object = (JLDataView)this.dataViews.get(n6);
            if (((JLDataView)object).isClickable()) {
                XYData xYData = new XYData(((JLDataView)object).getData(), jLDataView.getData());
                if (xYData.isValid()) {
                    xYData.initFirstPoint();
                }
                while (xYData.isValid()) {
                    int n7;
                    Point point2 = this.transform(jLDataView.getTransformedValue(xYData.d2.y), ((JLDataView)object).getTransformedValue(xYData.d1.y), jLAxis);
                    if (rectangle.contains(point2) && (n7 = this.distance2(n, n2, point2.x, point2.y)) < n4) {
                        n4 = n7;
                        dataList = xYData.d1;
                        dataList2 = xYData.d2;
                        object2 = object;
                        point = point2;
                        n5 = point2.x < this.boundRect.x + this.boundRect.width / 2 ? (point2.y < this.boundRect.y + this.boundRect.height / 2 ? 3 : 1) : (point2.y < this.boundRect.y + this.boundRect.height / 2 ? 2 : 0);
                    }
                    xYData.toNextXYPoint();
                }
            }
            ++n6;
        }
        if (n4 == Integer.MAX_VALUE) {
            return new SearchInfo();
        }
        object = new SearchInfo(point.x, point.y, (JLDataView)object2, this, dataList, n4, n5, -1);
        ((SearchInfo)object).setXValue(dataList2, jLDataView);
        return object;
    }

    public SearchInfo searchNearest(int n, int n2, JLAxis jLAxis) {
        if (n <= this.boundRect.x - 10 || n >= this.boundRect.x + this.boundRect.width + 10 || n2 <= this.boundRect.y - 10 || n2 >= this.boundRect.y + this.boundRect.height + 10) {
            return new SearchInfo();
        }
        if (jLAxis.isXY()) {
            return this.searchNearestXY(n, n2, jLAxis);
        }
        return this.searchNearestNormal(n, n2, jLAxis);
    }

    /*
     * Unable to fully structure code
     */
    private void computeLabels(FontRenderContext var1_1, double var2_2) {
        var4_3 = this.max - this.min;
        var10_4 = (int)var2_2;
        this.labels.clear();
        switch (this.annotation) {
            case 1: {
                this.computeDateformat(10);
                var18_5 = (int)(this.min / this.desiredPrec);
                var13_7 = (double)(var18_5 + 1) * this.desiredPrec;
                var6_9 = this.inverted != false ? var2_2 * (1.0 - (var13_7 - this.min) / var4_3) : var2_2 * ((var13_7 - this.min) / var4_3);
                JLAxis.calendar.setTimeInMillis((long)var13_7);
                var11_11 = JLAxis.calendar.getTime();
                var12_12 = this.useFormat.format(var11_11);
                var17_14 = this.labelFont.getStringBounds(var12_12, var1_1);
                var8_16 = (int)var17_14.getWidth();
                var9_17 = (int)var17_14.getHeight();
                this.labels.add(new LabelInfo(var12_12, var8_16, var9_17, var6_9));
                var19_18 = (double)var8_16 * 1.3;
                if (var19_18 < this.minTickStep) {
                    var19_18 = this.minTickStep;
                }
                var21_19 = var19_18 / var2_2 * var4_3;
                var15_20 = this.desiredPrec;
                while (var15_20 < var21_19) {
                    var15_20 += this.desiredPrec;
                }
                this.tickStep = var2_2 * var15_20 / var4_3;
                var13_7 += var15_20;
                if (this.inverted) {
                    this.tickStep = -this.tickStep;
                }
                this.subTickStep = 0;
                while (var13_7 <= this.max) {
                    var6_9 = this.inverted != false ? (double)((int)Math.rint(var2_2 * (1.0 - (var13_7 - this.min) / var4_3))) : (double)((int)Math.rint(var2_2 * ((var13_7 - this.min) / var4_3)));
                    JLAxis.calendar.setTimeInMillis((long)var13_7);
                    var11_11 = JLAxis.calendar.getTime();
                    var12_12 = this.useFormat.format(var11_11);
                    var17_14 = this.labelFont.getStringBounds(var12_12, var1_1);
                    if (var6_9 > 0.0 && var6_9 < (double)var10_4) {
                        var8_16 = (int)var17_14.getWidth();
                        var9_17 = (int)var17_14.getHeight();
                        this.labels.add(new LabelInfo(var12_12, var8_16, var9_17, var6_9));
                    }
                    var13_7 += var15_20;
                }
                break;
            }
            case 2: {
                var23_22 = this.labelFont.getLineMetrics("0", var1_1).getAscent();
                var15_21 = this.computeLowTen(this.max - this.min);
                var25_23 = false;
                if (!this.isHorizontal()) {
                    var26_24 = (int)(var2_2 / (2.0 * var23_22));
                } else {
                    if (this.scale == 1) {
                        var27_25 = Math.pow(10.0, this.min);
                        var29_27 = Math.pow(10.0, this.max);
                    } else {
                        var27_25 = this.min;
                        var29_27 = this.max;
                    }
                    var12_13 = this.formatValue(var27_25, var15_21);
                    var17_15 = this.labelFont.getStringBounds(var12_13, var1_1);
                    var31_29 = var17_15.getWidth();
                    var12_13 = this.formatValue(var29_27, var15_21);
                    var17_15 = this.labelFont.getStringBounds(var12_13, var1_1);
                    if (var17_15.getWidth() > var31_29) {
                        var31_29 = var17_15.getWidth();
                    }
                    var31_29 = 1.5 * var31_29;
                    var26_24 = (int)(var2_2 / var31_29);
                }
                var28_31 = 0;
                var29_28 = 0;
                var30_32 = (int)Math.rint(var2_2 / this.minTickStep);
                if (var30_32 < var26_24) {
                    var26_24 = var30_32;
                }
                if (var26_24 < 1) {
                    var26_24 = 1;
                }
                if (this.scale != 1) ** GOTO lbl88
                var15_21 = 1.0;
                var28_31 = -1;
                var13_8 = Math.rint(this.min);
                var27_26 = (int)Math.rint((this.max - this.min) / var15_21);
                while (var27_26 > var26_24) {
                    var28_31 = 2;
                    var27_26 = (int)Math.rint((this.max - this.min) / (var15_21 *= 2.0));
                    if (var27_26 <= var26_24) continue;
                    var28_31 = 10;
                    var27_26 = (int)Math.rint((this.max - this.min) / (var15_21 *= 5.0));
                }
                var29_28 = var28_31;
                ** GOTO lbl137
lbl88:
                // 1 sources

                var28_31 = 10;
                var27_26 = (int)Math.rint((this.max - this.min) / var15_21);
                if (var27_26 > var26_24) ** GOTO lbl105
                var27_26 = (int)Math.rint((this.max - this.min) / (var15_21 / 2.0));
                while (var27_26 <= var26_24) {
                    var28_31 = 5;
                    var27_26 = (int)Math.rint((this.max - this.min) / ((var15_21 /= 2.0) / 5.0));
                    if (var27_26 > var26_24) continue;
                    var28_31 = 10;
                    var27_26 = (int)Math.rint((this.max - this.min) / ((var15_21 /= 5.0) / 2.0));
                }
                ** GOTO lbl106
lbl-1000:
                // 1 sources

                {
                    var28_31 = 5;
                    var27_26 = (int)Math.rint((this.max - this.min) / (var15_21 *= 5.0));
                    if (var27_26 <= var26_24) continue;
                    var28_31 = 10;
                    var27_26 = (int)Math.rint((this.max - this.min) / (var15_21 *= 2.0));
lbl105:
                    // 3 sources

                    ** while (var27_26 > var26_24)
                }
lbl106:
                // 2 sources

                var18_6 = (int)Math.floor(this.min / var15_21);
                var31_29 = var13_8 = (double)var18_6 * var15_21;
                var33_33 = 0;
                while (var31_29 <= this.max) {
                    if (var31_29 >= this.min - 1.0E-12) {
                        ++var33_33;
                    }
                    var31_29 += var15_21;
                }
                if (var33_33 <= 1) {
                    if (var28_31 == 10) {
                        var28_31 = 5;
                        var15_21 /= 2.0;
                    } else {
                        var28_31 = 10;
                        var15_21 /= 5.0;
                    }
                    var25_23 = true;
                }
                var34_36 = Math.abs(var15_21 / var4_3 * var2_2 / (double)var28_31);
                var29_28 = var28_31;
                while (var34_36 < 10.0 && var29_28 > 1) {
                    switch (var29_28) {
                        case 10: {
                            var29_28 = 5;
                            var34_36 *= 2.0;
                            break;
                        }
                        case 5: {
                            var29_28 = 2;
                            var34_36 *= 2.5;
                            break;
                        }
                        case 2: {
                            var29_28 = 1;
                        }
                    }
                }
lbl137:
                // 2 sources

                this.tickStep = var2_2 * var15_21 / var4_3;
                if (this.inverted) {
                    this.tickStep = -this.tickStep;
                }
                this.subTickStep = var29_28;
                var31_30 = 0;
                var32_38 = 0;
                switch (this.dOrientation) {
                    case 6: {
                        var31_30 = this.tickLength < 0 ? this.tickLength : 0;
                        break;
                    }
                    case 5: {
                        var31_30 = this.tickLength < 0 ? -this.tickLength : 0;
                        break;
                    }
                    default: {
                        var32_38 = this.tickLength < 0 ? -this.tickLength : 0;
                        break;
                    }
                }
                while (var13_8 <= this.max) {
                    var6_10 = this.inverted != false ? (double)((int)Math.rint(var2_2 * (1.0 - (var13_8 - this.min) / var4_3))) : (double)((int)Math.rint(var2_2 * ((var13_8 - this.min) / var4_3)));
                    var33_34 = this.scale == 1 ? Math.pow(10.0, var13_8) : var13_8;
                    var12_13 = this.formatValue(var33_34, var15_21);
                    var17_15 = this.labelFont.getStringBounds(var12_13, var1_1);
                    if (var13_8 >= this.min - 1.0E-12) {
                        var35_39 = new LabelInfo(var12_13, (int)var17_15.getWidth(), (int)var23_22, var6_10);
                        var35_39.setOffset(var31_30, var32_38);
                        this.labels.add(var35_39);
                    }
                    var13_8 += var15_21;
                }
                if (!var25_23 || this.labels.size() <= 2) break;
                var33_35 = new Vector<LabelInfo>();
                var34_37 = (LabelInfo)this.labels.get(0);
                var35_39 = (LabelInfo)this.labels.get(this.labels.size() - 1);
                var33_35.add(var34_37);
                var33_35.add(var35_39);
                this.tickStep = var35_39.pos - var34_37.pos;
                this.subTickStep = this.labels.size() - 1;
                this.labels = var33_35;
            }
        }
    }

    public void drawFast(Graphics graphics, Point point, Point point2, JLDataView jLDataView) {
        Object object;
        if (point != null && this.boundRect.contains(point)) {
            object = (Graphics2D)graphics;
            Stroke stroke = ((Graphics2D)object).getStroke();
            BasicStroke basicStroke = GraphicsUtils.createStrokeForLine(jLDataView.getLineWidth(), jLDataView.getStyle());
            if (basicStroke != null) {
                ((Graphics2D)object).setStroke(basicStroke);
            }
            graphics.setColor(jLDataView.getColor());
            graphics.drawLine(point.x, point.y, point2.x, point2.y);
            ((Graphics2D)object).setStroke(stroke);
        }
        object = graphics.getColor();
        graphics.setColor(jLDataView.getMarkerColor());
        JLAxis.paintMarker(graphics, jLDataView.getMarker(), jLDataView.getMarkerSize(), point2.x, point2.y);
        graphics.setColor((Color)object);
    }

    public static void paintMarker(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n2 / 2;
        int n6 = n2 / 2 + 1;
        switch (n) {
            case 1: {
                graphics.fillOval(n3 - n5, n4 - n5, n2, n2);
                break;
            }
            case 2: {
                graphics.fillRect(n3 - n5, n4 - n5, n2, n2);
                break;
            }
            case 3: {
                triangleShape.translate(n3, n4);
                graphics.fillPolygon(triangleShape);
                triangleShape.translate(-n3, -n4);
                break;
            }
            case 4: {
                diamondShape.translate(n3, n4);
                graphics.fillPolygon(diamondShape);
                diamondShape.translate(-n3, -n4);
                break;
            }
            case 5: {
                graphics.drawLine(n3 - n5, n4 + n5, n3 + n6, n4 - n6);
                graphics.drawLine(n3 + n5, n4 + n5, n3 - n6, n4 - n6);
                graphics.drawLine(n3, n4 - n5, n3, n4 + n6);
                graphics.drawLine(n3 - n5, n4, n3 + n6, n4);
                break;
            }
            case 6: {
                graphics.drawLine(n3, n4 - n5, n3, n4 + n6);
                break;
            }
            case 7: {
                graphics.drawLine(n3 - n5, n4, n3 + n6, n4);
                break;
            }
            case 8: {
                graphics.drawLine(n3, n4 - n5, n3, n4 + n6);
                graphics.drawLine(n3 - n5, n4, n3 + n6, n4);
                break;
            }
            case 9: {
                graphics.drawOval(n3 - n5, n4 - n5, n2 + 1, n2 + 1);
                break;
            }
            case 10: {
                graphics.drawRect(n3 - n5, n4 - n5, n2, n2);
            }
        }
    }

    private void paintBarBorder(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawLine(n3 - n / 2, n4, n3 + n / 2, n4);
        graphics.drawLine(n3 + n / 2, n4, n3 + n / 2, n2);
        graphics.drawLine(n3 + n / 2, n2, n3 - n / 2, n2);
        graphics.drawLine(n3 - n / 2, n2, n3 - n / 2, n4);
    }

    private void paintBar(Graphics graphics, Paint paint, int n, Color color, int n2, int n3, int n4, int n5) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (n2 != 0) {
            if (paint != null) {
                graphics2D.setPaint(paint);
            } else {
                graphics2D.setColor(color);
            }
            if (n5 > n3) {
                graphics.fillRect(n4 - n / 2, n3, n, n5 - n3);
            } else {
                graphics.fillRect(n4 - n / 2, n5, n, n3 - n5);
            }
        }
    }

    public static void drawSampleLine(Graphics graphics, int n, int n2, JLDataView jLDataView) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        BasicStroke basicStroke = GraphicsUtils.createStrokeForLine(jLDataView.getLineWidth(), jLDataView.getStyle());
        if (basicStroke != null) {
            graphics2D.setStroke(basicStroke);
        }
        graphics.drawLine(n, n2, n + 40, n2);
        graphics2D.setStroke(stroke);
        Color color = graphics.getColor();
        graphics.setColor(jLDataView.getMarkerColor());
        JLAxis.paintMarker(graphics, jLDataView.getMarker(), jLDataView.getMarkerSize(), n + 20, n2);
        graphics.setColor(color);
    }

    void paintDataViews(Graphics graphics, JLAxis jLAxis, int n, int n2) {
        Object object;
        int n3 = this.dataViews.size();
        boolean bl = jLAxis.isXY();
        JLDataView jLDataView = null;
        int n4 = n + 1;
        int n5 = this.isXAxisOnBottom() || this.getScale() == 1 ? n2 - this.getLength() + 1 : (int)this.transform(0.0, this.min, jLAxis).getY() - this.getLength() + 1;
        int n6 = jLAxis.getLength() - 1;
        int n7 = this.getLength() - 1;
        if (n6 <= 1 || n7 <= 1) {
            return;
        }
        graphics.setClip(n4, n5, n6, n7);
        if (bl) {
            jLDataView = (JLDataView)jLAxis.getViews().get(0);
        }
        int n8 = 0;
        while (n8 < n3) {
            object = (JLDataView)this.dataViews.get(n8);
            if (bl) {
                this.paintDataViewXY(graphics, (JLDataView)object, jLDataView, jLAxis, n, n2);
            } else {
                this.paintDataViewNormal(graphics, (JLDataView)object, jLAxis, n, n2);
            }
            ++n8;
        }
        object = this.parent.getSize();
        graphics.setClip(0, 0, ((Dimension)object).width, ((Dimension)object).height);
    }

    private int computeBarWidth(JLDataView jLDataView, JLAxis jLAxis) {
        int n = 20;
        double d = jLAxis.getMin();
        double d2 = jLAxis.getMax();
        int n2 = jLDataView.getBarWidth();
        double d3 = Double.MAX_VALUE;
        if (n2 > 0) {
            return n2;
        }
        if (jLAxis.getScale() == 1) {
            return n;
        }
        if (jLAxis.isXY()) {
            JLDataView jLDataView2 = (JLDataView)jLAxis.getViews().get(0);
            DataList dataList = jLDataView2.getData();
            if (dataList != null) {
                double d4 = dataList.y;
                dataList = dataList.next;
                while (dataList != null) {
                    double d5 = Math.abs(dataList.y - d4);
                    if (d5 < d3) {
                        d3 = d5;
                    }
                    d4 = dataList.y;
                    dataList = dataList.next;
                }
            }
        } else {
            DataList dataList = jLDataView.getData();
            if (dataList != null) {
                double d6 = dataList.x;
                dataList = dataList.next;
                while (dataList != null) {
                    double d7 = Math.abs(dataList.x - d6);
                    if (d7 < d3) {
                        d3 = d7;
                    }
                    d6 = dataList.x;
                    dataList = dataList.next;
                }
            }
        }
        if (d3 == Double.MAX_VALUE) {
            return n;
        }
        n2 = (int)Math.floor(d3 / (d2 - d) * (double)jLAxis.getLength()) - 2;
        n2 /= 2;
        if ((n2 *= 2) < 0) {
            n2 = 0;
        }
        return n2;
    }

    private void paintDataViewBar(Graphics2D graphics2D, JLDataView jLDataView, int n, BasicStroke basicStroke, Paint paint, int n2, int n3, int n4) {
        if (jLDataView.getViewType() == 1) {
            this.paintBar(graphics2D, paint, n, jLDataView.getFillColor(), jLDataView.getFillStyle(), n2, n3, n4);
            if (jLDataView.getLineWidth() > 0) {
                Stroke stroke = graphics2D.getStroke();
                if (basicStroke != null) {
                    graphics2D.setStroke(basicStroke);
                }
                graphics2D.setColor(jLDataView.getColor());
                this.paintBarBorder(graphics2D, n, n2, n3, n4);
                graphics2D.setStroke(stroke);
            }
        }
    }

    private void paintDataViewPolyline(Graphics2D graphics2D, JLDataView jLDataView, BasicStroke basicStroke, Paint paint, int n, int n2, int[] nArray, int[] nArray2) {
        if (n > 1 && jLDataView.getViewType() == 0) {
            Object object;
            if (jLDataView.getFillStyle() != 0) {
                object = new int[n + 2];
                int[] nArray3 = new int[n + 2];
                int n3 = 0;
                while (n3 < n) {
                    object[n3 + 1] = nArray[n3];
                    nArray3[n3 + 1] = nArray2[n3];
                    ++n3;
                }
                object[0] = object[1];
                nArray3[0] = n2;
                object[n + 1] = object[n];
                nArray3[n + 1] = n2;
                if (paint != null) {
                    graphics2D.setPaint(paint);
                }
                graphics2D.fillPolygon((int[])object, nArray3, n + 2);
            }
            if (jLDataView.getLineWidth() > 0) {
                object = graphics2D.getStroke();
                if (basicStroke != null) {
                    graphics2D.setStroke(basicStroke);
                }
                graphics2D.setColor(jLDataView.getColor());
                graphics2D.drawPolyline(nArray, nArray2, n);
                graphics2D.setStroke((Stroke)object);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void paintDataViewNormal(Graphics var1_1, JLDataView var2_2, JLAxis var3_3, int var4_4, int var5_5) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void paintDataViewXY(Graphics graphics, JLDataView jLDataView, JLDataView jLDataView2, JLAxis jLAxis, int n, int n2) {
        XYData xYData = new XYData(jLDataView.getData(), jLDataView2.getData());
        if (xYData.isValid()) {
            int n3;
            int n4 = jLDataView.getDataLength() + jLDataView2.getDataLength();
            int[] nArray = new int[n4];
            int[] nArray2 = new int[n4];
            double d = jLDataView.getA0();
            double d2 = jLDataView.getA1();
            double d3 = jLDataView.getA2();
            double d4 = jLDataView2.getA0();
            double d5 = jLDataView2.getA1();
            double d6 = jLDataView2.getA2();
            double d7 = jLAxis.getMin();
            double d8 = jLAxis.getMax();
            double d9 = jLAxis.getLength();
            int n5 = jLAxis.getScale();
            double d10 = this.min;
            double d11 = this.max;
            double d12 = this.getLength();
            int n6 = 0;
            boolean bl = true;
            switch (jLDataView.getFillMethod()) {
                case 0: {
                    n3 = n2 - (int)d12;
                    break;
                }
                case 1: {
                    if (this.scale == 1) {
                        n3 = n2;
                        break;
                    }
                    n3 = (int)(d10 / (d11 - d10) * d12) + n2;
                    break;
                }
                default: {
                    n3 = n2;
                }
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            BasicStroke basicStroke = GraphicsUtils.createStrokeForLine(jLDataView.getLineWidth(), jLDataView.getStyle());
            Paint paint = GraphicsUtils.createPatternForFilling(jLDataView.getFillStyle(), jLDataView.getFillColor(), jLDataView.getColor());
            int n7 = this.computeBarWidth(jLDataView, jLAxis);
            while (xYData.isValid()) {
                xYData.initFirstPoint();
                while (bl && xYData.isValid()) {
                    double d13 = d + d2 * xYData.d1.y + d3 * xYData.d1.y * xYData.d1.y;
                    double d14 = d4 + d5 * xYData.d2.y + d6 * xYData.d2.y * xYData.d2.y;
                    boolean bl2 = bl = !Double.isNaN(d14) && !Double.isNaN(d13) && (n5 != 1 || d14 > 1.0E-100) && (this.scale != 1 || d13 > 1.0E-100);
                    if (!bl) continue;
                    double d15 = n5 == 1 ? (Math.log(d14) / this.ln10 - d7) / (d8 - d7) * d9 : (d14 - d7) / (d8 - d7) * d9;
                    double d16 = this.scale == 1 ? -(Math.log(d13) / this.ln10 - d10) / (d11 - d10) * d12 : (this.isXAxisOnBottom() ? -(d13 - d10) / (d11 - d10) * d12 : -d13 / (d11 - d10) * d12);
                    if (d15 < -32000.0) {
                        d15 = -32000.0;
                    }
                    if (d15 > 32000.0) {
                        d15 = 32000.0;
                    }
                    if (d16 < -32000.0) {
                        d16 = -32000.0;
                    }
                    if (d16 > 32000.0) {
                        d16 = 32000.0;
                    }
                    if (n6 < n4) {
                        nArray[n6] = (int)d15 + n;
                        nArray2[n6] = (int)d16 + n2;
                        if (jLDataView.getMarker() > 0) {
                            graphics.setColor(jLDataView.getMarkerColor());
                            JLAxis.paintMarker(graphics, jLDataView.getMarker(), jLDataView.getMarkerSize(), nArray[n6], nArray2[n6]);
                        }
                        this.paintDataViewBar(graphics2D, jLDataView, n7, basicStroke, paint, n3, nArray[n6], nArray2[n6]);
                        ++n6;
                    }
                    xYData.toNextXYPoint();
                }
                this.paintDataViewPolyline(graphics2D, jLDataView, basicStroke, paint, n6, n3, nArray, nArray2);
                n6 = 0;
                if (bl) continue;
                xYData.toNextXYPoint();
                bl = true;
            }
        }
    }

    private void paintYOutTicks(Graphics graphics, int n, double d, int n2, int n3, BasicStroke basicStroke, int n4, int n5, boolean bl) {
        block8: {
            Stroke stroke;
            Graphics2D graphics2D;
            block9: {
                graphics2D = (Graphics2D)graphics;
                stroke = graphics2D.getStroke();
                if (!this.subtickVisible) break block8;
                if (this.subTickStep != -1) break block9;
                int n6 = 0;
                while (n6 < logStep.length) {
                    int n7 = (int)Math.rint(d + this.tickStep * logStep[n6]);
                    if (n7 >= n2 && n7 <= n2 + this.csize.height) {
                        graphics.drawLine(n + n4 + n5, n7, n + n4 + n5 + this.subtickLength, n7);
                        if (this.gridVisible && this.subGridVisible && bl) {
                            if (basicStroke != null) {
                                graphics2D.setStroke(basicStroke);
                            }
                            graphics.drawLine(n, n7, n + n3, n7);
                            graphics2D.setStroke(stroke);
                        }
                    }
                    ++n6;
                }
                break block8;
            }
            if (this.subTickStep <= 0) break block8;
            double d2 = 1.0 / (double)this.subTickStep;
            int n8 = 0;
            while (n8 < this.subTickStep) {
                int n9 = (int)Math.rint(d + this.tickStep * d2 * (double)n8);
                if (n9 >= n2 && n9 <= n2 + this.csize.height) {
                    graphics.drawLine(n + n4 + n5, n9, n + n4 + n5 + this.subtickLength, n9);
                    if (n8 > 0 && this.gridVisible && this.subGridVisible && bl) {
                        if (basicStroke != null) {
                            graphics2D.setStroke(basicStroke);
                        }
                        graphics.drawLine(n, n9, n + n3, n9);
                        graphics2D.setStroke(stroke);
                    }
                }
                ++n8;
            }
        }
    }

    private void paintXOutTicks(Graphics graphics, int n, double d, int n2, int n3, BasicStroke basicStroke, int n4, int n5, boolean bl) {
        block8: {
            Stroke stroke;
            Graphics2D graphics2D;
            block9: {
                graphics2D = (Graphics2D)graphics;
                stroke = graphics2D.getStroke();
                if (!this.subtickVisible) break block8;
                if (this.subTickStep != -1) break block9;
                int n6 = 0;
                while (n6 < logStep.length) {
                    int n7 = (int)Math.rint(d + this.tickStep * logStep[n6]);
                    if (n7 >= n2 && n7 <= n2 + this.csize.width) {
                        graphics.drawLine(n7, n + n4 + n5, n7, n + n4 + n5 + this.subtickLength);
                        if (this.gridVisible && this.subGridVisible && bl) {
                            if (basicStroke != null) {
                                graphics2D.setStroke(basicStroke);
                            }
                            graphics.drawLine(n7, n, n7, n + n3);
                            graphics2D.setStroke(stroke);
                        }
                    }
                    ++n6;
                }
                break block8;
            }
            if (this.subTickStep <= 0) break block8;
            double d2 = 1.0 / (double)this.subTickStep;
            int n8 = 0;
            while (n8 < this.subTickStep) {
                int n9 = (int)Math.rint(d + this.tickStep * d2 * (double)n8);
                if (n9 >= n2 && n9 <= n2 + this.csize.width) {
                    graphics.drawLine(n9, n + n4 + n5, n9, n + n4 + n5 + this.subtickLength);
                    if (n8 > 0 && this.gridVisible && this.subGridVisible && bl) {
                        if (basicStroke != null) {
                            graphics2D.setStroke(basicStroke);
                        }
                        graphics.drawLine(n9, n, n9, n + n3);
                        graphics2D.setStroke(stroke);
                    }
                }
                ++n8;
            }
        }
    }

    private int getTickOffset(int n) {
        int n2 = 0;
        switch (this.dOrientation) {
            case 6: {
                if (this.orientation != 7) break;
                n2 = -n / 2;
                break;
            }
            case 5: {
                if (this.orientation == 7) {
                    n2 = -n / 2;
                    break;
                }
                n2 = -n;
                break;
            }
            case 1: {
                n2 = this.orientation == 3 || this.orientation == 4 ? -n / 2 : (this.orientation == 2 ? 0 : -n);
            }
        }
        return n2;
    }

    private int getTickOffsetOpposite(int n) {
        int n2 = 0;
        switch (this.dOrientation) {
            case 5: {
                if (this.orientation != 7) break;
                n2 = -n / 2;
                break;
            }
            case 6: {
                if (this.orientation == 7) {
                    n2 = -n / 2;
                    break;
                }
                n2 = -n;
                break;
            }
            case 1: {
                n2 = this.orientation == 3 || this.orientation == 4 ? -n / 2 : (this.orientation == 2 ? -n : 0);
            }
        }
        return n2;
    }

    private void paintYTicks(Graphics graphics, int n, int n2, double d, int n3, BasicStroke basicStroke, int n4, int n5, boolean bl) {
        block6: {
            Stroke stroke;
            Graphics2D graphics2D;
            block7: {
                graphics2D = (Graphics2D)graphics;
                stroke = graphics2D.getStroke();
                if (!this.subtickVisible || n >= this.labels.size() - 1) break block6;
                if (this.subTickStep != -1) break block7;
                int n6 = 0;
                while (n6 < logStep.length) {
                    int n7 = (int)Math.rint(d + this.tickStep * logStep[n6]);
                    graphics.drawLine(n2 + n4 + n5, n7, n2 + n4 + n5 + this.subtickLength, n7);
                    if (this.gridVisible && this.subGridVisible && bl) {
                        if (basicStroke != null) {
                            graphics2D.setStroke(basicStroke);
                        }
                        graphics.drawLine(n2, n7, n2 + n3, n7);
                        graphics2D.setStroke(stroke);
                    }
                    ++n6;
                }
                break block6;
            }
            if (this.subTickStep <= 0) break block6;
            double d2 = 1.0 / (double)this.subTickStep;
            int n8 = 0;
            while (n8 < this.subTickStep) {
                int n9 = (int)Math.rint(d + this.tickStep * d2 * (double)n8);
                graphics.drawLine(n2 + n4 + n5, n9, n2 + n4 + n5 + this.subtickLength, n9);
                if (n8 > 0 && this.gridVisible && this.subGridVisible && bl) {
                    if (basicStroke != null) {
                        graphics2D.setStroke(basicStroke);
                    }
                    graphics.drawLine(n2, n9, n2 + n3, n9);
                    graphics2D.setStroke(stroke);
                }
                ++n8;
            }
        }
    }

    private void paintXTicks(Graphics graphics, int n, int n2, double d, int n3, BasicStroke basicStroke, int n4, int n5, boolean bl) {
        block6: {
            Stroke stroke;
            Graphics2D graphics2D;
            block7: {
                graphics2D = (Graphics2D)graphics;
                stroke = graphics2D.getStroke();
                if (!this.subtickVisible || n >= this.labels.size() - 1) break block6;
                if (this.subTickStep != -1) break block7;
                int n6 = 0;
                while (n6 < logStep.length) {
                    int n7 = (int)Math.rint(d + this.tickStep * logStep[n6]);
                    graphics.drawLine(n7, n2 + n4 + n5, n7, n2 + n4 + n5 + this.subtickLength);
                    if (this.gridVisible && this.subGridVisible && bl) {
                        if (basicStroke != null) {
                            graphics2D.setStroke(basicStroke);
                        }
                        graphics.drawLine(n7, n2, n7, n2 + n3);
                        graphics2D.setStroke(stroke);
                    }
                    ++n6;
                }
                break block6;
            }
            if (this.subTickStep <= 0) break block6;
            double d2 = 1.0 / (double)this.subTickStep;
            int n8 = 0;
            while (n8 < this.subTickStep) {
                int n9 = (int)Math.rint(d + this.tickStep * d2 * (double)n8);
                graphics.drawLine(n9, n2 + n4 + n5, n9, n2 + n4 + n5 + this.subtickLength);
                if (n8 > 0 && this.gridVisible && this.subGridVisible && bl) {
                    if (basicStroke != null) {
                        graphics2D.setStroke(basicStroke);
                    }
                    graphics.drawLine(n9, n2, n9, n2 + n3);
                    graphics2D.setStroke(stroke);
                }
                ++n8;
            }
        }
    }

    public Color computeMediumColor(Color color, Color color2) {
        return new Color((color.getRed() + 3 * color2.getRed()) / 4, (color.getGreen() + 3 * color2.getGreen()) / 4, (color.getBlue() + 3 * color2.getBlue()) / 4);
    }

    void paintAxis(Graphics graphics, FontRenderContext fontRenderContext, int n, int n2, JLAxis jLAxis, int n3, int n4, Color color, boolean bl) {
        int n5 = 0;
        int n6 = 0;
        Point point = null;
        if (!this.isHorizontal() && this.dataViews.size() == 0) {
            return;
        }
        if (this.getLength() <= 1) {
            this.boundRect.setRect(0.0, 0.0, 0.0, 0.0);
            return;
        }
        n5 = jLAxis.getLength();
        if (n5 <= 0) {
            this.boundRect.setRect(0.0, 0.0, 0.0, 0.0);
            return;
        }
        switch (this.dOrientation) {
            case 6: {
                this.boundRect.setRect(n + this.getThickness(), n2, n5, this.csize.height);
                if (this.orientation != 7) break;
                point = this.transform(0.0, 1.0, jLAxis);
                if (point.x >= n + this.csize.width && point.x <= n + this.csize.width + n5) {
                    n6 = point.x - (n + this.csize.width);
                    break;
                }
                return;
            }
            case 5: {
                this.boundRect.setRect(n - n5 - 1, n2, n5, this.csize.height);
                if (this.orientation != 7) break;
                point = this.transform(0.0, 1.0, jLAxis);
                if (point.x >= n - n5 - 1 && point.x <= n) {
                    n6 = point.x - n;
                    break;
                }
                return;
            }
            case 1: 
            case 2: {
                this.boundRect.setRect(n, n2 - n5, this.csize.width, n5);
                if (this.orientation != 3 && this.orientation != 4) break;
                point = jLAxis.transform(1.0, 0.0, this);
                if (point.y >= n2 - n5 && point.y <= n2) {
                    n6 = point.y - n2;
                    break;
                }
                return;
            }
            default: {
                System.out.println("JLChart warning: Wrong axis position");
            }
        }
        if (!this.visible) {
            return;
        }
        this.paintAxisDirect(graphics, fontRenderContext, n, n2, color, n6, jLAxis.getLength());
        if (this.drawOpposite && bl) {
            if (this.orientation == 7 || this.orientation == 3 || this.orientation == 4) {
                this.paintAxisOppositeDouble(graphics, fontRenderContext, n, n2, color, n6, jLAxis.getLength());
            } else {
                this.paintAxisOpposite(graphics, fontRenderContext, n, n2, color, n6, jLAxis.getLength());
            }
        }
    }

    public void paintAxisDirect(Graphics graphics, FontRenderContext fontRenderContext, int n, int n2, Color color, int n3, int n4) {
        BasicStroke basicStroke = null;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color2 = this.computeMediumColor(this.labelColor, color);
        if (this.gridVisible) {
            basicStroke = GraphicsUtils.createStrokeForLine(1, this.gridStyle);
        }
        graphics.setFont(this.labelFont);
        int n5 = this.getTickOffset(this.tickLength);
        int n6 = this.getTickOffset(this.subtickLength);
        switch (this.dOrientation) {
            case 6: {
                Object object;
                Object object2;
                if (this.labels.size() > 0) {
                    object2 = (LabelInfo)this.labels.get(0);
                    object = (LabelInfo)this.labels.get(this.labels.size() - 1);
                    graphics.setColor(color2);
                    this.paintYOutTicks(graphics, n + this.csize.width, (double)n2 + ((LabelInfo)object2).pos - this.tickStep, n2, n4, basicStroke, n3, n6, true);
                    this.paintYOutTicks(graphics, n + this.csize.width, (double)n2 + ((LabelInfo)object).pos, n2, n4, basicStroke, n3, n6, true);
                }
                int n7 = 0;
                while (n7 < this.labels.size()) {
                    graphics.setColor(this.labelColor);
                    object2 = (LabelInfo)this.labels.get(n7);
                    int n8 = n + (this.csize.width - 4) - ((LabelInfo)object2).size.width;
                    int n9 = (int)Math.rint(((LabelInfo)object2).pos) + n2;
                    graphics.drawString(((LabelInfo)object2).value, n8 + n3 + ((LabelInfo)object2).offset.x, n9 + ((LabelInfo)object2).offset.y + ((LabelInfo)object2).size.height / 3);
                    if (this.gridVisible) {
                        object = graphics2D.getStroke();
                        if (basicStroke != null) {
                            graphics2D.setStroke(basicStroke);
                        }
                        graphics.drawLine(n + (this.csize.width + 1), n9, n + (this.csize.width + 1) + n4, n9);
                        graphics2D.setStroke((Stroke)object);
                    }
                    graphics.setColor(color2);
                    this.paintYTicks(graphics, n7, n + this.csize.width, ((LabelInfo)object2).pos + (double)n2, n4, basicStroke, n3, n6, true);
                    graphics.setColor(this.labelColor);
                    graphics.drawLine(n + n3 + this.csize.width + n5, n9, n + n3 + this.csize.width + n5 + this.tickLength, n9);
                    ++n7;
                }
                graphics.setColor(this.labelColor);
                graphics.drawLine(n + n3 + this.csize.width, n2, n + n3 + this.csize.width, n2 + this.csize.height);
                if (this.name == null) break;
                object2 = this.labelFont.getStringBounds(this.name, fontRenderContext);
                graphics.drawString(this.name, n + n3 + this.csize.width - (int)((RectangularShape)object2).getWidth() / 2, n2 - (int)(((RectangularShape)object2).getHeight() / 2.0) - 2);
                break;
            }
            case 5: {
                Object object;
                Object object3;
                if (this.labels.size() > 0) {
                    object3 = (LabelInfo)this.labels.get(0);
                    object = (LabelInfo)this.labels.get(this.labels.size() - 1);
                    graphics.setColor(color2);
                    this.paintYOutTicks(graphics, n, (double)n2 + ((LabelInfo)object3).pos - this.tickStep, n2, -n4, basicStroke, n3, n6, true);
                    this.paintYOutTicks(graphics, n, (double)n2 + ((LabelInfo)object).pos, n2, -n4, basicStroke, n3, n6, true);
                }
                int n10 = 0;
                while (n10 < this.labels.size()) {
                    graphics.setColor(this.labelColor);
                    object3 = (LabelInfo)this.labels.get(n10);
                    int n11 = (int)Math.rint(((LabelInfo)object3).pos) + n2;
                    graphics.drawString(((LabelInfo)object3).value, n + n3 + ((LabelInfo)object3).offset.x + 6, n11 + ((LabelInfo)object3).offset.y + ((LabelInfo)object3).size.height / 3);
                    if (this.gridVisible) {
                        object = graphics2D.getStroke();
                        if (basicStroke != null) {
                            graphics2D.setStroke(basicStroke);
                        }
                        graphics.drawLine(n, n11, n - n4, n11);
                        graphics2D.setStroke((Stroke)object);
                    }
                    graphics.setColor(color2);
                    this.paintYTicks(graphics, n10, n, ((LabelInfo)object3).pos + (double)n2, -n4, basicStroke, n3, n6, true);
                    graphics.setColor(this.labelColor);
                    graphics.drawLine(n + n3 + n5, n11, n + n3 + n5 + this.tickLength, n11);
                    ++n10;
                }
                graphics.setColor(this.labelColor);
                graphics.drawLine(n + n3, n2, n + n3, n2 + this.csize.height);
                if (this.name == null) break;
                object3 = this.labelFont.getStringBounds(this.name, fontRenderContext);
                graphics.drawString(this.name, n + n3 - (int)((RectangularShape)object3).getWidth() / 2, n2 - (int)(((RectangularShape)object3).getHeight() / 2.0) - 2);
                break;
            }
            case 1: 
            case 2: {
                Object object;
                Object object4;
                if (this.orientation == 2) {
                    n3 = -n4;
                }
                if (this.labels.size() > 0) {
                    object4 = (LabelInfo)this.labels.get(0);
                    object = (LabelInfo)this.labels.get(this.labels.size() - 1);
                    graphics.setColor(color2);
                    this.paintXOutTicks(graphics, n2, (double)n + ((LabelInfo)object4).pos - this.tickStep, n, -n4, basicStroke, n3, n6, true);
                    this.paintXOutTicks(graphics, n2, (double)n + ((LabelInfo)object).pos, n, -n4, basicStroke, n3, n6, true);
                }
                int n12 = 0;
                while (n12 < this.labels.size()) {
                    graphics.setColor(this.labelColor);
                    object4 = (LabelInfo)this.labels.get(n12);
                    int n13 = (int)Math.rint(((LabelInfo)object4).pos) + n;
                    int n14 = n2;
                    graphics.drawString(((LabelInfo)object4).value, n13 + ((LabelInfo)object4).offset.x - ((LabelInfo)object4).size.width / 2, n14 + n3 + ((LabelInfo)object4).offset.y + ((LabelInfo)object4).size.height + 2);
                    graphics.setColor(color2);
                    this.paintXTicks(graphics, n12, n14, ((LabelInfo)object4).pos + (double)n, -n4, basicStroke, n3, n6, true);
                    graphics.setColor(this.labelColor);
                    if (this.gridVisible) {
                        object = graphics2D.getStroke();
                        if (basicStroke != null) {
                            graphics2D.setStroke(basicStroke);
                        }
                        graphics.drawLine(n13, n2, n13, n2 - n4);
                        graphics2D.setStroke((Stroke)object);
                    }
                    graphics.setColor(this.labelColor);
                    graphics.drawLine(n13, n2 + n3 + n5, n13, n2 + n3 + n5 + this.tickLength);
                    ++n12;
                }
                graphics.setColor(this.labelColor);
                graphics.drawLine(n, n2 + n3, n + this.csize.width, n2 + n3);
                if (this.name == null) break;
                object4 = this.labelFont.getStringBounds(this.name, fontRenderContext);
                graphics.drawString(this.name, n + (this.csize.width - (int)((RectangularShape)object4).getWidth()) / 2, n2 + 2 * (int)((RectangularShape)object4).getHeight());
            }
        }
    }

    public void paintAxisOpposite(Graphics graphics, FontRenderContext fontRenderContext, int n, int n2, Color color, int n3, int n4) {
        BasicStroke basicStroke = null;
        Color color2 = this.computeMediumColor(this.labelColor, color);
        int n5 = this.getTickOffsetOpposite(this.tickLength);
        int n6 = this.getTickOffsetOpposite(this.subtickLength);
        switch (this.dOrientation) {
            case 5: {
                LabelInfo labelInfo;
                int n7 = n - n4 - this.csize.width;
                if (this.labels.size() > 0) {
                    labelInfo = (LabelInfo)this.labels.get(0);
                    LabelInfo labelInfo2 = (LabelInfo)this.labels.get(this.labels.size() - 1);
                    graphics.setColor(color2);
                    this.paintYOutTicks(graphics, n7 + this.csize.width, (double)n2 + labelInfo.pos - this.tickStep, n2, n4, basicStroke, n3, n6, false);
                    this.paintYOutTicks(graphics, n7 + this.csize.width, (double)n2 + labelInfo2.pos, n2, n4, basicStroke, n3, n6, false);
                }
                int n8 = 0;
                while (n8 < this.labels.size()) {
                    labelInfo = (LabelInfo)this.labels.get(n8);
                    int n9 = n7 + (this.csize.width - 4) - labelInfo.size.width;
                    int n10 = (int)Math.rint(labelInfo.pos) + n2;
                    graphics.setColor(color2);
                    this.paintYTicks(graphics, n8, n7 + this.csize.width, labelInfo.pos + (double)n2, n4, basicStroke, n3, n6, false);
                    graphics.setColor(this.labelColor);
                    graphics.drawLine(n7 + n3 + this.csize.width + n5, n10, n7 + n3 + this.csize.width + n5 + this.tickLength, n10);
                    ++n8;
                }
                graphics.setColor(this.labelColor);
                graphics.drawLine(n7 + n3 + this.csize.width, n2, n7 + n3 + this.csize.width, n2 + this.csize.height);
                break;
            }
            case 6: {
                LabelInfo labelInfo;
                int n11 = n + n4 + this.csize.width;
                if (this.labels.size() > 0) {
                    labelInfo = (LabelInfo)this.labels.get(0);
                    LabelInfo labelInfo3 = (LabelInfo)this.labels.get(this.labels.size() - 1);
                    graphics.setColor(color2);
                    this.paintYOutTicks(graphics, n11, (double)n2 + labelInfo.pos - this.tickStep, n2, -n4, basicStroke, n3, n6, false);
                    this.paintYOutTicks(graphics, n11, (double)n2 + labelInfo3.pos, n2, -n4, basicStroke, n3, n6, false);
                }
                int n12 = 0;
                while (n12 < this.labels.size()) {
                    labelInfo = (LabelInfo)this.labels.get(n12);
                    int n13 = (int)Math.rint(labelInfo.pos) + n2;
                    graphics.setColor(color2);
                    this.paintYTicks(graphics, n12, n11, labelInfo.pos + (double)n2, -n4, basicStroke, n3, n6, false);
                    graphics.setColor(this.labelColor);
                    graphics.drawLine(n11 + n3 + n5, n13, n11 + n3 + n5 + this.tickLength, n13);
                    ++n12;
                }
                graphics.setColor(this.labelColor);
                graphics.drawLine(n11 + n3, n2, n11 + n3, n2 + this.csize.height);
                break;
            }
            case 1: 
            case 2: {
                LabelInfo labelInfo;
                if (this.orientation == 1) {
                    n3 = -n4;
                }
                if (this.labels.size() > 0) {
                    labelInfo = (LabelInfo)this.labels.get(0);
                    LabelInfo labelInfo4 = (LabelInfo)this.labels.get(this.labels.size() - 1);
                    graphics.setColor(color2);
                    this.paintXOutTicks(graphics, n2, (double)n + labelInfo.pos - this.tickStep, n, -n4, basicStroke, n3, n6, false);
                    this.paintXOutTicks(graphics, n2, (double)n + labelInfo4.pos, n, -n4, basicStroke, n3, n6, false);
                }
                int n14 = 0;
                while (n14 < this.labels.size()) {
                    labelInfo = (LabelInfo)this.labels.get(n14);
                    int n15 = (int)Math.rint(labelInfo.pos) + n;
                    int n16 = n2;
                    graphics.setColor(color2);
                    this.paintXTicks(graphics, n14, n16, labelInfo.pos + (double)n, -n4, basicStroke, n3, n6, false);
                    graphics.setColor(this.labelColor);
                    graphics.drawLine(n15, n2 + n3 + n5, n15, n2 + n3 + n5 + this.tickLength);
                    ++n14;
                }
                graphics.setColor(this.labelColor);
                graphics.drawLine(n, n2 + n3, n + this.csize.width, n2 + n3);
            }
        }
    }

    public void paintAxisOppositeDouble(Graphics graphics, FontRenderContext fontRenderContext, int n, int n2, Color color, int n3, int n4) {
        switch (this.dOrientation) {
            case 5: {
                int n5 = n - n4;
                graphics.setColor(this.labelColor);
                graphics.drawLine(n5, n2, n5, n2 + this.csize.height);
                graphics.drawLine(n5 + n4, n2, n5 + n4, n2 + this.csize.height);
                break;
            }
            case 6: {
                int n6 = n + this.csize.width;
                graphics.setColor(this.labelColor);
                graphics.drawLine(n6, n2, n6, n2 + this.csize.height);
                graphics.drawLine(n6 + n4, n2, n6 + n4, n2 + this.csize.height);
                break;
            }
            case 1: 
            case 2: {
                graphics.setColor(this.labelColor);
                graphics.drawLine(n, n2 - n4, n + this.csize.width, n2 - n4);
                graphics.drawLine(n, n2, n + this.csize.width, n2);
            }
        }
    }

    public void applyConfiguration(String string, CfFileReader cfFileReader) {
        Vector vector = cfFileReader.getParam(string + "grid");
        if (vector != null) {
            this.setGridVisible(OFormat.getBoolean(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "subgrid")) != null) {
            this.setSubGridVisible(OFormat.getBoolean(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "grid_style")) != null) {
            this.setGridStyle(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "min")) != null) {
            this.setMinimum(OFormat.getDouble(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "max")) != null) {
            this.setMaximum(OFormat.getDouble(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "autoscale")) != null) {
            this.setAutoScale(OFormat.getBoolean(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "scale")) != null) {
            this.setScale(OFormat.getInt(vector.get(0).toString()));
        } else {
            vector = cfFileReader.getParam(string + "cale");
            if (vector != null) {
                this.setScale(OFormat.getInt(vector.get(0).toString()));
            }
        }
        vector = cfFileReader.getParam(string + "format");
        if (vector != null) {
            this.setLabelFormat(OFormat.getInt(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "title")) != null) {
            this.setName(OFormat.getName(vector.get(0).toString()));
        }
        if ((vector = cfFileReader.getParam(string + "color")) != null) {
            this.setAxisColor(OFormat.getColor(vector));
        }
        if ((vector = cfFileReader.getParam(string + "label_font")) != null) {
            this.setFont(OFormat.getFont(vector));
        }
    }

    public String getConfiguration(String string) {
        String string2 = "";
        string2 = string2 + string + "grid:" + this.isGridVisible() + "\n";
        string2 = string2 + string + "subgrid:" + this.isSubGridVisible() + "\n";
        string2 = string2 + string + "grid_style:" + this.getGridStyle() + "\n";
        string2 = string2 + string + "min:" + this.getMinimum() + "\n";
        string2 = string2 + string + "max:" + this.getMaximum() + "\n";
        string2 = string2 + string + "autoscale:" + this.isAutoScale() + "\n";
        string2 = string2 + string + "scale:" + this.getScale() + "\n";
        string2 = string2 + string + "format:" + this.getLabelFormat() + "\n";
        string2 = string2 + string + "title:'" + this.getName() + "'\n";
        string2 = string2 + string + "color:" + OFormat.color(this.getAxisColor()) + "\n";
        string2 = string2 + string + "label_font:" + OFormat.font(this.getFont()) + "\n";
        return string2;
    }
}

