/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util;

import fr.esrf.tangoatk.core.ATKException;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.AttributeSetException;
import fr.esrf.tangoatk.core.CommandExecuteException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.IEntity;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.ISetErrorListener;
import fr.esrf.tangoatk.widget.util.ErrorHistory;
import fr.esrf.tangoatk.widget.util.ErrorPane;

public class ErrorPopup
implements IErrorListener,
ISetErrorListener {
    private String getSourceName(ErrorEvent errorEvent) {
        Object object = errorEvent.getSource();
        String string = "";
        if (object != null) {
            if (object instanceof IEntity) {
                string = ((IEntity)object).getName();
            } else if (object instanceof Device) {
                string = ((Device)object).getName();
            } else if (object instanceof String) {
                string = (String)object;
            } else {
                System.out.println("ErrorPopup.getSourceName() : Warning getting unknown source object.");
            }
        }
        return string;
    }

    public void errorChange(ErrorEvent errorEvent) {
        Throwable throwable = errorEvent.getError();
        if (throwable instanceof AttributeSetException || throwable instanceof CommandExecuteException) {
            ATKException aTKException = (ATKException)throwable;
            ErrorPane.showErrorMessage(null, this.getSourceName(errorEvent), aTKException);
        }
    }

    public void setErrorOccured(ErrorEvent errorEvent) {
        Throwable throwable = errorEvent.getError();
        if (throwable instanceof AttributeSetException) {
            ATKException aTKException = (ATKException)throwable;
            ErrorPane.showErrorMessage(null, "Set Attribute Error", this.getSourceName(errorEvent), aTKException);
        } else {
            System.out.println("ErrorPopup.setErrorOccured() : not an AttributeSetException.");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        AttributeList attributeList = new AttributeList();
        ErrorHistory errorHistory = new ErrorHistory();
        attributeList.addErrorListener((IErrorListener)errorHistory);
        errorHistory.show();
        attributeList.addErrorListener((IErrorListener)new ErrorPopup());
        attributeList.add("eas/test-api/1/attr_wrong_type");
        attributeList.startRefresher();
    }
}

