/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.device;

import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.Database;
import fr.esrf.tangoatk.core.ATKException;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.Device;
import fr.esrf.tangoatk.core.DeviceFactory;
import fr.esrf.tangoatk.core.EventSupport;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.ICommand;
import fr.esrf.tangoatk.core.IDevice;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.IStatusListener;
import fr.esrf.tangoatk.widget.device.tree.DeviceTreeCellRenderer;
import fr.esrf.tangoatk.widget.device.tree.DomainNode;
import fr.esrf.tangoatk.widget.device.tree.FamilyNode;
import fr.esrf.tangoatk.widget.device.tree.MemberNode;
import fr.esrf.tangoatk.widget.dnd.NodeFactory;
import fr.esrf.tangoatk.widget.dnd.TransferHandler;
import fr.esrf.tangoatk.widget.util.LoadingDialog;
import java.awt.event.ComponentListener;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyListener;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class Tree
extends JTree {
    DomainNode[] domains;
    EventSupport propChanges;
    DefaultMutableTreeNode top;

    public Tree() {
        this.initComponents();
    }

    public void refresh() {
        this.top.removeAllChildren();
        this.importFromDb();
    }

    public synchronized void removeListeners() {
        this.propChanges.removeAtkEventListeners();
        ComponentListener[] componentListenerArray = this.getComponentListeners();
        int n = 0;
        while (n < componentListenerArray.length) {
            this.removeComponentListener(componentListenerArray[n]);
            ++n;
        }
        FocusListener[] focusListenerArray = this.getFocusListeners();
        int n2 = 0;
        while (n2 < focusListenerArray.length) {
            this.removeFocusListener(focusListenerArray[n2]);
            ++n2;
        }
        HierarchyBoundsListener[] hierarchyBoundsListenerArray = this.getHierarchyBoundsListeners();
        int n3 = 0;
        while (n3 < hierarchyBoundsListenerArray.length) {
            this.removeHierarchyBoundsListener(hierarchyBoundsListenerArray[n3]);
            ++n3;
        }
        HierarchyListener[] hierarchyListenerArray = this.getHierarchyListeners();
        int n4 = 0;
        while (n4 < hierarchyListenerArray.length) {
            this.removeHierarchyListener(hierarchyListenerArray[n4]);
            ++n4;
        }
        InputMethodListener[] inputMethodListenerArray = this.getInputMethodListeners();
        int n5 = 0;
        while (n5 < inputMethodListenerArray.length) {
            this.removeInputMethodListener(inputMethodListenerArray[n5]);
            ++n5;
        }
        KeyListener[] keyListenerArray = this.getKeyListeners();
        int n6 = 0;
        while (n6 < keyListenerArray.length) {
            this.removeKeyListener(keyListenerArray[n6]);
            ++n6;
        }
        MouseListener[] mouseListenerArray = this.getMouseListeners();
        int n7 = 0;
        while (n7 < mouseListenerArray.length) {
            this.removeMouseListener(mouseListenerArray[n7]);
            ++n7;
        }
        MouseMotionListener[] mouseMotionListenerArray = this.getMouseMotionListeners();
        int n8 = 0;
        while (n8 < mouseMotionListenerArray.length) {
            this.removeMouseMotionListener(mouseMotionListenerArray[n8]);
            ++n8;
        }
        MouseWheelListener[] mouseWheelListenerArray = this.getMouseWheelListeners();
        int n9 = 0;
        while (n9 < mouseWheelListenerArray.length) {
            this.removeMouseWheelListener(mouseWheelListenerArray[n9]);
            ++n9;
        }
        PropertyChangeListener[] propertyChangeListenerArray = this.getPropertyChangeListeners();
        int n10 = 0;
        while (n10 < propertyChangeListenerArray.length) {
            this.removePropertyChangeListener(propertyChangeListenerArray[n10]);
            ++n10;
        }
    }

    protected void error(Exception exception) {
        this.propChanges.fireReadErrorEvent((Object)this, (Throwable)exception);
    }

    public void importFromDb() {
        try {
            this.propChanges.fireStatusEvent((Object)this, "Importing from database...");
            Database database = new Database();
            String[] stringArray = database.get_device_domain("*");
            this.addDomains(this.top, database, stringArray);
        }
        catch (DevFailed devFailed) {
            this.error((Exception)new ATKException(devFailed));
        }
        this.propChanges.fireStatusEvent((Object)this, "Importing from database...Done");
        this.expandRow(0);
    }

    public void addErrorListener(IErrorListener iErrorListener) {
        this.propChanges.addErrorListener(iErrorListener);
    }

    public void removeErrorListener(IErrorListener iErrorListener) {
        this.propChanges.removeErrorListener(iErrorListener);
    }

    public void addStatusListener(IStatusListener iStatusListener) {
        this.propChanges.addStatusListener(iStatusListener);
    }

    public void removeStatusListener(IStatusListener iStatusListener) {
        this.propChanges.removeStatusListener(iStatusListener);
    }

    protected void initComponents() {
        this.propChanges = new EventSupport();
        this.top = new DefaultMutableTreeNode("Devices");
        this.setTransferHandler(new TransferHandler());
        this.setCellRenderer(new DeviceTreeCellRenderer(this.getCellRenderer()));
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (Tree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY()) != null) {
                    Tree.this.clearSelection();
                    Tree.this.setSelectionPath(Tree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY()));
                }
            }
        });
        ((DefaultTreeModel)this.getModel()).setRoot(this.top);
    }

    protected void addDomains(DefaultMutableTreeNode defaultMutableTreeNode, Database database, String[] stringArray) throws DevFailed {
        this.domains = new DomainNode[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            this.domains[n] = new DomainNode(string, database);
            this.addFamilies(this.domains[n], database, database.get_device_family(string + "/*"));
            defaultMutableTreeNode.add(this.domains[n]);
            ++n;
        }
    }

    protected void addFamilies(DomainNode domainNode, Database database, String[] stringArray) throws DevFailed {
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            String[] stringArray2 = database.get_device_member(domainNode.getName() + "/" + string + "/*");
            FamilyNode familyNode = new FamilyNode(domainNode, string, database);
            this.initialAddMembers(familyNode, database, stringArray2);
            domainNode.add(familyNode);
            ++n;
        }
    }

    protected void initialAddMembers(FamilyNode familyNode, Database database, String[] stringArray) throws DevFailed {
        Object var4_4 = null;
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            MemberNode memberNode = new MemberNode(familyNode, string, database);
            familyNode.add(memberNode);
            ++n;
        }
    }

    protected void addAttributes(DefaultMutableTreeNode defaultMutableTreeNode, AttributeList attributeList) {
        NodeFactory nodeFactory = NodeFactory.getInstance();
        int n = 0;
        while (n < attributeList.size()) {
            IAttribute iAttribute = (IAttribute)attributeList.get(n);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(nodeFactory.getNode4Entity(iAttribute));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            ++n;
        }
    }

    protected void addCommands(DefaultMutableTreeNode defaultMutableTreeNode, CommandList commandList) {
        NodeFactory nodeFactory = NodeFactory.getInstance();
        int n = 0;
        while (n < commandList.size()) {
            ICommand iCommand = (ICommand)commandList.get(n);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(nodeFactory.getNode4Entity(iCommand));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            ++n;
        }
    }

    protected void addMembers(FamilyNode familyNode) {
        if (familyNode.isFilled()) {
            return;
        }
        LoadingDialog.showMessageDialog("Importing devices on " + familyNode + "...");
        this.propChanges.fireStatusEvent((Object)this, "Importing devices on " + familyNode + "...");
        familyNode.setFilled(true);
        List list = familyNode.getChildren();
        Vector<Device> vector = new Vector<Device>();
        DeviceFactory deviceFactory = DeviceFactory.getInstance();
        int n = 0;
        while (n < list.size()) {
            String string = ((MemberNode)list.get(n)).getName();
            try {
                vector.add(deviceFactory.getDevice(string));
            }
            catch (Exception exception) {
                familyNode.setFilled(false);
                this.error((Exception)((Object)new ConnectionException(exception)));
            }
            ++n;
        }
        this.addDevices(familyNode, vector);
        LoadingDialog.hideMessageDialog();
        this.propChanges.fireStatusEvent((Object)this, "Importing devices on " + familyNode + "..." + "done");
    }

    protected void addDevices(FamilyNode familyNode, List list) {
        MemberNode memberNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        int n = 0;
        while (n < list.size()) {
            AttributeList attributeList = new AttributeList();
            CommandList commandList = new CommandList();
            IDevice iDevice = (IDevice)list.get(n);
            memberNode = familyNode.getChild(iDevice.getName());
            memberNode.setAttributeList(attributeList);
            memberNode.setCommandList(commandList);
            memberNode.setDevice(iDevice);
            try {
                attributeList.add(iDevice.getName() + "/*");
            }
            catch (ATKException aTKException) {
                this.error((Exception)((Object)aTKException));
            }
            if (attributeList.size() > 0) {
                defaultMutableTreeNode = new DefaultMutableTreeNode("Attributes");
                memberNode.add(defaultMutableTreeNode);
                this.addAttributes(defaultMutableTreeNode, attributeList);
            }
            try {
                commandList.add(iDevice.getName() + "/*");
            }
            catch (ConnectionException connectionException) {
                this.error((Exception)((Object)connectionException));
            }
            if (commandList.size() > 0) {
                defaultMutableTreeNode2 = new DefaultMutableTreeNode("commands");
                memberNode.add(defaultMutableTreeNode2);
                this.addCommands(defaultMutableTreeNode2, commandList);
            }
            ++n;
        }
    }

    public void setShowEntities(boolean bl) {
        if (!bl) {
            return;
        }
        this.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            }

            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                TreePath treePath = treeExpansionEvent.getPath();
                Object[] objectArray = treePath.getPath();
                if (objectArray.length == 3) {
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)objectArray[2];
                    if (!(defaultMutableTreeNode instanceof FamilyNode)) {
                        return;
                    }
                    Tree.this.addMembers((FamilyNode)defaultMutableTreeNode);
                }
            }
        });
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        Tree tree = new Tree();
        tree.setShowEntities(true);
        jFrame.setContentPane(tree);
        jFrame.pack();
        jFrame.show();
    }
}

