/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeStateEvent;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarHistory;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.widget.attribute.Trend;
import fr.esrf.tangoatk.widget.util.chart.DataList;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

class TrendSelectionNode
extends DefaultMutableTreeNode
implements INumberScalarListener,
PropertyChangeListener {
    private String devname = "";
    private INumberScalar model;
    private int selected;
    private JLDataView data;
    private long lastErrorTime = 0L;
    static GregorianCalendar calendar = new GregorianCalendar();
    static SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
    Trend chart;

    public TrendSelectionNode(Trend trend) {
        this.devname = "Trend";
        this.model = null;
        this.data = null;
        this.chart = trend;
    }

    public TrendSelectionNode(Trend trend, String string) {
        this.devname = string;
        this.data = null;
        this.model = null;
        this.chart = trend;
    }

    public TrendSelectionNode(Trend trend, String string, INumberScalar iNumberScalar, int n, Color color) {
        this.devname = string;
        this.model = iNumberScalar;
        this.selected = n;
        this.chart = trend;
        this.data = new JLDataView();
        this.data.setColor(color);
        this.data.setMarkerColor(color);
        INumberScalarHistory[] iNumberScalarHistoryArray = iNumberScalar.getNumberScalarHistory();
        if (iNumberScalarHistoryArray != null) {
            int n2 = 0;
            while (n2 < iNumberScalarHistoryArray.length) {
                this.data.add(iNumberScalarHistoryArray[n2].getTimestamp(), iNumberScalarHistoryArray[n2].getValue());
                ++n2;
            }
            this.chart.getChart().garbageData(this.data);
        }
        iNumberScalar.addNumberScalarListener((INumberScalarListener)this);
        iNumberScalar.getProperty("label").addPresentationListener((PropertyChangeListener)this);
        iNumberScalar.getProperty("unit").addPresentationListener((PropertyChangeListener)this);
        iNumberScalar.getProperty("format").addPresentationListener((PropertyChangeListener)this);
    }

    public void refreshNode() {
        this.data.setUnit(this.model.getUnit());
        this.data.setUserFormat(this.model.getFormat());
        if (this.model.getLabel().length() > 0 && !this.model.getLabel().equalsIgnoreCase("not specified")) {
            if (this.chart.displayDeviceNames()) {
                this.data.setName(this.devname + "/" + this.model.getLabel());
            } else {
                this.data.setName(this.model.getLabel());
            }
        } else {
            this.data.setName(this.model.getName());
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.model != null) {
            this.refreshNode();
            this.chart.refreshNode(this);
        }
    }

    public int getSelected() {
        return this.selected;
    }

    public void setSelected(int n) {
        switch (n) {
            case 0: {
                switch (this.selected) {
                    case 1: {
                        this.chart.getChart().getXAxis().removeDataView(this.data);
                        break;
                    }
                    case 2: {
                        this.chart.getChart().getY1Axis().removeDataView(this.data);
                        break;
                    }
                    case 3: {
                        this.chart.getChart().getY2Axis().removeDataView(this.data);
                    }
                }
                break;
            }
            case 1: {
                switch (this.selected) {
                    case 2: {
                        this.chart.getChart().getY1Axis().removeDataView(this.data);
                        break;
                    }
                    case 3: {
                        this.chart.getChart().getY2Axis().removeDataView(this.data);
                    }
                }
                this.chart.getChart().getXAxis().addDataView(this.data);
                break;
            }
            case 2: {
                switch (this.selected) {
                    case 1: {
                        this.chart.getChart().getXAxis().removeDataView(this.data);
                        break;
                    }
                    case 3: {
                        this.chart.getChart().getY2Axis().removeDataView(this.data);
                    }
                }
                this.chart.getChart().getY1Axis().addDataView(this.data);
                break;
            }
            case 3: {
                switch (this.selected) {
                    case 1: {
                        this.chart.getChart().getXAxis().removeDataView(this.data);
                        break;
                    }
                    case 2: {
                        this.chart.getChart().getY1Axis().removeDataView(this.data);
                    }
                }
                this.chart.getChart().getY2Axis().addDataView(this.data);
            }
        }
        this.selected = n;
    }

    public boolean isLeaf() {
        return this.model != null;
    }

    public INumberScalar getModel() {
        return this.model;
    }

    public JLDataView getData() {
        return this.data;
    }

    public void delItem(INumberScalar iNumberScalar) {
        int n = 0;
        int n2 = 0;
        int n3 = this.getChildCount();
        boolean bl = false;
        String string = iNumberScalar.getName();
        String string2 = string.substring(0, string.lastIndexOf(47));
        while (n < n3 && !bl) {
            bl = string2.equals(this.getChild(n).toString());
            if (bl) continue;
            ++n;
        }
        if (bl) {
            TrendSelectionNode trendSelectionNode = (TrendSelectionNode)this.getChildAt(n);
            bl = false;
            n2 = 0;
            int n4 = trendSelectionNode.getChildCount();
            while (n2 < n4 && !bl) {
                bl = string.equals(trendSelectionNode.getChild(n2).getModelName());
                if (bl) continue;
                ++n2;
            }
            if (bl) {
                trendSelectionNode.getChild(n2).setSelected(0);
                iNumberScalar.removeNumberScalarListener((INumberScalarListener)trendSelectionNode.getChild(n2));
                trendSelectionNode.remove(n2);
                if (n4 == 1) {
                    this.remove(n);
                }
            }
        }
    }

    public TrendSelectionNode addItem(Trend trend, INumberScalar iNumberScalar, Color color) {
        int n = 0;
        int n2 = this.getChildCount();
        boolean bl = false;
        String string = iNumberScalar.getName();
        String string2 = string.substring(0, string.lastIndexOf(47));
        while (n < n2 && !bl) {
            bl = string2.equals(this.getChild(n).toString());
            if (bl) continue;
            ++n;
        }
        TrendSelectionNode trendSelectionNode = new TrendSelectionNode(trend, string2, iNumberScalar, 0, color);
        if (bl) {
            this.getChild(n).add(trendSelectionNode);
        } else {
            TrendSelectionNode trendSelectionNode2 = new TrendSelectionNode(trend, string2);
            this.add(trendSelectionNode2);
            trendSelectionNode2.add(trendSelectionNode);
        }
        return trendSelectionNode;
    }

    public Vector getSelectableItems() {
        Vector<TrendSelectionNode> vector;
        if (this.isLeaf()) {
            vector = new Vector<TrendSelectionNode>();
            vector.add(this);
        } else {
            int n = this.getChildCount();
            vector = new Vector();
            int n2 = 0;
            while (n2 < n) {
                TrendSelectionNode trendSelectionNode = this.getChild(n2);
                vector.addAll(trendSelectionNode.getSelectableItems());
                ++n2;
            }
        }
        return vector;
    }

    public void showOptions() {
        if (this.data != null) {
            this.chart.getChart().showDataOptionDialog(this.data);
        }
    }

    public String getModelName() {
        if (this.model != null) {
            return this.model.getName();
        }
        return "";
    }

    public void clearModel() {
        if (this.model != null) {
            this.model.removeNumberScalarListener((INumberScalarListener)this);
            this.model.getProperty("label").removePresentationListener((PropertyChangeListener)this);
            this.model.getProperty("unit").removePresentationListener((PropertyChangeListener)this);
            this.model.getProperty("format").removePresentationListener((PropertyChangeListener)this);
        }
        this.data = null;
        this.model = null;
    }

    public TrendSelectionNode getChild(int n) {
        return (TrendSelectionNode)this.getChildAt(n);
    }

    public void numberScalarChange(NumberScalarEvent numberScalarEvent) {
        if (this.model == null) {
            return;
        }
        boolean bl = true;
        DataList dataList = this.data.getLastValue();
        double d = numberScalarEvent.getTimeStamp();
        double d2 = numberScalarEvent.getValue();
        if (dataList != null) {
            boolean bl2 = bl = dataList.x != d || dataList.y != d2;
        }
        if (bl) {
            this.data.add(numberScalarEvent.getTimeStamp(), numberScalarEvent.getValue());
            this.chart.getChart().garbageData(this.data);
        }
    }

    public void errorChange(ErrorEvent errorEvent) {
        if (this.model == null) {
            return;
        }
        if (this.lastErrorTime != errorEvent.getTimeStamp()) {
            this.lastErrorTime = errorEvent.getTimeStamp();
            this.data.add(this.lastErrorTime, Double.NaN);
            this.chart.getChart().garbageData(this.data);
        }
    }

    public void stateChange(AttributeStateEvent attributeStateEvent) {
    }

    public String toString() {
        if (this.model != null) {
            if (this.model.getLabel().length() > 0 && !this.model.getLabel().equalsIgnoreCase("not specified")) {
                return this.model.getLabel();
            }
            return this.model.getNameSansDevice();
        }
        return this.devname;
    }
}

