/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.ErrorEvent;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.core.attribute.AAttribute;
import fr.esrf.tangoatk.widget.attribute.NumberSpectrumViewer;
import fr.esrf.tangoatk.widget.util.chart.JLChartEvent;
import fr.esrf.tangoatk.widget.util.chart.JLDataView;
import java.awt.Color;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.JFrame;

public class NumberSpectrumPeakViewer
extends NumberSpectrumViewer
implements INumberScalarListener {
    List peak_models = null;
    List peak_data_views = null;
    JLDataView refCurveDV = null;
    INumberScalar x_min_model = null;
    INumberScalar x_max_model = null;
    INumberScalar ind_track_span_model = null;
    double min_x = 0.0;
    double max_x = 0.0;
    double min_y1 = 0.0;
    double max_y1 = 0.0;
    int index_track_span = 0;
    Color spectrumColor = Color.red;
    Color refCurveColor = Color.red;
    boolean xAxisAutoScale = true;
    boolean y1AxisAutoScale = true;
    double refCurveA0 = 0.0;
    double refCurveA1 = 1.0;
    double[] refCurveValues = null;

    public NumberSpectrumPeakViewer() {
        this.dvy.setColor(this.spectrumColor);
        this.peak_models = new Vector();
        this.peak_data_views = new Vector();
        this.refCurveDV = new JLDataView();
        this.refCurveDV.setColor(this.refCurveColor);
        this.refCurveDV.setName("Reference");
    }

    public Color getSpectrumColor() {
        return this.spectrumColor;
    }

    public void setSpectrumColor(Color color) {
        if (color == null) {
            return;
        }
        this.spectrumColor = color;
        this.dvy.setColor(this.spectrumColor);
    }

    public Color getRefCurveColor() {
        return this.refCurveColor;
    }

    public void setRefCurveColor(Color color) {
        if (color == null) {
            return;
        }
        this.refCurveColor = color;
        this.refCurveDV.setColor(this.refCurveColor);
    }

    public boolean getXAxisAutoScale() {
        return this.xAxisAutoScale;
    }

    public void setXAxisAutoScale(boolean bl) {
        this.xAxisAutoScale = bl;
        this.getXAxis().setAutoScale(this.xAxisAutoScale);
    }

    public boolean getY1AxisAutoScale() {
        return this.y1AxisAutoScale;
    }

    public void setY1AxisAutoScale(boolean bl) {
        this.y1AxisAutoScale = bl;
        this.getY1Axis().setAutoScale(this.y1AxisAutoScale);
    }

    public void setY1AxisMinMax(double d, double d2) {
        if (d >= d2) {
            return;
        }
        if (this.y1AxisAutoScale) {
            return;
        }
        this.min_y1 = d;
        this.max_y1 = d2;
        this.getY1Axis().setMinimum(d);
        this.getY1Axis().setMaximum(d2);
    }

    public void setXaxisModels(INumberScalar iNumberScalar, INumberScalar iNumberScalar2) {
        if (this.x_min_model != null) {
            this.x_min_model.removeNumberScalarListener((INumberScalarListener)this);
            this.x_min_model = null;
        }
        if (this.x_max_model != null) {
            this.x_max_model.removeNumberScalarListener((INumberScalarListener)this);
            this.x_max_model = null;
        }
        if (iNumberScalar == null || iNumberScalar2 == null) {
            return;
        }
        if (iNumberScalar == iNumberScalar2) {
            return;
        }
        this.x_min_model = iNumberScalar;
        this.x_max_model = iNumberScalar2;
        this.x_min_model.addNumberScalarListener((INumberScalarListener)this);
        this.x_max_model.addNumberScalarListener((INumberScalarListener)this);
        iNumberScalar.refresh();
        iNumberScalar2.refresh();
    }

    public void addPeakModel(INumberScalar iNumberScalar) {
        JLDataView jLDataView = null;
        if (iNumberScalar == null) {
            return;
        }
        if (this.peakAlreadyUsed(iNumberScalar)) {
            return;
        }
        this.peak_models.add(iNumberScalar);
        jLDataView = new JLDataView();
        jLDataView.setMarker(2);
        jLDataView.setMarkerSize(4);
        jLDataView.setColor(Color.black);
        jLDataView.setMarkerColor(Color.black);
        jLDataView.setLabelVisible(false);
        this.peak_data_views.add(jLDataView);
        this.getY1Axis().addDataView(jLDataView);
        iNumberScalar.addNumberScalarListener((INumberScalarListener)this);
        iNumberScalar.refresh();
    }

    public void removePeakModel(INumberScalar iNumberScalar) {
        if (iNumberScalar == null) {
            return;
        }
        if (this.peakAlreadyUsed(iNumberScalar)) {
            this.removePeakFromList(iNumberScalar);
        }
    }

    public int getPeakModelNumber() {
        int n = -1;
        n = this.peak_models.size();
        return n;
    }

    public void clearPeakModels() {
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        Object var4_4 = null;
        INumberScalar iNumberScalar = null;
        JLDataView jLDataView = null;
        n = this.peak_models.size();
        n2 = this.peak_data_views.size();
        n3 = 0;
        while (n3 < n) {
            try {
                var4_4 = null;
                var4_4 = this.peak_models.get(n3);
                if (var4_4 != null && var4_4 instanceof INumberScalar) {
                    iNumberScalar = var4_4;
                    iNumberScalar.removeNumberScalarListener((INumberScalarListener)this);
                }
            }
            catch (Exception exception) {
                System.out.println("NumberSpectrumPeakViewer : this case should not happen;");
                System.out.println("NumberSpectrumPeakViewer : cannot get peak model from peak_models List for index.");
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            try {
                var4_4 = null;
                var4_4 = this.peak_data_views.get(n3);
                if (var4_4 != null && var4_4 instanceof JLDataView) {
                    jLDataView = var4_4;
                    this.getY1Axis().removeDataView(jLDataView);
                }
            }
            catch (Exception exception) {
                System.out.println("NumberSpectrumPeakViewer : this case should not happen;");
                System.out.println("NumberSpectrumPeakViewer : cannot get peak dataview from peak_data_views List for index.");
            }
            ++n3;
        }
        this.peak_models = new Vector();
        this.peak_data_views = new Vector();
    }

    public void setIndexTrackSpanModel(INumberScalar iNumberScalar) {
        if (this.ind_track_span_model != null) {
            this.ind_track_span_model.removeNumberScalarListener((INumberScalarListener)this);
            this.ind_track_span_model = null;
            this.index_track_span = 0;
        }
        if (iNumberScalar == null) {
            return;
        }
        this.ind_track_span_model = iNumberScalar;
        this.ind_track_span_model.addNumberScalarListener((INumberScalarListener)this);
        iNumberScalar.refresh();
    }

    public INumberScalar getIndexTrackSpanModel() {
        return this.ind_track_span_model;
    }

    public double getXValue(JLChartEvent jLChartEvent) {
        return jLChartEvent.getXValue();
    }

    public double getYValue(JLChartEvent jLChartEvent) {
        return jLChartEvent.getYValue();
    }

    public void errorChange(ErrorEvent errorEvent) {
        int n = -1;
        if (errorEvent.getSource() == this.model) {
            super.errorChange(errorEvent);
            return;
        }
        n = this.peak_models.indexOf(errorEvent.getSource());
        if (n >= 0) {
            this.removePeakModel((INumberScalar)errorEvent.getSource());
        }
    }

    public void numberScalarChange(NumberScalarEvent numberScalarEvent) {
        int n = -1;
        if (numberScalarEvent.getSource() == this.x_min_model) {
            this.minXchange(numberScalarEvent);
            return;
        }
        if (numberScalarEvent.getSource() == this.x_max_model) {
            this.maxXchange(numberScalarEvent);
            return;
        }
        if (numberScalarEvent.getSource() == this.ind_track_span_model) {
            this.trackSpanChange(numberScalarEvent);
            return;
        }
        n = this.peak_models.indexOf(numberScalarEvent.getSource());
        if (n >= 0) {
            this.refreshPeak(n, numberScalarEvent);
        }
    }

    private void minXchange(NumberScalarEvent numberScalarEvent) {
        this.min_x = numberScalarEvent.getValue();
        if (this.min_x < this.max_x) {
            if (!this.xAxisAutoScale) {
                // empty if block
            }
            this.getXAxis().setMinimum(this.min_x);
            this.getXAxis().setMaximum(this.max_x);
            this.changeAffineTransform();
        }
    }

    private void maxXchange(NumberScalarEvent numberScalarEvent) {
        this.max_x = numberScalarEvent.getValue();
        if (this.min_x < this.max_x) {
            if (!this.xAxisAutoScale) {
                // empty if block
            }
            this.getXAxis().setMinimum(this.min_x);
            this.getXAxis().setMaximum(this.max_x);
            this.changeAffineTransform();
        }
    }

    private void changeAffineTransform() {
        if (this.dvy == null) {
            return;
        }
        int n = this.dvy.getDataLength();
        if (n <= 0) {
            return;
        }
        double d = (this.max_x - this.min_x) / (double)n;
        this.setXAxisAffineTransform(this.min_x, d);
    }

    private void trackSpanChange(NumberScalarEvent numberScalarEvent) {
        if (numberScalarEvent.getValue() > 5.0) {
            this.index_track_span = (int)numberScalarEvent.getValue();
            return;
        }
        this.index_track_span = 0;
    }

    private boolean peakAlreadyUsed(INumberScalar iNumberScalar) {
        if (this.peak_models.size() == 0) {
            return false;
        }
        return this.peak_models.indexOf(iNumberScalar) >= 0;
    }

    private void removePeakFromList(INumberScalar iNumberScalar) {
        int n = -1;
        Object var3_3 = null;
        JLDataView jLDataView = null;
        if (this.peak_models.size() == 0) {
            return;
        }
        n = this.peak_models.indexOf(iNumberScalar);
        if (n < 0) {
            return;
        }
        try {
            this.peak_models.remove(n);
            iNumberScalar.removeNumberScalarListener((INumberScalarListener)this);
        }
        catch (Exception exception) {
            System.out.println("NumberSpectrumPeakViewer : this case should not happen;");
            System.out.println("NumberSpectrumPeakViewer : cannot remove peak model from peak_models List.");
        }
        try {
            var3_3 = null;
            var3_3 = this.peak_data_views.get(n);
            if (var3_3 != null && var3_3 instanceof JLDataView) {
                jLDataView = var3_3;
                this.getY1Axis().removeDataView(jLDataView);
            }
            this.peak_data_views.remove(n);
        }
        catch (Exception exception) {
            System.out.println("NumberSpectrumPeakViewer : this case should not happen;");
            System.out.println("NumberSpectrumPeakViewer : cannot remove peak model from peak_data_views List.");
        }
    }

    private void refreshPeak(int n, NumberScalarEvent numberScalarEvent) {
        JLDataView jLDataView = null;
        int n2 = -1;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        AAttribute aAttribute = null;
        if (this.model instanceof AAttribute) {
            aAttribute = (AAttribute)this.model;
        }
        int n3 = aAttribute != null ? aAttribute.getMaxXDimension() : 0;
        try {
            jLDataView = (JLDataView)this.peak_data_views.get(n);
            if (jLDataView != null) {
                n2 = (int)numberScalarEvent.getValue();
                if (this.index_track_span > 5) {
                    int n4 = n2 - this.index_track_span / 2;
                    int n5 = n2 + this.index_track_span / 2;
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    if (n5 >= n3) {
                        n5 = n3 - 1;
                    }
                    d = this.dvy.getXValueByIndex(n4);
                    d2 = this.dvy.getYValueByIndex(n2);
                    if (d == Double.NaN || d2 == Double.NaN) {
                        return;
                    }
                    d3 = this.dvy.getXValueByIndex(n5);
                    d4 = this.dvy.getYValueByIndex(n2);
                    if (d3 == Double.NaN || d4 == Double.NaN) {
                        return;
                    }
                }
                double d5 = this.dvy.getXValueByIndex(n2);
                double d6 = this.dvy.getYValueByIndex(n2);
                if (d5 == Double.NaN || d6 == Double.NaN) {
                    return;
                }
                jLDataView.reset();
                if (this.index_track_span > 5) {
                    jLDataView.add(d, d2);
                }
                jLDataView.add(d5, d6);
                if (this.index_track_span > 5) {
                    jLDataView.add(d3, d4);
                }
                this.repaint();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return;
        }
    }

    public void resetRefCurve() {
        this.refCurveDV.reset();
    }

    public void updateRefCurve(double[] dArray, double d, double d2) {
        int n = dArray.length;
        if (n <= 0) {
            return;
        }
        this.refCurveValues = dArray;
        double d3 = (d2 - d) / (double)n;
        if (d3 <= 0.0) {
            this.refCurveA0 = d2;
            this.refCurveA1 = 0.0 - d3;
        } else {
            this.refCurveA0 = d;
            this.refCurveA1 = d3;
        }
        this.refCurveDV.reset();
        int n2 = 0;
        while (n2 < n) {
            this.refCurveDV.add(this.refCurveA0 + this.refCurveA1 * (double)n2, dArray[n2]);
            ++n2;
        }
    }

    public void displayRefCurve() {
        this.getY1Axis().removeDataView(this.refCurveDV);
        this.getY1Axis().addDataViewAt(0, this.refCurveDV);
    }

    public void removeRefCurve() {
        this.getY1Axis().removeDataView(this.refCurveDV);
    }

    public static void main(String[] stringArray) {
        final AttributeList attributeList = new AttributeList();
        NumberSpectrumPeakViewer numberSpectrumPeakViewer = new NumberSpectrumPeakViewer();
        try {
            INumberSpectrum iNumberSpectrum = (INumberSpectrum)attributeList.add("seglab/tuneserver2/1/Spectrum");
            INumberScalar iNumberScalar = (INumberScalar)attributeList.add("seglab/tuneserver2/1/FreqMin");
            INumberScalar iNumberScalar2 = (INumberScalar)attributeList.add("seglab/tuneserver2/1/FreqMax");
            INumberScalar iNumberScalar3 = (INumberScalar)attributeList.add("seglab/tuneserver2/1/PeakHCenter");
            INumberScalar iNumberScalar4 = (INumberScalar)attributeList.add("seglab/tuneserver2/1/PeakVCenter");
            INumberScalar iNumberScalar5 = (INumberScalar)attributeList.add("seglab/tuneserver2/1/TrackSpanWidth");
            numberSpectrumPeakViewer.setModel(iNumberSpectrum);
            numberSpectrumPeakViewer.setXaxisModels(iNumberScalar, iNumberScalar2);
            numberSpectrumPeakViewer.addPeakModel(iNumberScalar3);
            numberSpectrumPeakViewer.addPeakModel(iNumberScalar4);
            numberSpectrumPeakViewer.setIndexTrackSpanModel(iNumberScalar5);
        }
        catch (Exception exception) {
            System.out.println("caught exception : " + exception.getMessage());
            System.exit(-1);
        }
        attributeList.startRefresher();
        JFrame jFrame = new JFrame();
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                attributeList.startRefresher();
            }
        });
        jFrame.setContentPane(numberSpectrumPeakViewer);
        jFrame.pack();
        jFrame.show();
    }
}

