/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberScalarListener;
import fr.esrf.tangoatk.core.IScalarAttribute;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.core.NumberScalarEvent;
import fr.esrf.tangoatk.widget.attribute.AScalarViewer;
import fr.esrf.tangoatk.widget.util.ATKFormat;
import fr.esrf.tangoatk.widget.util.ATKNumberField;
import fr.esrf.tangoatk.widget.util.UIManagerHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.JFrame;

public class NumberScalarViewer
extends AScalarViewer
implements INumberScalarListener {
    INumberScalar model;

    public NumberScalarViewer() {
        this.setValueField(new ATKNumberField());
        this.setValueBorder(BorderFactory.createLoweredBevelBorder());
        UIManagerHelper.setAll("NumberScalarViewer.Label", this.getLabel());
        UIManagerHelper.setAll("NumberScalarViewer.Value", this.getValue());
        UIManagerHelper.setAll("NumberScalarViewer.Unit", this.getUnit());
    }

    public NumberScalarViewer(INumberScalar iNumberScalar) {
        this();
        this.setModel(iNumberScalar);
    }

    public void numberScalarChange(NumberScalarEvent numberScalarEvent) {
        ((ATKNumberField)this.getValue()).setValue(new Double(numberScalarEvent.getValue()));
    }

    public void setModel(IAttribute iAttribute) {
        if (!(iAttribute instanceof INumberScalar)) {
            throw new IllegalArgumentException("Only accept INumberScalars");
        }
        this.setModel((IAttribute)((IStringScalar)iAttribute));
    }

    public void setModel(INumberScalar iNumberScalar) {
        if (this.model != null) {
            this.model.removeNumberScalarListener((INumberScalarListener)this);
        }
        this.model = iNumberScalar;
        this.getValue().setFormat(this.model.getProperty("format").getPresentation());
        ((ATKNumberField)this.getValue()).setModel(this.model);
        this.init((IScalarAttribute)this.model);
        this.model.addNumberScalarListener((INumberScalarListener)this);
    }

    public static void main(String[] stringArray) {
        GridBagConstraints gridBagConstraints;
        Object object;
        AttributeList attributeList = new AttributeList();
        long l = System.currentTimeMillis();
        NumberScalarViewer numberScalarViewer = new NumberScalarViewer();
        long l2 = System.currentTimeMillis();
        System.out.println("nsv creation time = " + (l2 - l));
        NumberScalarViewer numberScalarViewer2 = new NumberScalarViewer();
        numberScalarViewer.setLabelVisible(true);
        numberScalarViewer.setValueEditable(true);
        numberScalarViewer2.setValueEditable(true);
        numberScalarViewer.setBorder(BorderFactory.createLoweredBevelBorder());
        numberScalarViewer.setValueBorder(null);
        numberScalarViewer2.setLabelVisible(true);
        try {
            object = (INumberScalar)attributeList.add("eas/test-api/1/Att_eas");
            l = System.currentTimeMillis();
            numberScalarViewer.setModel((INumberScalar)object);
            numberScalarViewer.setBackground(Color.blue);
            l2 = System.currentTimeMillis();
            System.out.println("nsv setModel time = " + (l2 - l));
            numberScalarViewer2.setModel((INumberScalar)object);
            numberScalarViewer2.setBorder(null);
            numberScalarViewer.setBackground(Color.blue);
            numberScalarViewer.setBorder(null);
            numberScalarViewer.setUserFormat(new ATKFormat(){

                public String format(Number number) {
                    return "urk  " + number.toString();
                }
            });
            gridBagConstraints = (INumberScalar)attributeList.add("eas/test-api/1/Att_eas");
            numberScalarViewer.setPropertyListEditable(true);
            numberScalarViewer2.setPropertyListEditable(false);
            attributeList.startRefresher();
            boolean bl = false;
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        object = new JFrame();
        ((JFrame)object).getContentPane().setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        ((JFrame)object).getContentPane().add((Component)numberScalarViewer, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        ((JFrame)object).getContentPane().add((Component)numberScalarViewer2, gridBagConstraints);
        ((Frame)object).setBackground(Color.green);
        ((Window)object).pack();
        ((Window)object).show();
    }

    public String toString() {
        return "{numberscalarviewer}";
    }
}

