/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.attribute;

import fr.esrf.tangoatk.core.IAttribute;
import fr.esrf.tangoatk.core.INumberImage;
import fr.esrf.tangoatk.core.INumberScalar;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.core.IStringScalar;
import fr.esrf.tangoatk.widget.attribute.AScalarViewer;
import fr.esrf.tangoatk.widget.attribute.NumberImageViewer;
import fr.esrf.tangoatk.widget.attribute.NumberScalarViewer;
import fr.esrf.tangoatk.widget.attribute.NumberSpectrumViewer;
import fr.esrf.tangoatk.widget.attribute.PropertyFrame;
import fr.esrf.tangoatk.widget.attribute.StringScalarViewer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class AttributeViewerFactory {
    private static AttributeViewerFactory instance;
    ImageIcon propertyIcon = new ImageIcon(this.getClass().getResource("/fr/esrf/tangoatk/widget/icons/Properties16.gif"));

    private AttributeViewerFactory() {
    }

    public static AttributeViewerFactory getInstance() {
        if (instance == null) {
            instance = new AttributeViewerFactory();
        }
        return instance;
    }

    public JComponent getViewer4Attribute(INumberScalar iNumberScalar, boolean bl, boolean bl2, boolean bl3) {
        NumberScalarViewer numberScalarViewer = new NumberScalarViewer(iNumberScalar);
        return this.configure(numberScalarViewer, bl, bl2, bl3);
    }

    public JComponent getViewer4Attribute(INumberScalar iNumberScalar) {
        NumberScalarViewer numberScalarViewer = new NumberScalarViewer(iNumberScalar);
        numberScalarViewer.setInfoVisible(false);
        return numberScalarViewer;
    }

    public JComponent getViewer4Attribute(IStringScalar iStringScalar, boolean bl, boolean bl2, boolean bl3) {
        StringScalarViewer stringScalarViewer = new StringScalarViewer(iStringScalar);
        return this.configure(stringScalarViewer, bl, bl2, bl3);
    }

    public JComponent getViewer4Attribute(IStringScalar iStringScalar) {
        StringScalarViewer stringScalarViewer = new StringScalarViewer(iStringScalar);
        stringScalarViewer.setInfoVisible(false);
        return stringScalarViewer;
    }

    protected AScalarViewer configure(AScalarViewer aScalarViewer, boolean bl, boolean bl2, boolean bl3) {
        aScalarViewer.setValueEditable(bl);
        aScalarViewer.setPropertyListEditable(bl2);
        if (!bl3) {
            aScalarViewer.setBorder(null);
        }
        return aScalarViewer;
    }

    public JComponent getViewer4Attribute(INumberSpectrum iNumberSpectrum, boolean bl) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        NumberSpectrumViewer numberSpectrumViewer = new NumberSpectrumViewer();
        numberSpectrumViewer.setModel(iNumberSpectrum);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        jPanel.add((Component)numberSpectrumViewer, gridBagConstraints);
        jPanel.add(this.getInfoButton((IAttribute)iNumberSpectrum, bl));
        return jPanel;
    }

    public JComponent getViewer4Attribute(INumberImage iNumberImage, boolean bl) {
        NumberImageViewer numberImageViewer = new NumberImageViewer();
        numberImageViewer.setModel(iNumberImage);
        return numberImageViewer;
    }

    public JButton getInfoButton(IAttribute iAttribute, boolean bl) {
        JButton jButton = new JButton("...");
        jButton.setIcon(this.propertyIcon);
        final boolean bl2 = bl;
        final IAttribute iAttribute2 = iAttribute;
        jButton.addMouseListener(new MouseAdapter(){
            PropertyFrame f;

            public void mouseClicked(MouseEvent mouseEvent) {
                if (this.f == null) {
                    this.f = new PropertyFrame();
                    this.f.setSize(300, 400);
                    this.f.setEditable(bl2);
                    this.f.setModel(iAttribute2);
                    this.f.pack();
                }
                this.f.show();
            }
        });
        return jButton;
    }

    public JComponent getViewer4Attribute(IAttribute iAttribute, boolean bl, boolean bl2, boolean bl3) {
        if (iAttribute instanceof IStringScalar) {
            return this.getViewer4Attribute((IStringScalar)iAttribute, bl, bl2, bl3);
        }
        if (iAttribute instanceof INumberScalar) {
            return this.getViewer4Attribute((INumberScalar)iAttribute, bl, bl2, bl3);
        }
        if (iAttribute instanceof INumberSpectrum) {
            return this.getViewer4Attribute((INumberSpectrum)iAttribute, bl2);
        }
        if (iAttribute instanceof INumberImage) {
            return this.getViewer4Attribute((INumberImage)iAttribute, bl2);
        }
        return null;
    }

    public JComponent getViewer4Attribute(IAttribute iAttribute) {
        return this.getViewer4Attribute(iAttribute, true, true, false);
    }
}

