/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.tangoatk.widget.util.jdraw;

import fr.esrf.tangoatk.widget.util.jdraw.JDAxis;
import fr.esrf.tangoatk.widget.util.jdraw.JDBar;
import fr.esrf.tangoatk.widget.util.jdraw.JDEllipse;
import fr.esrf.tangoatk.widget.util.jdraw.JDGroup;
import fr.esrf.tangoatk.widget.util.jdraw.JDImage;
import fr.esrf.tangoatk.widget.util.jdraw.JDLabel;
import fr.esrf.tangoatk.widget.util.jdraw.JDLine;
import fr.esrf.tangoatk.widget.util.jdraw.JDObject;
import fr.esrf.tangoatk.widget.util.jdraw.JDPolyline;
import fr.esrf.tangoatk.widget.util.jdraw.JDRectangle;
import fr.esrf.tangoatk.widget.util.jdraw.JDRoundRectangle;
import fr.esrf.tangoatk.widget.util.jdraw.JDSlider;
import fr.esrf.tangoatk.widget.util.jdraw.JDSpline;
import fr.esrf.tangoatk.widget.util.jdraw.JDSwingObject;
import fr.esrf.tangoatk.widget.util.jdraw.UndoPattern;
import java.util.Vector;

class UndoBuffer {
    UndoPattern[] undoBuffer;
    String name;

    UndoBuffer(Vector vector, String string) {
        this.undoBuffer = new UndoPattern[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            this.undoBuffer[n] = ((JDObject)vector.get(n)).getUndoPattern();
            ++n;
        }
        this.name = string;
    }

    UndoBuffer(JDObject[] jDObjectArray, String string) {
        this.undoBuffer = new UndoPattern[jDObjectArray.length];
        int n = 0;
        while (n < jDObjectArray.length) {
            this.undoBuffer[n] = jDObjectArray[n].getUndoPattern();
            ++n;
        }
        this.name = string;
    }

    static void rebuildObject(UndoPattern undoPattern, Vector vector) {
        switch (undoPattern.JDclass) {
            case 1: {
                vector.add(new JDEllipse(undoPattern));
                break;
            }
            case 2: {
                vector.add(new JDGroup(undoPattern));
                break;
            }
            case 3: {
                vector.add(new JDLabel(undoPattern));
                break;
            }
            case 4: {
                vector.add(new JDLine(undoPattern));
                break;
            }
            case 5: {
                vector.add(new JDPolyline(undoPattern));
                break;
            }
            case 6: {
                vector.add(new JDRectangle(undoPattern));
                break;
            }
            case 7: {
                vector.add(new JDRoundRectangle(undoPattern));
                break;
            }
            case 8: {
                vector.add(new JDSpline(undoPattern));
                break;
            }
            case 9: {
                vector.add(new JDImage(undoPattern));
                break;
            }
            case 10: {
                vector.add(new JDSwingObject(undoPattern));
                break;
            }
            case 11: {
                vector.add(new JDAxis(undoPattern));
                break;
            }
            case 12: {
                vector.add(new JDBar(undoPattern));
                break;
            }
            case 13: {
                vector.add(new JDSlider(undoPattern));
                break;
            }
            default: {
                System.out.println("!!! UndoBuffer.rebuildObject() : WARNING Undo failure !!!");
            }
        }
    }

    Vector rebuild() {
        Vector vector = new Vector();
        int n = 0;
        while (n < this.undoBuffer.length) {
            UndoBuffer.rebuildObject(this.undoBuffer[n], vector);
            ++n;
        }
        return vector;
    }

    UndoPattern get(int n) {
        return this.undoBuffer[n];
    }

    String getName() {
        return this.name;
    }
}

